/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.login.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Maps;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.baseutils.JVMProperties;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.XmlReader;
import com.mapr.fs.proto.Security;
import com.mapr.login.MapRLoginException;
import com.mapr.login.client.MapRLoginClient;
import com.mapr.login.common.AuthResponse;
import com.mapr.login.common.GenRemoteTicketRequest;
import com.mapr.login.common.GenTicketTypeRequest;
import com.mapr.login.common.GetRemoteTicketRequest;
import com.mapr.login.common.KerberosAuthRequest;
import com.mapr.login.common.PasswordAuthRequest;
import com.mapr.login.common.RenewRequest;
import com.mapr.security.FipsLoader;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import com.mapr.security.SecurityHelper;
import com.mapr.security.UnixUserGroupHelper;
import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class MapRLoginHttpsClient
implements MapRLoginClient {
    private static Log LOG = LogFactory.getLog(MapRLoginHttpsClient.class);
    private static Logger julRootLogger = Logger.getLogger("");
    private static FileHandler julLogHandler;
    private Map<String, List<CLDBRpcCommonUtils.IpPort>> clustersMap = CLDBRpcCommonUtils.getInstance().getClusterMap();
    public static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    public static final String NT_GSS_KRB5_PRINCIPAL = "1.2.840.113554.1.2.2.1";
    public static final String MAPR_CLIENT_KERBEROS = "MAPR_CLIENT_KERBEROS";
    private static final String BCFKS_FIPS_STORE_TYPE = "bcfks";
    private static final String DEFAULT_TRUSTSTORE_TYPE = "jks";
    private String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
    private static boolean kerberosRuntimeAvailable;
    private static boolean kerberosCheckDone;
    private static final String DEFAULT_MAPR_USER_TICKET_FILE_LOCATION = "/opt/mapr/conf/mapruserticket";
    private boolean checkUGI = true;
    private static final boolean windows;
    private static final String TOKEN_PATH_ATTRIB = "fs.mapr.sso.tokenpath";
    private static final String REFRESH_TOKEN_PATH_ATTRIB = "fs.mapr.sso.refreshtokenpath";
    private static final String jwtTokenPath;
    private static final String jwtRefreshTokenPath;
    private static final String CORE_SITE_XML_PATH = "core-site.xml";
    private static final int MAX_RETRIES = 5;
    private static final int RETRY_DELAY_MS = 3000;

    public boolean hasGoodServerKey(String clusterName) {
        try {
            return this.doesSecurityHaveGoodKey(clusterName, false, Security.ServerKeyType.ServerKey);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasGoodClusterKey(String clusterName) {
        try {
            return this.doesSecurityHaveGoodKey(clusterName, false, Security.ServerKeyType.ClusterKey);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void quietAuthenticateIfNeeded() {
        this.quietAuthenticateIfNeeded(this.currentClusterName);
    }

    public void quietAuthenticateIfNeeded(String cluster) {
        try {
            this.authenticateIfNeeded(cluster);
        }
        catch (MapRLoginException e) {
            LOG.debug((Object)"Exception in authentication suppressed. May cause issues later.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void quietAuthenticateIfNeeded(String cluster, Security.ServerKeyType keyToUse) {
        try {
            this.authenticateIfNeeded(cluster, keyToUse);
        }
        catch (MapRLoginException e) {
            LOG.debug((Object)"Exception in authentication suppressed. May cause issues later.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Security.TicketAndKey authenticateIfNeeded() throws MapRLoginException {
        return this.authenticateIfNeeded(this.currentClusterName, Security.ServerKeyType.ServerKey);
    }

    @Override
    public Security.TicketAndKey authenticateIfNeeded(String cluster) throws MapRLoginException {
        LOG.debug((Object)"Entering authenticate if needed.");
        return this.authenticateIfNeeded(cluster, this.isKerberosAnOption(cluster), Security.ServerKeyType.ServerKey);
    }

    private Security.TicketAndKey authenticateIfNeeded(boolean hasKerberosOption) throws MapRLoginException {
        return this.authenticateIfNeeded(this.currentClusterName, hasKerberosOption, Security.ServerKeyType.ServerKey);
    }

    public Security.TicketAndKey authenticateIfNeeded(String cluster, Security.ServerKeyType keyToUse) throws MapRLoginException {
        LOG.debug((Object)"Entering authenticate if needed.");
        return this.authenticateIfNeeded(cluster, this.isKerberosAnOption(cluster), keyToUse);
    }

    private boolean hasValidTicketFileForKey(String cluster, File file, Security.ServerKeyType keyToUse, boolean bailOnError) throws MapRLoginException {
        if (!file.exists()) {
            if (bailOnError) {
                throw new MapRLoginException("Unable to authenticate as ticket is not available");
            }
            return false;
        }
        int errno = Security.SetTicketAndKeyFile(file.toString());
        if (errno != 0) {
            if (bailOnError) {
                throw new MapRLoginException("Unable to load ticket file '" + file + "', error = " + errno);
            }
            return false;
        }
        return this.doesSecurityHaveGoodKey(cluster, bailOnError, keyToUse);
    }

    private static String GetTokenPath() {
        String tokenPath = System.getenv("MAPR_JWT_TOKEN_LOCATION");
        if (tokenPath != null) {
            return tokenPath;
        }
        try {
            XmlReader xmlReader = new XmlReader(CORE_SITE_XML_PATH);
            tokenPath = xmlReader.getValue(TOKEN_PATH_ATTRIB);
            return tokenPath;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String GetRefreshTokenPath() {
        String tokenPath = System.getenv("MAPR_JWT_REFRESH_TOKEN_LOCATION");
        if (tokenPath != null) {
            return tokenPath;
        }
        try {
            XmlReader xmlReader = new XmlReader(CORE_SITE_XML_PATH);
            tokenPath = xmlReader.getValue(REFRESH_TOKEN_PATH_ATTRIB);
            return tokenPath;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Security.TicketAndKey loadTicketUsingToken(String cluster, String ticketFile) throws MapRLoginException {
        UnixUserGroupHelper helper = new UnixUserGroupHelper();
        String userName = helper.getLoggedinUsername();
        Object refreshTokenContent = null;
        LOG.debug((Object)("Try fetching the ticket file " + ticketFile + " from token file " + jwtTokenPath + " for user " + userName));
        return this.getMapRCredentialsViaJwt(cluster, userName, ticketFile, jwtTokenPath, jwtRefreshTokenPath);
    }

    private Security.TicketAndKey authenticateIfNeeded(String cluster, boolean hasKerberosOption, Security.ServerKeyType keyToUse) throws MapRLoginException {
        if (!this.isSecurityEnabled(cluster)) {
            LOG.debug((Object)"security appears to be off");
            return null;
        }
        if (this.doesSecurityHaveGoodKey(cluster, false, keyToUse)) {
            LOG.debug((Object)"Already have good ticket, done");
            return this.getTicket(cluster, keyToUse);
        }
        File file = new File(JNISecurity.GetUserTicketAndKeyFileLocation());
        if (this.hasValidTicketFileForKey(cluster, file, keyToUse, jwtTokenPath == null && !hasKerberosOption)) {
            return this.getTicket(cluster, keyToUse);
        }
        if (jwtTokenPath != null) {
            this.loadTicketUsingToken(cluster, file.toString());
            if (this.hasValidTicketFileForKey(cluster, file, keyToUse, !hasKerberosOption)) {
                return this.getTicket(cluster, keyToUse);
            }
        }
        LOG.debug((Object)"Try kerberos");
        Security.TicketAndKey tk = this.getMapRCredentialsViaKerberos(cluster, null);
        Security.SetTicketAndKey(Security.ServerKeyType.ServerKey, cluster, tk);
        return tk;
    }

    @Override
    public boolean isSecurityEnabled() throws MapRLoginException {
        return this.isSecurityEnabled(this.currentClusterName);
    }

    @Override
    public boolean isSecurityEnabled(String cluster) {
        return JNISecurity.IsSecurityEnabled(cluster);
    }

    private Security.TicketAndKey getTicket(String cluster) {
        return this.getTicket(cluster, Security.ServerKeyType.ServerKey);
    }

    private Security.TicketAndKey getTicket(String cluster, Security.ServerKeyType keyToUse) {
        MutableInt err = new MutableInt();
        Security.TicketAndKey tk = Security.GetTicketAndKeyForCluster(keyToUse, cluster, err);
        return tk;
    }

    private boolean doesSecurityHaveGoodKey(String cluster, boolean bailOnError, Security.ServerKeyType keyToUse) throws MapRLoginException {
        MutableInt err = new MutableInt();
        Security.TicketAndKey tk = Security.GetTicketAndKeyForCluster(keyToUse, cluster, err);
        if (tk != null && err.GetValue() == 0) {
            if (Security.IsTicketAndKeyUsable(tk)) {
                LOG.debug((Object)"found existing MapR ticket");
                return true;
            }
            if (bailOnError) {
                throw new MapRLoginException("Found ticket for cluster '" + cluster + "' but it has expired.");
            }
        }
        if (bailOnError) {
            throw new MapRLoginException("Failed to find ticket for cluster '" + cluster + "', error = " + err.GetValue());
        }
        return false;
    }

    private synchronized boolean isKerberosAnOption(String cluster) {
        if (!JNISecurity.IsKerberosEnabled(cluster)) {
            LOG.debug((Object)"Kerberos not configured for this cluster.");
            return false;
        }
        LOG.debug((Object)"Kerberos available for this cluster. Determining if kerberos authentication supported in runtime");
        if (!kerberosCheckDone) {
            kerberosCheckDone = true;
            try {
                if (Configuration.getConfiguration().getAppConfigurationEntry(MAPR_CLIENT_KERBEROS) != null) {
                    LOG.debug((Object)"Found JAAS configuration MAPR_CLIENT_KERBEROS");
                    KerberosPrincipal kn = new KerberosPrincipal("anything");
                    LOG.debug((Object)"Found Kerberos runtime");
                    kerberosRuntimeAvailable = true;
                } else {
                    LOG.debug((Object)"No Kerberos JAAS configuration");
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Failed to detect kerberos runtime. No Kerberos usage." + e.getMessage()));
            }
            if (kerberosRuntimeAvailable) {
                LOG.debug((Object)"Kerberos is an option");
            } else {
                LOG.debug((Object)"Kerberos is not an option");
            }
        }
        return kerberosRuntimeAvailable;
    }

    @Override
    public Security.TicketAndKey getMapRCredentialsViaPassword(String username, String password, Long desiredTicketDurInSecs) throws MapRLoginException {
        return this.getMapRCredentialsViaPassword(this.currentClusterName, username, password, desiredTicketDurInSecs, null);
    }

    @Override
    public Security.TicketAndKey getMapRCredentialsViaPassword(String cluster, String username, String password, Long desiredTicketDurInSecs, String ticketLocation) throws MapRLoginException {
        AuthResponse response = this.authenticateWithRetry(cluster, this.getPasswordAuthRequestString(username, password, desiredTicketDurInSecs), "/login/password");
        return this.processResponse(cluster, response, ticketLocation);
    }

    @Override
    public Security.TicketAndKey getMapRCredentialsViaJwt(String cluster, String username, String ticketLocation, String jwtTokenPath, String refreshTokenPath) throws MapRLoginException {
        String refreshJwtContent = null;
        try {
            refreshJwtContent = Files.readString(Path.of(refreshTokenPath, new String[0]));
            refreshJwtContent = refreshJwtContent.trim();
        }
        catch (Exception e) {
            refreshJwtContent = null;
        }
        String jwtContent = null;
        try {
            jwtContent = Files.readString(Path.of(jwtTokenPath, new String[0]));
            jwtContent = jwtContent.trim();
        }
        catch (Exception e) {
            throw new MapRLoginException("Unable to load ticket has invalid token " + jwtTokenPath);
        }
        Security.GetJwtTicketRequest.Builder jwtReq = Security.GetJwtTicketRequest.newBuilder();
        jwtReq.setUserName(username).setAuthToken(jwtContent);
        if (refreshJwtContent != null) {
            jwtReq.setRefreshToken(refreshJwtContent);
        }
        byte[] content = jwtReq.build().toByteArray();
        String strReq = Base64.getEncoder().encodeToString(content);
        AuthResponse response = this.authenticateWithRetry(cluster, strReq, "/login/token");
        if (response.getStatus() != 0) {
            LOG.error((Object)("Could not get ticket " + response.getError()));
            return null;
        }
        if (ticketLocation == null || ticketLocation.isEmpty()) {
            ticketLocation = JNISecurity.GetUserTicketAndKeyFileLocation();
        }
        this.writeMapRCredentialsToFileJwt(cluster, Base64.getDecoder().decode(response.getTicketAndKeyString()), ticketLocation);
        this.writeAccessTokenToAccessJwt(cluster, response.getAccessToken(), jwtTokenPath);
        MutableInt err = new MutableInt();
        Security.TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.ServerKey, cluster, err);
        return ticketAndKey;
    }

    @Override
    public Security.TicketAndKey getMapRCredentialsViaKerberos(Long desiredTicketDurInSecs) throws MapRLoginException {
        return this.getMapRCredentialsViaKerberos(this.currentClusterName, desiredTicketDurInSecs);
    }

    @Override
    public void setCheckUGI(boolean b) {
        this.checkUGI = b;
    }

    @Override
    public Security.TicketAndKey getMapRCredentialsViaKerberos(String cluster, final Long desiredTicketDurInSecs) throws MapRLoginException {
        AuthResponse response;
        if (JNISecurity.IsReplayDetectionDisabled(cluster)) {
            LOG.info((Object)"REPLAY DETECTION DISABLED");
        }
        try {
            AccessControlContext context = AccessController.getContext();
            Subject subject = Subject.getSubject(context);
            if (subject == null || subject.getPrincipals(KerberosPrincipal.class).isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    if (subject == null) {
                        LOG.debug((Object)"No subject found");
                    } else {
                        LOG.debug((Object)"Subject found but no Kerberos principal in it");
                    }
                }
                if (this.checkUGI) {
                    LOG.debug((Object)"Will attempt to check UGI object for Kerberos creds");
                    try {
                        Class<?> aclass = Class.forName("org.apache.hadoop.security.UserGroupInformation");
                        Method m = aclass.getMethod("getCurrentUser", null);
                        Object ugi = m.invoke(null, (Object[])null);
                        m = aclass.getMethod("getSubject", null);
                        subject = (Subject)m.invoke(ugi, (Object[])null);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.debug((Object)"Couldn't find UGI object. Doesn't matter.");
                    }
                } else {
                    LOG.debug((Object)"UGI checking disabled.");
                }
                if (subject == null || subject.getPrincipals(KerberosPrincipal.class).isEmpty()) {
                    LOG.debug((Object)"No subject with Kerberos found even after (optionally) checking Hadoop UGI object");
                    LoginContext lcontext = new LoginContext(MAPR_CLIENT_KERBEROS);
                    lcontext.login();
                    subject = lcontext.getSubject();
                }
            }
            LOG.debug((Object)("Client kerberos identity: " + subject.getPrincipals()));
            final String clusterName = cluster;
            response = Subject.doAs(subject, new PrivilegedExceptionAction<AuthResponse>(){

                @Override
                public AuthResponse run() throws Exception {
                    String authScheme;
                    String serverPrinc = MapRLoginHttpsClient.this.getCLDBKerberosName(clusterName);
                    GSSManager manager = GSSManager.getInstance();
                    LOG.debug((Object)("Attempting to connect to kerberos server that has the identity '" + serverPrinc + "'"));
                    GSSName serverName = manager.createName(serverPrinc, new Oid(MapRLoginHttpsClient.NT_GSS_KRB5_PRINCIPAL), new Oid(MapRLoginHttpsClient.SPNEGO_OID));
                    GSSContext context = manager.createContext(serverName, new Oid(MapRLoginHttpsClient.SPNEGO_OID), null, 0);
                    if (JNISecurity.IsReplayDetectionDisabled(clusterName)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Replay detection disabled in mapr-clusters.conf");
                        }
                        context.requestReplayDet(false);
                    }
                    context.requestMutualAuth(true);
                    byte[] intoken = new byte[]{};
                    Object credBytes = null;
                    byte[] outtoken = context.initSecContext(intoken, 0, intoken.length);
                    if (outtoken == null) {
                        LOG.error((Object)"No kerberos identity to use.");
                        throw new MapRLoginException("No kerberos identity.");
                    }
                    String base64 = Base64.getEncoder().encodeToString(outtoken);
                    String request = MapRLoginHttpsClient.this.getKerberosAuthRequestString(base64, desiredTicketDurInSecs);
                    AuthResponse response = MapRLoginHttpsClient.this.authenticateWithMapRCluster(clusterName, request, authScheme = "/login/kerberos");
                    if (response.getError() != null) {
                        return response;
                    }
                    base64 = response.getToken();
                    intoken = Base64.getDecoder().decode(base64);
                    outtoken = context.initSecContext(intoken, 0, intoken.length);
                    if (!context.isEstablished()) {
                        LOG.error((Object)"During kerberos authentication another auth round expected. Unable to complete authentication.");
                        throw new MapRLoginException("Unable to complete Kerberos authentication.");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Context Established! Client principal is " + context.getSrcName()));
                        LOG.debug((Object)("Server principal is " + context.getTargName()));
                    }
                    return response;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            String error = "Failure during kerberos authentication. " + e.getMessage();
            LOG.debug((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
        return this.processResponse(cluster, response);
    }

    @Override
    public void logOut() throws MapRLoginException {
        String ticketFilePath = JNISecurity.GetUserTicketAndKeyFileLocation();
        File ticketFile = new File(ticketFilePath);
        if (!ticketFile.exists() || !ticketFile.delete()) {
            throw new MapRLoginException("Logout failed. Unable to delete the ticket file: " + ticketFile.getAbsolutePath());
        }
        LOG.info((Object)"All tickets deleted.");
    }

    @Override
    public void logOut(String cluster) throws MapRLoginException {
        String ticketFilePath = JNISecurity.GetUserTicketAndKeyFileLocation();
        File tempFile = this.getTempFile(ticketFilePath + ".tmp");
        try {
            File ticketFile = new File(ticketFilePath);
            Map<String, String> clusterToCredentials = this.getExistingCredsFromTicketFile(ticketFile);
            if (clusterToCredentials.containsKey(cluster)) {
                clusterToCredentials.remove(cluster);
                FileOutputStream fos = new FileOutputStream(tempFile);
                for (String clusterName : clusterToCredentials.keySet()) {
                    String clusterTicket = clusterToCredentials.get(clusterName);
                    fos.write(clusterName.getBytes("UTF-8"));
                    fos.write(" ".getBytes("UTF-8"));
                    fos.write(clusterTicket.getBytes("UTF-8"));
                    fos.write("\n".getBytes("UTF-8"));
                }
                fos.close();
                this.renameFile(tempFile, ticketFile);
                LOG.info((Object)("Deleted the ticket for cluster '" + cluster + "' from " + ticketFilePath));
            } else {
                LOG.info((Object)("No ticket present for cluster '" + cluster + "' in " + ticketFilePath + ". Nothing to delete."));
                tempFile.delete();
            }
        }
        catch (Exception e) {
            String error = "Error writing mapr credentials to file. File path: " + ticketFilePath;
            LOG.error((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
    }

    @Override
    public Security.TicketAndKey renew(Long desiredTicketDurInSecs) throws MapRLoginException {
        return this.renew(this.currentClusterName, desiredTicketDurInSecs, null, null);
    }

    @Override
    public Security.TicketAndKey renew(String cluster, Long desiredTicketDurInSecs, String inTicketFile, String ticketLocation) throws MapRLoginException {
        File file;
        MutableInt err = new MutableInt();
        if (inTicketFile != null && !(file = new File(inTicketFile)).exists()) {
            throw new MapRLoginException("keyfile: " + inTicketFile + " not found");
        }
        byte[] ticketBytes = this.getTicketBytes(cluster, inTicketFile, err);
        if (err.GetValue() != 0 || ticketBytes == null || ticketBytes.length == 0) {
            String error = "Cannot renew the ticket for cluster '" + cluster + "'. Error decoding the existing ticket. Error code: " + err.GetValue();
            LOG.error((Object)error);
            throw new MapRLoginException(error);
        }
        try {
            Security.TicketAndKey ticketAndKey = Security.TicketAndKey.parseFrom((byte[])ticketBytes);
            long lastRenewalTime = ticketAndKey.hasLastRenewalTime() && ticketAndKey.getLastRenewalTime() != 0L ? ticketAndKey.getLastRenewalTime() : ticketAndKey.getCreationTimeSec();
            long ticketDurationInSec = ticketAndKey.getExpiryTime() - lastRenewalTime;
            long maxRenewalTime = ticketAndKey.getCreationTimeSec() + ticketAndKey.getMaxRenewalDurationSec();
            if (maxRenewalTime < System.currentTimeMillis() / 1000L + ticketDurationInSec) {
                ticketDurationInSec = maxRenewalTime - System.currentTimeMillis() / 1000L;
            }
            RenewRequest req = new RenewRequest();
            req.setTicketAndKeyString(Base64.getEncoder().encodeToString(ticketAndKey.toByteArray()));
            req.setTicketDurInSecs(ticketDurationInSec);
            return this.processResponse(cluster, this.authenticateWithMapRCluster(cluster, RenewRequest.toJSON(req), "/renew"), ticketLocation);
        }
        catch (InvalidProtocolBufferException e) {
            String error = "Cannot renew the ticket for cluster '" + cluster + "'. Error building the TicketAndKey object.";
            LOG.error((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
        catch (JsonProcessingException e) {
            String error = "Cannot renew the ticket for cluster '" + cluster + "'. Error in JSON serialization of the TicketAndKey object.";
            LOG.error((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
    }

    @Override
    public Security.TicketAndKey generateTicket(GenTicketTypeRequest.TicketType ticketType, String targetUserName, String cluster, Long desiredTicketDurInSecs, Long renewalTicketDurInSecs, List<CLDBRpcCommonUtils.IpAddr> ips, List<Integer> uids, List<Integer> gids, String ticketFileLocation) throws MapRLoginException {
        return this.genTicketType(ticketType, targetUserName, cluster, desiredTicketDurInSecs, renewalTicketDurInSecs, ips, uids, gids, ticketFileLocation);
    }

    private Security.TicketAndKey genTicketType(GenTicketTypeRequest.TicketType ticketType, String targetUserName, String cluster, Long desiredTicketDurInSecs, Long renewalTicketDurInSecs, List<CLDBRpcCommonUtils.IpAddr> ips, List<Integer> uids, List<Integer> gids, String ticketFileLocation) throws MapRLoginException {
        MutableInt err = new MutableInt();
        byte[] ticketBytes = this.getTicketBytes(cluster, null, err);
        if (err.GetValue() != 0 || ticketBytes == null || ticketBytes.length == 0) {
            String error = "Cannot generate service ticket for cluster '" + cluster + "'. Error decoding the existing ticket. Error code: " + err.GetValue();
            LOG.error((Object)error);
            throw new MapRLoginException(error);
        }
        try {
            Security.TicketAndKey ticketAndKey = Security.TicketAndKey.parseFrom((byte[])ticketBytes);
            GenTicketTypeRequest req = new GenTicketTypeRequest();
            req.setTicketAndKeyString(Base64.getEncoder().encodeToString(ticketAndKey.toByteArray()));
            req.setTicketDurInSecs(desiredTicketDurInSecs);
            req.setTicketRenewInSecs(renewalTicketDurInSecs);
            req.setTargetUserName(targetUserName);
            req.setTicketType(ticketType);
            req.setIps(ips);
            req.setUids(uids);
            req.setGids(gids);
            return this.processResponse(cluster, this.authenticateWithMapRCluster(cluster, GenTicketTypeRequest.toJSON(req), "/gentickettype"), ticketFileLocation);
        }
        catch (InvalidProtocolBufferException e) {
            String error = "Cannot generate service ticket for cluster '" + cluster + "'. Error building the TicketAndKey object.";
            LOG.error((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
        catch (JsonProcessingException e) {
            String error = "Cannot generate service ticket for cluster '" + cluster + "'. Error in JSON serialization of the TicketAndKey object.";
            LOG.error((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
    }

    private byte[] getTicketBytes(String cluster, String inTicketFile, MutableInt err) throws MapRLoginException {
        String ticketFilePath = inTicketFile != null ? inTicketFile : JNISecurity.GetUserTicketAndKeyFileLocation();
        File ticketFile = new File(ticketFilePath);
        Map<String, String> clusterToCredentials = this.getExistingCredsFromTicketFile(ticketFile);
        if (!ticketFile.exists() || !clusterToCredentials.containsKey(cluster)) {
            String error = "Operation failed. User has no established credentials on the cluster: " + cluster;
            LOG.error((Object)error);
            throw new MapRLoginException(error);
        }
        return Security.DecodeDataFromKeyFile(clusterToCredentials.get(cluster).getBytes(), err);
    }

    @Override
    public Security.TicketAndKey getRemoteTicket(String remoteCluster, String ticketLocation) throws MapRLoginException {
        MutableInt err = new MutableInt();
        byte[] ticketBytes = this.getTicketBytes(this.currentClusterName, null, err);
        if (err.GetValue() != 0 || ticketBytes == null || ticketBytes.length == 0) {
            String error = "Cannot get ticket for cluster '" + this.currentClusterName + "'. Error decoding the existing ticket. Error code: " + err.GetValue();
            LOG.error((Object)error);
            throw new MapRLoginException(error);
        }
        try {
            Security.TicketAndKey ticketAndKey = Security.TicketAndKey.parseFrom((byte[])ticketBytes);
            GetRemoteTicketRequest req = new GetRemoteTicketRequest();
            req.setTicketAndKeyString(Base64.getEncoder().encodeToString(ticketAndKey.toByteArray()));
            req.setRemoteCluster(remoteCluster);
            return this.processResponse(remoteCluster, this.authenticateWithMapRCluster(this.currentClusterName, GetRemoteTicketRequest.toJSON(req), "/getremoteticket"), ticketLocation);
        }
        catch (InvalidProtocolBufferException e) {
            String error = "Cannot build TicketAndKey object for cluster " + this.currentClusterName;
            LOG.error((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
        catch (JsonProcessingException e) {
            String error = "Error in JSON serialization of GetRemoteTicketRequest";
            LOG.error((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
    }

    @Override
    public Security.TicketAndKey genRemoteTicket(String remoteCluster, String localTicketAndKeyString) throws MapRLoginException {
        MutableInt err = new MutableInt();
        try {
            GenRemoteTicketRequest req = new GenRemoteTicketRequest();
            req.setTicketAndKeyString(localTicketAndKeyString);
            return this.processResponse(remoteCluster, this.authenticateWithMapRCluster(remoteCluster, GenRemoteTicketRequest.toJSON(req), "/genremoteticket"), null, false);
        }
        catch (JsonProcessingException e) {
            String error = "Error in JSON serialization of GenRemoteTicketRequest";
            LOG.error((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
    }

    private Security.TicketAndKey processResponse(String cluster, AuthResponse response) throws MapRLoginException {
        String ticketFilePath = JNISecurity.GetUserTicketAndKeyFileLocation();
        return this.processResponse(cluster, response, ticketFilePath);
    }

    private Security.TicketAndKey processResponse(String cluster, AuthResponse response, String ticketFilePath) throws MapRLoginException {
        return this.processResponse(cluster, response, ticketFilePath, true);
    }

    private Security.TicketAndKey processResponse(String cluster, AuthResponse response, String ticketFilePath, boolean writeTicket) throws MapRLoginException {
        if (response.getStatus() == 0) {
            if (writeTicket && (ticketFilePath == null || ticketFilePath.isEmpty())) {
                ticketFilePath = JNISecurity.GetUserTicketAndKeyFileLocation();
            }
            Security.TicketAndKey ticketAndKey = this.extractCredentialsFromResponse(response);
            if (writeTicket) {
                this.writeMapRCredentialsToFile(cluster, ticketAndKey, ticketFilePath);
            }
            return ticketAndKey;
        }
        String error = "Error obtaining mapr credentials for cluster : " + cluster + ". Error message from cldb: " + response.getError();
        LOG.error((Object)error);
        throw new MapRLoginException(response.getError());
    }

    private AuthResponse authenticateWithRetry(String cluster, String jsonRequest, String authScheme) throws MapRLoginException {
        int attempts = 0;
        try {
            while (true) {
                AuthResponse response;
                if ((response = this.authenticateWithMapRCluster(cluster, jsonRequest, authScheme)).getStatus() != 503) {
                    return response;
                }
                if (++attempts >= 5) {
                    String error = "Error: " + response.getError();
                    LOG.error((Object)error);
                    throw new MapRLoginException(error);
                }
                LOG.info((Object)("CLDB is not ready yet for cluster '" + cluster + "'. Retrying... Attempt: " + attempts));
                Thread.sleep(3000L);
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Authentication interrupted for cluster '" + cluster + "'."), (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private AuthResponse authenticateWithMapRCluster(String cluster, String jsonRequest, String authScheme) throws MapRLoginException {
        if (LOG.isDebugEnabled()) {
            try {
                String requestString = null;
                if (authScheme.equals("/login/password")) {
                    requestString = PasswordAuthRequest.fromJSON(jsonRequest).toString();
                } else if (authScheme.equals("/login/kerberos")) {
                    requestString = KerberosAuthRequest.fromJSON(jsonRequest).toString();
                } else if (authScheme.equals("/renew")) {
                    requestString = RenewRequest.fromJSON(jsonRequest).toString();
                } else if (authScheme.equals("/gentickettype")) {
                    requestString = GenTicketTypeRequest.fromJSON(jsonRequest).toString();
                } else if (authScheme.equals("/login/token")) {
                    requestString = jsonRequest;
                } else if (authScheme.equals("/getremoteticket")) {
                    requestString = GetRemoteTicketRequest.fromJSON(jsonRequest).toString();
                } else if (authScheme.equals("/genremoteticket")) {
                    requestString = GenRemoteTicketRequest.fromJSON(jsonRequest).toString();
                }
                LOG.debug((Object)("Attempting authentication with cluster - " + cluster + ". Request - " + (requestString != null ? requestString : "null") + ", auth scheme: " + authScheme));
            }
            catch (JsonProcessingException e) {
                LOG.debug((Object)e);
            }
            catch (IOException e) {
                LOG.debug((Object)e);
            }
        }
        CLDBRpcCommonUtils.getInstance().reloadClusterMap(cluster);
        this.clustersMap = CLDBRpcCommonUtils.getInstance().getClusterMap();
        if (!this.clustersMap.containsKey(cluster)) {
            String error = "Cluster name '" + cluster + "' is not found in " + CLDBRpcCommonUtils.getInstance().getPathToClustersConfFile();
            LOG.error((Object)error);
            throw new MapRLoginException(error);
        }
        StringBuilder cldbs = new StringBuilder();
        boolean first = true;
        int cldbHttpsPort = JNISecurity.GetCldbHttpsPort(this.currentClusterName);
        ArrayList cldbHosts = new ArrayList(this.clustersMap.get(cluster));
        Collections.shuffle(cldbHosts);
        for (CLDBRpcCommonUtils.IpPort cldb : cldbHosts) {
            for (CLDBRpcCommonUtils.IpAddr cldbAddr : cldb.getOriginalAddr()) {
                if (!first) {
                    cldbs.append(", ");
                }
                first = false;
                cldbs.append(cldbAddr.getSockAddr(cldbHttpsPort));
                HttpURLConnection cldbConn = this.getCLDBConnection(cldbAddr, cldbHttpsPort, authScheme);
                if (cldbConn != null) {
                    AuthResponse response;
                    block29: {
                        response = new AuthResponse();
                        if (authScheme.equals("/login/token")) {
                            String resp = this.sendRequest(jsonRequest, cldbConn);
                            try {
                                LOG.debug((Object)("Received is " + resp));
                                Security.GetJwtTicketResponse jwtResp = Security.GetJwtTicketResponse.parseFrom((byte[])Base64.getDecoder().decode(resp));
                                response.setError(jwtResp.getError());
                                response.setStatus(jwtResp.getStatus());
                                String s = Base64.getEncoder().encodeToString(jwtResp.getMaprTicket().toByteArray());
                                response.setTicketAndKeyString(s);
                                if (jwtResp.hasAccessToken()) {
                                    String newAccessToken = jwtResp.getAccessToken();
                                    response.setAccessToken(newAccessToken);
                                    break block29;
                                }
                                response.setAccessToken(null);
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Exception parsing response ", (Throwable)e);
                            }
                        } else {
                            response = this.parseAuthResponse(this.sendRequest(jsonRequest, cldbConn));
                        }
                    }
                    cldbConn.disconnect();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Obtained auth response " + response.toString() + " from cldb @ " + cldbAddr.toString() + ":" + cldbHttpsPort));
                    }
                    if (response.getStatus() == 30) {
                        LOG.info((Object)("Message from cldb " + cldbAddr.toString() + ":" + cldbHttpsPort + " - '" + response.getError() + "'. Trying another cldb.."));
                        continue;
                    }
                    return response;
                }
                LOG.warn((Object)("Couldn't connect to cldb " + cldbAddr.toString() + ":" + cldbHttpsPort + ". Trying another cldb.."));
            }
        }
        String error = "Unable to connect to any of the cluster's CLDBs. CLDBs tried: " + cldbs.toString() + ". Please check your cluster configuration.";
        LOG.error((Object)error);
        throw new MapRLoginException(error);
    }

    private String getCLDBKerberosName(String clustername) {
        Object prin = JNISecurity.GetCldbPrincipal(clustername);
        if (((String)prin).trim().isEmpty()) {
            prin = "mapr/" + clustername;
        }
        return prin;
    }

    private AuthResponse parseAuthResponse(String response) throws MapRLoginException {
        try {
            return AuthResponse.fromJSON(response);
        }
        catch (IOException jsone) {
            String error = "JSON parse error while parsing auth response.";
            LOG.error((Object)error, (Throwable)jsone);
            throw new MapRLoginException(error, jsone);
        }
    }

    private Security.TicketAndKey extractCredentialsFromResponse(AuthResponse response) throws MapRLoginException {
        try {
            return Security.TicketAndKey.parseFrom((byte[])Base64.getDecoder().decode(response.getTicketAndKeyString()));
        }
        catch (InvalidProtocolBufferException e) {
            String error = "Error parsing base64 encoded ticket and key string into proto object";
            LOG.error((Object)error);
            throw new MapRLoginException(error, e);
        }
    }

    private void writeAccessTokenToAccessJwt(String cluster, String accessToken, String accessTokenPath) throws MapRLoginException {
        if (accessToken == null || accessToken.length() == 0) {
            return;
        }
        File tempFile = this.getTempFile(accessTokenPath + ".tmp");
        try {
            File tokenPath = new File(accessTokenPath);
            FileOutputStream writer = new FileOutputStream(tempFile);
            writer.write(accessToken.getBytes("UTF-8"));
            writer.close();
            this.renameFile(tempFile, tokenPath);
        }
        catch (Exception e) {
            String error = "Error writing access jwt token. File path: " + accessTokenPath;
            LOG.error((Object)error, (Throwable)e);
            if (System.out != null) {
                System.out.println(error);
            }
            throw new MapRLoginException(error, e);
        }
    }

    private void writeMapRCredentialsToFileJwt(String cluster, byte[] encodedTicket, String ticketFilePath) throws MapRLoginException {
        if (encodedTicket == null) {
            String error = "Encoded  ticket is null . Error: ";
            LOG.error((Object)error);
            throw new MapRLoginException(error);
        }
        if (ticketFilePath.equals(DEFAULT_MAPR_USER_TICKET_FILE_LOCATION)) {
            String error = "ticket file location set to default - will not overwrite";
            LOG.error((Object)error);
            throw new MapRLoginException(error);
        }
        File tempFile = this.getTempFile(ticketFilePath + ".tmp");
        try {
            Map<Object, Object> clusterToCredentials = Maps.newLinkedHashMap();
            File ticketFile = new File(ticketFilePath);
            if (ticketFile.exists()) {
                clusterToCredentials = this.getExistingCredsFromTicketFile(ticketFile);
            }
            clusterToCredentials.put(cluster, new String(encodedTicket, "UTF-8"));
            FileOutputStream fos = new FileOutputStream(tempFile);
            for (String string : clusterToCredentials.keySet()) {
                String clusterTicket = (String)clusterToCredentials.get(string);
                fos.write(string.getBytes("UTF-8"));
                fos.write(" ".getBytes("UTF-8"));
                fos.write(clusterTicket.getBytes("UTF-8"));
                fos.write("\n".getBytes("UTF-8"));
            }
            fos.close();
            this.renameFile(tempFile, ticketFile);
            String message = "MapR credentials for cluster " + cluster + " are written to " + ticketFilePath;
            LOG.info((Object)message);
            if (System.out != null) {
                System.out.println(message);
            }
        }
        catch (Exception e) {
            String error = "Error writing mapr credentials to file. File path: " + ticketFilePath;
            LOG.error((Object)error, (Throwable)e);
            if (System.out != null) {
                System.out.println(error);
            }
            throw new MapRLoginException(error, e);
        }
    }

    private void writeMapRCredentialsToFile(String cluster, Security.TicketAndKey creds, String ticketFilePath) throws MapRLoginException {
        MutableInt err = new MutableInt();
        byte[] encodedTicket = Security.EncodeDataForWritingToKeyFile(creds.toByteArray(), err);
        if (encodedTicket == null) {
            String error = "Failed to encode ticket and key. Error: " + err.GetValue();
            LOG.error((Object)error);
            throw new MapRLoginException(error);
        }
        if (ticketFilePath.equals(DEFAULT_MAPR_USER_TICKET_FILE_LOCATION)) {
            String error = "ticket file location set to default - will not overwrite";
            LOG.error((Object)error);
            throw new MapRLoginException(error);
        }
        File tempFile = this.getTempFile(ticketFilePath + ".tmp");
        try {
            Map<Object, Object> clusterToCredentials = Maps.newLinkedHashMap();
            File ticketFile = new File(ticketFilePath);
            if (ticketFile.exists()) {
                clusterToCredentials = this.getExistingCredsFromTicketFile(ticketFile);
            }
            clusterToCredentials.put(cluster, new String(encodedTicket, "UTF-8"));
            FileOutputStream fos = new FileOutputStream(tempFile);
            for (String string : clusterToCredentials.keySet()) {
                String clusterTicket = (String)clusterToCredentials.get(string);
                fos.write(string.getBytes("UTF-8"));
                fos.write(" ".getBytes("UTF-8"));
                fos.write(clusterTicket.getBytes("UTF-8"));
                fos.write("\n".getBytes("UTF-8"));
            }
            fos.close();
            this.renameFile(tempFile, ticketFile);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\n************* \nSaved mapr credentials to file: " + ticketFilePath + ". \nUser credentials: \n" + Security.UserCredsToString(cluster, creds.getUserCreds()) + "\n************* \n"));
            }
            String message = "MapR credentials of user '" + creds.getUserCreds().getUserName() + "' for cluster '" + cluster + "' are written to '" + ticketFilePath + "'";
            LOG.info((Object)message);
            if (System.out != null) {
                System.out.println(message);
            }
        }
        catch (Exception e) {
            String error = "Error writing mapr credentials to file. File path: " + ticketFilePath;
            LOG.error((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
    }

    private void renameFile(File tempFile, File ticketFile) throws MapRLoginException {
        boolean result = tempFile.renameTo(ticketFile);
        if (result) {
            return;
        }
        if (windows) {
            LOG.debug((Object)"The rename failed, since I'm on windows, try deleting the target file first.");
            ticketFile.delete();
            result = tempFile.renameTo(ticketFile);
            if (result) {
                return;
            }
        }
        String error = "Unable to rename " + tempFile.getAbsolutePath() + " to " + ticketFile.getAbsolutePath();
        LOG.error((Object)error);
        throw new MapRLoginException(error);
    }

    private File getTempFile(String tempFilePath) throws MapRLoginException {
        File tempFile = new File(tempFilePath);
        int maxRetries = 10;
        int retries = 0;
        long retryInterval = 500L;
        try {
            while (!tempFile.createNewFile()) {
                LOG.info((Object)(tempFilePath + " already exists. will retry again in " + retryInterval + " ms"));
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)e);
                    throw new MapRLoginException(e);
                }
                if (++retries < maxRetries) continue;
                LOG.info((Object)(tempFilePath + " is present even after " + maxRetries + " retries. Deleting it."));
                if (tempFile.delete()) continue;
                String error = "Unable to delete the temporary ticket file: " + tempFilePath;
                LOG.error((Object)error);
                throw new MapRLoginException(error);
            }
        }
        catch (IOException e) {
            String message = "Unable to create " + tempFilePath;
            LOG.error((Object)message, (Throwable)e);
            throw new MapRLoginException(message, e);
        }
        tempFile.setExecutable(false, false);
        tempFile.setWritable(false, false);
        tempFile.setReadable(false, false);
        tempFile.setWritable(true, true);
        tempFile.setReadable(true, true);
        return tempFile;
    }

    private Map<String, String> getExistingCredsFromTicketFile(File file) throws MapRLoginException {
        LinkedHashMap clusterToCredsMap = Maps.newLinkedHashMap();
        if (file.exists()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    String[] parts = line.split(" ");
                    clusterToCredsMap.put(parts[0], parts[1]);
                }
                reader.close();
            }
            catch (IOException e) {
                String error = "Error reading from " + file.getAbsolutePath();
                LOG.error((Object)error, (Throwable)e);
                throw new MapRLoginException(error, e);
            }
        }
        return clusterToCredsMap;
    }

    private String getPasswordAuthRequestString(String username, String password, Long desiredTicketDurInSecs) throws MapRLoginException {
        PasswordAuthRequest par = new PasswordAuthRequest();
        par.setUserName(username);
        par.setPassWord(password);
        par.setTicketDurInSecs(desiredTicketDurInSecs);
        try {
            return PasswordAuthRequest.toJSON(par);
        }
        catch (JsonProcessingException jsone) {
            String error = "JSON parse error";
            LOG.error((Object)error, (Throwable)jsone);
            throw new MapRLoginException(error, jsone);
        }
    }

    private String getKerberosAuthRequestString(String kerberosToken, Long desiredTicketDurInSecs) throws MapRLoginException {
        KerberosAuthRequest kar = new KerberosAuthRequest();
        kar.setToken(kerberosToken);
        kar.setTicketDurInSecs(desiredTicketDurInSecs);
        try {
            return KerberosAuthRequest.toJSON(kar);
        }
        catch (JsonProcessingException jsone) {
            String error = "JSON parse error";
            LOG.error((Object)error, (Throwable)jsone);
            throw new MapRLoginException(error, jsone);
        }
    }

    private String sendRequest(String request, HttpURLConnection cldbConn) throws MapRLoginException {
        try {
            String line;
            OutputStream outputStream = cldbConn.getOutputStream();
            outputStream.write(request.getBytes());
            outputStream.close();
            BufferedReader input = new BufferedReader(new InputStreamReader(cldbConn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = input.readLine()) != null) {
                sb.append(line);
            }
            input.close();
            return sb.toString();
        }
        catch (IOException e) {
            String error = "Error sending request data via http output stream";
            LOG.error((Object)error, (Throwable)e);
            throw new MapRLoginException(error, e);
        }
    }

    private HttpURLConnection getCLDBConnection(CLDBRpcCommonUtils.IpAddr cldbAddr, int cldbPort, String authScheme) {
        LOG.debug((Object)"Getting CLDB connection");
        String authUrl = this.getAuthURL(cldbAddr, cldbPort, authScheme);
        HttpURLConnection conn = null;
        try {
            SslConfig sslConfig = WebSecurityConfig.CONFIG.getSslConfig(SslConfig.SslConfigScope.SCOPE_CLIENT_ONLY);
            String trustStoreType = sslConfig.getClientTruststoreType();
            if (trustStoreType == null) {
                trustStoreType = DEFAULT_TRUSTSTORE_TYPE;
            }
            if (trustStoreType.equals(BCFKS_FIPS_STORE_TYPE)) {
                LOG.debug((Object)"Trust store type is BCFKS. Using BC FIPS provider");
                try {
                    String julLogFileName = System.getProperty("log.file");
                    julLogHandler = new FileHandler(julLogFileName + "-jul");
                    julLogHandler.setFormatter(new SimpleFormatter());
                    julRootLogger.removeHandler(julRootLogger.getHandlers()[0]);
                    julRootLogger.addHandler(julLogHandler);
                }
                catch (Exception e) {
                    LOG.info((Object)"Unable to configure BC logger. Using default configuration");
                }
                FipsLoader.loadFipsProviders();
                String trustStoreLocation = sslConfig.getClientTruststoreLocation();
                if (trustStoreLocation == null) {
                    throw new FileNotFoundException("Missing value for attribute ssl.client.truststore.location");
                }
                char[] truststorePassword = sslConfig.getClientTruststorePassword();
                if (truststorePassword == null && (truststorePassword = SecurityHelper.getPasswordFromCredStore(SecurityHelper.CredStore.CRED_TRUSTSTORE, "ssl.client.truststore.password", trustStoreType, null)) == null) {
                    throw new InvalidParameterException("Missing value for attribute ssl.client.truststore.password");
                }
                LOG.debug((Object)("Setting trust store at " + trustStoreLocation));
                File trustStoreFile = new File(trustStoreLocation);
                KeyStore trustStore = KeyStore.getInstance(trustStoreFile, truststorePassword);
                SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
                LOG.debug((Object)"Adding BCJSSE SSL context");
                KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                keyMgrFact.init(trustStore, truststorePassword);
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(trustStore);
                sslContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BCFIPS"));
                SSLSocketFactory fact = sslContext.getSocketFactory();
                LOG.debug((Object)("Opening CLDB connection to " + authUrl));
                conn = (HttpsURLConnection)new URL(authUrl).openConnection();
                ((HttpsURLConnection)conn).setSSLSocketFactory(fact);
            } else {
                LOG.debug((Object)("Opening CLDB connection to " + authUrl));
                conn = (HttpsURLConnection)new URL(authUrl).openConnection();
            }
            ((HttpsURLConnection)conn).setHostnameVerifier(new MyVerifier());
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
            conn.getOutputStream();
            return conn;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException e) {
            String error = "Unable to open connection to cldb at " + authUrl;
            if (conn != null && conn.getErrorStream() != null) {
                try {
                    String line;
                    StringBuilder sb = new StringBuilder();
                    sb.append(error);
                    sb.append(". Details: ");
                    BufferedReader input = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                    while ((line = input.readLine()) != null) {
                        sb.append(line);
                    }
                    input.close();
                    LOG.warn((Object)sb.toString());
                }
                catch (IOException ioe) {
                    LOG.warn((Object)error, (Throwable)e);
                }
            } else {
                LOG.warn((Object)error, (Throwable)e);
            }
            return null;
        }
    }

    private String getAuthURL(CLDBRpcCommonUtils.IpAddr cldbAddr, int cldbHttpsPort, String authScheme) {
        StringBuilder builder = new StringBuilder();
        builder.append("https://");
        String hostName = cldbAddr.getHostName();
        if (hostName != null && !hostName.isEmpty()) {
            builder.append(hostName);
            builder.append(":");
            builder.append(cldbHttpsPort);
        } else {
            builder.append(cldbAddr.getSockAddr(cldbHttpsPort));
        }
        builder.append(authScheme);
        return builder.toString();
    }

    static {
        kerberosRuntimeAvailable = false;
        kerberosCheckDone = false;
        windows = System.getProperty("os.name").startsWith("Windows");
        jwtTokenPath = MapRLoginHttpsClient.GetTokenPath();
        jwtRefreshTokenPath = MapRLoginHttpsClient.GetRefreshTokenPath();
        JVMProperties.init();
    }

    class MyVerifier
    implements HostnameVerifier {
        MyVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            try {
                X509Certificate[] chain = (X509Certificate[])session.getPeerCertificates();
                if (LOG.isDebugEnabled()) {
                    StringBuffer chainStr = new StringBuffer();
                    for (int i = 0; i < chain.length; ++i) {
                        chainStr.append("  Peer cert #" + i + ": " + chain[i].getSubjectX500Principal().getName() + ", signer = " + chain[i].getIssuerX500Principal().getName() + "\n");
                    }
                    LOG.debug((Object)("Certificate chain: " + chainStr));
                }
                String subject = chain[0].getSubjectX500Principal().getName();
                String issuer = chain[0].getIssuerX500Principal().getName();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Java default verification failed for cert with subject " + subject + ", custom verifier now checking."));
                }
                if (chain.length == 1 && issuer.equals(subject)) {
                    LOG.debug((Object)"Accepting self signed certificate automatically.");
                    return true;
                }
                if (chain.length == 3 && chain[2].getBasicConstraints() != -1) {
                    if (issuer.equals(chain[1].getSubjectX500Principal().getName()) && chain[1].getIssuerX500Principal().getName().equals(chain[2].getSubjectX500Principal().getName())) {
                        LOG.debug((Object)"Accepting signed certificate automatically.");
                        return true;
                    }
                    LOG.debug((Object)"Not accepting signed cert with different issuers");
                }
                LOG.warn((Object)("Peer certificate has failed verification. SubjectDN is: " + subject));
                return false;
            }
            catch (SSLPeerUnverifiedException e) {
                LOG.error((Object)"Unexpected SSL handshake issue", (Throwable)e);
                return false;
            }
        }
    }
}

