/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.insightUtils;

import com.mapr.baseutils.insightUtils.InsightClient;
import com.mapr.baseutils.insightUtils.InsightCommunicationException;
import com.mapr.baseutils.insightUtils.InsightConstants;
import com.mapr.baseutils.insightUtils.InsightService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightClientHandler
implements InsightClient {
    private static Logger log = LoggerFactory.getLogger(InsightClientHandler.class);
    private static volatile InsightClientHandler instance;
    private final InsightService insightService = InsightService.getInstance();
    private final Map<String, OperationHandler> operationHandlers = new HashMap<String, OperationHandler>();

    private InsightClientHandler() {
        this.operationHandlers.put("authentications", this::handleAuthentications);
        this.operationHandlers.put("authorizations", this::handleAuthorizations);
        this.operationHandlers.put("fileOperations", this::handleFileOperations);
        this.operationHandlers.put("config", this::handleConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InsightClientHandler getInstance() {
        if (instance != null) return instance;
        Class<InsightClientHandler> clazz = InsightClientHandler.class;
        synchronized (InsightClientHandler.class) {
            if (instance != null) return instance;
            instance = new InsightClientHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String execute(String baseUrl, List<NameValuePair> queryParams, HttpEntity requestBody, String operation) throws Exception {
        return Optional.ofNullable(this.operationHandlers.get(operation)).orElseThrow(() -> new IllegalArgumentException("Unsupported operation: " + operation)).handle(baseUrl, queryParams, requestBody);
    }

    private String handleAuthentications(String insightUrl, List<NameValuePair> queryParams, HttpEntity requestBody) throws InsightCommunicationException {
        return this.insightService.executeHttpRequest(insightUrl + "/authentications", InsightConstants.HttpMethod.GET, queryParams, null);
    }

    private String handleAuthorizations(String insightUrl, List<NameValuePair> queryParams, HttpEntity requestBody) throws InsightCommunicationException {
        return this.insightService.executeHttpRequest(insightUrl + "/authorizations", InsightConstants.HttpMethod.GET, queryParams, null);
    }

    private String handleFileOperations(String insightUrl, List<NameValuePair> queryParams, HttpEntity requestBody) throws InsightCommunicationException {
        return this.insightService.executeHttpRequest(insightUrl + "/fileOperations", InsightConstants.HttpMethod.GET, queryParams, null);
    }

    private String handleConfig(String insightUrl, List<NameValuePair> queryParams, HttpEntity requestBody) throws InsightCommunicationException {
        return this.insightService.executeHttpRequest(insightUrl + "/config", InsightConstants.HttpMethod.GET, queryParams, null);
    }

    @FunctionalInterface
    private static interface OperationHandler {
        public String handle(String var1, List<NameValuePair> var2, HttpEntity var3) throws InsightCommunicationException;
    }
}

