/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.insightUtils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mapr.baseutils.insightUtils.InsightCommunicationException;
import com.mapr.baseutils.insightUtils.InsightConstants;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightService {
    private static Logger log = LoggerFactory.getLogger(InsightService.class);
    private static volatile InsightService instance;

    private InsightService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InsightService getInstance() {
        if (instance != null) return instance;
        Class<InsightService> clazz = InsightService.class;
        synchronized (InsightService.class) {
            if (instance != null) return instance;
            instance = new InsightService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String executeHttpRequest(String url, InsightConstants.HttpMethod method, List<NameValuePair> queryParams, HttpEntity requestBody) throws InsightCommunicationException {
        try {
            HttpGet request;
            URI uri = this.buildUri(url, queryParams);
            switch (method) {
                case GET: {
                    request = new HttpGet(uri);
                    break;
                }
                case POST: {
                    HttpPost postRequest = new HttpPost(uri);
                    postRequest.setEntity(requestBody);
                    request = postRequest;
                    break;
                }
                case PUT: {
                    HttpPut putRequest = new HttpPut(uri);
                    putRequest.setEntity(requestBody);
                    request = putRequest;
                    break;
                }
                case DELETE: {
                    request = new HttpDelete(uri);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported HTTP method: " + method);
                }
            }
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            if (200 == status) {
                HttpEntity entity = response.getEntity();
                return EntityUtils.toString((HttpEntity)entity);
            }
            log.error("HTTP request failed with error code " + status);
            throw new InsightCommunicationException("HTTP request failed with error code " + status);
        }
        catch (IOException | URISyntaxException e) {
            log.error("Exception while executing HTTP request: {}", (Object)e.getMessage());
            throw new InsightCommunicationException("Exception while executing HTTP request: " + e.getMessage());
        }
    }

    private URI buildUri(String url, List<NameValuePair> queryParams) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            uriBuilder.setParameters(queryParams);
        }
        return uriBuilder.build();
    }

    private <T> T parseResponse(HttpResponse response, Class<T> responseType) throws IOException {
        HttpEntity entity = response.getEntity();
        return Optional.ofNullable(entity).map(e -> {
            try {
                String responseBody = EntityUtils.toString((HttpEntity)entity);
                return new ObjectMapper().readValue(responseBody, responseType);
            }
            catch (IOException ex) {
                log.error("Error while converting response: {}", (Object)ex.getMessage());
                return null;
            }
        }).orElse(null);
    }
}

