/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.mapr.baseutils.utils.HashMapLocks;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReentrantHashMapLocks {
    private Map<Integer, EntryLock> locksMap = new HashMap<Integer, EntryLock>();
    private Lock locksMapLock = new ReentrantLock();
    public static final Logger LOG = LoggerFactory.getLogger(HashMapLocks.class);

    public void lock(int id) {
        this.locksMapLock.lock();
        EntryLock entryLock = null;
        try {
            entryLock = this.locksMap.get(id);
            if (entryLock == null) {
                entryLock = new EntryLock();
                this.locksMap.put(id, entryLock);
            }
            entryLock.incrementRefCount();
        }
        finally {
            this.locksMapLock.unlock();
        }
        entryLock.entryLock();
    }

    public boolean tryLock(int id) {
        this.locksMapLock.lock();
        EntryLock entryLock = null;
        try {
            entryLock = this.locksMap.get(id);
            if (entryLock == null) {
                entryLock = new EntryLock();
                this.locksMap.put(id, entryLock);
            }
            entryLock.incrementRefCount();
        }
        finally {
            this.locksMapLock.unlock();
        }
        return entryLock.entryTryLock();
    }

    public void unlock(int id) {
        this.locksMapLock.lock();
        try {
            EntryLock entryLock = this.locksMap.get(id);
            entryLock.decrementRefCount();
            entryLock.entryUnlock();
            if (entryLock.getCount() == 0) {
                this.locksMap.remove(id);
            }
        }
        finally {
            this.locksMapLock.unlock();
        }
    }

    private class EntryLock {
        private short refCount = 0;
        private Lock lock = new ReentrantLock();

        EntryLock() {
        }

        void incrementRefCount() {
            this.refCount = (short)(this.refCount + 1);
        }

        void decrementRefCount() {
            this.refCount = (short)(this.refCount - 1);
        }

        short getCount() {
            return this.refCount;
        }

        void entryLock() {
            this.lock.lock();
        }

        void entryUnlock() {
            this.lock.unlock();
        }

        boolean entryTryLock() {
            return this.lock.tryLock();
        }
    }
}

