/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.cldbutils;

import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BaseUtilTests;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CldbRpcCommonUtilsTest
extends BaseUtilTests {
    @Test
    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27468")
    public void initPropertyEnvVarTest() throws Exception {
        Map map;
        Object obj;
        Field field;
        String resourcesPath = CldbRpcCommonUtilsTest.class.getResource("/").getFile();
        System.out.println(resourcesPath);
        Class<?>[] classes = Collections.class.getDeclaredClasses();
        Map<String, String> env = System.getenv();
        for (Class<?> cl : classes) {
            if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
            Field field2 = cl.getDeclaredField("m");
            field2.setAccessible(true);
            Object obj2 = field2.get(env);
            Map map2 = (Map)obj2;
            map2.put("MAPR_HOME", resourcesPath);
        }
        String maprHome = System.getenv("MAPR_HOME");
        Assert.assertTrue((boolean)resourcesPath.equalsIgnoreCase(maprHome));
        CLDBRpcCommonUtils utils = CLDBRpcCommonUtils.getInstance();
        Assert.assertNotNull((Object)utils.getCurrentClusterName());
        System.out.println(utils.getCurrentClusterName());
        Assert.assertEquals((Object)"cluster1", (Object)utils.getCurrentClusterName().toLowerCase());
        List ipPorts = (List)utils.getClusterMap().get("cluster1");
        Assert.assertEquals((long)2L, (long)ipPorts.size());
        env = System.getenv();
        for (Class<?> cl : classes) {
            if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
            field = cl.getDeclaredField("m");
            field.setAccessible(true);
            obj = field.get(env);
            map = (Map)obj;
            map.put("MAPR_HOME", resourcesPath + "opt/mapr/");
        }
        maprHome = System.getenv("MAPR_HOME");
        Assert.assertTrue((boolean)(resourcesPath + "opt/mapr/").equalsIgnoreCase(maprHome));
        utils.reloadClusterMap(null);
        Assert.assertNotNull((Object)utils.getCurrentClusterName());
        Assert.assertTrue((boolean)"cluster2".equalsIgnoreCase(utils.getCurrentClusterName()));
        ipPorts = (List)utils.getClusterMap().get("cluster2");
        Assert.assertEquals((long)1L, (long)ipPorts.size());
        env = System.getenv();
        for (Class<?> cl : classes) {
            if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
            field = cl.getDeclaredField("m");
            field.setAccessible(true);
            obj = field.get(env);
            map = (Map)obj;
            map.remove("MAPR_HOME");
        }
        maprHome = System.getenv("MAPR_HOME");
        Assert.assertNull((Object)maprHome);
        System.setProperty("mapr.home.dir", resourcesPath);
        utils.reloadClusterMap(null);
        Assert.assertNotNull((Object)utils.getCurrentClusterName());
        Assert.assertTrue((boolean)"cluster1".equalsIgnoreCase(utils.getCurrentClusterName()));
        ipPorts = (List)utils.getClusterMap().get("cluster1");
        Assert.assertEquals((long)2L, (long)ipPorts.size());
    }

    @Test
    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27468")
    public void concurModExceptionTest() throws Exception {
        String resourcesPath = CldbRpcCommonUtilsTest.class.getResource("/").getFile();
        System.out.println(resourcesPath);
        System.setProperty("mapr.home.dir", resourcesPath);
        CLDBRpcCommonUtils utils = CLDBRpcCommonUtils.getInstance();
        CLDBProto.isCLDBMasterRequest request = CLDBProto.isCLDBMasterRequest.newBuilder().build();
        utils.sendRequest("cluster1", Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.IsCLDBMasterProc.getNumber(), (MessageLite)request, CLDBProto.isCLDBMasterResponse.class);
        List ipPorts = (List)utils.getClusterMap().get("cluster1");
        Assert.assertNotNull((Object)ipPorts);
        Assert.assertNotEquals((long)2L, (long)ipPorts.size());
    }

    @Test
    public void unknownClusterTest() throws Exception {
        Method newBuilder = CLDBProto.isCLDBMasterResponse.class.getMethod("newBuilder", new Class[0]);
        Object returnObject = newBuilder.invoke(null, new Object[0]);
        Method statusMethod = returnObject.getClass().getMethod("setStatus", Integer.TYPE);
        returnObject = statusMethod.invoke(returnObject, 133);
        Method build = returnObject.getClass().getMethod("build", new Class[0]);
        MessageLite buildObject = (MessageLite)build.invoke(returnObject, new Object[0]);
        byte[] bytes = buildObject.toByteArray();
        Assert.assertNotNull((Object)bytes);
        CLDBProto.isCLDBMasterResponse resp = CLDBProto.isCLDBMasterResponse.parseFrom((byte[])bytes);
        Assert.assertEquals((long)133L, (long)resp.getStatus());
    }

    @Test
    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27468")
    public void concurClusterModTest() throws Exception {
        Object resourcesPath = CldbRpcCommonUtilsTest.class.getResource("/").getPath();
        String[] pathes = ((String)resourcesPath).split("baseutils", 2);
        resourcesPath = pathes[0] + "baseutils/src/test/resources/";
        System.out.println((String)resourcesPath);
        System.setProperty("mapr.home.dir", (String)resourcesPath);
        final CLDBRpcCommonUtils utils = CLDBRpcCommonUtils.getInstance();
        String currClusterName = utils.getCurrentClusterName();
        Assert.assertEquals((String)("currClusterName: " + currClusterName), (Object)"cluster1", (Object)currClusterName);
        Thread oneThread = new Thread(new Runnable(){

            @Override
            public void run() {
                utils.reloadClusterMap(null);
            }
        });
        Thread twoThread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    String clusterName = utils.getCurrentClusterName();
                    Assert.assertNotNull((Object)clusterName);
                    Assert.assertTrue((String)("currClusterName: " + clusterName), (boolean)"cluster1".equals(clusterName));
                }
            }
        });
        twoThread.start();
        oneThread.start();
    }
}

