/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.google.common.base.Preconditions;
import com.mapr.baseutils.Installation;
import com.mapr.web.security.SslConfig;
import com.mapr.web.security.XmlSslConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(WebSecurityConfig.class);
    public static final WebSecurityConfig CONFIG = new WebSecurityConfig();
    private static final String UNSET_PROCESS_NAME = "<UNSET_PROCESS_NAME>";
    private String processName = "<UNSET_PROCESS_NAME>";
    private final String maprHome;
    private final String maprConfDir;
    private final String maprImpersonationEnabled = System.getenv("MAPR_IMPERSONATION_ENABLED");
    private final String maprClusterCfgLocation;
    private final String maprServerTicketName = "maprserverticket";
    private final String authTokenPropSuffix = "auth.token.secret";
    private final String authExprPropSuffix = "auth.token.expiration";

    private WebSecurityConfig() {
        this.maprHome = Installation.getMapRHome();
        this.maprConfDir = Installation.getMaprConfDir();
        this.maprClusterCfgLocation = Installation.getMaprClusterCfgLocation();
    }

    public String getProcessName() {
        if (this.processName == UNSET_PROCESS_NAME) {
            log.warn("A process name has not been set using com.mapr.security.web.Config.setProcessName()");
        }
        return this.processName;
    }

    public SslConfig getSslConfig() throws SecurityException {
        return this.getSslConfig(SslConfig.SslConfigScope.SCOPE_ALL);
    }

    public SslConfig getSslConfig(SslConfig.SslConfigScope scope) throws SecurityException {
        return new XmlSslConfig(scope);
    }

    public WebSecurityConfig setProcessName(String processName) {
        Preconditions.checkNotNull((Object)processName);
        if (this.processName == UNSET_PROCESS_NAME) {
            log.info("Setting the current process name to '{}'", (Object)processName);
            this.processName = processName;
        } else if (this.processName != processName) {
            log.warn("Attempt to reset the process({}) name to '{}'", (Object)this.processName, (Object)processName);
        }
        return this;
    }

    public String getMaprHome() {
        return this.maprHome;
    }

    public String getMaprConfDir() {
        return this.maprConfDir;
    }

    public String getMaprImpersonationEnabled() {
        return this.maprImpersonationEnabled;
    }

    public String getMaprClusterCfgLocation() {
        return this.maprClusterCfgLocation;
    }

    public String getMaprServerTicketName() {
        return this.maprServerTicketName;
    }

    public String getAuthTokenPropSuffix() {
        return this.authTokenPropSuffix;
    }

    public String getAuthExprPropSuffix() {
        return this.authExprPropSuffix;
    }
}

