/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.metric;

import com.mapr.baseutils.metric.MetricRepo;
import com.mapr.baseutils.metric.MetricRepoBase;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMetricRepo
extends MetricRepoBase
implements MetricRepo {
    private static final Logger LOG = LoggerFactory.getLogger(TaskMetricRepo.class);
    private static final String taskInsertSQL = "insert into metrics.TASK (TASK_ID, JOB_ID, TYPE, STATUS, TIME_STARTED) values(?, ?, ?, ?, ?)";
    private static final String taskUpdateSQL = "update metrics.TASK set SUCCESS_ATTEMPT_ID = IFNULL(SUCCESS_ATTEMPT_ID, ?), INPUT_SPLIT_LOCATIONS = IFNULL(INPUT_SPLIT_LOCATIONS, ?), INPUT_SPLIT_INFO = IFNULL(INPUT_SPLIT_INFO, ?), STATUS = IFNULL(STATUS, ?), TIME_STARTED = IFNULL(TIME_STARTED, ?), TIME_FINISHED = IFNULL(TIME_FINISHED, ?) WHERE TASK_ID = ?";
    private ClusterMetricsProto.TaskMetric taskMetric;

    public TaskMetricRepo(ClusterMetricsProto.TaskMetric taskMetric) {
        this.taskMetric = taskMetric;
    }

    @Override
    public List<ClusterMetricsProto.Counters> prepareTransactions() {
        ArrayList<ClusterMetricsProto.Counters> metricTransacions = new ArrayList<ClusterMetricsProto.Counters>();
        return metricTransacions;
    }

    @Override
    public ClusterMetricsProto.MetricAttributes getMetricAttributes() {
        if (this.taskMetric.hasAttributes()) {
            return this.taskMetric.getAttributes();
        }
        return null;
    }

    @Override
    public MetricRepo.MetricType getMetricType() {
        return MetricRepo.MetricType.TASK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeDBOperations(Connection dbConnection) throws SQLException {
        block30: {
            if (this.taskMetric.hasFinalMetric()) {
                String taskId;
                ClusterMetricsProto.TaskMetric.FinalMetric tFinalMetric;
                block29: {
                    tFinalMetric = this.taskMetric.getFinalMetric();
                    taskId = tFinalMetric.getId();
                    try (PreparedStatement taskInsertPrepStmt = dbConnection.prepareStatement(taskInsertSQL);){
                        taskInsertPrepStmt.setString(1, taskId);
                        taskInsertPrepStmt.setString(2, tFinalMetric.getJobId());
                        taskInsertPrepStmt.setString(3, tFinalMetric.getType());
                        if (tFinalMetric.hasStatus()) {
                            taskInsertPrepStmt.setString(4, tFinalMetric.getStatus());
                        } else {
                            taskInsertPrepStmt.setNull(4, 1);
                        }
                        if (tFinalMetric.hasStartTime()) {
                            taskInsertPrepStmt.setLong(5, tFinalMetric.getStartTime());
                        } else {
                            taskInsertPrepStmt.setNull(5, -5);
                        }
                        try {
                            taskInsertPrepStmt.executeUpdate();
                        }
                        catch (SQLException e) {
                            if (e.getErrorCode() == 1062) {
                                break block29;
                            }
                            LOG.error("Exception while trying to insert Task: ", (Throwable)e);
                            throw e;
                        }
                    }
                }
                try (PreparedStatement taskUpdatePrepStmt = dbConnection.prepareStatement(taskUpdateSQL);){
                    if (tFinalMetric.hasSuccessTaskAttemptId()) {
                        taskUpdatePrepStmt.setString(1, tFinalMetric.getSuccessTaskAttemptId());
                    } else {
                        taskUpdatePrepStmt.setNull(1, 1);
                    }
                    if (tFinalMetric.hasInputSplitLocations()) {
                        taskUpdatePrepStmt.setString(2, tFinalMetric.getInputSplitLocations());
                    } else {
                        taskUpdatePrepStmt.setNull(2, 1);
                    }
                    if (tFinalMetric.hasInputSplitInfo()) {
                        taskUpdatePrepStmt.setString(3, tFinalMetric.getInputSplitInfo());
                    } else {
                        taskUpdatePrepStmt.setNull(3, 1);
                    }
                    if (tFinalMetric.hasStatus()) {
                        taskUpdatePrepStmt.setString(4, tFinalMetric.getStatus());
                    } else {
                        taskUpdatePrepStmt.setNull(4, 1);
                    }
                    if (tFinalMetric.hasStartTime()) {
                        taskUpdatePrepStmt.setLong(5, tFinalMetric.getStartTime());
                    } else {
                        taskUpdatePrepStmt.setNull(5, -5);
                    }
                    if (tFinalMetric.hasEndTime()) {
                        taskUpdatePrepStmt.setLong(6, tFinalMetric.getEndTime());
                    } else {
                        taskUpdatePrepStmt.setNull(6, -5);
                    }
                    taskUpdatePrepStmt.setString(7, taskId);
                    try {
                        taskUpdatePrepStmt.executeUpdate();
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 1062) {
                            break block30;
                        }
                        LOG.error("Exception while trying to update Task: ", (Throwable)e);
                        throw e;
                    }
                }
            }
        }
    }

    @Override
    public List<ClusterMetricsProto.Pair> prepareEvents() {
        ClusterMetricsProto.TaskMetric.EventMetric taEventMetric;
        ArrayList<ClusterMetricsProto.Pair> events = new ArrayList<ClusterMetricsProto.Pair>();
        if (this.taskMetric.hasEventMetric() && this.taskMetric.hasAttributes() && (taEventMetric = this.taskMetric.getEventMetric()).hasStatus()) {
            events.add(ClusterMetricsProto.Pair.newBuilder().setName("TSTATUS").setValue(taEventMetric.getStatus()).build());
        }
        return events;
    }
}

