/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AceHelper {
    public static final Logger LOG = LoggerFactory.getLogger(AceHelper.class);
    private static String CurrentPermission;
    private static int index;
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    private static final String APPENDPERM = "appendperm";
    private static final String BULKLOADPERM = "bulkloadperm";
    private static final String SPLITMERGEPERM = "splitmergeperm";
    private static final String COMPRESSIONPERM = "compressionperm";
    private static final String DELETEFAMILYPERM = "deletefamilyperm";
    private static final String ENCRYPTPERM = "encryptperm";
    private static final String MEMORYPERM = "memoryperm";
    private static final String CREATERENAMEFAMILYPERM = "createrenamefamilyperm";
    private static final String PACKPERM = "packperm";
    private static final String READPERM = "readperm";
    private static final String UNMASKEDREADPERM = "unmaskedreadperm";
    private static final String VERSIONSPERM = "versionperm";
    private static final String WRITEPERM = "writeperm";
    private static final String ACEADMINPERM = "adminaccessperm";
    private static final String REPLPERM = "replperm";
    private static final String INDEXPERM = "indexperm";
    private static final String TRAVERSEPERM = "traverseperm";
    private static final String VERSIONDEFAULTPERM = "defaultversionperm";
    private static final String COMPRESSIONDEFAULTPERM = "defaultcompressionperm";
    private static final String MEMORYDEFAULTPERM = "defaultmemoryperm";
    private static final String WRITEDEFAULTPERM = "defaultwriteperm";
    private static final String APPENDDEFAULTPERM = "defaultappendperm";
    private static final String READDEFAULTPERM = "defaultreadperm";
    private static final String UNMASKEDREADDEFAULTPERM = "defaultunmaskedreadperm";
    private static final String ENCRYPTDEFAULTPERM = "defaultencryptperm";
    private static final String TRAVERSEDEFAULTPERM = "defaulttraverseperm";
    public static final String FILEREAD = "readfile";
    public static final String FILEWRITE = "writefile";
    public static final String FILEEXECUTE = "executefile";
    public static final String READDIR = "readdir";
    public static final String ADDCHILD = "addchild";
    public static final String DELETECHILD = "deletechild";
    public static final String LOOKUPDIR = "lookupdir";
    private static UnixUserGroupHelper ugHelper;
    public static final Map<Common.FSAccessType, String> fsPermissionMap;
    public static final Map<Dbserver.DBAccessType, String> tblPermissionMap;
    public static final Map<String, Dbserver.DBAccessType> tblAccessTypeMap;
    public static final Map<Dbserver.DBAccessType, String> cfDefPermissionMap;
    public static final Map<Dbserver.DBAccessType, String> cfPermissionMap;
    public static final Map<String, Dbserver.DBAccessType> cfAccessTypeMap;
    public static final Map<Dbserver.DBAccessType, String> colPermissionMap;
    public static final Map<String, Dbserver.DBAccessType> colAccessTypeMap;
    public static final Set<String> TABLE_PERMISSIONS;
    public static final Set<String> FAMILY_PERMISSIONS;
    public static final Set<String> COLUMN_PERMISSIONS;

    public static String getPermissionsListForShellHelp() {
        return "  For tables:\n    \"splitmergeperm\"          Split and Merge Permission settings\n    \"bulkloadperm\"            Bulk load Permission settings\n    \"deletefamilyperm\"        Delete Family Permission settings\n    \"createrenamefamilyperm\"  Add/Rename Family Permission settings\n    \"packperm\"                Pack Permission settings\n    \"adminaccessperm\"         Modify Admin access Permission settings\n    \"replperm\"                Modify Replication Admin settings\n    \"indexperm\"               Modify Secondary Index Admin settings\n    \"defaultappendperm\"       CF Append Default Permission\n    \"defaultcompressionperm\"  CF Compression Default Permission\n    \"defaultencryptperm\"      CF Encrypt Default Permission\n    \"defaultmemoryperm\"       CF Memory Default Permission\n    \"defaultreadperm\"         CF Read Default Permission\n    \"defaultunmaskedreadperm\" CF Unmasked Read Default Permission\n    \"defaultversionperm\"      CF Set Versions/TTL Default Permission\n    \"defaultwriteperm\"        CF Write Default Permission\n\n  For column families:\n    \"appendperm\"              Append Permissions\n    \"compressionperm\"         Compression Permissions\n    \"encryptperm\"             Encrypt Permissions\n    \"memoryperm\"              Memory Permissions\n    \"readperm\"                Read Permissions\n    \"unmaskedreadperm\"        Unmasked Read Permissions\n    \"versionperm\"             Set Versions/TTL Permissions\n    \"writeperm\"               Write Permissions\n    \"traverseperm\"            Traverse Permissions\n\n  For column qualifiers:\n    \"appendperm\"              Append Permissions\n    \"encryptperm\"             Encrypt Permissions\n    \"readperm\"                Read Permissions\n    \"unmaskedreadperm\"        Unmasked Read Permissions\n    \"writeperm\"               Write Permissions\n    \"traverseperm\"            Traverse Permissions";
    }

    public static String toInfix(String postfix) throws IOException {
        if (postfix == null || postfix.length() == 0) {
            return "";
        }
        Stack<Object> expression = new Stack<Object>();
        for (String token : postfix.split(" ")) {
            String opp;
            boolean isOper;
            if (token.equals("&")) {
                isOper = true;
                opp = "|";
            } else if (token.equals("|")) {
                isOper = true;
                opp = "&";
            } else if (token.equals("!")) {
                isOper = true;
                opp = "";
            } else {
                isOper = false;
                opp = "";
            }
            if (isOper) {
                if (expression.empty()) {
                    AceHelper.conversionError("Unbalanced expression");
                }
                Object popped_expression = (String)expression.pop();
                if (!opp.equals("")) {
                    if (expression.empty()) {
                        AceHelper.conversionError("Unbalanced expression");
                    }
                    Object popped_expression_2 = (String)expression.pop();
                    if (((String)popped_expression).contains(opp) && !((String)popped_expression).startsWith("!(")) {
                        popped_expression = "(" + (String)popped_expression + ")";
                    }
                    if (((String)popped_expression_2).contains(opp) && !((String)popped_expression).startsWith("!(")) {
                        popped_expression_2 = "(" + (String)popped_expression_2 + ")";
                    }
                    expression.push((String)popped_expression_2 + " " + token + " " + (String)popped_expression);
                    continue;
                }
                if (((String)popped_expression).contains("&") || ((String)popped_expression).contains("|")) {
                    expression.push(token + "(" + (String)popped_expression + ")");
                    continue;
                }
                expression.push(token + (String)popped_expression);
                continue;
            }
            if (token.isEmpty()) continue;
            expression.push(AceHelper.convertToName(token));
        }
        if (expression.size() != 1) {
            AceHelper.conversionError("Converting expression contains more expressions than operators");
        }
        return (String)expression.pop();
    }

    private static void conversionError(String message) throws IOException {
        throw new IOException("An error has occurred " + message);
    }

    public static String toPostfix(String permission) throws IOException {
        if (permission == null || permission.length() == 0) {
            return "";
        }
        if ((permission = permission.trim()).length() == 0) {
            throw new IOException("Invalid ace expression");
        }
        if (permission.equals("p")) {
            return permission;
        }
        Stack<Character> operatorStack = new Stack<Character>();
        StringBuilder current = new StringBuilder();
        StringBuilder result = new StringBuilder(permission.length());
        int subexpr = 0;
        HashMap<Integer, Character> subexprOper = new HashMap<Integer, Character>();
        String operOrder = null;
        boolean expectOper = false;
        CurrentPermission = permission;
        for (int i = 0; i < permission.length(); ++i) {
            index = i;
            char ch = permission.charAt(i);
            operOrder = AceHelper.getOperatorPrecedence(Character.valueOf(ch));
            if (operOrder != null) {
                if ((current = new StringBuilder(current.toString().trim())).length() > 0) {
                    result.append((CharSequence)AceHelper.checkExpression(current));
                    current = new StringBuilder();
                    expectOper = true;
                }
                if (!operOrder.equals("")) {
                    if (operOrder.equals("!")) {
                        AceHelper.runCheck(expectOper || current.length() > 0, "Expected 'not' to proceed expression");
                    } else {
                        AceHelper.runCheck(!expectOper, "Expected expression, operator '" + ch + "' was given");
                        if (!subexprOper.containsKey(subexpr)) {
                            subexprOper.put(subexpr, Character.valueOf(ch));
                        } else {
                            AceHelper.runCheck(((Character)subexprOper.get(subexpr)).charValue() != ch, "Cannot combine & and | without using parenthesies ( )");
                        }
                    }
                    result.append((CharSequence)AceHelper.checkStack(operOrder, operatorStack));
                    expectOper = false;
                    operatorStack.push(Character.valueOf(ch));
                    continue;
                }
                if (ch == '(') {
                    AceHelper.runCheck(expectOper, "Expected parentheses to follow operator");
                    operatorStack.push(Character.valueOf(ch));
                    ++subexpr;
                    continue;
                }
                if (ch != ')') continue;
                AceHelper.runCheck(!expectOper, "Expected expression to proceed end parentheses");
                expectOper = true;
                result.append((CharSequence)AceHelper.checkStack("!&|", operatorStack));
                subexprOper.remove(subexpr);
                AceHelper.runCheck(--subexpr < 0, "Mismatched parenthesies");
                operatorStack.pop();
                continue;
            }
            if (current.toString().trim().length() > 0) {
                AceHelper.runCheck(expectOper, "Expected operator and got expression instead");
                expectOper = false;
            }
            current.append(ch);
        }
        if ((current = new StringBuilder(current.toString().trim())).length() > 0) {
            result.append((CharSequence)AceHelper.checkExpression(current));
            expectOper = true;
        }
        while (!operatorStack.empty()) {
            if (((Character)operatorStack.peek()).charValue() != '(') {
                result.append(" ");
                result.append(operatorStack.pop());
                continue;
            }
            operatorStack.pop();
        }
        AceHelper.runCheck(!expectOper, "Expression ended with operator");
        AceHelper.runCheck(subexpr != 0, "Mismatched parentheses");
        index = -1;
        CurrentPermission = null;
        return result.toString().trim();
    }

    private static StringBuilder checkStack(String validators, Stack<Character> oper) {
        StringBuilder result = new StringBuilder();
        while (!oper.empty() && validators.indexOf(oper.peek().charValue()) > -1) {
            result.append(" ");
            result.append(oper.pop());
        }
        return result;
    }

    private static String getOperatorPrecedence(Character ch) {
        switch (ch.charValue()) {
            case '(': 
            case ')': {
                return "";
            }
            case '&': {
                return "!&";
            }
            case '!': {
                return "!";
            }
            case '|': {
                return "!&|";
            }
        }
        return null;
    }

    private static String convertToName(String current) throws IOException {
        Object idToName = current;
        if (ugHelper == null) {
            ugHelper = new UnixUserGroupHelper();
        }
        try {
            if (current.charAt(0) == 'u') {
                idToName = "u:" + ugHelper.getUsername(Integer.parseInt(current.substring(2)));
            } else if (current.charAt(0) == 'g') {
                idToName = "g:" + ugHelper.getGroupname(Integer.parseInt(current.substring(2)));
            } else if (current.charAt(0) == 'm') {
                long seconds = Long.parseLong(current.substring(2));
                idToName = "m:" + (seconds % 86400L == 0L ? seconds / 86400L + "d" : seconds + "s");
            } else if (current.charAt(0) == 'a') {
                long seconds = Long.parseLong(current.substring(2));
                idToName = "a:" + (seconds % 86400L == 0L ? seconds / 86400L + "d" : seconds + "s");
            } else if (current.charAt(0) == 's') {
                long size = Long.parseLong(current.substring(2), 10);
                idToName = size % 0x40000000L == 0L ? "s:" + size / 0x40000000L + "g" : (size % 0x100000L == 0L ? "s:" + size / 0x100000L + "m" : (size % 1024L == 0L ? "s:" + size / 1024L + "k" : "s:" + size + "b"));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Error processing \"" + current + "\". Cannot extract uid/gid from this value.");
        }
        catch (SecurityException se) {
            LOG.error("Error processing ID: \"" + current + "\" : " + se.getMessage());
            return current;
        }
        return idToName;
    }

    private static StringBuilder convertToId(StringBuilder current) throws IOException {
        if (ugHelper == null) {
            ugHelper = new UnixUserGroupHelper();
        }
        String id = current.substring(2);
        try {
            try {
                current = new StringBuilder(current.charAt(0) + ":" + Integer.parseInt(id));
                if (current.charAt(0) == 'u') {
                    String name = ugHelper.getUsername(Integer.parseInt(id));
                } else if (current.charAt(0) == 'g') {
                    String string = ugHelper.getGroupname(Integer.parseInt(id));
                }
            }
            catch (NumberFormatException e) {
                if (current.charAt(0) == 'u') {
                    current = new StringBuilder("u:" + ugHelper.getUserId(id));
                } else if (current.charAt(0) == 'g') {
                    current = new StringBuilder("g:" + ugHelper.getGroupId(id));
                }
            }
        }
        catch (SecurityException se) {
            throw new IOException("Error occured. " + se.getMessage());
        }
        return current;
    }

    private static StringBuilder checkExpression(StringBuilder current) throws IOException {
        AceHelper.runCheck("ugrpmas".indexOf(current.charAt(0)) == -1, current, 0, "Expected permission to start with one of 'ugrpms'");
        if (current.charAt(0) == 'p') {
            AceHelper.runCheck(true, current, 0, "Expected 'p' to be by itself.");
        } else {
            AceHelper.runCheck(current.length() < 2 || current.charAt(1) != ':', current, 0, "Expected ':' to follow 'urgmas'");
            AceHelper.runCheck(current.length() < 3, current, 0, "Expected username/groupname/rolename/mtime/atime to follow ':'");
            if (current.charAt(0) == 'm') {
                char lastChar = current.charAt(current.length() - 1);
                AceHelper.runCheck(lastChar != 'd' && lastChar != 's', current, current.length() - 1, "Expected 'd' or 's' at the end of mtime");
                current.setLength(current.length() - 1);
                current.delete(0, 2);
                long seconds = 0L;
                try {
                    if (Long.parseLong(current.toString(), 10) < 0L) {
                        throw new NumberFormatException();
                    }
                    seconds = lastChar == 'd' ? Long.parseLong(current.toString(), 10) * 24L * 60L * 60L : Long.parseLong(current.toString(), 10);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Error processing '" + current + "'. Cannot extract mtime from this value.");
                }
                return new StringBuilder(" m:" + seconds);
            }
            if (current.charAt(0) == 'a') {
                char lastChar = current.charAt(current.length() - 1);
                AceHelper.runCheck(lastChar != 'd' && lastChar != 's', current, current.length() - 1, "Expected 'd' or 's' at the end of atime");
                current.setLength(current.length() - 1);
                current.delete(0, 2);
                long seconds = 0L;
                try {
                    if (Long.parseLong(current.toString(), 10) < 0L) {
                        throw new NumberFormatException();
                    }
                    seconds = lastChar == 'd' ? Long.parseLong(current.toString(), 10) * 24L * 60L * 60L : Long.parseLong(current.toString(), 10);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Error processing '" + current + "'. Cannot extract atime from this value.");
                }
                return new StringBuilder(" a:" + seconds);
            }
            if (current.charAt(0) == 's') {
                char lastChar = current.charAt(current.length() - 1);
                AceHelper.runCheck(lastChar != 'g' && lastChar != 'm' && lastChar != 'k' && lastChar != 'b', current, current.length() - 1, "Expected 'g' or 'm' or 'k' or 'b' at the end of size");
                current.setLength(current.length() - 1);
                current.delete(0, 2);
                long size = 0L;
                try {
                    if (Long.parseLong(current.toString(), 10) < 0L) {
                        throw new NumberFormatException();
                    }
                    size = lastChar == 'g' ? Long.parseLong(current.toString(), 10) * 1024L * 1024L * 1024L : (lastChar == 'm' ? Long.parseLong(current.toString(), 10) * 1024L * 1024L : (lastChar == 'k' ? Long.parseLong(current.toString(), 10) * 1024L : Long.parseLong(current.toString(), 10)));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Error processing '" + current + "'. Cannot extract size from this value.");
                }
                return new StringBuilder(" s:" + size);
            }
            if (current.charAt(0) == 'r') {
                int currentLen = current.length();
                for (int k = 2; k < currentLen; ++k) {
                    char ch = current.charAt(k);
                    boolean isInvalidChar = !(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_');
                    AceHelper.runCheck(isInvalidChar, current, k, "Expected alphanumaric or '-' or '_' only for role names");
                }
            }
            if (current.charAt(0) != 'r') {
                current = AceHelper.convertToId(current);
            }
        }
        current.insert(0, " ");
        return current;
    }

    private static void runCheck(boolean check, String message) throws IOException {
        if (check) {
            throw new IOException("Error occured '" + CurrentPermission.substring(0, index + 1) + "\u001b[31m[\u001b[0m" + CurrentPermission.charAt(index) + "\u001b[31m]\u001b[0m" + CurrentPermission.substring(index + 1) + "' at position '" + index + "'. " + message);
        }
    }

    private static void runCheck(boolean check, StringBuilder token, int index, String message) throws IOException {
        if (check) {
            throw new IOException("Error occured in token '" + token.substring(0, index + 1) + "\u001b[31m[\u001b[0m" + token.charAt(index) + "\u001b[31m]\u001b[0m" + token.substring(index + 1) + "' at position '" + index + "'. " + message);
        }
    }

    public static ArrayList<Dbserver.AccessControlExpression> getColumnPermission(JSONObject json) throws IOException, JSONException {
        ArrayList<Dbserver.AccessControlExpression> ace = new ArrayList<Dbserver.AccessControlExpression>();
        for (Map.Entry<Dbserver.DBAccessType, String> entry : colPermissionMap.entrySet()) {
            String val = entry.getValue();
            if (!json.has(val)) continue;
            ace.add(Dbserver.AccessControlExpression.newBuilder().setAccessType(entry.getKey()).setBooleanExpression(ByteString.copyFromUtf8((String)AceHelper.toPostfix(json.getString(val)))).build());
        }
        return ace;
    }

    public static Dbserver.TableAces getTablePermission(DBPermission dbperm) throws IOException {
        return Dbserver.TableAces.newBuilder().addAllAces(AceHelper.getPermission(dbperm, tblPermissionMap)).addAllDefaultColumnFamilyAces(AceHelper.getPermission(dbperm, cfDefPermissionMap)).build();
    }

    public static ArrayList<Dbserver.AccessControlExpression> getColumnPermission(DBPermission dbperm) throws IOException {
        return AceHelper.getPermission(dbperm, colPermissionMap);
    }

    public static ArrayList<Dbserver.AccessControlExpression> getCfPermission(DBPermission dbperm) throws IOException {
        return AceHelper.getPermission(dbperm, cfPermissionMap);
    }

    private static ArrayList<Dbserver.AccessControlExpression> getPermission(DBPermission cliClass, Map<Dbserver.DBAccessType, String> permissionMap) throws IOException {
        ArrayList<Dbserver.AccessControlExpression> ace = new ArrayList<Dbserver.AccessControlExpression>();
        for (Map.Entry<Dbserver.DBAccessType, String> entry : permissionMap.entrySet()) {
            String val = cliClass.getCliParam(entry.getValue());
            if (val == null) continue;
            ace.add(Dbserver.AccessControlExpression.newBuilder().setAccessType(entry.getKey()).setBooleanExpression(ByteString.copyFromUtf8((String)AceHelper.toPostfix(val))).build());
        }
        return ace;
    }

    public static ArrayList<Common.FileACE> getFilePermission(FSPermission fsperm) throws IOException {
        return AceHelper.getPermission(fsperm, fsPermissionMap);
    }

    private static ArrayList<Common.FileACE> getPermission(FSPermission cliClass, Map<Common.FSAccessType, String> permissionMap) throws IOException {
        ArrayList<Common.FileACE> ace = new ArrayList<Common.FileACE>();
        for (Map.Entry<Common.FSAccessType, String> entry : permissionMap.entrySet()) {
            String val = cliClass.getCliParam(entry.getValue());
            if (val == null) continue;
            ace.add(Common.FileACE.newBuilder().setAccessType(entry.getKey()).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix(val))).build());
        }
        return ace;
    }

    static {
        ugHelper = null;
        fsPermissionMap = new ImmutableMap.Builder().put((Object)Common.FSAccessType.AceRead, (Object)FILEREAD).put((Object)Common.FSAccessType.AceWrite, (Object)FILEWRITE).put((Object)Common.FSAccessType.AceExecute, (Object)FILEEXECUTE).put((Object)Common.FSAccessType.AceReadDir, (Object)READDIR).put((Object)Common.FSAccessType.AceAddChild, (Object)ADDCHILD).put((Object)Common.FSAccessType.AceDeleteChild, (Object)DELETECHILD).put((Object)Common.FSAccessType.AceLookupDir, (Object)LOOKUPDIR).build();
        tblPermissionMap = new ImmutableMap.Builder().put((Object)Dbserver.DBAccessType.ForcePack, (Object)PACKPERM).put((Object)Dbserver.DBAccessType.SplitMerge, (Object)SPLITMERGEPERM).put((Object)Dbserver.DBAccessType.SchemaAddRenameFamily, (Object)CREATERENAMEFAMILYPERM).put((Object)Dbserver.DBAccessType.SchemaRemoveFamily, (Object)DELETEFAMILYPERM).put((Object)Dbserver.DBAccessType.TableSchemaAceAdmin, (Object)ACEADMINPERM).put((Object)Dbserver.DBAccessType.BulkLoad, (Object)BULKLOADPERM).put((Object)Dbserver.DBAccessType.Repl, (Object)REPLPERM).put((Object)Dbserver.DBAccessType.Index, (Object)INDEXPERM).build();
        tblAccessTypeMap = new ImmutableMap.Builder().put((Object)PACKPERM, (Object)Dbserver.DBAccessType.ForcePack).put((Object)SPLITMERGEPERM, (Object)Dbserver.DBAccessType.SplitMerge).put((Object)CREATERENAMEFAMILYPERM, (Object)Dbserver.DBAccessType.SchemaAddRenameFamily).put((Object)DELETEFAMILYPERM, (Object)Dbserver.DBAccessType.SchemaRemoveFamily).put((Object)ACEADMINPERM, (Object)Dbserver.DBAccessType.TableSchemaAceAdmin).put((Object)BULKLOADPERM, (Object)Dbserver.DBAccessType.BulkLoad).put((Object)REPLPERM, (Object)Dbserver.DBAccessType.Repl).put((Object)INDEXPERM, (Object)Dbserver.DBAccessType.Index).build();
        cfDefPermissionMap = new ImmutableMap.Builder().put((Object)Dbserver.DBAccessType.FamilySetMinMaxVersions, (Object)VERSIONDEFAULTPERM).put((Object)Dbserver.DBAccessType.FamilySetCompressions, (Object)COMPRESSIONDEFAULTPERM).put((Object)Dbserver.DBAccessType.FamilyPinCFInMemory, (Object)MEMORYDEFAULTPERM).put((Object)Dbserver.DBAccessType.FamilyReadData, (Object)READDEFAULTPERM).put((Object)Dbserver.DBAccessType.FamilyUnmaskedReadData, (Object)UNMASKEDREADDEFAULTPERM).put((Object)Dbserver.DBAccessType.FamilyWriteData, (Object)WRITEDEFAULTPERM).put((Object)Dbserver.DBAccessType.FamilyAppendData, (Object)APPENDDEFAULTPERM).put((Object)Dbserver.DBAccessType.FamilyEncryptData, (Object)ENCRYPTDEFAULTPERM).put((Object)Dbserver.DBAccessType.FamilyTraverseData, (Object)TRAVERSEDEFAULTPERM).build();
        cfPermissionMap = new ImmutableMap.Builder().put((Object)Dbserver.DBAccessType.FamilySetMinMaxVersions, (Object)VERSIONSPERM).put((Object)Dbserver.DBAccessType.FamilySetCompressions, (Object)COMPRESSIONPERM).put((Object)Dbserver.DBAccessType.FamilyPinCFInMemory, (Object)MEMORYPERM).put((Object)Dbserver.DBAccessType.FamilyReadData, (Object)READPERM).put((Object)Dbserver.DBAccessType.FamilyUnmaskedReadData, (Object)UNMASKEDREADPERM).put((Object)Dbserver.DBAccessType.FamilyWriteData, (Object)WRITEPERM).put((Object)Dbserver.DBAccessType.FamilyAppendData, (Object)APPENDPERM).put((Object)Dbserver.DBAccessType.FamilyEncryptData, (Object)ENCRYPTPERM).put((Object)Dbserver.DBAccessType.FamilyTraverseData, (Object)TRAVERSEPERM).build();
        cfAccessTypeMap = new ImmutableMap.Builder().put((Object)VERSIONSPERM, (Object)Dbserver.DBAccessType.FamilySetMinMaxVersions).put((Object)COMPRESSIONPERM, (Object)Dbserver.DBAccessType.FamilySetCompressions).put((Object)MEMORYPERM, (Object)Dbserver.DBAccessType.FamilyPinCFInMemory).put((Object)READPERM, (Object)Dbserver.DBAccessType.FamilyReadData).put((Object)UNMASKEDREADPERM, (Object)Dbserver.DBAccessType.FamilyUnmaskedReadData).put((Object)WRITEPERM, (Object)Dbserver.DBAccessType.FamilyWriteData).put((Object)APPENDPERM, (Object)Dbserver.DBAccessType.FamilyAppendData).put((Object)ENCRYPTPERM, (Object)Dbserver.DBAccessType.FamilyEncryptData).put((Object)TRAVERSEPERM, (Object)Dbserver.DBAccessType.FamilyTraverseData).build();
        colPermissionMap = new ImmutableMap.Builder().put((Object)Dbserver.DBAccessType.ColumnReadData, (Object)READPERM).put((Object)Dbserver.DBAccessType.ColumnUnmaskedReadData, (Object)UNMASKEDREADPERM).put((Object)Dbserver.DBAccessType.ColumnWriteData, (Object)WRITEPERM).put((Object)Dbserver.DBAccessType.ColumnAppendData, (Object)APPENDPERM).put((Object)Dbserver.DBAccessType.ColumnEncrypt, (Object)ENCRYPTPERM).put((Object)Dbserver.DBAccessType.ColumnTraverseData, (Object)TRAVERSEPERM).build();
        colAccessTypeMap = new ImmutableMap.Builder().put((Object)READPERM, (Object)Dbserver.DBAccessType.ColumnReadData).put((Object)UNMASKEDREADPERM, (Object)Dbserver.DBAccessType.ColumnUnmaskedReadData).put((Object)WRITEPERM, (Object)Dbserver.DBAccessType.ColumnWriteData).put((Object)APPENDPERM, (Object)Dbserver.DBAccessType.ColumnAppendData).put((Object)ENCRYPTPERM, (Object)Dbserver.DBAccessType.ColumnEncrypt).put((Object)TRAVERSEPERM, (Object)Dbserver.DBAccessType.ColumnTraverseData).build();
        TABLE_PERMISSIONS = new HashSet<String>(){
            {
                this.addAll(tblPermissionMap.values());
                this.addAll(cfDefPermissionMap.values());
            }
        };
        FAMILY_PERMISSIONS = new HashSet<String>(){
            {
                this.addAll(cfPermissionMap.values());
            }
        };
        COLUMN_PERMISSIONS = new HashSet<String>(){
            {
                this.addAll(colPermissionMap.values());
            }
        };
    }

    public static interface DBPermission {
        public String getCliParam(String var1) throws IOException;
    }

    public static interface FSPermission {
        public String getCliParam(String var1) throws IOException;
    }
}

