/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.mapr.security.SecurityHelper;

public class HadoopCredsTest {
    private static void usage() {
        System.out.println("Usage: java HadoopCredsTest <credstore> <alias> <storetype> <storepass>");
        System.out.println("<credstore> Credential store. Must be either keystore or truststore");
        System.out.println("<alias>     Alias whose value is to be retrieved");
        System.out.println("<storetype> Store type. Must be either jks, jceks, or bcfks");
        System.out.println("<storepass> Credential store password. If not specified, the default");
        System.out.println("            Hadoop Credential Provider API password is used");
    }

    public static void main(String[] args) throws Exception {
        String credStoreStr = null;
        String alias = null;
        String storePass = null;
        String storeType = null;
        SecurityHelper.CredStore credStore = null;
        if (args.length < 3 || args.length > 4) {
            HadoopCredsTest.usage();
            System.exit(1);
        }
        if ((credStoreStr = args[0]).equalsIgnoreCase("keystore")) {
            credStore = SecurityHelper.CredStore.CRED_KEYSTORE;
        } else if (credStoreStr.equalsIgnoreCase("truststore")) {
            credStore = SecurityHelper.CredStore.CRED_TRUSTSTORE;
        } else {
            HadoopCredsTest.usage();
            System.exit(1);
        }
        alias = args[1];
        storeType = args[2];
        if (!(storeType.equalsIgnoreCase("jks") || storeType.equalsIgnoreCase("jceks") || storeType.equalsIgnoreCase("bcfks"))) {
            HadoopCredsTest.usage();
            System.exit(1);
        }
        if (args.length == 4) {
            storePass = args[3];
        }
        System.out.println("Using credential store " + credStoreStr + ", alias " + alias);
        System.out.print("Store password: ");
        if (storePass != null) {
            System.out.println("storePass");
        } else {
            System.out.println("<default>");
        }
        try {
            char[] password = SecurityHelper.getPasswordFromCredStore((SecurityHelper.CredStore)credStore, (String)alias, (String)storeType, (String)storePass);
            if (password == null) {
                System.out.println("Failed to retrieve password from credential store");
            } else {
                System.out.println(String.valueOf(password));
            }
        }
        catch (Exception e) {
            System.out.println("Exception occurred: " + e.getMessage());
        }
    }
}

