/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.cldbutils;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BaseUtilsHelper;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtilsException;
import com.mapr.baseutils.utils.Util;
import com.mapr.fs.Rpc;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityAuthException;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLDBRpcCommonUtils {
    private int RPC_INTERNAL = 1;
    private int RPC_EXTERNAL = 2;
    private int RPC_CLIENT = 8;
    private int RPC_DISABLE_MERGE_IPS = 32;
    private static final Logger LOG = LoggerFactory.getLogger(CLDBRpcCommonUtils.class);
    private static final String MAPR_CLUSTER_FILE_NAME = "/conf/mapr-clusters.conf";
    private static final String MAPR_SERVER_TICKET_FILE_NAME = "/conf/maprserverticket";
    private static final int CLDB_PORT_DEFAULT = 7222;
    private static final String CLDB_LOCAL_HOST = "127.0.0.1";
    private boolean partOfServer = false;
    public static final int listenPortForPS = 30;
    public static final int listenPortForS3 = 40;
    public static final int listenPortForClusterGroup = 50;
    static Pattern patternIP = Pattern.compile("[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}");
    private Map<String, List<IpPort>> clustersMap = new ConcurrentHashMap<String, List<IpPort>>();
    private Map<String, List<IpPort>> clusterGroupIpPortMap = new ConcurrentHashMap<String, List<IpPort>>();
    private Map<String, List<IpPort>> originalClustersMap = new ConcurrentHashMap<String, List<IpPort>>();
    private Map<String, CLDBProto.ClusterGroupConf> clustersGroupMap = new ConcurrentHashMap<String, CLDBProto.ClusterGroupConf>();
    private Map<String, CLDBProto.ExternalServer> externalServerMap = new ConcurrentHashMap<String, CLDBProto.ExternalServer>();
    private static CLDBRpcCommonUtils s_instance;
    private Map<String, Common.IPType> clusterIpTypes = new ConcurrentHashMap<String, Common.IPType>();
    private volatile String defaultClusterName = "default";
    private String origClusterName;
    private Map<String, String> zkConnectStringMap = new HashMap<String, String>();
    private Map<String, String> hostMap = new ConcurrentHashMap<String, String>();

    private CLDBRpcCommonUtils() {
        this.init();
    }

    public static CLDBRpcCommonUtils getInstance() {
        return s_instance;
    }

    public synchronized void setPartOfServer(boolean partOfServer) {
        this.partOfServer = partOfServer;
    }

    public synchronized String getZkConnect() {
        if (this.defaultClusterName == null) {
            LOG.error("Default cluster name is null. Can not get ZK string");
            return null;
        }
        return this.getZkConnect(this.defaultClusterName);
    }

    public synchronized String getZkConnect(String clusterName) {
        if (clusterName == null || !this.clustersMap.containsKey(clusterName)) {
            LOG.error("Invalid cluster name specified: " + clusterName);
            return null;
        }
        String zkConnectString = this.zkConnectStringMap.get(clusterName);
        if (zkConnectString != null) {
            return zkConnectString;
        }
        try {
            byte[] responseData = this.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.IsCLDBMasterProc.getNumber(), (MessageLite)CLDBProto.isCLDBMasterRequest.newBuilder().build(), CLDBProto.isCLDBMasterResponse.class);
            if (responseData == null) {
                LOG.error("No data is received from any cldb");
                return null;
            }
            try {
                CLDBProto.isCLDBMasterResponse response = CLDBProto.isCLDBMasterResponse.parseFrom((byte[])responseData);
                if (response.getStatus() != 0) {
                    LOG.error("Non-valid status received from isCLDBMasterResponse: " + Errno.toString(response.getStatus()));
                }
                zkConnectString = response.getZkconnect();
                this.zkConnectStringMap.put(clusterName, zkConnectString);
                LOG.info("ZKConnect: " + zkConnectString);
                return zkConnectString;
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error("Exception while parsing response from isCLDBMasterResponse", (Throwable)e);
                return null;
            }
        }
        catch (Throwable t) {
            LOG.error("Exception while trying to send RPC to CLDB", t);
            return null;
        }
    }

    public synchronized void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("init");
        }
        String tempClusterName = null;
        HashMap tempMap = new HashMap();
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        String clusterConfFile = maprHome + MAPR_CLUSTER_FILE_NAME;
        try {
            String strLine;
            BufferedReader bfr = new BufferedReader(new FileReader(clusterConfFile));
            while ((strLine = bfr.readLine()) != null) {
                String[] tokens;
                if (strLine.matches("^\\s*#.*") || (tokens = strLine.split("[\\s]+")).length < 2) continue;
                String clusterName = tokens[0];
                ArrayList<IpPort> ipList = new ArrayList<IpPort>();
                for (int i = 1; i < tokens.length; ++i) {
                    if (tokens[i].contains("=")) {
                        String[] arr = tokens[i].split("=");
                        if (arr.length == 2 && JNISecurity.SetClusterOption(clusterName, arr[0], arr[1]) == 0) continue;
                        LOG.error("Invalid Conf options:" + tokens[i] + " for cluster " + clusterName);
                        continue;
                    }
                    String[] cldbIps = tokens[i].split(";");
                    IpPort ipPort = new IpPort();
                    for (int j = 0; j < cldbIps.length; ++j) {
                        int port = 7222;
                        String[] arr = cldbIps[j].split(":");
                        String host = arr[0];
                        this.hostMap.put(host, clusterName);
                        int index = host.indexOf(44);
                        if (index != -1) {
                            host = index < host.length() - 1 ? host.substring(index + 1) : host.substring(0, index);
                        }
                        if (arr.length >= 2) {
                            try {
                                port = Integer.valueOf(arr[1]);
                            }
                            catch (NumberFormatException nfe) {
                                LOG.error("Port is not Integer: " + arr[1] + ". Using default CLDB port: 7222");
                            }
                            if (port < 0 || port > 65535) {
                                LOG.error("Port is invalid number: " + port + ". Skipping " + cldbIps[j]);
                                continue;
                            }
                        }
                        ipPort.addIPOrHost(host, port);
                    }
                    if (ipPort.getNumIPs() <= 0) continue;
                    ipList.add(ipPort);
                }
                if (tempClusterName == null) {
                    this.defaultClusterName = clusterName;
                    tempClusterName = clusterName;
                }
                if (ipList.isEmpty()) {
                    LOG.error("No CLDBs defined for cluster: " + clusterName);
                    continue;
                }
                tempMap.put(clusterName, ipList);
            }
            this.clustersMap.putAll(tempMap);
            for (Map.Entry<String, List<IpPort>> entry : this.clustersMap.entrySet()) {
                if (tempMap.containsKey(entry.getKey())) continue;
                this.clustersMap.remove(entry.getKey());
            }
        }
        catch (FileNotFoundException bfr) {
        }
        catch (Throwable t) {
            LOG.error("Exception during init", t);
        }
        JNISecurity.SetParsingDone();
        if (this.clustersMap.size() == 0) {
            ArrayList<IpPort> ipList = new ArrayList<IpPort>();
            IpPort ipPort = new IpPort();
            ipPort.addIPOrHost(CLDB_LOCAL_HOST, 7222);
            ipList.add(ipPort);
            this.clustersMap.put(this.defaultClusterName, ipList);
        }
        this.originalClustersMap.putAll(this.clustersMap);
    }

    public static int ipToInt(String addr) {
        if (addr.equals("localhost")) {
            addr = CLDB_LOCAL_HOST;
        }
        String[] addrArray = addr.split("\\.");
        long num = 0L;
        for (int i = 0; i < addrArray.length; ++i) {
            int power = 3 - i;
            num = (long)((double)num + (double)(Integer.parseInt(addrArray[i]) % 256) * Math.pow(256.0, power));
        }
        return (int)num;
    }

    private long init(int cldbPort, List<String> cldbHostString, String clusterName, Security.ServerKeyType keyType, int srcPort) throws CLDBRpcCommonUtilsException {
        MutableInt mutableerr;
        Security.TicketAndKey ticket;
        if (cldbHostString == null || cldbHostString.size() == 0) {
            return 0L;
        }
        int[] cldbIps = new int[cldbHostString.size()];
        int idx = 0;
        for (String cldbIp : cldbHostString) {
            cldbIps[idx] = CLDBRpcCommonUtils.ipToInt(cldbIp);
            ++idx;
        }
        try {
            int port = Rpc.initialize(0, 0, clusterName);
            if (port < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            throw new CLDBRpcCommonUtilsException("Exception in Rpc.initialize " + e);
        }
        if (JNISecurity.IsSecurityEnabled(clusterName) && (ticket = Security.GetTicketAndKeyForCluster(keyType, clusterName, mutableerr = new MutableInt())) == null) {
            int err = Security.SetTicketAndKeyFile(this.getPathToServerTicketFile());
            if (err != 0) {
                LOG.error("Error " + err + " in loading " + this.getPathToServerTicketFile());
            }
            ticket = Security.GetTicketAndKeyForCluster(keyType, clusterName, mutableerr);
        }
        int flags = this.getFlagsForBinding(clusterName, false);
        long binding = srcPort > 0 ? Rpc.createBindingForIpsWithSrcPort2(cldbIps, cldbPort, srcPort, clusterName, keyType.getNumber(), flags) : Rpc.createBindingForIps2(cldbIps, cldbPort, clusterName, keyType.getNumber(), flags);
        return binding;
    }

    private IpPort getIpPortFromStr(String cldbIpPort) {
        String[] cldbIp = cldbIpPort.split(":");
        if (cldbIp.length != 2) {
            LOG.error("getIpPortFromStr: Invalid IpPort string: " + cldbIpPort);
            return null;
        }
        IpPort ipPort = new IpPort();
        if (!Util.isInteger(cldbIp[1].trim())) {
            LOG.error("lookupInClusterMaps: Port is not integer");
            return null;
        }
        int port = Integer.parseInt(cldbIp[1].trim());
        ipPort.addIPOrHost(cldbIp[0].trim(), port);
        return ipPort;
    }

    private void updateIpPortsFromClusterConf(CLDBProto.ClusterGroupConf conf) {
        if (conf == null) {
            return;
        }
        if (conf.hasCldbIps() || conf.hasCldbExtIps()) {
            IpPort ipPort;
            IpPort extIpPort;
            int i;
            ArrayList<IpPort> ipPorts = new ArrayList<IpPort>();
            List<Object> cldbIpPorts = new ArrayList();
            List<Object> cldbExtIpPorts = new ArrayList();
            if (conf.hasCldbIps() && !conf.getCldbIps().isEmpty()) {
                cldbIpPorts = Arrays.asList(conf.getCldbIps().split(" "));
            }
            if (conf.hasCldbExtIps() && !conf.getCldbExtIps().isEmpty()) {
                cldbExtIpPorts = Arrays.asList(conf.getCldbExtIps().split(" "));
            }
            int numElementsToBeZigZag = 0;
            if (cldbIpPorts.size() != 0 && cldbExtIpPorts.size() != 0) {
                numElementsToBeZigZag = cldbIpPorts.size() <= cldbExtIpPorts.size() ? cldbIpPorts.size() : cldbExtIpPorts.size();
                LOG.debug("updateIpPortsFromClusterConf: numElementsToBeZigZag: " + numElementsToBeZigZag);
                for (i = 0; i < numElementsToBeZigZag; ++i) {
                    if (!((String)cldbExtIpPorts.get(i)).isEmpty()) {
                        extIpPort = this.getIpPortFromStr((String)cldbExtIpPorts.get(i));
                        if (extIpPort == null) {
                            LOG.error("updateIpPortsFromClusterConf: invalid external ip or port in zig zag: " + (String)cldbExtIpPorts.get(i));
                        } else {
                            LOG.debug("updateIpPortsFromClusterConf: adding ext in zigzag ipPort: " + extIpPort.toString());
                            ipPorts.add(extIpPort);
                        }
                    }
                    if (((String)cldbIpPorts.get(i)).isEmpty()) continue;
                    ipPort = this.getIpPortFromStr((String)cldbIpPorts.get(i));
                    if (ipPort == null) {
                        LOG.error("updateIpPortsFromClusterConf: invalid ip or port in zig zag: " + (String)cldbIpPorts.get(i));
                        continue;
                    }
                    LOG.debug("updateIpPortsFromClusterConf: adding internal in zigzag ipPort: " + ipPort.toString());
                    ipPorts.add(ipPort);
                }
            }
            if (cldbExtIpPorts.size() > numElementsToBeZigZag) {
                for (i = numElementsToBeZigZag; i < cldbExtIpPorts.size(); ++i) {
                    if (((String)cldbExtIpPorts.get(i)).isEmpty()) continue;
                    extIpPort = this.getIpPortFromStr((String)cldbExtIpPorts.get(i));
                    if (extIpPort == null) {
                        LOG.error("updateIpPortsFromClusterConf: invalid ext ip or port: " + (String)cldbExtIpPorts.get(i));
                        continue;
                    }
                    LOG.debug("updateIpPortsFromClusterConf: adding ext in ipPort: " + extIpPort.toString());
                    ipPorts.add(extIpPort);
                }
            }
            if (cldbIpPorts.size() > numElementsToBeZigZag) {
                for (i = numElementsToBeZigZag; i < cldbIpPorts.size(); ++i) {
                    if (((String)cldbIpPorts.get(i)).isEmpty()) continue;
                    ipPort = this.getIpPortFromStr((String)cldbIpPorts.get(i));
                    if (ipPort == null) {
                        LOG.error("updateIpPortsFromClusterConf: invalid ip or port: " + (String)cldbIpPorts.get(i));
                        continue;
                    }
                    LOG.debug("updateIpPortsFromClusterConf: adding in internal ipPort: " + ipPort.toString());
                    ipPorts.add(ipPort);
                }
            }
            if (ipPorts.size() > 0) {
                this.clusterGroupIpPortMap.put(conf.getClusterName(), ipPorts);
            }
        }
    }

    private List<IpPort> lookupInClusterGroupIpPortsMaps(String clusterName) {
        List<IpPort> ipPorts = null;
        ipPorts = this.clusterGroupIpPortMap.get(clusterName);
        if (ipPorts == null) {
            LOG.debug("lookupInClusterGroupIpPortsMaps: didnt find any IP for clusterName " + clusterName);
        }
        LOG.debug("Read IpPorts {} for clustername {} , from clusterGroupIpPortMap", ipPorts, (Object)clusterName);
        return ipPorts;
    }

    private List<IpPort> lookupInClusterMaps(String clusterName) {
        List<IpPort> ipPorts = null;
        ipPorts = this.clustersMap.get(clusterName);
        if (ipPorts == null) {
            LOG.debug("lookupInClusterMaps: entry: {} not present in clustersMap", (Object)clusterName);
            CLDBProto.ClusterGroupConf conf = this.clustersGroupMap.get(clusterName);
            ipPorts = new ArrayList<IpPort>();
            if (conf != null) {
                int port;
                IpPort ipPort;
                String[] cldbIp;
                if (conf.hasCldbIps()) {
                    for (String cldbIpPort : conf.getCldbIps().split(" ")) {
                        if (conf.getCldbIps().isEmpty()) {
                            LOG.info("lookupInClusterMaps: found empty internal cldb ips for cluster {}", (Object)clusterName);
                            continue;
                        }
                        cldbIp = cldbIpPort.split(":");
                        LOG.debug("lookupInClusterMaps: adding internal {} - {} ip {}", new Object[]{clusterName, cldbIpPort, cldbIp[0].trim()});
                        ipPort = new IpPort();
                        if (!Util.isInteger(cldbIp[1].trim())) {
                            LOG.error("lookupInClusterMaps: Port is not integer");
                            continue;
                        }
                        port = Integer.parseInt(cldbIp[1].trim());
                        ipPort.addIPOrHost(cldbIp[0].trim(), port);
                        ipPorts.add(ipPort);
                    }
                } else {
                    LOG.debug("lookupInClusterMaps  clustersGroupMap.get  don't have internal cldb ips for cluster {}", (Object)clusterName);
                }
                if (conf.hasCldbExtIps()) {
                    for (String cldbIpPort : conf.getCldbExtIps().split(" ")) {
                        if (cldbIpPort.isEmpty()) {
                            LOG.info("lookupInClusterMaps: found empty external cldb ips for cluster {}", (Object)clusterName);
                            continue;
                        }
                        cldbIp = cldbIpPort.split(":");
                        LOG.debug("lookupInClusterMaps: adding external {} - {} ip {}", new Object[]{clusterName, cldbIpPort, cldbIp[0].trim()});
                        ipPort = new IpPort();
                        if (!Util.isInteger(cldbIp[1].trim())) {
                            LOG.error("lookupInClusterMaps: Port is not integer");
                            continue;
                        }
                        port = Integer.parseInt(cldbIp[1].trim());
                        ipPort.addIPOrHost(cldbIp[0].trim(), port);
                        ipPorts.add(ipPort);
                    }
                } else {
                    LOG.debug("lookupInClusterMaps: clustersGroupMap.get  don't have external  cldb ips for cluster {}", (Object)clusterName);
                }
            }
            if (ipPorts != null && !ipPorts.isEmpty()) {
                LOG.info("lookupInClusterMaps: adding IpPorts {} for clustername {} ,from cgMap", ipPorts, (Object)clusterName);
                this.clustersMap.put(clusterName, ipPorts);
            } else {
                LOG.info("lookupInClusterMaps: didnt find any IP for clusterName " + clusterName);
                ipPorts = null;
            }
        } else {
            LOG.debug("lookupInClusterMaps: found in main map for clustername " + clusterName + ipPorts.toString());
        }
        return ipPorts;
    }

    public byte[] sendRequest(int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) throws Exception {
        return this.sendRequest(this.defaultClusterName, programId, procedureId, request, responseClass, Security.ServerKeyType.ServerKey);
    }

    public byte[] sendRequest(int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, int cldbPort) throws Exception {
        return this.sendRequest(this.defaultClusterName, programId, procedureId, request, responseClass, Security.ServerKeyType.ServerKey, 0, cldbPort);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) throws Exception {
        return this.sendRequest(clusterName, programId, procedureId, request, responseClass, Security.ServerKeyType.ServerKey);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType) throws Exception {
        return this.sendRequest(clusterName, programId, procedureId, request, responseClass, keyType, 0);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType, int srcPort) throws Exception {
        return this.sendRequest(clusterName, programId, procedureId, request, responseClass, keyType, srcPort, 0);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType, int srcPort, int cldbPort) throws Exception {
        if (this.lookupInClusterMaps(clusterName) == null) {
            this.init();
            if (this.lookupInClusterMaps(clusterName) == null) {
                try {
                    Method newBuilder = responseClass.getMethod("newBuilder", new Class[0]);
                    Object returnObject = newBuilder.invoke(null, new Object[0]);
                    Method statusMethod = returnObject.getClass().getMethod("setStatus", Integer.TYPE);
                    returnObject = statusMethod.invoke(returnObject, 133);
                    Method build = returnObject.getClass().getMethod("build", new Class[0]);
                    MessageLite buildObject = (MessageLite)build.invoke(returnObject, new Object[0]);
                    byte[] bytes = buildObject.toByteArray();
                    LOG.error("Unable to reach cluster with name: " + clusterName + ". No entry found in file /conf/mapr-clusters.conf for cluster " + clusterName + ". Failing the CLDB RPC with status 133");
                    return bytes;
                }
                catch (Exception e) {
                    LOG.error("Error while trying to construct erroneous response", (Throwable)e);
                    LOG.error("Cluster with name: " + clusterName + " is not found. Can not proceed with CLDB RPC");
                    return null;
                }
            }
        }
        if (this.clustersMap.get(clusterName) == null || this.clustersMap.get(clusterName).isEmpty()) {
            this.init();
        }
        if (cldbPort > 0) {
            IpPort cldbCredentials = new IpPort();
            cldbCredentials.addIPOrHost(CLDB_LOCAL_HOST, cldbPort);
            byte[] retBytes = this.getDataForParticularCLDB(clusterName, cldbCredentials, programId, procedureId, request, responseClass, keyType, srcPort);
            return retBytes;
        }
        ArrayList clusterCredentials = new ArrayList(this.clustersMap.get(clusterName));
        int origSize = clusterCredentials.size();
        Iterator iter = clusterCredentials.iterator();
        byte[] retBytes = null;
        while (iter.hasNext()) {
            IpPort cldbCredentials = (IpPort)iter.next();
            try {
                retBytes = this.getDataForParticularCLDB(clusterName, cldbCredentials, programId, procedureId, request, responseClass, keyType, srcPort);
            }
            catch (MaprSecurityAuthException e) {
                iter.remove();
                continue;
            }
            if (retBytes != null) break;
            iter.remove();
            LOG.info("Bad CLDB credentials removed: " + cldbCredentials);
        }
        if (clusterCredentials.size() != origSize) {
            this.clustersMap.put(clusterName, clusterCredentials);
        }
        if (clusterCredentials.size() == 0) {
            this.clustersMap.remove(clusterName);
        }
        return retBytes;
    }

    public byte[] sendCGRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType, int srcPort) throws Exception {
        if (this.lookupInClusterGroupIpPortsMaps(clusterName) == null) {
            LOG.error("sendCGRequest: cluster: " + clusterName + " not available in lookupInClusterGroupIpPortsMaps");
            return null;
        }
        ArrayList clusterCredentials = new ArrayList(this.clusterGroupIpPortMap.get(clusterName));
        int origSize = clusterCredentials.size();
        Iterator iter = clusterCredentials.iterator();
        byte[] retBytes = null;
        while (iter.hasNext()) {
            IpPort cldbCredentials = (IpPort)iter.next();
            try {
                LOG.debug("sendCGRequest: cldbCredentials being tried: " + cldbCredentials.toString());
                retBytes = this.getDataForParticularCLDB(clusterName, cldbCredentials, programId, procedureId, request, responseClass, keyType, srcPort);
            }
            catch (MaprSecurityAuthException e) {
                iter.remove();
                continue;
            }
            if (retBytes != null) break;
            iter.remove();
            LOG.info("Bad CLDB credentials removed: " + cldbCredentials);
        }
        return retBytes;
    }

    public boolean isValidClusterName(String clusterName) {
        if (this.lookupInClusterMaps(clusterName) != null) {
            return true;
        }
        this.init();
        if (this.lookupInClusterMaps(clusterName) != null) {
            return true;
        }
        LOG.error("Cluster with name: " + clusterName + " not found");
        return false;
    }

    public String getPathToClustersConfFile() {
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        return maprHome + MAPR_CLUSTER_FILE_NAME;
    }

    public String getPathToServerTicketFile() {
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        return maprHome + MAPR_SERVER_TICKET_FILE_NAME;
    }

    private byte[] getDataForParticularCLDB(String clusterName, IpPort cldbCredentials, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType, int srcPort) throws Exception {
        try {
            byte[] retBytes;
            MapRLoginHttpsClient loginClient = new MapRLoginHttpsClient();
            if (keyType == Security.ServerKeyType.ServerKey && !loginClient.hasGoodServerKey(clusterName) && loginClient.hasGoodClusterKey(clusterName)) {
                keyType = Security.ServerKeyType.ClusterKey;
            }
            loginClient.quietAuthenticateIfNeeded(clusterName, keyType);
            long binding = this.init(cldbCredentials.getPort(), cldbCredentials.getAddr(), clusterName, keyType, srcPort);
            if (binding == 0L) {
                return null;
            }
            if (procedureId != CLDBProto.CLDBProg.ContainerRootLookupProc.getNumber()) {
                Common.IPType ipType = this.getIPTypeForCluster(clusterName, srcPort);
                LOG.debug("Got iptype " + ipType + " for procid " + procedureId);
                request = this.embedIpTypeInRequest(programId, procedureId, request, ipType);
            }
            Method parseFromMethod = responseClass.getMethod("parseFrom", ByteString.class);
            int MAX_ATTEMPTS = 6;
            int nAttempt = 0;
            Integer status = 0;
            do {
                if ((retBytes = Rpc.sendRequest(binding, programId, procedureId, request)) != null) {
                    Object returnObject = parseFromMethod.invoke(null, ByteString.copyFrom((byte[])retBytes));
                    Method statusMethod = returnObject.getClass().getMethod("getStatus", new Class[0]);
                    status = (Integer)statusMethod.invoke(returnObject, new Object[0]);
                    if (status == null) {
                        LOG.error("Return Status is not Integer: " + status);
                        continue;
                    }
                    if (status == 30) {
                        LOG.info(cldbCredentials.toString() + " is READ_ONLY CLDB. Trying another one");
                        continue;
                    }
                    if (status == 3) {
                        if (++nAttempt == 1) {
                            LOG.info(cldbCredentials.toString() + " is attempting to become a master. Retrying RPC " + programId + "." + procedureId);
                        }
                        if (nAttempt >= 6) continue;
                        Thread.sleep((2 * nAttempt + 1) * 1000);
                        continue;
                    }
                    return retBytes;
                }
                LOG.error("No data returned in RPC: " + programId + "." + procedureId + " from " + cldbCredentials.toString() + ". Continue searching for correct CLDB");
            } while (retBytes != null && status == 3 && nAttempt < 6);
        }
        catch (CLDBRpcCommonUtilsException e) {
            LOG.error("Exception while trying to bind on: " + cldbCredentials.toString());
        }
        catch (MaprSecurityException se) {
            LOG.error("", (Throwable)se);
            throw se;
        }
        catch (Exception ex) {
            LOG.error("Exception while trying to send RPC to CLDB: " + cldbCredentials.toString() + ". Trying another host/port", (Throwable)ex);
        }
        return null;
    }

    public synchronized IpPort getCurrentValidIpPort(String clusterName) {
        if (this.clustersMap.get(clusterName) != null && this.clustersMap.containsKey(clusterName)) {
            return this.clustersMap.get(clusterName).get(0);
        }
        return null;
    }

    public IpPort getCurrentValidIpPort() {
        return this.getCurrentValidIpPort(this.defaultClusterName);
    }

    public String getCurrentClusterName() {
        return this.defaultClusterName;
    }

    public List<CLDBProto.ClusterGroupConf> getClusterGroupConfs() {
        return new ArrayList<CLDBProto.ClusterGroupConf>(this.clustersGroupMap.values());
    }

    public CLDBProto.ClusterGroupConf addClusterGroupConf(CLDBProto.ClusterGroupConf cgConf) {
        CLDBProto.ClusterGroupConf ret = null;
        if (cgConf != null) {
            ret = this.clustersGroupMap.put(cgConf.getClusterName(), cgConf);
            this.updateIpPortsFromClusterConf(cgConf);
            this.clustersMap.remove(cgConf.getClusterName());
            LOG.debug("addClusterGroup " + cgConf.getClusterName());
        }
        return ret;
    }

    public CLDBProto.ClusterGroupConf removeClusterGroupConf(String clustername) {
        CLDBProto.ClusterGroupConf ret = null;
        if (clustername != null) {
            ret = this.clustersGroupMap.remove(clustername);
            this.clusterGroupIpPortMap.remove(clustername);
            this.clustersMap.remove(clustername);
            LOG.debug("removeClusterGroup " + clustername);
        }
        return ret;
    }

    public CLDBProto.ClusterGroupConf getClusterGroupConf(String clusterName) {
        CLDBProto.ClusterGroupConf ret = null;
        if (clusterName != null) {
            ret = this.clustersGroupMap.get(clusterName);
            LOG.debug("getClusterGroup " + clusterName);
        }
        return ret;
    }

    public int getClusterGroupSize() {
        return this.clustersGroupMap.size();
    }

    private boolean isClusterGroupMember(String clusterName) {
        return this.clustersGroupMap.containsKey(clusterName);
    }

    public boolean isExternalServerMember(String extNfsName) {
        return this.externalServerMap.containsKey(extNfsName);
    }

    public boolean isGnsMember(String extServerName) {
        return this.isClusterGroupMember(extServerName) || this.isExternalServerMember(extServerName);
    }

    public List<CLDBProto.ExternalServer> getExternalServers() {
        return new ArrayList<CLDBProto.ExternalServer>(this.externalServerMap.values());
    }

    public ArrayList<String> getExternalServerNames() {
        return new ArrayList<String>(this.externalServerMap.keySet());
    }

    public CLDBProto.ExternalServer getExternalServer(String extServerName) {
        CLDBProto.ExternalServer ret = null;
        if (extServerName != null) {
            ret = this.externalServerMap.get(extServerName);
            LOG.debug("getExternalServer " + extServerName);
        }
        return ret;
    }

    public CLDBProto.ExternalServer addExternalServer(CLDBProto.ExternalServer extServer) {
        CLDBProto.ExternalServer ret = null;
        if (extServer != null) {
            if (extServer.getExternalServerOneOfCase() == CLDBProto.ExternalServer.ExternalServerOneOfCase.EXTNFS) {
                ret = this.externalServerMap.put(extServer.getExtNfs().getName(), extServer);
                LOG.debug("addExternalServer " + extServer.getExtNfs().getName());
            } else {
                LOG.info("addExternalServer of unknown type");
            }
        }
        return ret;
    }

    public CLDBProto.ExternalServer removeExternalServer(String extServerName) {
        CLDBProto.ExternalServer ret = null;
        if (extServerName != null) {
            ret = this.externalServerMap.remove(extServerName);
            LOG.debug("removeExternalServer " + extServerName);
        }
        return ret;
    }

    public synchronized void setCurrentClusterName(String clusterName) {
        if (!this.clustersMap.containsKey(clusterName)) {
            throw new IllegalArgumentException("Cluster " + clusterName + " is not known");
        }
        if (this.origClusterName == null) {
            this.origClusterName = this.defaultClusterName;
        }
        this.defaultClusterName = clusterName;
    }

    public synchronized void resetCurrentClusterName() {
        if (this.origClusterName != null) {
            this.defaultClusterName = this.origClusterName;
        }
    }

    public Map<String, List<IpPort>> getClusterMap() {
        return this.clustersMap;
    }

    public Map<String, List<IpPort>> getClusterMapReloaded(String clustersName) {
        if (this.lookupInClusterMaps(clustersName) != null) {
            this.init();
        }
        return this.clustersMap;
    }

    public Map<String, List<IpPort>> getOriginalClusterMap() {
        return this.originalClustersMap;
    }

    public Map<String, String> getHostMap() {
        return this.hostMap;
    }

    public List<IpPort> getDefaultClusterIpPort() {
        return this.clustersMap.get(this.defaultClusterName);
    }

    public String getDefaultClusterName() {
        return this.defaultClusterName;
    }

    public static String convertHostToIp(String host) {
        try {
            InetAddress ia = InetAddress.getByName(host);
            String ip = ia.getHostAddress();
            return ip;
        }
        catch (UnknownHostException e) {
            LOG.error("Can not find IP for host: " + host);
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public synchronized long[] getCldbBindings(String clusterName) throws CLDBRpcCommonUtilsException {
        List<IpPort> ipPorts = this.lookupInClusterMaps(clusterName);
        if (ipPorts == null || ipPorts.isEmpty()) {
            this.init();
        }
        if ((ipPorts = this.clustersMap.get(clusterName)) == null || ipPorts.isEmpty()) {
            LOG.error("Unable to get CLDB bindings for cluster " + clusterName);
            return null;
        }
        long[] cldbBindings = new long[ipPorts.size()];
        Iterator<IpPort> itr = ipPorts.iterator();
        int index = 0;
        while (itr.hasNext()) {
            IpPort ipPort = itr.next();
            cldbBindings[index++] = this.init(ipPort.getPort(), ipPort.getAddr(), clusterName, Security.ServerKeyType.ServerKey, 0);
        }
        return cldbBindings;
    }

    public Common.IPType getIPTypeForCluster(String clusterName) {
        return this.getIPTypeForCluster(clusterName, 0);
    }

    public Common.IPType getIPTypeForCluster(String clusterName, int srcPort) {
        if (clusterName == null || clusterName.equals(this.defaultClusterName)) {
            return Common.IPType.INTERNAL_ONLY;
        }
        Common.IPType clusterIpType = this.clusterIpTypes.get(clusterName);
        if (clusterIpType != null) {
            return clusterIpType;
        }
        CLDBProto.ContainerRootLookupResponse resp = null;
        CLDBProto.ContainerRootLookupRequest req = CLDBProto.ContainerRootLookupRequest.newBuilder().setRootPath("mapr.cluster.root").setWantCldbIps(true).build();
        byte[] data = null;
        Security.ServerKeyType keyType = Security.ServerKeyType.ServerKey;
        if (this.partOfServer) {
            keyType = Security.ServerKeyType.ClusterKey;
        }
        LOG.error("Using Key type " + keyType);
        try {
            data = this.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerRootLookupProc.getNumber(), (MessageLite)req, CLDBProto.ContainerRootLookupResponse.class, keyType, srcPort);
        }
        catch (Exception e) {
            LOG.error("getIPTypeForCluster : Exception during container root lookup for " + clusterName + " exception : " + e.getMessage());
        }
        if (data == null) {
            LOG.error("getIPTypeForCluster : Could not get container root lookup response for " + clusterName);
            this.clusterIpTypes.put(clusterName, Common.IPType.EXTERNAL_ONLY);
            return Common.IPType.EXTERNAL_ONLY;
        }
        try {
            resp = CLDBProto.ContainerRootLookupResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("getIPTypeForCluster : Could not parse container root lookup response for " + clusterName);
            return Common.IPType.EXTERNAL_ONLY;
        }
        boolean internalOnly = false;
        boolean externalOnly = false;
        List<IpPort> configuredIps = this.clustersMap.get(clusterName);
        ArrayList<CallSite> configuredHosts = new ArrayList<CallSite>();
        for (IpPort ipPort : configuredIps) {
            List<String> ips = ipPort.getAddr();
            int port = ipPort.getPort();
            for (String string : ips) {
                configuredHosts.add((CallSite)((Object)(CLDBRpcCommonUtils.ipToInt(string) + ":" + port)));
            }
        }
        LOG.debug("Configured host:port for cluster " + clusterName + " are " + configuredHosts);
        List internalIpsGotten = resp.getIpPortsList();
        LOG.info("RootContainerLookup response to cluster " + clusterName + " returned internal host:port as " + this.printIPPortList(internalIpsGotten));
        block6: for (Object internalIpPort : internalIpsGotten) {
            List internalHostsGotten = internalIpPort.getHostsList();
            int port = internalIpPort.getPort();
            for (Integer host : internalHostsGotten) {
                if (!configuredHosts.contains(host + ":" + port)) continue;
                internalOnly = true;
                continue block6;
            }
        }
        List list = resp.getExternalIPPortsList();
        LOG.info("RootContainerLookup response to cluster " + clusterName + " returned external host:port as " + this.printIPPortList(internalIpsGotten));
        block8: for (Common.IPPort externalIpPort : list) {
            List externalHostsGotten = externalIpPort.getHostsList();
            int n = externalIpPort.getPort();
            for (Integer host : externalHostsGotten) {
                if (!configuredHosts.contains(host + ":" + n)) continue;
                externalOnly = true;
                continue block8;
            }
        }
        Common.IPType ipType = Common.IPType.INTERNAL_ONLY;
        if (internalOnly && externalOnly) {
            ipType = Common.IPType.INTERNAL_EXTERNAL_BOTH;
        } else if (externalOnly) {
            ipType = Common.IPType.EXTERNAL_ONLY;
        }
        LOG.info("Detected cluster " + clusterName + " as " + ipType);
        this.clusterIpTypes.put(clusterName, ipType);
        return ipType;
    }

    private String printIPPortList(List<Common.IPPort> ipPorts) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Common.IPPort ipPort : ipPorts) {
            List hostsGotten = ipPort.getHostsList();
            int port = ipPort.getPort();
            for (Integer host : hostsGotten) {
                sb.append(host);
                sb.append(":");
                sb.append(port);
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private MessageLite embedIpTypeInRequest(int programId, int procId, MessageLite request, Common.IPType ipType) {
        if (programId != Common.MapRProgramId.CldbProgramId.getNumber()) {
            return request;
        }
        MessageLite modifiedReq = request;
        if (procId == CLDBProto.CLDBProg.ContainerLookupProc.getNumber()) {
            CLDBProto.ContainerLookupRequest oldReq = (CLDBProto.ContainerLookupRequest)request;
            modifiedReq = CLDBProto.ContainerLookupRequest.newBuilder((CLDBProto.ContainerLookupRequest)oldReq).setIpType(ipType).build();
        } else if (procId == CLDBProto.CLDBProg.ContainerOnFileServerFailProc.getNumber()) {
            CLDBProto.ContainerOnFileServerFailRequest oldReq = (CLDBProto.ContainerOnFileServerFailRequest)request;
            modifiedReq = CLDBProto.ContainerOnFileServerFailRequest.newBuilder((CLDBProto.ContainerOnFileServerFailRequest)oldReq).setIpType(ipType).build();
        } else if (procId == CLDBProto.CLDBProg.VolumeLookupProc.getNumber()) {
            CLDBProto.VolumeLookupRequest oldReq = (CLDBProto.VolumeLookupRequest)request;
            modifiedReq = CLDBProto.VolumeLookupRequest.newBuilder((CLDBProto.VolumeLookupRequest)oldReq).setIpType(ipType).build();
        } else if (procId == CLDBProto.CLDBProg.VolumeContainersMapProc.getNumber()) {
            CLDBProto.VolumeContainersMapRequest oldReq = (CLDBProto.VolumeContainersMapRequest)request;
            modifiedReq = CLDBProto.VolumeContainersMapRequest.newBuilder((CLDBProto.VolumeContainersMapRequest)oldReq).setIpType(ipType).build();
        } else if (procId == CLDBProto.CLDBProg.SnapshotContainersMapProc.getNumber()) {
            CLDBProto.SnapshotContainersMapRequest oldSCMReq = (CLDBProto.SnapshotContainersMapRequest)request;
            modifiedReq = CLDBProto.SnapshotContainersMapRequest.newBuilder((CLDBProto.SnapshotContainersMapRequest)oldSCMReq).setIpType(ipType).build();
        }
        return modifiedReq;
    }

    public int getFlagsForBinding(String clusterName, boolean isConnectionToMfs) {
        int flags = this.RPC_CLIENT;
        if (!isConnectionToMfs) {
            return flags |= this.RPC_INTERNAL | this.RPC_EXTERNAL | this.RPC_DISABLE_MERGE_IPS;
        }
        if (clusterName.equals(this.defaultClusterName)) {
            flags |= this.RPC_INTERNAL;
        } else {
            Common.IPType ipType = this.getIPTypeForCluster(clusterName);
            switch (ipType) {
                case INTERNAL_EXTERNAL_BOTH: {
                    flags |= this.RPC_INTERNAL | this.RPC_EXTERNAL;
                    break;
                }
                case EXTERNAL_ONLY: {
                    flags |= this.RPC_EXTERNAL;
                    break;
                }
                default: {
                    flags |= this.RPC_INTERNAL;
                }
            }
        }
        return flags;
    }

    static {
        ShimLoader.load();
        s_instance = new CLDBRpcCommonUtils();
    }

    public static class IpPort {
        private List<String> ips = new ArrayList<String>();
        private List<String> originalAddr = new ArrayList<String>();
        private int port = 7222;

        public void addIPOrHost(String addr, int port) {
            String ip = addr;
            if (!patternIP.matcher(addr).matches() && (ip = CLDBRpcCommonUtils.convertHostToIp(addr)) == null) {
                LOG.error("Can not find non-local IP based on provided hostname: " + addr);
            }
            if (ip != null) {
                this.ips.add(ip);
                this.originalAddr.add(addr);
                this.port = port;
            }
        }

        public int getNumIPs() {
            return this.ips.size();
        }

        public List<String> getAddr() {
            return this.ips;
        }

        public List<String> getOriginalAddr() {
            return this.originalAddr;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            Object ipStr = "";
            for (String ip : this.ips) {
                ipStr = (String)ipStr + ip + "-";
            }
            return "CLDB Ips: " + (String)ipStr + ", Port: " + this.port;
        }
    }
}

