/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.sso;

import com.mapr.baseutils.Installation;
import com.mapr.baseutils.sso.JwtValidator;
import com.mapr.baseutils.sso.providers.keycloak.KeyCloakJwtValidator;
import com.mapr.baseutils.sso.providers.okta.OktaJwtValidator;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoManager {
    private static SsoManager s_instance;
    private String clientID = "";
    private String clientSecret = "";
    private String issuer = "";
    private String ssoProvider = "";
    private long lastModifiedSSOTime = 0L;
    private static Logger LOG;

    public void readSsoParams() {
        long ssoPropertiesModifiedTime;
        long ssoConfModifiedTime;
        String ssoConf;
        Properties ssoProperties = new Properties();
        try {
            ssoConf = Installation.getMapRHome() + File.separator + "conf" + File.separator + "sso.conf";
            ssoProperties.load(new FileInputStream(ssoConf));
        }
        catch (Exception e) {
            LOG.error("Exception Loading Cldb Conf File: ", (Throwable)e);
            return;
        }
        String ssoCreds = Installation.getMapRHome() + File.separator + "conf" + File.separator + "sso.creds";
        File ssoCredsFile = new File(ssoCreds);
        File ssoPropertiesFile = new File(ssoConf);
        if (ssoCredsFile.exists() && Math.max(ssoConfModifiedTime = ssoCredsFile.lastModified(), ssoPropertiesModifiedTime = ssoPropertiesFile.lastModified()) > this.lastModifiedSSOTime) {
            String ssoProvider = ssoProperties.getProperty("sso.provider");
            if (ssoProvider != null) {
                this.ssoProvider = ssoProvider;
                try {
                    String clientID;
                    String issuersList;
                    Properties ssoCredsProperties = new Properties();
                    ssoCredsProperties.load(new FileInputStream(ssoCreds));
                    String clientSecret = ssoCredsProperties.getProperty("sso.client.secret");
                    if (clientSecret != null) {
                        this.clientSecret = clientSecret;
                    }
                    if ((issuersList = ssoProperties.getProperty("sso.issuers.list")) != null) {
                        this.issuer = issuersList;
                    }
                    if ((clientID = ssoCredsProperties.getProperty("sso.client.id")) != null) {
                        this.clientID = clientID;
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception Loading SSO Creds File: ", (Throwable)e);
                    return;
                }
            }
            this.lastModifiedSSOTime = Math.max(ssoConfModifiedTime, ssoPropertiesModifiedTime);
        }
    }

    public static synchronized SsoManager getInstance() {
        if (s_instance == null) {
            s_instance = new SsoManager();
        }
        return s_instance;
    }

    public String getClientID() {
        this.readSsoParams();
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientSecret() {
        this.readSsoParams();
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getIssuer() {
        this.readSsoParams();
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getSsoProvider() {
        this.readSsoParams();
        return this.ssoProvider;
    }

    public void setSsoProvider(String ssoProvider) {
        this.ssoProvider = ssoProvider;
    }

    public JwtValidator getValidator() {
        JwtValidator validator;
        String issuers = this.getIssuer();
        String ssoType = this.getSsoProvider();
        if (ssoType.toLowerCase().equals("keycloak")) {
            validator = new KeyCloakJwtValidator(issuers);
        } else if (ssoType.toLowerCase().equals("okta")) {
            validator = new OktaJwtValidator(issuers);
        } else {
            String err = "SSO scheme of type " + ssoType + " is not suppoted";
            LOG.error(err);
            return null;
        }
        return validator;
    }

    static {
        LOG = LoggerFactory.getLogger(SsoManager.class);
    }
}

