/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.maprsasl;

import com.mapr.baseutils.BaseUtilsHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.security.ClusterServerTicketGeneration;
import com.mapr.security.MapRPrincipal;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaprSecurityLoginModule
implements LoginModule {
    public static final String USER_TICKET_FILE_LOCATION = "MAPR_TICKETFILE_LOCATION";
    private static final Logger LOG = LoggerFactory.getLogger(MaprSecurityLoginModule.class);
    private static final String maprHome = BaseUtilsHelper.getPathToMaprHome();
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> options;
    private Map<String, ?> sharedState;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private MapRPrincipal principal = null;
    private boolean useServerKey;
    private static boolean useMaprServerTicket;
    private static boolean generatedServerKey;
    private static String cldbkeylocation;
    private static Security.TicketAndKey maprServerTicketAndKey;
    private boolean checkUGI = true;

    private static synchronized void generateClusterServerTicket(String clusterName) throws IOException {
        if (!generatedServerKey) {
            ClusterServerTicketGeneration.getInstance().generateTicketAndSetServerKey(clusterName);
            generatedServerKey = true;
        }
    }

    private static synchronized Security.TicketAndKey getMaprServerTicketAndKey(String clusterName) throws LoginException {
        if (maprServerTicketAndKey == null) {
            String ticketPath = maprHome + "/conf/maprserverticket";
            if (!new File(ticketPath).exists()) {
                throw new LoginException("Security is enabled, but userTicketFile can not be found.");
            }
            Security.SetTicketAndKeyFile(ticketPath);
            MutableInt err = new MutableInt();
            Security.TicketAndKey tk = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.CldbKey, clusterName, err);
            if (tk != null && err.GetValue() == 0) {
                maprServerTicketAndKey = tk;
                try {
                    MaprSecurityLoginModule.generateClusterServerTicket(clusterName);
                }
                catch (Throwable t) {
                    LOG.warn("Unable to generate the server key.");
                    LOG.debug(t.getMessage(), t);
                }
            } else {
                throw new LoginException("MapR user ticket not available! error = " + err);
            }
        }
        return maprServerTicketAndKey;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.principal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Commit Failed: Subject is Readonly");
        }
        this.subject.getPrincipals().add(this.principal);
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.useServerKey = "true".equalsIgnoreCase((String)options.get("useServerKey"));
        this.checkUGI = !"false".equalsIgnoreCase((String)options.get("checkUGI"));
    }

    @Override
    public boolean login() throws LoginException {
        String cluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (cluster == null) {
            throw new LoginException("Current cluster name is not found");
        }
        MutableInt err = new MutableInt();
        Security.TicketAndKey tk = null;
        if (useMaprServerTicket) {
            tk = MaprSecurityLoginModule.getMaprServerTicketAndKey(cluster);
        } else {
            try {
                boolean needToTryPlainTicket = false;
                if (this.useServerKey) {
                    try {
                        MaprSecurityLoginModule.generateClusterServerTicket(cluster);
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Unable to obtain MapR credentials", (Throwable)e);
                        }
                        needToTryPlainTicket = true;
                    }
                }
                if (!this.useServerKey || needToTryPlainTicket) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Need to addplainticket: " + needToTryPlainTicket);
                    }
                    MapRLoginHttpsClient c = new MapRLoginHttpsClient();
                    c.setCheckUGI(this.checkUGI);
                    c.authenticateIfNeeded(cluster);
                }
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to obtain MapR credentials", (Throwable)e);
                }
                throw (LoginException)new LoginException("Unable to obtain MapR credentials").initCause(e);
            }
            tk = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.ServerKey, cluster, err);
        }
        if (tk == null || err.GetValue() != 0) {
            throw new LoginException("MapR user ticket not available! error = " + err);
        }
        String user = tk.getUserCreds().getUserName();
        this.principal = new MapRPrincipal(user, cluster);
        this.succeeded = true;
        return this.succeeded;
    }

    @Override
    public boolean logout() throws LoginException {
        Iterator<Principal> itr = this.subject.getPrincipals().iterator();
        while (itr.hasNext()) {
            Principal object = itr.next();
            if (!(object instanceof MapRPrincipal)) continue;
            itr.remove();
        }
        return true;
    }

    public static boolean isUseMaprServerTicket() {
        return useMaprServerTicket;
    }

    static {
        generatedServerKey = false;
        Set<Object> propsKeys = System.getProperties().keySet();
        for (Object propKey : propsKeys) {
            String propKeyStr = (String)propKey;
            if (propKeyStr.endsWith("mapr.usemaprserverticket")) {
                useMaprServerTicket = Boolean.getBoolean(propKeyStr);
            }
            if (!propKeyStr.endsWith("mapr.cldbkeyfile.location")) continue;
            cldbkeylocation = System.getProperty(propKeyStr);
        }
        if (cldbkeylocation != null) {
            Security.Key serverKey;
            MutableInt err = new MutableInt();
            int errCode = Security.SetKeyFile(Security.ServerKeyType.CldbKey, cldbkeylocation);
            if (errCode != 0) {
                LOG.error("Failed to set cldb key file " + cldbkeylocation + " err " + err);
            } else if (LOG.isInfoEnabled()) {
                LOG.info("Set the cldb key file to " + cldbkeylocation);
            }
            Security.Key cldbKey = Security.GetKey(Security.ServerKeyType.CldbKey, err);
            if (cldbKey == null) {
                LOG.error("Cldb key can not be obtained: " + err.GetValue());
            }
            if ((serverKey = Security.GetServerKey(cldbKey, 0L)) == null) {
                LOG.error("Server key can not be obtained");
            }
            if ((errCode = Security.SetKey(Security.ServerKeyType.ServerKey, serverKey)) != 0) {
                LOG.error("Failed to set Server key with error: " + err);
            }
        }
    }
}

