/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.audit;

import com.mapr.baseutils.audit.KeyValue;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class AuditRecord {
    final TimeZone tz = TimeZone.getTimeZone("UTC");
    final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private boolean forceAudit;
    private long epoch;
    private String isoDate;
    private String resource;
    private Op op;
    private String clientIp;
    private int uid;
    private int gid;
    private int status;
    private String username;
    private boolean populateTargetUser;
    private String targetUsername;
    private int targetUid;
    private int targetGid;
    private KeyValue keyValue;
    private List<KeyValue> keyValues;
    private boolean keyValuesSR;

    private void setDate() {
        this.epoch = System.currentTimeMillis();
        this.isoDate = this.df.format(new Date(this.epoch));
    }

    public AuditRecord() {
        this.df.setTimeZone(this.tz);
        this.setDate();
        this.clientIp = null;
        this.resource = null;
        this.op = null;
        this.keyValue = new KeyValue();
        this.keyValues = null;
        this.uid = -1;
        this.gid = -1;
        this.status = -1;
        this.populateTargetUser = false;
        this.targetUsername = null;
        this.targetUid = -1;
        this.targetGid = -1;
        this.username = null;
        this.forceAudit = false;
        this.keyValuesSR = false;
    }

    public void init(Common.IPAddress ip) {
        String ipAddr = this.intToIp(ip.getHost());
        this.init(ipAddr);
    }

    public void init(String ip) {
        this.setDate();
        this.clientIp = ip;
    }

    public void setCreds(Security.CredentialsMsg creds) {
        if (creds == null) {
            return;
        }
        if (creds.hasUserName()) {
            this.username = creds.getUserName();
        }
        if (creds.hasUid()) {
            this.uid = creds.getUid();
        }
        if (creds.getGidsCount() > 0) {
            this.gid = creds.getGids(0);
        }
    }

    public void clear() {
        this.keyValue.reInit();
        this.clientIp = null;
        this.resource = null;
        this.op = null;
        this.keyValues = null;
        this.uid = -1;
        this.gid = -1;
        this.status = -1;
        this.populateTargetUser = false;
        this.targetUid = -1;
        this.targetGid = -1;
        this.username = null;
        this.forceAudit = false;
        this.keyValuesSR = false;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Op getOp() {
        return this.op;
    }

    public void setOp(Op op) {
        this.op = op;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setKeyValuesSR(boolean val) {
        this.keyValuesSR = val;
    }

    public boolean getKeyValuesSR() {
        return this.keyValuesSR;
    }

    public void setValues(String key, String oldValue, String newValue) {
        this.keyValue.setValues(key, oldValue, newValue);
    }

    public KeyValue getKeyValue() {
        return this.keyValue;
    }

    public List<KeyValue> getKeyValues() {
        return this.keyValues;
    }

    public void addAllKeyValues(List<KeyValue> keyValues) {
        if (keyValues == null) {
            return;
        }
        if (this.keyValues == null) {
            this.keyValues = new ArrayList<KeyValue>();
        }
        this.keyValues.addAll(keyValues);
    }

    public void setKeyValues(List<KeyValue> keyValues) {
        this.keyValues = keyValues;
    }

    public void addKeyValue(KeyValue keyValue) {
        if (this.keyValues == null) {
            this.keyValues = new ArrayList<KeyValue>();
        }
        this.keyValues.add(keyValue);
    }

    public long getEpoch() {
        return this.epoch;
    }

    public String getIsoDate() {
        return this.isoDate;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGid(int gid) {
        this.gid = gid;
    }

    public boolean populateTargetUser() {
        return this.populateTargetUser;
    }

    public void setPopulateTargetUser(boolean val) {
        this.populateTargetUser = val;
    }

    public String getTargetUsername() {
        return this.targetUsername;
    }

    public void setTargetUsername(String username) {
        this.targetUsername = username;
    }

    public int getTargetUid() {
        return this.targetUid;
    }

    public void setTargetUid(int uid) {
        this.targetUid = uid;
    }

    public int getTargetGid() {
        return this.targetGid;
    }

    public void setTargetGid(int gid) {
        this.targetGid = gid;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean getForceAudit() {
        return this.forceAudit;
    }

    public void setForceAudit(boolean forceAudit) {
        this.forceAudit = forceAudit;
    }

    private String intToIp(int i) {
        StringBuilder sb = new StringBuilder();
        sb.append(i >> 24 & 0xFF);
        sb.append(".");
        sb.append(i >> 16 & 0xFF);
        sb.append(".");
        sb.append(i >> 8 & 0xFF);
        sb.append(".");
        sb.append(i & 0xFF);
        return sb.toString();
    }

    public static enum Op {
        passwordAuth,
        kerberosAuth,
        generateTicket,
        renewTicket,
        volumeCreate,
        volumeModify,
        volumeRemove,
        volumeRename,
        volumeMount,
        volumeUnmount,
        volumeConvert,
        volumePutInGfsck,
        volumeLookup,
        volumeList,
        volumePromote,
        volumeRemoveFromGfsck,
        volumeShowMounts,
        volumePropertiesLookup,
        volumeMove,
        volumeMirrorStart,
        volumeMirrorStop,
        volumeMirrorPermCheck,
        volumeMirrorRestoreInit,
        volumeMirrorRestoreUpdate,
        volumeOffload,
        volumeCompaction,
        volumeRecall,
        volumeTierJobStatus,
        volumeTierJobAbort,
        volumeTierStats,
        snapshotRemove,
        fileServerRemove,
        fileServerMove,
        fileServerModify,
        fileServerAllowInCluster,
        fileServerMaintenance,
        fileServerLookup,
        fileServerList,
        clusterUpgrade,
        clusterInfo,
        getClusterTopology,
        changeLogLevel,
        policyCreate,
        policyModify,
        policyRemove,
        policyGet,
        alarmAdd,
        alarmRemove,
        alarmEdit,
        alarmView,
        alarmLookup,
        alarmUpdate,
        aeLookup,
        aeModify,
        dumpInfo,
        aclShow,
        aclModify,
        configRead,
        configTest,
        configModify,
        licenseAdd,
        licenseRemove,
        licenseShow,
        addCRL,
        showCRL,
        eulaAccept,
        eulaShowAccept,
        dialhomeEnable,
        dialhomeStatus,
        dialhomeSuccessfulAck,
        dialhomeLastDialedResp,
        rlimitGet,
        rlimitSet,
        getTabletInfo,
        gatewayConfigSet,
        gatewayConfigGet,
        gatewayConfigList,
        gatewayConfigDelete,
        getLicenseId,
        getServerKey,
        getServerTicket,
        getClusterKey,
        getMapRUserTicket,
        blacklist,
        listBlacklist,
        dbreplGatewayConfigSet,
        dbreplGatewayConfigGet,
        dbreplGatewayConfigList,
        dbreplGatewayConfigDelete,
        addVirtualIps,
        listVirtualIps,
        moveVirtualIps,
        removeVirtualIps,
        modifyVirtualIps,
        fetchPolicies,
        enableFeatures,
        listFeatures,
        clientAuthorizationRequest,
        canRemoveSp,
        mirrorValidateStart,
        aeRemove,
        alarmGroupList,
        alarmGroupUpdate,
        getMinMax,
        balanceVolumeContainers,
        tierCreate,
        tierModify,
        tierRemove,
        tierLookup,
        tierList,
        offloadRuleCreate,
        offloadRuleModify,
        offloadRuleRemove,
        offloadRuleLookup,
        offloadRuleList,
        getDataSizeToMirror,
        snapshotRestore,
        snapshotRestoreStatus,
        volumeMirrorStatus,
        securityPolicyCreate,
        securityPolicyUpdate,
        securityPolicyList,
        securityPolicyLookUp,
        labelManagementRequest,
        spLabelAssignment,
        tierGwBalancerInfo,
        aeCreate,
        aeVolList,
        s3ServerConfigSet,
        s3ServerConfigAdd,
        s3ServerConfigRemove,
        s3ServerConfigShow,
        s3AddBucket,
        s3LookupBucket,
        s3RemoveBucket,
        s3RenameBucket,
        s3PurgeBucketOfVol,
        s3BucketCreateLocation,
        s3AccountCreateInit,
        s3AccountCreateConfirm,
        s3AccountModify,
        s3AccountInfo,
        s3AccountList,
        s3AccountDelete,
        s3CreateDomain,
        s3ModifyDomain,
        s3InfoDomain,
        s3ListDomain,
        s3DeleteDomain,
        s3AddUser,
        s3ModifyUser,
        s3RemoveUser,
        s3RefreshLdapUser,
        s3CreateKey,
        s3RemoveKey,
        s3ListKey,
        s3GenerateTempKey,
        s3SetAccessKeyStatus,
        s3CreatePolicy,
        s3AttachPolicy,
        s3DetachPolicy,
        s3ModifyPolicy,
        s3RemovePolicy,
        s3BulkPolicyAttach,
        s3BulkPolicyDetach,
        s3AddGroup,
        s3RemoveGroup,
        s3AccountRemoveInit,
        s3AccountRemoveConfirm,
        getRemoteTicket,
        genRemoteTicket;

    }
}

