/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.audit;

import java.util.List;

public class KeyValue {
    private String key;
    private String oldValue;
    private String newValue;

    public KeyValue() {
    }

    public KeyValue(String key) {
        this.key = key;
    }

    public KeyValue(String key, String oldValue, String newValue) {
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public KeyValue(String key, int oldValue, int newValue) {
        this.key = key;
        this.oldValue = Integer.toString(oldValue);
        this.newValue = Integer.toString(newValue);
    }

    public KeyValue(String key, long oldValue, long newValue) {
        this.key = key;
        this.oldValue = Long.toString(oldValue);
        this.newValue = Long.toString(newValue);
    }

    public KeyValue(String key, boolean oldValue, boolean newValue) {
        this.key = key;
        this.oldValue = Boolean.toString(oldValue);
        this.newValue = Boolean.toString(newValue);
    }

    public String getKey() {
        return this.key;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public boolean hasValues() {
        return this.key != null || this.oldValue != null || this.newValue != null;
    }

    public void setValues(String key, String oldValue, String newValue) {
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public void reInit() {
        this.key = null;
        this.oldValue = null;
        this.newValue = null;
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append("properties");
        sb.append("\"");
        sb.append(":");
        sb.append("[");
        this.toJsonStringInternal(sb);
        sb.append("]");
        return sb.toString();
    }

    public static String toJsonStringSR(List<KeyValue> keyValues) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append("properties");
        sb.append("\"");
        sb.append(":");
        sb.append("[");
        int i = 0;
        for (KeyValue keyValue : keyValues) {
            if (i > 0) {
                sb.append(",");
            }
            keyValue.toJsonStringInternal(sb);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private void toJsonStringInternal(StringBuilder sb) {
        sb.append("{");
        sb.append("\"");
        sb.append("property");
        sb.append("\"");
        sb.append(":");
        sb.append("\"");
        sb.append(this.key);
        sb.append("\"");
        sb.append(",");
        sb.append("\"");
        sb.append("oldvalue");
        sb.append("\"");
        sb.append(":");
        sb.append("\"");
        if (this.oldValue != null) {
            sb.append(this.oldValue);
        }
        sb.append("\"");
        sb.append(",");
        sb.append("\"");
        sb.append("newvalue");
        sb.append("\"");
        sb.append(":");
        sb.append("\"");
        if (this.newValue != null) {
            sb.append(this.newValue);
        }
        sb.append("\"");
        sb.append("}");
    }
}

