/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.utils.ACL;
import com.mapr.baseutils.utils.PolicyServerNobodyCredentials;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyServerPermissionsManager {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyServerPermissionsManager.class);
    private ACL clusterAcl;
    private int clusterOwnerUid;
    private boolean rejectRoot;
    private boolean squashRoot;
    private static PolicyServerPermissionsManager s_instance = null;

    private PolicyServerPermissionsManager(Security.AccessControlList clusterAclList, int clusterOwnerUid, boolean rejectRoot, boolean squashRoot) {
        this.clusterOwnerUid = clusterOwnerUid;
        this.updateConfParams(clusterAclList, rejectRoot, squashRoot);
    }

    public static synchronized PolicyServerPermissionsManager getInstance(Security.AccessControlList clusterAclList, int clusterOwnerUid, boolean rejectRoot, boolean squashRoot) {
        if (s_instance == null) {
            s_instance = new PolicyServerPermissionsManager(clusterAclList, clusterOwnerUid, rejectRoot, squashRoot);
        }
        return s_instance;
    }

    public void updateConfParams(Security.AccessControlList clusterAclList, boolean rejectRoot, boolean squashRoot) {
        this.clusterAcl = new ACL(clusterAclList);
        this.rejectRoot = rejectRoot;
        this.squashRoot = squashRoot;
    }

    private boolean isRejectRootEnabled() {
        return this.rejectRoot;
    }

    private boolean isSquashRootEnabled() {
        return this.squashRoot;
    }

    private int getClusterOwnerUid() {
        return this.clusterOwnerUid;
    }

    public ACL getClusterAcl() {
        return this.clusterAcl;
    }

    private boolean hasSecurityPolicyAclReadPerms(Common.SecurityPolicyProperties spProps, Security.CredentialsMsg creds) {
        int spBitMask = SecurityCommandHelper.SECURITY_POLICY_FULL_CONTROL_MASK | SecurityCommandHelper.SECURITY_POLICY_ADMIN_MASK;
        int clusterBitMask = SecurityCommandHelper.CLUSTER_FULL_CONTROL_MASK;
        return this.canPerformActionOnSecurityPolicy(spProps, creds, spBitMask, null) || this.canPerformActionAtClusterLevel(creds, clusterBitMask, null);
    }

    private boolean hasSecurityPolicyGenericReadPerms(Common.SecurityPolicyProperties spProps, Security.CredentialsMsg creds) {
        int spBitMask = SecurityCommandHelper.SECURITY_POLICY_READ_MASK | SecurityCommandHelper.SECURITY_POLICY_FULL_CONTROL_MASK;
        int clusterBitMask = SecurityCommandHelper.CLUSTER_FULL_CONTROL_MASK;
        return this.canPerformActionOnSecurityPolicy(spProps, creds, spBitMask, null) || this.canPerformActionAtClusterLevel(creds, clusterBitMask, null);
    }

    private boolean hasSecurityPolicyAclModify(Common.SecurityPolicyProperties spProps, Security.CredentialsMsg creds) {
        return this.canPerformActionOnSecurityPolicy(spProps, creds, SecurityCommandHelper.SECURITY_POLICY_ADMIN_MASK, null);
    }

    private boolean hasSecurityPolicyGenericPropertiesModify(Common.SecurityPolicyProperties spProps, Security.CredentialsMsg creds) {
        return this.canPerformActionOnSecurityPolicy(spProps, creds, SecurityCommandHelper.SECURITY_POLICY_FULL_CONTROL_MASK, null);
    }

    public boolean canPerformActionOnSecurityPolicy(Common.SecurityPolicyProperties spProps, Security.CredentialsMsg creds, int actionMask, StringBuilder errorMsg) {
        if (spProps == null || creds == null) {
            return false;
        }
        if (!spProps.hasAcl()) {
            if (errorMsg != null) {
                errorMsg.append("ACL Not Present for security policy " + spProps.getPolicyName());
            }
            return false;
        }
        if (this.hasAdminCredentials(creds)) {
            return true;
        }
        int callerUid = creds.getUid();
        if (callerUid == 0) {
            if (this.isRejectRootEnabled()) {
                if (errorMsg != null) {
                    errorMsg.append("Root cannot perform action since reject root is enabled");
                }
                return false;
            }
            if (this.isSquashRootEnabled()) {
                creds = PolicyServerNobodyCredentials.getInstance();
            }
        }
        ACL acl = new ACL(spProps.getAcl());
        return acl.verifyPermissions(creds, actionMask, errorMsg);
    }

    public boolean canPerformActionAtClusterLevel(Security.CredentialsMsg creds, int actionMask, StringBuilder errorMsg) {
        if (creds == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Credentials missing in the Request");
            }
            if (errorMsg != null && errorMsg.length() == 0) {
                errorMsg.append("Credentials missing in the Request");
            }
            return false;
        }
        if (this.hasAdminCredentials(creds)) {
            return true;
        }
        if (this.getClusterAcl() == null) {
            if (errorMsg != null && errorMsg.length() == 0) {
                errorMsg.append("Missing Cluster ACLs");
            }
            return false;
        }
        return this.getClusterAcl().verifyPermissions(creds, actionMask, errorMsg);
    }

    public boolean canPerformSecurityPolicyAction(CLDBProto.UserActions action, Security.CredentialsMsg creds, Common.SecurityPolicyProperties spProps) {
        if (action == null || creds == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("canPerformSecurityPolicyAction:action or creds is null");
            }
            return false;
        }
        switch (action) {
            case SecurityPolicyAclLookup: {
                return this.hasSecurityPolicyAclReadPerms(spProps, creds);
            }
            case SecurityPolicyGenericPropertiesLookup: {
                return this.hasSecurityPolicyGenericReadPerms(spProps, creds);
            }
            case SecurityPolicyAclModify: {
                return this.hasSecurityPolicyAclModify(spProps, creds);
            }
            case SecurityPolicyGenericPropertiesModify: {
                return this.hasSecurityPolicyGenericPropertiesModify(spProps, creds);
            }
        }
        if (LOG.isErrorEnabled()) {
            LOG.warn("canPerformSecurityPolicyAction: invalid action: " + action);
        }
        return false;
    }

    public boolean hasAdminCredentials(Security.CredentialsMsg creds) {
        if (creds == null) {
            return false;
        }
        int callerUid = creds.getUid();
        if (callerUid == 0) {
            if (this.isRejectRootEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("hasAdminCredentials: root is not admin since reject root is enabled");
                }
                return false;
            }
            if (this.isSquashRootEnabled()) {
                creds = PolicyServerNobodyCredentials.getInstance();
                callerUid = creds.getUid();
            }
        }
        return callerUid == this.getClusterOwnerUid();
    }

    public List<PoilicyActionPermission> getUserPermissions(Security.CredentialsMsg userCreds, Common.SecurityPolicyProperties secPolProp) {
        ArrayList<PoilicyActionPermission> permissions = new ArrayList<PoilicyActionPermission>(CLDBProto.UserActions.values().length);
        for (CLDBProto.UserActions action : CLDBProto.UserActions.values()) {
            String fieldname = action.name();
            boolean allow = false;
            if (!action.name().startsWith("SecurityPolicy") || secPolProp == null) continue;
            allow = this.canPerformSecurityPolicyAction(action, userCreds, secPolProp);
            permissions.add(new PoilicyActionPermission(fieldname, allow));
        }
        return permissions;
    }

    public class PoilicyActionPermission {
        public String action;
        public boolean allow;

        PoilicyActionPermission(String name, boolean val) {
            this.action = name;
            this.allow = val;
        }
    }
}

