/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.maprsasl;

import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.util.Map;
import javax.security.sasl.SaslException;

public class MapRSaslImplBase {
    protected boolean completed = false;
    protected String negotiatedQOPProperty;
    protected Security.Key sessionKey;
    protected int rawSendSize;
    protected int recvMaxBufSize;

    public MapRSaslImplBase(Map<String, ?> props) throws SaslException {
        this.recvMaxBufSize = this.parseInt(props, "javax.security.sasl.maxbuffer", 65536);
        this.rawSendSize = JNISecurity.GetDecryptedSize(this.recvMaxBufSize);
    }

    public String getMechanismName() {
        return "MAPR-SECURITY";
    }

    public boolean isComplete() {
        return this.completed;
    }

    public Object getNegotiatedProperty(String propName) {
        this.ensureComplete();
        switch (propName) {
            case "javax.security.sasl.qop": {
                return this.negotiatedQOPProperty;
            }
            case "javax.security.sasl.rawsendsize": {
                return String.valueOf(this.rawSendSize);
            }
            case "javax.security.sasl.maxbuffer": {
                return String.valueOf(this.recvMaxBufSize);
            }
        }
        return null;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        this.ensureComplete();
        byte[] keyBytes = new byte[len];
        System.arraycopy(incoming, offset, keyBytes, 0, len);
        MutableInt err = new MutableInt();
        byte[] decrypted = Security.Decrypt(this.sessionKey, keyBytes, err);
        return decrypted;
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        this.ensureComplete();
        byte[] keyBytes = new byte[len];
        System.arraycopy(outgoing, offset, keyBytes, 0, len);
        MutableInt err = new MutableInt();
        byte[] encrypted = Security.Encrypt(this.sessionKey, keyBytes, err);
        return encrypted;
    }

    private void ensureComplete() {
        if (!this.completed) {
            throw new IllegalStateException("MAPR-SECURITY authentication is not complete.");
        }
    }

    private int parseInt(Map<String, ?> props, String propKey, int defaultValue) throws SaslException {
        int value = defaultValue;
        String propValue = null;
        if (props != null && (propValue = (String)props.get(propKey)) != null) {
            try {
                value = Integer.parseInt(propValue);
            }
            catch (NumberFormatException e) {
                throw new SaslException(String.format("Property `%s` must be string representation of integer", propKey), e);
            }
        }
        return value;
    }
}

