/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security.verifier;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.OSInfo;
import com.mapr.security.JNISecurity;
import com.mapr.security.SecurityConf;
import com.mapr.web.security.SslConfig;
import com.mapr.web.security.verifier.Output;
import com.mapr.web.security.verifier.SecureFileVerifier;
import com.mapr.web.security.verifier.SslConfigVerifier;
import com.mapr.web.security.verifier.SslManagerVerifier;
import com.mapr.web.security.verifier.Tests;
import java.io.File;
import java.io.PrintStream;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityVerifierMain {
    private static final Logger log = LoggerFactory.getLogger(SecurityVerifierMain.class);
    private static final String UG_MAPR = "mapr";
    private final boolean asServer;
    private final String maprUser;
    private final String maprGroup;
    private Tests test;
    private SecureFileVerifier secureFileVerifier;
    private SslConfigVerifier sslConfigVerifier;
    private SslManagerVerifier sslManagerVerifier;
    private static final boolean isFipsEnabled = SecurityConf.isFipsEnabled();
    private static final String credProvider = isFipsEnabled ? "bcfks" : "jceks";
    private static final String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
    private static final boolean isSecured = JNISecurity.IsSecurityEnabled(currentClusterName);

    private static void usage(PrintStream strm) {
        strm.print("Usage: ");
        strm.println("mapr secchk [ <options...>]");
        strm.println("Options:");
        strm.println("  --server true|false           Specifies if the security configurations tests include those for MapR Service process (default is true)");
        strm.println("  --mapruser  <username>        Username that run the MapR Services on the node (default is 'mapr')");
        strm.println("  --maprgroup <groupname>       Primary group name of the user that runs the MapR Services (default is 'mapr')");
        strm.println("  --summary true|false          Prints a summary of errors at the end (default is false)");
        strm.println("  --verbose true|false          Prints verbose output from tests (default is false)");
    }

    public static void main(String[] args) {
        if (OSInfo.getOsFamily() != OSInfo.OsFamily.Linux) {
            System.err.println("This tool can only run on Linux machines.");
            System.exit(1);
        }
        int errCode = 0;
        boolean asServer = true;
        String maprUser = UG_MAPR;
        String maprGroup = UG_MAPR;
        block23: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--summary": 
                case "-s": {
                    Output.summary = SecurityVerifierMain.getBoolArgVal(i, args, true);
                    continue block23;
                }
                case "--server": 
                case "-S": {
                    asServer = SecurityVerifierMain.getBoolArgVal(i, args, true);
                    continue block23;
                }
                case "--mapruser": 
                case "-U": {
                    maprUser = SecurityVerifierMain.getStrArgVal(i, args, UG_MAPR);
                    continue block23;
                }
                case "--maprgroup": 
                case "-G": {
                    maprGroup = SecurityVerifierMain.getStrArgVal(i, args, UG_MAPR);
                    continue block23;
                }
                case "--verbose": 
                case "-V": {
                    Output.verbose = SecurityVerifierMain.getBoolArgVal(i, args, true);
                    continue block23;
                }
                default: {
                    errCode = 22;
                    Output.error("Unrecognized command line argument: '%s'", args[i]);
                }
                case "--help": {
                    SecurityVerifierMain.usage(System.err);
                    System.exit(errCode);
                }
            }
        }
        try {
            if (asServer && !new File("/opt/mapr/conf/ssl_keystore").canRead()) {
                throw new RuntimeException("Security Verifier was run in Server mode but the current user doesn't have the required privileges. Use \"--server false\" option to run client only tests, or run this tool as a privileged user.");
            }
            SecurityVerifierMain tool = SecurityVerifierMain.builder().asServer(asServer).maprUser(maprUser).maprGroup(maprGroup).build();
            tool.setTest(new Tests()).setSecureFileVerifier(new SecureFileVerifier(tool)).setSslConfigVerifier(new SslConfigVerifier(tool)).setSslManagerVerifier(new SslManagerVerifier()).run();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            Output.error(e);
        }
    }

    private void run() {
        Output.printfl("Running security health check as a %s", this.asServer ? "Server" : "Client");
        Output.printfl("===============================================", new Object[0]);
        Output.printH1("Checking Cluster Security configuration for Cluster '%s'", Output.yellow(currentClusterName));
        Output.info("Cluster is%s secured.", isSecured ? "" : " NOT");
        Output.info("FIPS is%s enabled.", isFipsEnabled ? "" : " NOT");
        if (this.asServer) {
            this.verifyServerSecuritySettings();
        }
        this.verifyClientSecuritySettings();
        Output.printfl("===============================================", new Object[0]);
        int errorCount = Tests.getErrorCount();
        Output.printfl("Tests complete, total error count: %d", errorCount);
        if (Output.summary && errorCount > 0) {
            Output.printfl("Error summary:", new Object[0]);
            Stack<Tests.Test> allTests = Tests.getAllTests();
            for (Tests.Test testWithError : allTests) {
                if (testWithError.errors.size() <= 0) continue;
                Output.printH2(testWithError.name, new Object[0]);
                for (String errMsg : testWithError.errors) {
                    Output.printf("   ", new Object[0]);
                    Output.error(errMsg, new Object[0]);
                }
            }
            Output.printfl("===============================================", new Object[0]);
        }
        System.exit(errorCount);
    }

    private void verifyServerSecuritySettings() {
        String[][] secureFiles;
        Output.printH1("Checking Server security configurations", new Object[0]);
        if (isSecured) {
            this.secureFileVerifier.verify("/opt/mapr/conf/maprserverticket", "rw-------");
            this.secureFileVerifier.verify("/opt/mapr/conf/mapruserticket", "rw-------");
        }
        for (String[] secureFile : secureFiles = new String[][]{{"/opt/mapr/conf/ssl-server.xml", "rw-r-----"}, {"/opt/mapr/conf/ssl_keystore", "r--------"}, {"/opt/mapr/conf/ssl_keystore.pem", "r--------"}, {"/opt/mapr/conf/ssl_keystore.p12", "r--------"}, {"/opt/mapr/conf/ssl_userkeystore", "r--------"}, {"/opt/mapr/conf/ssl_userkeystore.pem", "r--------"}, {"/opt/mapr/conf/ssl_userkeystore.p12", "r--------"}, {"/opt/mapr/conf/private.key", "r--------"}, {"/opt/mapr/conf/maprkeycreds.conf", "rw-------"}, {"/opt/mapr/conf/maprkeycreds." + credProvider, "rw-------"}}) {
            this.secureFileVerifier.verify(secureFile[0], secureFile[1]);
        }
        this.secureFileVerifier.verifyFolder("/opt/mapr/conf/tokens", "rw-------");
        this.secureFileVerifier.verifyFolder("/opt/mapr/conf/ca/root-ca/private", "rw-------");
        this.sslConfigVerifier.verify(SslConfig.SslConfigScope.SCOPE_ALL);
        this.sslManagerVerifier.verifyServer();
    }

    private void verifyClientSecuritySettings() {
        String[][] secureFiles;
        Output.printH1("Checking Client security configurations", new Object[0]);
        for (String[] secureFile : secureFiles = new String[][]{{"/opt/mapr/conf/ssl-client.xml", "rw-r--r--"}, {"/opt/mapr/conf/ssl_truststore", "r--r--r--"}, {"/opt/mapr/conf/ssl_truststore.pem", "r--r--r--"}, {"/opt/mapr/conf/ssl_truststore.p12", "r--r--r--"}, {"/opt/mapr/conf/ssl_usertruststore", "r--r--r--"}, {"/opt/mapr/conf/ssl_usertruststore.pem", "r--r--r--"}, {"/opt/mapr/conf/ssl_usertruststore.p12", "r--r--r--"}, {"/opt/mapr/conf/public.crt", "r--r--r--"}, {"/opt/mapr/conf/maprtrustcreds.conf", "rw-r--r--"}, {"/opt/mapr/conf/maprtrustcreds." + credProvider, "rw-r--r--"}}) {
            this.secureFileVerifier.verify(secureFile[0], secureFile[1]);
        }
        this.secureFileVerifier.verifyFolder("/opt/mapr/conf/ca", "glob:*.{crt,csr,pem}", "rw-r--r--");
        this.sslConfigVerifier.verify(SslConfig.SslConfigScope.SCOPE_CLIENT_ONLY);
        this.sslManagerVerifier.verifyClient();
    }

    private static boolean getBoolArgVal(int i, String[] args, boolean defaultVal) {
        return ++i < args.length && !args[i].startsWith("-") ? Boolean.getBoolean(args[i]) : defaultVal;
    }

    private static String getStrArgVal(int i, String[] args, String defaultVal) {
        return ++i < args.length && !args[i].startsWith("-") ? args[i] : defaultVal;
    }

    public static SecurityVerifierMainBuilder builder() {
        return new SecurityVerifierMainBuilder();
    }

    public SecurityVerifierMain(boolean asServer, String maprUser, String maprGroup, Tests test, SecureFileVerifier secureFileVerifier, SslConfigVerifier sslConfigVerifier, SslManagerVerifier sslManagerVerifier) {
        this.asServer = asServer;
        this.maprUser = maprUser;
        this.maprGroup = maprGroup;
        this.test = test;
        this.secureFileVerifier = secureFileVerifier;
        this.sslConfigVerifier = sslConfigVerifier;
        this.sslManagerVerifier = sslManagerVerifier;
    }

    public String getMaprUser() {
        return this.maprUser;
    }

    public String getMaprGroup() {
        return this.maprGroup;
    }

    private SecurityVerifierMain setTest(Tests test) {
        this.test = test;
        return this;
    }

    public Tests getTest() {
        return this.test;
    }

    private SecurityVerifierMain setSecureFileVerifier(SecureFileVerifier secureFileVerifier) {
        this.secureFileVerifier = secureFileVerifier;
        return this;
    }

    public SecureFileVerifier getSecureFileVerifier() {
        return this.secureFileVerifier;
    }

    private SecurityVerifierMain setSslConfigVerifier(SslConfigVerifier sslConfigVerifier) {
        this.sslConfigVerifier = sslConfigVerifier;
        return this;
    }

    public SslConfigVerifier getSslConfigVerifier() {
        return this.sslConfigVerifier;
    }

    private SecurityVerifierMain setSslManagerVerifier(SslManagerVerifier sslManagerVerifier) {
        this.sslManagerVerifier = sslManagerVerifier;
        return this;
    }

    public SslManagerVerifier getSslManagerVerifier() {
        return this.sslManagerVerifier;
    }

    public static class SecurityVerifierMainBuilder {
        private boolean asServer;
        private String maprUser;
        private String maprGroup;
        private Tests test;
        private SecureFileVerifier secureFileVerifier;
        private SslConfigVerifier sslConfigVerifier;
        private SslManagerVerifier sslManagerVerifier;

        SecurityVerifierMainBuilder() {
        }

        public SecurityVerifierMainBuilder asServer(boolean asServer) {
            this.asServer = asServer;
            return this;
        }

        public SecurityVerifierMainBuilder maprUser(String maprUser) {
            this.maprUser = maprUser;
            return this;
        }

        public SecurityVerifierMainBuilder maprGroup(String maprGroup) {
            this.maprGroup = maprGroup;
            return this;
        }

        public SecurityVerifierMainBuilder test(Tests test) {
            this.test = test;
            return this;
        }

        public SecurityVerifierMainBuilder secureFileVerifier(SecureFileVerifier secureFileVerifier) {
            this.secureFileVerifier = secureFileVerifier;
            return this;
        }

        public SecurityVerifierMainBuilder sslConfigVerifier(SslConfigVerifier sslConfigVerifier) {
            this.sslConfigVerifier = sslConfigVerifier;
            return this;
        }

        public SecurityVerifierMainBuilder sslManagerVerifier(SslManagerVerifier sslManagerVerifier) {
            this.sslManagerVerifier = sslManagerVerifier;
            return this;
        }

        public SecurityVerifierMain build() {
            return new SecurityVerifierMain(this.asServer, this.maprUser, this.maprGroup, this.test, this.secureFileVerifier, this.sslConfigVerifier, this.sslManagerVerifier);
        }

        public String toString() {
            return "SecurityVerifierMain.SecurityVerifierMainBuilder(asServer=" + this.asServer + ", maprUser=" + this.maprUser + ", maprGroup=" + this.maprGroup + ", test=" + this.test + ", secureFileVerifier=" + this.secureFileVerifier + ", sslConfigVerifier=" + this.sslConfigVerifier + ", sslManagerVerifier=" + this.sslManagerVerifier + ")";
        }
    }
}

