/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security.verifier;

import com.mapr.web.security.verifier.Output;
import com.mapr.web.security.verifier.SecurityVerifierMain;
import com.mapr.web.security.verifier.Tests;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureFileVerifier {
    private static final Logger log = LoggerFactory.getLogger(SecureFileVerifier.class);
    private static final FileSystem fs_s = FileSystems.getDefault();
    private final String maprUser;
    private final String maprGroup;

    public SecureFileVerifier(SecurityVerifierMain tool) {
        this.maprUser = tool.getMaprUser();
        this.maprGroup = tool.getMaprGroup();
    }

    public void verify(String secureFilePath, String permissions) {
        Tests.newTest("Verifying secure file '%s'", Output.yellow(secureFilePath));
        File secureFile = new File(secureFilePath);
        Tests.assertAndPrint(secureFile.exists(), "Exists", new Object[0]);
        if (!secureFile.exists()) {
            return;
        }
        Tests.assertAndPrint(secureFile.canRead(), "Readable", new Object[0]);
        Path filePath = secureFile.toPath();
        PosixFileAttributes attrs = Files.getFileAttributeView(filePath, PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
        Tests.assertEqualAndPrint(this.maprUser, attrs.owner().getName(), "Owner is set to '%s'", this.maprUser);
        Tests.assertEqualAndPrint(this.maprGroup, attrs.group().getName(), "Group is set to '%s'", this.maprGroup);
        if (permissions != null) {
            String actualPermissions = PosixFilePermissions.toString(attrs.permissions());
            log.info("Actual permissions for file {}: '{}'", (Object)secureFilePath, (Object)actualPermissions);
            Tests.assertEqualAndPrint(permissions, actualPermissions, "Permissions are set to '%s'", permissions);
        }
    }

    public void verifyFolder(String secureFolderPath, String permissions) {
        this.verifyFolder(secureFolderPath, null, permissions);
    }

    public void verifyFolder(String secureFolderPath, final String pattern, String permissions) {
        File[] allFiles;
        Tests.newTest("Verifying files in secure folder '%s'", Output.yellow(secureFolderPath));
        File secureFolder = new File(secureFolderPath);
        Tests.assertAndPrint(secureFolder.exists(), "Exists", new Object[0]);
        if (!secureFolder.exists()) {
            return;
        }
        Tests.assertAndPrint(secureFolder.isDirectory(), "Is a folder", new Object[0]);
        File[] fileArray = allFiles = pattern == null ? secureFolder.listFiles() : secureFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                PathMatcher pm = fs_s.getPathMatcher(pattern);
                return pm.matches(fs_s.getPath(name, new String[0]));
            }
        });
        if (allFiles.length == 0) {
            Output.info("No matching files found in %s", secureFolderPath);
            log.info("No matching files found in {}", (Object)secureFolderPath);
            return;
        }
        for (File secureFile : allFiles) {
            if (!secureFile.isFile()) continue;
            this.verify(secureFile.getAbsolutePath(), permissions);
        }
    }
}

