/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.simplesasl;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.commons.codec.binary.Base64;

public class SimpleSaslServer
implements SaslServer {
    public static final String SIMPLE_SECURITY_MECH_NAME = "SIMPLE-SECURITY";
    private boolean completed;
    private String authorizationId;

    @Override
    public void dispose() throws SaslException {
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("SimpleSasl authentication already completed");
        }
        if (response == null || response.length < 1) {
            throw new SaslException("Received challenge is empty when secret expected");
        }
        byte[] base64decoded = Base64.decodeBase64((byte[])response);
        this.authorizationId = new String(base64decoded);
        this.completed = true;
        return null;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationId;
    }

    @Override
    public String getMechanismName() {
        return SIMPLE_SECURITY_MECH_NAME;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return incoming;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return outgoing;
    }

    public static class SaslSimpleServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) {
            if (SimpleSaslServer.SIMPLE_SECURITY_MECH_NAME.equals(mechanism)) {
                return new SimpleSaslServer();
            }
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{SimpleSaslServer.SIMPLE_SECURITY_MECH_NAME};
        }
    }
}

