/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.audit.KeyValue;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final DecimalFormat decimalFormat;
    private static final SimpleDateFormat sdf;
    private static final Logger LOG;
    private static final long numSecondsUpToStartOf2020 = 1577836800L;
    public static int SEC;
    public static int MIN;
    public static int FIVE_MIN;

    public static String intToIp(int i) {
        StringBuilder sb = new StringBuilder();
        sb.append(i >> 24 & 0xFF);
        sb.append(".");
        sb.append(i >> 16 & 0xFF);
        sb.append(".");
        sb.append(i >> 8 & 0xFF);
        sb.append(".");
        sb.append(i & 0xFF);
        return sb.toString();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static int ipToInt(String addr) {
        if (addr.equals("localhost")) {
            addr = "127.0.0.1";
        }
        String[] addrArray = addr.split("\\.");
        long num = 0L;
        for (int i = 0; i < addrArray.length; ++i) {
            int power = 3 - i;
            num = (long)((double)num + (double)(Integer.parseInt(addrArray[i]) % 256) * Math.pow(256.0, power));
        }
        return (int)num;
    }

    public static long ipToLong(String ipAddress) {
        long result = 0L;
        String[] addrArray = ipAddress.split("\\.");
        for (int i = 3; i >= 0; --i) {
            result |= Long.parseLong(addrArray[3 - i]) << i * 8;
        }
        return result & 0xFFFFFFFFFFFFFFFFL;
    }

    public static String longToIp(long i) {
        StringBuilder sb = new StringBuilder();
        sb.append(i >> 24 & 0xFFL);
        sb.append(".");
        sb.append(i >> 16 & 0xFFL);
        sb.append(".");
        sb.append(i >> 8 & 0xFFL);
        sb.append(".");
        sb.append(i & 0xFFL);
        return sb.toString();
    }

    public static String toHex(String ipAddress) {
        return Long.toHexString(Util.ipToLong(ipAddress));
    }

    public static String readableSizeMB(long sizeMB) {
        double val = 0.0;
        String ending = "";
        if (sizeMB < 1024L) {
            val = sizeMB;
            ending = " MB";
        } else if (sizeMB < 0x100000L) {
            val = 1.0 * (double)sizeMB / 1024.0;
            ending = " GB";
        } else if (sizeMB < 0x40000000L) {
            val = 1.0 * (double)sizeMB / 1048576.0;
            ending = " TB";
        } else if (sizeMB < 0x10000000000L) {
            val = 1.0 * (double)sizeMB / 1.073741824E9;
            ending = " PB";
        }
        StringBuffer sb = new StringBuffer(Util.limitDecimalTo2(val));
        sb.append(ending);
        return sb.toString();
    }

    public static long readableSizeToSizeMB(String size) {
        if (size == null || size.length() < 2) {
            return -1L;
        }
        String readableString = size.substring(size.length() - 1);
        String sizeString = size.substring(0, size.length() - 1);
        double s = Double.valueOf(sizeString);
        if (readableString.equals("M")) {
            return (long)s;
        }
        if (readableString.equals("G")) {
            return (long)(s *= 1024.0);
        }
        if (readableString.equals("T")) {
            s = s * 1024.0 * 1024.0;
            return (long)s;
        }
        if (readableString.equals("P")) {
            s = s * 1024.0 * 1024.0 * 1024.0;
            return (long)s;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String limitDecimalTo2(double d) {
        DecimalFormat decimalFormat = Util.decimalFormat;
        synchronized (decimalFormat) {
            return Util.decimalFormat.format(d);
        }
    }

    public static long makeLongFromInts(long higher, long lower) {
        return higher << 32 | 0xFFFFFFFFL & lower;
    }

    public static int getHigherIntFromLong(long number) {
        return (int)(number >>> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    public static int getLowerIntFromLong(long number) {
        return (int)(number & 0xFFFFFFFFFFFFFFFFL);
    }

    public static long getMin(int number) {
        return Util.makeLongFromInts(number, 0L);
    }

    public static long getMax(int number) {
        return Util.makeLongFromInts(number, Integer.MAX_VALUE);
    }

    public static boolean ipBelongsToServer(Common.Server server, Common.IPAddress toCompare) {
        if (server == null || toCompare == null) {
            return false;
        }
        for (Common.IPAddress ip : server.getIpsList()) {
            if (ip.getHost() != toCompare.getHost()) continue;
            if (ip.getPort() == toCompare.getPort()) {
                return true;
            }
            for (Integer sport : server.getSecondaryPortsList()) {
                if (toCompare.getPort() != sport.intValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static List<Common.IPAddress> getCombinedIPAddresses(List<Common.IPAddress> primary, List<Integer> secondaryPorts) {
        if (primary.size() == 0 || secondaryPorts.size() == 0) {
            return primary;
        }
        ArrayList<Common.IPAddress> out = new ArrayList<Common.IPAddress>(primary.size());
        out.addAll(primary);
        Common.IPAddress baseIP = primary.get(0);
        for (Common.IPAddress ip : primary) {
            for (Integer port : secondaryPorts) {
                Common.IPAddress newIp = Common.IPAddress.newBuilder((Common.IPAddress)baseIP).clearHost().setHost(ip.getHost()).clearPort().setPort(port.intValue()).build();
                out.add(newIp);
            }
        }
        return out;
    }

    public static String printSimpleDateFormat(Common.FileTimeMsg time) {
        long nTime = (long)time.getSec() * 1000L + (long)time.getHusec();
        return sdf.format(new Date(nTime));
    }

    public static String printFidMsg(Common.FidMsg a) {
        return a.getCid() + "." + a.getCinum() + "." + a.getUniq();
    }

    public static String printIPAddress(int host, int port) {
        return Util.intToIp(host) + ":" + port;
    }

    public static String printServerList(List<Common.Server> servers) {
        StringBuilder sb = new StringBuilder();
        if (servers.size() == 0) {
            sb.append("... empty");
        } else {
            sb.append(servers.size() + " entries:");
            for (Common.Server s : servers) {
                sb.append("\n\t");
                Util.printServer(s, sb);
            }
        }
        return sb.toString();
    }

    public static String printServer(Common.Server server) {
        StringBuilder sb = new StringBuilder();
        Util.printServer(server, sb);
        return sb.toString();
    }

    private static void printServer(Common.Server server, StringBuilder sb) {
        if (server == null) {
            sb.append("unknown host");
            return;
        }
        sb.append("server-id:" + server.getServerId());
        sb.append(", IP: " + Util.printIPAddresses(server));
    }

    public static String printIPAddress(Common.IPAddress ip) {
        if (ip == null) {
            return "null";
        }
        return Util.intToIp(ip.getHost()) + ":" + ip.getPort();
    }

    public static String printIPAddresses(Common.Server server) {
        if (server == null) {
            return "unknown host";
        }
        if (server.getIpsList().isEmpty()) {
            return "unknown ip (" + server.getServerId() + ")";
        }
        return Util.printIPAddresses(server.getIpsList());
    }

    public static String printOneIpAddress(Common.Server server) {
        if (server == null) {
            return "unknown host";
        }
        if (server.getIpsList().isEmpty()) {
            return "unknown ip (" + server.getServerId() + ")";
        }
        return Util.printOneIpAddress(server.getIpsList());
    }

    private static String portToString(Common.IPAddress ip) {
        if (ip.getPort() != 5660) {
            return ":" + ip.getPort();
        }
        return "";
    }

    public static String printOneIpAddress(List<Common.IPAddress> ips) {
        if (ips.size() == 0) {
            return "No ip addresses";
        }
        StringBuilder sb = new StringBuilder().append(Util.intToIp(ips.get(0).getHost())).append(Util.portToString(ips.get(0)));
        if (ips.size() > 1) {
            sb.append("(");
            sb.append(ips.size());
            sb.append(")");
        }
        return sb.toString();
    }

    public static String printIPAddresses(List<Common.IPAddress> ips) {
        StringBuilder sb = new StringBuilder();
        for (Common.IPAddress ip : ips) {
            sb.append(Util.intToIp(ip.getHost()));
            sb.append(Util.portToString(ip));
            sb.append("-");
        }
        return sb.toString();
    }

    public static String printIPAddressesWithHostname(List<Common.IPAddress> ips) {
        StringBuilder sb = new StringBuilder();
        for (Common.IPAddress ip : ips) {
            sb.append(Util.intToIp(ip.getHost()));
            sb.append(Util.portToString(ip));
            sb.append("-");
            sb.append("hostname: ");
            sb.append(ip.getHostname());
            sb.append("-");
        }
        return sb.toString();
    }

    public static String printPorts(List<Integer> ports) {
        StringBuilder sb = new StringBuilder();
        for (Integer port : ports) {
            sb.append(port);
            sb.append("-");
        }
        return sb.toString();
    }

    public static String printSPIds(List<Common.StoragePoolInfo> sps) {
        StringBuilder sb = new StringBuilder();
        for (Common.StoragePoolInfo sp : sps) {
            sb.append(sp.getSpId());
            sb.append("(" + (sp.getDareEnabled() ? 1 : 0) + ")");
            sb.append("-");
        }
        return sb.toString();
    }

    public static String printServerWithState(Common.Server s) {
        return Util.printIPAddresses(s) + "-" + s.getEpoch() + "-" + s.getState();
    }

    public static String printServerWithNoState(Common.Server s) {
        return Util.printIPAddresses(s) + "-" + s.getEpoch();
    }

    public static String printContainerInfoWithServerId(CLDBProto.ContainerInfo c) {
        return Util.printContainerInfoWithServerId(c, false);
    }

    public static String printContainerInfoWithServerId(CLDBProto.ContainerInfo c, boolean verbose) {
        if (c == null) {
            return " ContainerInfo Null";
        }
        if (c.getContainerId() == 1) {
            verbose = true;
        }
        StringBuilder str = new StringBuilder();
        str.append(" Container ID:");
        str.append(c.getContainerId());
        if (c.hasMServer()) {
            str.append(" Master:");
            Util.addServerInfo(c.getMServer(), str, verbose);
        }
        str.append(" Servers: ");
        for (Common.Server server : c.getAServersList()) {
            Util.addServerInfo(server, str, verbose);
        }
        str.append(" Inactive: ");
        for (Common.Server server : c.getIServersList()) {
            Util.addServerInfo(server, str, verbose);
        }
        str.append(" Unused: ");
        for (Common.Server server : c.getUServersList()) {
            Util.addServerInfo(server, str, verbose);
        }
        str.append(" Epoch:");
        str.append(String.valueOf(c.getLatestEpoch()));
        str.append(" SizeMB:");
        str.append(c.getOwnedSizeMB() + c.getSharedSizeMB());
        if (c.hasContainerType()) {
            str.append(" CType:");
            str.append(String.valueOf(c.getContainerType()));
        }
        return str.toString();
    }

    private static void addServerInfo(Common.Server server, StringBuilder sb, boolean verbose) {
        sb.append(" ").append(Util.printOneIpAddress(server)).append("-").append(String.valueOf(server.getEpoch()));
        if (server.getResync()) {
            sb.append("-r");
        } else {
            sb.append(Util.replicaStateToString(server.getState()));
        }
        sb.append("(").append(server.getServerId()).append(")");
        if (verbose) {
            sb.append(" SPGUID:").append(server.getSpInfo().getSpId()).append(" ");
        }
    }

    private static String isDuplicateServerinList(List<Common.Server> servers, String strType) {
        StringBuilder sb = null;
        for (int i = 0; i < servers.size() - 1; ++i) {
            Common.Server server1 = servers.get(i);
            String spid1 = server1.getSpInfo().getSpId();
            for (int j = i + 1; j < servers.size(); ++j) {
                Common.Server server2 = servers.get(j);
                String spid2 = server2.getSpInfo().getSpId();
                if (server1.getServerId() != server2.getServerId() || !spid1.equals(spid2)) continue;
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(", fsid:");
                sb.append(server1.getServerId());
                sb.append(" sp:");
                sb.append(spid1);
                sb.append(" at ");
                sb.append(strType);
                sb.append(":");
                sb.append(i);
                sb.append(" at ");
                sb.append(strType);
                sb.append(":");
                sb.append(j);
            }
        }
        return sb == null ? null : sb.toString();
    }

    private static String isDuplicateServerinLists(List<Common.Server> list1, String strType1, List<Common.Server> list2, String strType2) {
        StringBuilder sb = null;
        for (int i = 0; i < list1.size(); ++i) {
            Common.Server server1 = list1.get(i);
            String spid1 = server1.getSpInfo().getSpId();
            for (int j = 0; j < list2.size(); ++j) {
                Common.Server server2 = list2.get(j);
                String spid2 = server2.getSpInfo().getSpId();
                if (server1.getServerId() != server2.getServerId() || !spid1.equals(spid2)) continue;
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(", fsid:");
                sb.append(server1.getServerId());
                sb.append(" sp:");
                sb.append(spid1);
                sb.append(" at ");
                sb.append(strType1);
                sb.append(":");
                sb.append(i);
                sb.append(" at ");
                sb.append(strType2);
                sb.append(":");
                sb.append(j);
            }
        }
        return sb == null ? null : sb.toString();
    }

    public static String getLogMsgIfMalformed(CLDBProto.ContainerInfo cInfo) {
        StringBuilder sb = null;
        String out = Util.isDuplicateServerinList(cInfo.getAServersList(), "A");
        if (out != null) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(out);
        }
        if ((out = Util.isDuplicateServerinLists(cInfo.getAServersList(), "A", cInfo.getIServersList(), "I")) != null) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(out);
        }
        if ((out = Util.isDuplicateServerinLists(cInfo.getAServersList(), "A", cInfo.getUServersList(), "U")) != null) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(out);
        }
        if ((out = Util.isDuplicateServerinList(cInfo.getIServersList(), "I")) != null) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(out);
        }
        if ((out = Util.isDuplicateServerinLists(cInfo.getIServersList(), "I", cInfo.getUServersList(), "U")) != null) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(out);
        }
        if ((out = Util.isDuplicateServerinList(cInfo.getUServersList(), "U")) != null) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(out);
        }
        if (sb == null) {
            return null;
        }
        StringBuilder logMsg = new StringBuilder("Container ID:");
        logMsg.append(cInfo.getContainerId());
        logMsg.append(" MALFORMED, ");
        logMsg.append(sb.toString());
        return logMsg.toString();
    }

    public static String printInitialContainerInfo(CLDBProto.ContainerInfo c) {
        if (c == null) {
            return " ContainerInfo Null";
        }
        StringBuilder str = new StringBuilder();
        str.append(" Container ID:");
        str.append(c.getContainerId());
        if (c.getType() == Common.ContainerReplType.STAR) {
            str.append("*");
        }
        if (c.hasVolumeId()) {
            str.append(" vol:");
            str.append(c.getVolumeId());
        }
        str.append(" Servers: ");
        for (Common.Server server : c.getAServersList()) {
            str.append(" ");
            str.append(Util.printOneIpAddress(server));
        }
        if (!c.hasMServer()) {
            str.append(" No master");
        }
        if (c.hasContainerType()) {
            str.append(" CType:");
            str.append(String.valueOf(c.getContainerType()));
        }
        return str.toString();
    }

    public static String replicaStateToString(Common.Server.ReplicaState replState) {
        switch (replState) {
            case BECOME_MASTER: {
                return "-BM";
            }
            case RESYNC: {
                return "-R";
            }
            case RECONNECT: {
                return "-C";
            }
        }
        return "";
    }

    public static String printContainerSizeInfo(CLDBProto.ContainerSizeInfo c) {
        if (c == null) {
            return " ContainerSizeInfo Null";
        }
        StringBuilder str = new StringBuilder();
        str.append(" Container ID:");
        str.append(c.getContainerId());
        str.append(" SizeMB:");
        str.append(c.getOwnedSizeMB() + c.getSharedSizeMB());
        return str.toString();
    }

    public static boolean compareIPAddress(Common.IPAddress a, Common.IPAddress b) {
        if (a == null || b == null) {
            return false;
        }
        return a.getHost() == b.getHost() && a.getPort() == b.getPort();
    }

    public static Integer getOneIPAddress(List<Common.IPAddress> ips) {
        if (ips == null) {
            return null;
        }
        if (ips.isEmpty()) {
            return null;
        }
        return ips.get(0).getHost();
    }

    public static boolean isDuplicateIPinServer(Common.Server s) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Common.IPAddress ip : s.getIpsList()) {
            if (set.add(ip.getHost())) continue;
            LOG.error("FATAL: Duplicate IP -- Server " + Util.printIPAddresses(s) + " contains duplicate ip: " + Util.printIPAddress(ip));
            return true;
        }
        return false;
    }

    public static void isDuplicateIPinContainer(CLDBProto.ContainerInfo cInfo) {
        if (cInfo.hasMServer() && Util.isDuplicateIPinServer(cInfo.getMServer())) {
            LOG.error("FATAL: Duplicate IP for Master server for container " + Util.printContainerInfoWithServerId(cInfo));
        }
        for (Common.Server server : cInfo.getAServersList()) {
            if (!Util.isDuplicateIPinServer(server)) continue;
            LOG.error("FATAL: Duplicate IP for Active server for container " + Util.printContainerInfoWithServerId(cInfo));
        }
        for (Common.Server server : cInfo.getIServersList()) {
            if (!Util.isDuplicateIPinServer(server)) continue;
            LOG.error("FATAL: Duplicate IP for INActive server for container " + Util.printContainerInfoWithServerId(cInfo));
        }
        for (Common.Server server : cInfo.getUServersList()) {
            if (!Util.isDuplicateIPinServer(server)) continue;
            LOG.error("FATAL: Duplicate IP for Unused server for container " + Util.printContainerInfoWithServerId(cInfo));
        }
    }

    public static boolean compareServers(Common.Server a, Common.Server b) {
        if (a == null || b == null) {
            return false;
        }
        return a.getServerId() == b.getServerId();
    }

    public static boolean compareServers(Common.Server a, long b) {
        return a.getServerId() == b;
    }

    public static boolean compareFidMsg(Common.FidMsg a, Common.FidMsg b) {
        return a.getCid() == b.getCid() && a.getCinum() == b.getCinum() && a.getUniq() == b.getUniq();
    }

    public static long getFloor(long val, long interval) {
        if (interval == 0L) {
            return val;
        }
        return val - val % interval;
    }

    public static long getCeil(long val, long interval) {
        if (interval == 0L) {
            return val;
        }
        return val + (interval - val % interval);
    }

    public static String aeKeyToString(CLDBProto.AeKey key) {
        String type = !key.getType() ? "u" : "g";
        return key.getName() + "(" + type + ")";
    }

    public static List<String> getHostIPAddresses() {
        Enumeration<NetworkInterface> netInterfaces = null;
        ArrayList<String> hostAddresses = new ArrayList<String>();
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return hostAddresses;
        }
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress addr = address.nextElement();
                if (addr.getHostAddress().indexOf(":") > -1 || addr.getHostAddress().equals("127.0.0.1") || addr.getHostAddress().equals("127.0.1.1")) continue;
                boolean found = false;
                for (String checkAddr : hostAddresses) {
                    if (!addr.equals(checkAddr)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                hostAddresses.add(addr.getHostAddress());
            }
        }
        return hostAddresses;
    }

    public static long hexToLong(byte[] bytes) {
        if (bytes.length > 16) {
            throw new IllegalArgumentException("Byte array too long");
        }
        long v = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            byte nextDigit = bytes[i];
            if ((nextDigit = (byte)(nextDigit - 48)) > 9) {
                nextDigit = (byte)(nextDigit - 39);
            }
            if (nextDigit < 0 || nextDigit > 15) {
                throw new IllegalArgumentException("Invalid HexCharacter " + bytes[i]);
            }
            v <<= 4;
            v |= (long)nextDigit;
        }
        return v;
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNonNegativeInteger(String s) {
        try {
            int v = Integer.parseInt(s);
            return v >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long roundTimeStampToMidnight(long timeOfDay) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(new Date(timeOfDay));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static int getContainerActualSize(CLDBProto.ContainerSizeInfo c) {
        int cSize = c.getOwnedSizeMB() + c.getSharedSizeMB();
        if (c.getChainSizeMB() > cSize) {
            cSize = c.getChainSizeMB();
        }
        return cSize;
    }

    public static int getContainerActualSize(int ownedSizeMB, int sharedSizeMB, int chainSizeMB) {
        int actualSize = ownedSizeMB + sharedSizeMB;
        if (chainSizeMB > actualSize) {
            actualSize = chainSizeMB;
        }
        return actualSize;
    }

    public static boolean hasOverlap(List<?> list1, List<?> list2) {
        if (list2 == null || list1 == null) {
            return false;
        }
        for (Object obj : list2) {
            if (!list1.contains(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDeviceOverlap(List<Common.InterfaceInfo> list1, List<Common.InterfaceInfo> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        for (Common.InterfaceInfo intf2 : list2) {
            String mac = intf2.getMacaddress();
            for (Common.InterfaceInfo intf1 : list1) {
                if (!mac.equalsIgnoreCase(intf1.getMacaddress())) continue;
                return true;
            }
        }
        return false;
    }

    public static long elapsedTimeGreaterThan(long lastLoggedTime, long skipMillis) {
        long curTime = System.currentTimeMillis();
        if (curTime < lastLoggedTime) {
            return curTime;
        }
        long elapsedTime = curTime - lastLoggedTime;
        if (elapsedTime > skipMillis) {
            return curTime;
        }
        return 0L;
    }

    public static String shrinkSpId(String spid) {
        if (spid.length() != 32) {
            return spid;
        }
        char[] cArr = new char[spid.length() / 2];
        int i = 0;
        int k = 0;
        while (i < spid.length()) {
            String tmp = spid.substring(i, i + 2);
            int ch = 0;
            try {
                ch = Integer.parseInt(tmp, 16);
            }
            catch (NumberFormatException e) {
                ch = 256;
            }
            if (ch > 255) {
                LOG.warn("spid " + spid + " not in hexadecimal string was reported by an MFS");
                return spid;
            }
            cArr[k] = (char)ch;
            i += 2;
            ++k;
        }
        return new String(cArr);
    }

    public static String expandSpId(String spid) {
        if (spid.length() != 16) {
            return spid;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < spid.length(); ++i) {
            String s = Integer.toHexString(spid.charAt(i));
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String printIPAddressForCLI(Common.IPAddress ip) {
        return Util.intToIp(ip.getHost()) + ":" + ip.getPort();
    }

    public static String printIPAddressesForCLI(Common.Server server) {
        if (server == null) {
            return "unknown host";
        }
        List ips = server.getIpsList();
        if (ips.isEmpty()) {
            return "unknown ip (" + server.getServerId() + ")";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.printIPAddressesForCLI(ips));
        return sb.toString();
    }

    public static String PrintExtIpAddressesForCli(Common.Server server) {
        if (server == null || server.getServerId() == 0L) {
            return "unknown host";
        }
        List externalIps = server.getExternalIPsList();
        if (externalIps.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.printExternalIPAddressesForCLI(externalIps, server.getExternalPortsList()));
        String extIps = sb.toString();
        if (extIps != null && extIps.length() > 0) {
            extIps = extIps.substring(0, extIps.length() - 1);
        }
        return extIps;
    }

    public static String printIPAddressesForCLI(List<Common.IPAddress> ips) {
        StringBuilder sb = new StringBuilder();
        for (Common.IPAddress ip : ips) {
            sb.append(Util.intToIp(ip.getHost()));
            sb.append(":");
            sb.append(ip.getPort());
            sb.append("-");
        }
        return sb.toString();
    }

    public static String printExternalIPAddressesForCLI(List<Common.IPAddress> ips, List<Integer> ports) {
        StringBuilder sb = new StringBuilder();
        for (Common.IPAddress ip : ips) {
            for (int port : ports) {
                sb.append(Util.intToIp(ip.getHost()));
                sb.append(":");
                sb.append(port);
                sb.append("-");
            }
        }
        return sb.toString();
    }

    public static String printRdmaPort(Common.Server s, int firstPort) {
        if (s == null || s.getRdmaPortsCount() == 0) {
            return "";
        }
        List rdmaPorts = s.getRdmaPortsList();
        if ((Integer)rdmaPorts.get(0) == firstPort) {
            return "-(RP)";
        }
        return "-(RP-" + rdmaPorts.get(0) + ")";
    }

    public static String printServerWithStateForCLI(Common.Server s) throws Exception {
        return Util.printServerWithStateForCLI(s, false);
    }

    public static String printServerWithStateForCLI(Common.Server s, boolean getCtime) throws Exception {
        if (s == null || s.getServerId() == 0L) {
            return "unknown host";
        }
        List ips = s.getIpsList();
        if (ips.isEmpty()) {
            throw new Exception("Ips list is empty for " + s.getServerId());
        }
        Common.IPAddress firstIp = (Common.IPAddress)ips.get(0);
        StringBuilder sb = new StringBuilder().append(Util.printIPAddressesForCLI(s)).append("-").append(s.getEpoch()).append("-").append(s.getState()).append(Util.printRdmaPort(s, firstIp.getPort()));
        if (getCtime && s.getCtime() != 0) {
            long ctime = Util.currentMillisFromMapRTime(s.getCtime());
            sb.append(", ctime: ");
            sb.append(sdf.format(new Date(ctime)));
        }
        return sb.toString();
    }

    public static String printServerWithNoStateForCLI(Common.Server s) throws Exception {
        return Util.printServerWithNoStateForCLI(s, false);
    }

    public static String printServerWithNoStateForCLI(Common.Server s, boolean getCtime) throws Exception {
        if (s == null || s.getServerId() == 0L) {
            return "unknown host";
        }
        List ips = s.getIpsList();
        if (ips.isEmpty()) {
            throw new Exception("Ips list is empty for " + s.getServerId());
        }
        Common.IPAddress firstIp = (Common.IPAddress)ips.get(0);
        StringBuilder sb = new StringBuilder().append(Util.printIPAddressesForCLI(s)).append("-").append(s.getEpoch()).append(Util.printRdmaPort(s, firstIp.getPort()));
        if (getCtime && s.getCtime() != 0) {
            long ctime = Util.currentMillisFromMapRTime(s.getCtime());
            sb.append(", ctime: ");
            sb.append(sdf.format(new Date(ctime)));
        }
        return sb.toString();
    }

    public static String printContainerInfoForCLI(CLDBProto.ContainerInfo c) {
        if (c == null) {
            return " ContainerInfo Null";
        }
        StringBuilder str = new StringBuilder();
        str.append(" Container ID:");
        str.append(c.getContainerId());
        if (c.hasVolumeId()) {
            str.append(" VolumeId:");
            str.append(c.getVolumeId());
        }
        if (c.hasMServer()) {
            str.append(" Master:");
            str.append(Util.printIPAddressesForCLI(c.getMServer()));
            str.append("-");
            str.append(String.valueOf(c.getMServer().getEpoch()));
            str.append("-");
            str.append(c.getMServer().getState());
            if (c.getMServer().getResync()) {
                str.append("-");
                str.append("r");
            }
        }
        str.append(" Servers: ");
        for (Common.Server server : c.getAServersList()) {
            str.append(" ");
            str.append(Util.printIPAddressesForCLI(server));
            str.append("-");
            str.append(String.valueOf(server.getEpoch()));
            str.append("-");
            str.append(server.getState());
            if (!server.getResync()) continue;
            str.append("-");
            str.append("r");
        }
        str.append(" Inactive Servers: ");
        for (Common.Server server : c.getIServersList()) {
            str.append(" ");
            str.append(Util.printIPAddressesForCLI(server));
            str.append("-");
            str.append(String.valueOf(server.getEpoch()));
        }
        str.append(" Unused Servers: ");
        for (Common.Server server : c.getUServersList()) {
            str.append(" ");
            str.append(Util.printIPAddressesForCLI(server));
            str.append("-");
            str.append(String.valueOf(server.getEpoch()));
        }
        str.append(" Latest epoch:");
        str.append(String.valueOf(c.getLatestEpoch()));
        return str.toString();
    }

    public static Common.GuidMsg getUniqueVolumeUuid(Common.GuidMsg clusterUuid, CLDBProto.VolumeProperties volProps) {
        Common.GuidMsg.Builder uuid = Common.GuidMsg.newBuilder();
        if (clusterUuid == null) {
            uuid.setId640(0L);
        } else {
            uuid.setId640(clusterUuid.getId640());
        }
        uuid.setId641(volProps.getVolumeUUID());
        return uuid.build();
    }

    public static String pringGuid(Common.GuidMsg guid) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("0x%08X", guid.getId640()));
        sb.append(":");
        sb.append(String.format("0x%08X", guid.getId641()));
        return sb.toString();
    }

    public static List<KeyValue> getChangedAlarmGroupEntries(Common.AlarmGroupConfigMsg oldConfig, Common.AlarmGroupConfigMsg newConfig) {
        ArrayList<KeyValue> changedValues = new ArrayList<KeyValue>();
        HashSet oldEmails = new HashSet(oldConfig.getEmailsList());
        HashSet newEmails = new HashSet(newConfig.getEmailsList());
        boolean setsDiffer = false;
        if (!oldEmails.containsAll(newEmails) || !newEmails.containsAll(oldEmails)) {
            setsDiffer = true;
        }
        if (setsDiffer) {
            changedValues.add(new KeyValue(CLDBProto.AlarmGroupFields.emails.toString(), ((Object)oldEmails).toString(), ((Object)newEmails).toString()));
        }
        HashSet oldAlarmIds = new HashSet(oldConfig.getAlarmIdsList());
        HashSet newAlarmIds = new HashSet(newConfig.getAlarmIdsList());
        setsDiffer = false;
        if (!oldAlarmIds.containsAll(newAlarmIds) || !newAlarmIds.containsAll(oldAlarmIds)) {
            setsDiffer = true;
        }
        if (setsDiffer) {
            changedValues.add(new KeyValue(CLDBProto.AlarmGroupFields.alarmIds.toString(), ((Object)oldAlarmIds).toString(), ((Object)newAlarmIds).toString()));
        }
        return changedValues;
    }

    public static List<KeyValue> getChangedOffloadRuleProps(CLDBProto.OffloadRuleProperties oldProps, CLDBProto.OffloadRuleProperties newProps) {
        ArrayList<KeyValue> changedValues = new ArrayList<KeyValue>();
        if (oldProps.getExpression() != newProps.getExpression()) {
            changedValues.add(new KeyValue(CLDBProto.ListSortKey.TierRuleExpression.toString(), oldProps.getExpression(), newProps.getExpression()));
        }
        return changedValues;
    }

    public static List<KeyValue> getChangedTierProps(CLDBProto.TierProperties oldProps, CLDBProto.TierProperties newProps) {
        ArrayList<KeyValue> changedValues = new ArrayList<KeyValue>();
        if (oldProps.getTierId() != newProps.getTierId()) {
            changedValues.add(new KeyValue(CLDBProto.ListSortKey.TierTierId.toString(), oldProps.getTierId(), newProps.getTierId()));
        }
        if (oldProps.getTierName() != newProps.getTierName()) {
            changedValues.add(new KeyValue(CLDBProto.ListSortKey.TierName.toString(), oldProps.getTierName(), newProps.getTierName()));
        }
        if (newProps.hasDbTopology() && !oldProps.getDbTopology().equals(newProps.getDbTopology())) {
            changedValues.add(new KeyValue(CLDBProto.VolumeInfoFields.rackPath.toString(), oldProps.getDbTopology(), newProps.getDbTopology()));
        }
        changedValues.add(new KeyValue(CLDBProto.ListSortKey.TierTierType.toString(), oldProps.getTierType().toString(), newProps.getTierType().toString()));
        if (newProps.getTierType() != CLDBProto.TierType.EC_TIER) {
            if (oldProps.getUrl() != newProps.getUrl()) {
                changedValues.add(new KeyValue(CLDBProto.ListSortKey.TierUrl.toString(), oldProps.getUrl(), newProps.getUrl()));
            }
            Security.TierCredentials newCreds = newProps.getTierCreds();
            Security.TierCredentials oldCreds = oldProps.getTierCreds();
            if (oldCreds.getBucketName() != newCreds.getBucketName()) {
                changedValues.add(new KeyValue(CLDBProto.ListSortKey.TierBucketName.toString(), oldCreds.getBucketName(), newCreds.getBucketName()));
            }
            if (oldCreds.getRegion() != newCreds.getRegion()) {
                changedValues.add(new KeyValue(CLDBProto.ListSortKey.TierRegion.toString(), oldCreds.getRegion(), newCreds.getRegion()));
            }
            changedValues.add(new KeyValue(CLDBProto.ListSortKey.TierObjectstoreType.toString(), oldProps.getObjectStoreType().toString(), newProps.getObjectStoreType().toString()));
        }
        return changedValues;
    }

    public static String getNameFromVolumenoteKey(String noteKey) {
        int delIdx = noteKey.indexOf(58);
        return noteKey.substring(delIdx + 1);
    }

    public static int getVolIdFromVolumenoteKey(String noteKey) {
        int delIdx = noteKey.indexOf(58);
        return Integer.parseInt(noteKey.substring(0, delIdx));
    }

    public static String getVolumenoteKey(int volId, String noteName) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%010d", volId)).append(":").append(noteName);
        return sb.toString();
    }

    public static String getCurrentDate() {
        GregorianCalendar cl = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss");
        return sdf.format(cl.getTime());
    }

    public static String getVolumeEnforcementModeName(boolean enforcePolicies, boolean enforceAces, boolean auditOnlyPolicyCheck) {
        if (auditOnlyPolicyCheck) {
            return "PolicyAceAuditAndDataAce";
        }
        if (enforcePolicies && enforceAces) {
            return "PolicyAceAndDataAce";
        }
        if (enforcePolicies && !enforceAces) {
            return "PolicyAceOnly";
        }
        if (!enforcePolicies && enforceAces) {
            return "DataAceOnly";
        }
        return "DefaultToDataAce";
    }

    public static String printVolumeAccessControl(int volId, Common.VolumeAces va) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%010d", volId)).append(": VolumeAces:");
        if (va.getAcesCount() != 0) {
            int k = 0;
            for (Common.VolumeAceEntry vae : va.getAcesList()) {
                sb.append(" ace" + k);
                if (vae.hasExpr()) {
                    sb.append(" expr " + vae.getExpr());
                }
                if (vae.hasAccessType()) {
                    sb.append(" accessType: " + vae.getAccessType());
                }
                ++k;
            }
        } else {
            sb.append(" No Volume Aces");
        }
        if (va.getPolicyIdsCount() > 0) {
            sb.append(" Security PolicyIds: " + Arrays.toString(va.getPolicyIdsList().toArray()));
        } else {
            sb.append(" No Security Policy Id");
        }
        if (va.getPolicyNamesCount() > 0) {
            sb.append(" Security PolicyNames: " + Arrays.toString(va.getPolicyNamesList().toArray()));
        } else {
            sb.append(" No Security Policy Name");
        }
        if (va.hasEnforceAces()) {
            sb.append(" enforceAces: " + va.getEnforceAces());
        } else {
            sb.append(" No enforceAces");
        }
        if (va.hasEnforcePolicies()) {
            sb.append(" enforcePolicies: " + va.getEnforcePolicies());
        } else {
            sb.append(" No enforcePolicies");
        }
        return sb.toString();
    }

    public static int getMapRTimeInSeconds(long millis) {
        long secs = millis / 1000L;
        return (int)(secs < 1577836800L ? 0L : secs - 1577836800L);
    }

    public static long currentMillisFromMapRTime(int seconds) {
        return seconds < 0 ? 0L : (1577836800L + (long)seconds) * 1000L;
    }

    public static byte[] getSHA256(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(input.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Algorithm SHA-256 not supported", (Throwable)e);
            return null;
        }
    }

    public static String printableKey(byte[] bytes) {
        return BinaryString.toStringBinary(bytes);
    }

    static {
        LOG = LoggerFactory.getLogger(Util.class);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        decimalFormat = (DecimalFormat)numberFormat;
        decimalFormat.applyPattern("#.##");
        sdf = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
        SEC = 1000;
        MIN = 60 * SEC;
        FIVE_MIN = 5 * MIN;
    }
}

