/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.google.protobuf.ByteString;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHelper.class);

    public static byte[] zookeeperAuthRequestCreationHelper(Security.TicketAndKey ticketAndKey, long sessionId) {
        if (ticketAndKey == null) {
            LOG.error("TicketAndKey is null");
            return null;
        }
        MutableInt err = new MutableInt();
        long randomSecret = System.currentTimeMillis();
        byte[] writeBuffer = new byte[]{(byte)(randomSecret >>> 56), (byte)(randomSecret >>> 48), (byte)(randomSecret >>> 40), (byte)(randomSecret >>> 32), (byte)(randomSecret >>> 24), (byte)(randomSecret >>> 16), (byte)(randomSecret >>> 8), (byte)(randomSecret >>> 0), (byte)(sessionId >>> 56), (byte)(sessionId >>> 48), (byte)(sessionId >>> 40), (byte)(sessionId >>> 32), (byte)(sessionId >>> 24), (byte)(sessionId >>> 16), (byte)(sessionId >>> 8), (byte)(sessionId >>> 0)};
        Security.AuthenticationReqFull.Builder bld = Security.AuthenticationReqFull.newBuilder();
        byte[] secretBytesEncrypted = Security.Encrypt(ticketAndKey.getUserKey(), writeBuffer, err);
        if (err.GetValue() != 0) {
            LOG.error("Could not encrypt ticket with error: " + err.GetValue());
            return null;
        }
        bld.setEncryptedRandomSecret(ByteString.copyFrom((byte[])secretBytesEncrypted));
        bld.setEncryptedTicket(ticketAndKey.getEncryptedTicket());
        byte[] authRequestBytes = bld.build().toByteArray();
        authRequestBytes = Base64.encodeBase64((byte[])authRequestBytes);
        return authRequestBytes;
    }

    public static Security.TicketAndKey ticketReadingHelper() {
        String ticketFileLocation = JNISecurity.GetUserTicketAndKeyFileLocation();
        if (ticketFileLocation == null) {
            LOG.error("TicketKey file is not found");
            return null;
        }
        MutableInt err = new MutableInt();
        int errorCode = Security.SetTicketAndKeyFile(ticketFileLocation);
        if (errorCode != 0) {
            LOG.error("Problem with TicketKey file: " + errorCode);
            return null;
        }
        String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (currentClusterName == null) {
            LOG.error("Current cluster name is not found");
            return null;
        }
        Security.TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.ServerKey, currentClusterName, err);
        if (ticketAndKey == null) {
            LOG.error("MaprTicket is not found");
            return null;
        }
        if (!Security.IsTicketAndKeyUsable(ticketAndKey)) {
            LOG.error("My Mapr ticket is expired. Get new one");
            return null;
        }
        return ticketAndKey;
    }

    public static List<String> getHostFromCluster(String clusterName) {
        List<CLDBRpcCommonUtils.IpPort> ipports = CLDBRpcCommonUtils.getInstance().getOriginalClusterMap().get(clusterName);
        if (ipports == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>(ipports.size());
        for (CLDBRpcCommonUtils.IpPort ipport : ipports) {
            List<String> hosts = ipport.getOriginalAddr();
            if (hosts.size() <= 0) continue;
            res.add(hosts.get(0));
        }
        return res;
    }

    public static String getClusterFromHost(List<String> hosts) {
        for (String host : hosts) {
            String cn = CLDBRpcCommonUtils.getInstance().getHostMap().get(host);
            if (cn == null) continue;
            return cn;
        }
        return null;
    }

    public static boolean addCLDBsToAuthReqFull(Security.AuthenticationReqFull.Builder bld, String clusterName) {
        String cn;
        String string = cn = clusterName == null || clusterName.isEmpty() ? CLDBRpcCommonUtils.getInstance().getCurrentClusterName() : clusterName;
        if (cn != null) {
            List<String> hosts = SecurityHelper.getHostFromCluster(cn);
            if (hosts == null) {
                LOG.error("No CLDBs can be found for the cluster " + cn);
                return false;
            }
            bld.addAllCldb(hosts);
            return true;
        }
        LOG.error("Current cluster name is null. Cannot retrieve CLDB host names.");
        return false;
    }

    public static boolean checkCLDBAuthReqFull(Security.AuthenticationReqFull req) {
        String currCluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        for (String host : req.getCldbList()) {
            String cn = CLDBRpcCommonUtils.getInstance().getHostMap().get(host);
            if (cn == null || !cn.equals(currCluster)) continue;
            return true;
        }
        return false;
    }

    public static Security.AuthenticationResp createAuthRespWrongTicket() {
        String currCluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        Security.AuthenticationResp.Builder res = Security.AuthenticationResp.newBuilder();
        res.setStatus(1);
        res.setError("Ticket for wrong cluster is being used on cluster " + currCluster);
        List<String> hosts = SecurityHelper.getHostFromCluster(currCluster);
        if (hosts == null) {
            LOG.error("No CLDBs can be found for the cluster " + currCluster);
            return null;
        }
        res.addAllReceivingCldb(hosts);
        return res.build();
    }
}

