/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.security;

import com.mapr.baseutils.BaseUtilTests;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class TestEncryptDecrypt
extends BaseUtilTests {
    private static final int E2BIG = 7;
    private static final int ENCRYPTION_OVERHEAD = 32;
    private static final int LENGTH_256MB_BYTES = 0x10000000;
    private static final int MAX_SIGNED_INT = Integer.MAX_VALUE;
    private static final int LENGTH_AES_BLOCKSIZE = 16;

    public void _doEncryptAndDecrypt(long clearTextLength, long encryptedLength, String message, int expectedResult) {
        System.out.println("Running test: " + message);
        Security.Key key = Security.GenerateRandomKey();
        MutableInt erri = new MutableInt();
        byte[] bufToEncrypt = new byte[(int)clearTextLength];
        Arrays.fill(bufToEncrypt, (byte)1);
        byte[] encryptedBytes = Security.Encrypt((Security.Key)key, (byte[])bufToEncrypt, (MutableInt)erri);
        Assert.assertEquals((long)encryptedLength, (long)encryptedBytes.length);
        Assert.assertEquals((long)0L, (long)erri.GetValue());
        erri.SetValue(0);
        byte[] decryptedBytes = Security.Decrypt((Security.Key)key, (byte[])encryptedBytes, (MutableInt)erri);
        Assert.assertEquals((long)clearTextLength, (long)decryptedBytes.length);
        Assert.assertArrayEquals((byte[])bufToEncrypt, (byte[])decryptedBytes);
        Assert.assertEquals((long)expectedResult, (long)erri.GetValue());
        System.out.println("Success: " + message);
    }

    @Test
    public void testEncryptedSize() {
        Assert.assertEquals((long)0L, (long)JNISecurity.GetEncryptedSize((int)0));
        Assert.assertEquals((long)132L, (long)JNISecurity.GetEncryptedSize((int)100));
    }

    @Test
    public void testDecryptedSize() {
        Assert.assertEquals((long)0L, (long)JNISecurity.GetDecryptedSize((int)0));
        Assert.assertEquals((long)68L, (long)JNISecurity.GetDecryptedSize((int)100));
    }

    @Test
    public void testEncDec256MB() {
        this._doEncryptAndDecrypt(0x10000000L, 0x10000020L, "Encrypt and decrypt 256MB", 0);
    }

    @Test
    public void testEncDecEqualOneBlock() {
        this._doEncryptAndDecrypt(16L, 48L, "Encrypt and decrypt 16 bytes", 0);
    }

    @Test
    public void testEncDecLessThanOneBlock() {
        this._doEncryptAndDecrypt(1L, 33L, "Encrypt and decrypt 1 byte", 0);
    }

    @Test
    public void testEncDecMoreThan256MB_LessThanOneBlock() {
        this._doEncryptAndDecrypt(0x10000001L, 0x10000021L, "Encrypt and decrypt 256MB + 1 bytes", 0);
    }

    @Test
    public void testEncDecMoreThan256MB_MoreThanOneBlock() {
        this._doEncryptAndDecrypt(0x10000013L, 0x10000033L, "Encrypt and decrypt 256MB + 16 + 3 bytes", 0);
    }

    @Test
    public void testEncDecMoreThan256MB_PlusOneBlock() {
        this._doEncryptAndDecrypt(0x10000010L, 0x10000030L, "Encrypt and decrypt 256MB + 16 bytes", 0);
    }

    @Test
    public void testEncDec512MB() {
        this._doEncryptAndDecrypt(0x20000000L, 0x20000020L, "Encrypt and decrypt 512MB", 0);
    }

    @Test
    public void testEncDec1GB() {
        this._doEncryptAndDecrypt(0x40000000L, 0x40000020L, "Encrypt and decrypt 1GB", 0);
    }

    @Test
    public void testEncDec1GBPlus256MB() {
        this._doEncryptAndDecrypt(0x50000000L, 0x50000020L, "Encrypt and decrypt 1GB+256MB", 0);
    }
}

