/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.audit;

import com.mapr.baseutils.audit.AuditJsonFormatter;
import com.mapr.baseutils.audit.AuditRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditRecordLogger {
    private final Log LOG;
    private static final AuditRecordLogger auditLogger = new AuditRecordLogger("AuditLogger");
    private LogFormat logFormat = LogFormat.Json;
    private AuditJsonFormatter jsonFormatter = AuditJsonFormatter.getInstance();

    protected AuditRecordLogger(String logger) {
        this.LOG = LogFactory.getLog((String)logger);
    }

    public static AuditRecordLogger getInstance() {
        return auditLogger;
    }

    public void setAuditLogFormat(LogFormat logFormat) {
        this.logFormat = logFormat;
    }

    public void logAuditRecord(AuditRecord auditRecord) {
        if (auditRecord == null) {
            return;
        }
        String logMsg = null;
        switch (this.logFormat) {
            case Json: {
                logMsg = this.jsonFormatter.formatAuditRecord(auditRecord);
                break;
            }
        }
        if (logMsg != null && !logMsg.isEmpty()) {
            String newLine = System.getProperty("line.separator");
            if (newLine != null && !newLine.isEmpty()) {
                logMsg.trim().replaceAll(newLine, "\t");
            }
            this.LOG.info((Object)logMsg);
        }
    }

    public static enum LogFormat {
        Json,
        String;

    }
}

