/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.simplesasl;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class GenericLoginModule
implements LoginModule {
    public static final String JAVA_VENDOR_NAME = System.getProperty("java.vendor");
    public static final boolean IBM_JAVA = JAVA_VENDOR_NAME.contains("IBM");
    private static final boolean windows = System.getProperty("os.name").startsWith("Windows");
    private static final boolean is64Bit = System.getProperty("os.arch").contains("64");
    private static final boolean aix = System.getProperty("os.name").equals("AIX");
    private static final String OS_LOGIN_MODULE_NAME = GenericLoginModule.getOSLoginModuleName();
    private LoginModule realModule;

    private static String getOSLoginModuleName() {
        if (IBM_JAVA) {
            if (windows) {
                return is64Bit ? "com.ibm.security.auth.module.Win64LoginModule" : "com.ibm.security.auth.module.NTLoginModule";
            }
            if (aix) {
                return is64Bit ? "com.ibm.security.auth.module.AIX64LoginModule" : "com.ibm.security.auth.module.AIXLoginModule";
            }
            return "com.ibm.security.auth.module.LinuxLoginModule";
        }
        return windows ? "com.sun.security.auth.module.NTLoginModule" : "com.sun.security.auth.module.UnixLoginModule";
    }

    @Override
    public boolean abort() throws LoginException {
        return this.realModule.abort();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.realModule.commit();
    }

    @Override
    public void initialize(Subject arg0, CallbackHandler arg1, Map<String, ?> arg2, Map<String, ?> arg3) {
        try {
            this.realModule = (LoginModule)Class.forName(OS_LOGIN_MODULE_NAME).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to instantiate needed login module: " + OS_LOGIN_MODULE_NAME, e);
        }
        this.realModule.initialize(arg0, arg1, arg2, arg3);
    }

    @Override
    public boolean login() throws LoginException {
        return this.realModule.login();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.realModule.logout();
    }
}

