/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.tedutils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TedServer {
    private static final Logger LOG = LoggerFactory.getLogger(TedServer.class);
    TedEvent[] tedEvents = new TedEvent[1504];

    public TedServer() {
        for (int i = 0; i < 1504; ++i) {
            this.tedEvents[i] = new TedEvent(i);
        }
    }

    public void enableEvent(int id) {
        if (id >= this.tedEvents.length) {
            return;
        }
        this.tedEvents[id].enabled = true;
        if (LOG.isInfoEnabled()) {
            LOG.info("Enabled ted event " + id);
        }
    }

    public boolean eventEnabled(int id) {
        if (id >= this.tedEvents.length) {
            return false;
        }
        return this.tedEvents[id].enabled;
    }

    public void disableEvent(int id) {
        if (id >= this.tedEvents.length) {
            return;
        }
        this.tedEvents[id].enabled = false;
        if (LOG.isInfoEnabled()) {
            LOG.info("Disabled ted event " + id);
        }
    }

    public EventType getEventType(int id) {
        if (id >= 0 && id <= 9) {
            return EventType.NODE_EVENT;
        }
        if (id >= 1000 && id <= 1003) {
            return EventType.VOLUME_EVENT;
        }
        if (id >= 1100 && id <= 1103) {
            return EventType.CID_GENERATOR_EVENT;
        }
        if (id >= 1200 && id <= 1202) {
            return EventType.VOLUME_MANAGER_EVENT;
        }
        if (id >= 1300 && id < 1301) {
            return EventType.KVSTORE_EVENT;
        }
        if (id >= 1400 && id < 1499) {
            return EventType.GENERIC_CLDB_EVENT;
        }
        if (id >= 1500 && id < 1504) {
            return EventType.PBS_EVENT;
        }
        return EventType.INVALID_EVENT;
    }

    class TedEvent {
        int eventId;
        boolean enabled;

        TedEvent(int id) {
            this.eventId = id;
            this.enabled = false;
        }
    }

    public static enum EventType {
        NODE_EVENT,
        VOLUME_EVENT,
        CID_GENERATOR_EVENT,
        VOLUME_MANAGER_EVENT,
        KVSTORE_EVENT,
        GENERIC_CLDB_EVENT,
        PBS_EVENT,
        INVALID_EVENT;

    }
}

