/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.google.protobuf.ByteString;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHelper.class);

    public static byte[] zookeeperAuthRequestCreationHelper(Security.TicketAndKey ticketAndKey, long sessionId) {
        if (ticketAndKey == null) {
            LOG.error("TicketAndKey is null");
            return null;
        }
        MutableInt err = new MutableInt();
        long randomSecret = System.currentTimeMillis();
        byte[] writeBuffer = new byte[]{(byte)(randomSecret >>> 56), (byte)(randomSecret >>> 48), (byte)(randomSecret >>> 40), (byte)(randomSecret >>> 32), (byte)(randomSecret >>> 24), (byte)(randomSecret >>> 16), (byte)(randomSecret >>> 8), (byte)(randomSecret >>> 0), (byte)(sessionId >>> 56), (byte)(sessionId >>> 48), (byte)(sessionId >>> 40), (byte)(sessionId >>> 32), (byte)(sessionId >>> 24), (byte)(sessionId >>> 16), (byte)(sessionId >>> 8), (byte)(sessionId >>> 0)};
        Security.AuthenticationReqFull.Builder bld = Security.AuthenticationReqFull.newBuilder();
        byte[] secretBytesEncrypted = Security.Encrypt(ticketAndKey.getUserKey(), writeBuffer, err);
        if (err.GetValue() != 0) {
            LOG.error("Could not encrypt ticket with error: " + err.GetValue());
            return null;
        }
        bld.setEncryptedRandomSecret(ByteString.copyFrom((byte[])secretBytesEncrypted));
        bld.setEncryptedTicket(ticketAndKey.getEncryptedTicket());
        byte[] authRequestBytes = bld.build().toByteArray();
        authRequestBytes = Base64.encodeBase64((byte[])authRequestBytes);
        return authRequestBytes;
    }

    public static Security.TicketAndKey ticketReadingHelper() {
        String ticketFileLocation = JNISecurity.GetUserTicketAndKeyFileLocation();
        if (ticketFileLocation == null) {
            LOG.error("TicketKey file is not found");
            return null;
        }
        MutableInt err = new MutableInt();
        int errorCode = Security.SetTicketAndKeyFile(ticketFileLocation);
        if (errorCode != 0) {
            LOG.error("Problem with TicketKey file: " + errorCode);
            return null;
        }
        String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (currentClusterName == null) {
            LOG.error("Current cluster name is not found");
            return null;
        }
        Security.TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.ServerKey, currentClusterName, err);
        if (ticketAndKey == null) {
            LOG.error("MaprTicket is not found");
            return null;
        }
        if (!Security.IsTicketAndKeyUsable(ticketAndKey)) {
            LOG.error("My Mapr ticket is expired. Get new one");
            return null;
        }
        return ticketAndKey;
    }
}

