/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.security.JNISecurity;
import com.mapr.security.maprauth.MaprAuthenticator;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaprHttpURL {
    private static final Logger LOG = LoggerFactory.getLogger(MaprHttpURL.class);
    private static AuthenticatedURL.Token token = new AuthenticatedURL.Token();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpURLConnection openConnection(URL url) throws IOException {
        if (JNISecurity.IsSecurityEnabled(CLDBRpcCommonUtils.getInstance().getCurrentClusterName())) {
            Class<MaprHttpURL> clazz = MaprHttpURL.class;
            synchronized (MaprHttpURL.class) {
                HttpURLConnection conn = null;
                if (token.isSet()) {
                    conn = (HttpURLConnection)url.openConnection();
                    AuthenticatedURL.injectToken((HttpURLConnection)conn, (AuthenticatedURL.Token)token);
                    conn.connect();
                    if (conn.getResponseCode() == 401) {
                        token = new AuthenticatedURL.Token();
                        LOG.debug("Received HTTP " + conn.getResponseCode() + ". Created a new token.");
                    } else {
                        LOG.debug("Received HTTP " + conn.getResponseCode() + ". Token still good..");
                    }
                }
                if (!token.isSet()) {
                    LOG.debug("Token not set. Peforming authentication..");
                    AuthenticatedURL authenticatedURL = new AuthenticatedURL((Authenticator)new MaprAuthenticator());
                    try {
                        conn = authenticatedURL.openConnection(url, token);
                    }
                    catch (AuthenticationException e) {
                        LOG.error("Authentication failed while connecting to URL: " + url.toString());
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return conn;
            }
        }
        return (HttpURLConnection)url.openConnection();
    }
}

