/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.threadpool.TimeStampedRunnableTask;
import com.mapr.fs.RpcCallContext;
import com.mapr.fs.RpcExport;
import com.mapr.fs.RpcProgram;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.ThreadPoolFinder;
import com.mapr.fs.jni.RpcNative;
import com.mapr.fs.proto.Security;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rpc
extends RpcNative {
    private static final Logger LOG = LoggerFactory.getLogger(Rpc.class);
    public static int MAX_RPC_THREADS_PER_INSTANCE = 4;
    private static RpcInstance[] rpcInstanceHolder;

    public static int initialize(int port, int numThreads, String clusterName) throws Exception {
        return Rpc.initialize(port, numThreads, clusterName, null, null);
    }

    public static int initialize(int listenPort, int numThreads, String clusterName, RpcExport[] rpcPrograms, ThreadPoolFinder poolFinder) throws Exception {
        return Rpc.initializeRpcServer(null, listenPort, numThreads, clusterName, rpcPrograms, poolFinder, 0);
    }

    public static int initializeRpcServer(String processName, int listenPort, int numThreads, String clusterName, RpcExport[] rpcPrograms, ThreadPoolFinder poolFinder, int serverIdx) throws Exception {
        RpcInstance ri;
        int port;
        if (serverIdx >= MAX_RPC_THREADS_PER_INSTANCE) {
            return -1;
        }
        if (rpcInstanceHolder[serverIdx] != null) {
            return rpcInstanceHolder[serverIdx].getPort();
        }
        if (rpcPrograms != null) {
            int[] programIds = new int[rpcPrograms.length];
            for (int i = 0; i < rpcPrograms.length; ++i) {
                programIds[i] = rpcPrograms[i].getProgramId();
            }
            port = Rpc.initAndExportServer(processName, serverIdx, listenPort, clusterName, programIds);
        } else {
            port = Rpc.initAndExportServer(processName, serverIdx, listenPort, clusterName, null);
        }
        if (port < 0) {
            return port;
        }
        Rpc.rpcInstanceHolder[serverIdx] = ri = new RpcInstance(serverIdx, port, rpcPrograms, poolFinder);
        return port;
    }

    static RpcProgram findProgram(int programId) {
        return Rpc.findProgram(programId, 0);
    }

    static RpcProgram findProgram(int programId, int serverIdx) {
        RpcInstance ri = rpcInstanceHolder[serverIdx];
        if (ri == null) {
            return null;
        }
        return ri.findProgram(programId);
    }

    public static byte[] sendRequest(long binding, int programId, int procedureId, MessageLite request) throws Exception {
        byte[] serializedReq = request.toByteArray();
        return Rpc.sendRequest(binding, programId, procedureId, serializedReq);
    }

    public static void exportProgram(int programId, RpcProgram program) throws Exception {
        Rpc.exportProgram(programId, program, 0);
    }

    public static void exportProgram(int programId, RpcProgram program, int serverIdx) throws Exception {
        RpcInstance ri = rpcInstanceHolder[serverIdx];
        if (ri == null) {
            return;
        }
        ri.exportProgram(programId, program);
    }

    public static void sendReply(RpcCallContext c, MessageLite reply) throws Exception {
        c.reply = reply.toByteArray();
        Rpc.sendReplyAsync(c.binding, c.context, c.reply, false);
    }

    public static void sendReplyAsync(RpcCallContext c, MessageLite reply) throws Exception {
        Rpc.sendReplyAsync(c, reply, false);
    }

    public static void sendReplyAsync(RpcCallContext c, MessageLite reply, boolean replyWithEBusy) throws Exception {
        c.reply = reply.toByteArray();
        Rpc.sendReplyAsync(c.binding, c.context, c.reply, replyWithEBusy);
    }

    public static void rejectCall(RpcCallContext c) throws Exception {
        Rpc.rejectCall(c.binding, c.context);
    }

    public static void closeBinding(RpcCallContext c) throws Exception {
        Rpc.closeBinding(c.binding);
    }

    public static Security.Ticket getAuthenticatedTicket(RpcCallContext c) {
        byte[] ticket = Rpc.getTicketFromContext(c.binding);
        if (ticket == null) {
            return null;
        }
        try {
            return Security.Ticket.parseFrom((byte[])ticket);
        }
        catch (InvalidProtocolBufferException ibe) {
            ibe.printStackTrace();
            return null;
        }
    }

    public static int initializeGuts(long shmAddr) {
        return Rpc.initializeRpcGuts(shmAddr);
    }

    static {
        ShimLoader.load();
        rpcInstanceHolder = new RpcInstance[MAX_RPC_THREADS_PER_INSTANCE];
    }

    static class RpcListenerThread
    extends Thread {
        private int myServerIdx;
        private ThreadPoolFinder threadPoolFinder;
        private ExecutorService defaultThreadPool = null;

        public RpcListenerThread(int serverIdx) {
            this.myServerIdx = serverIdx;
        }

        public void setThreadPool(ExecutorService threadPool) {
            this.defaultThreadPool = threadPool;
        }

        public void setThreadPoolFinder(ThreadPoolFinder threadPoolFinder) {
            this.threadPoolFinder = threadPoolFinder;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        RpcCallContext rpcContext = new RpcCallContext();
                        byte[] req = Rpc.waitForRequest(rpcContext, this.myServerIdx);
                        RpcProgram rpcProgram = Rpc.findProgram(rpcContext.programId);
                        if (rpcProgram == null) continue;
                        ExecutorService pool = this.threadPoolFinder != null ? this.threadPoolFinder.getThreadPool(rpcContext) : this.defaultThreadPool;
                        pool.execute(new RpcExecutor(rpcProgram, rpcContext, req));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                catch (OutOfMemoryError oom) {
                    oom.printStackTrace();
                    System.exit(0);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(0);
                    continue;
                }
                break;
            }
        }
    }

    static class RpcExecutor
    implements TimeStampedRunnableTask {
        private RpcProgram prog;
        private RpcCallContext ctx;
        private byte[] req;

        RpcExecutor(RpcProgram p, RpcCallContext c, byte[] r) {
            this.prog = p;
            this.ctx = c;
            this.req = r;
            this.ctx.arrTime = System.currentTimeMillis();
        }

        @Override
        public long arrTime() {
            return this.ctx.arrTime;
        }

        @Override
        public void run() {
            this.prog.requestArrived(this.ctx, this.req);
        }
    }

    private static class RpcInstance {
        private int myServerIdx;
        private RpcExport[] programTable;
        private int port;

        public RpcInstance(int serverIdx, int port, RpcExport[] rpcPrograms, ThreadPoolFinder poolFinder) {
            this.myServerIdx = serverIdx;
            this.port = port;
            if (rpcPrograms != null) {
                this.programTable = new RpcExport[rpcPrograms.length + 4];
                for (int i = 0; i < rpcPrograms.length; ++i) {
                    this.programTable[i] = new RpcExport(rpcPrograms[i].getProgramId(), rpcPrograms[i].getProgram());
                }
            } else {
                this.programTable = new RpcExport[4];
            }
            RpcListenerThread t = new RpcListenerThread(serverIdx);
            t.setDaemon(true);
            if (poolFinder == null) {
                t.setThreadPool(Executors.newCachedThreadPool());
            } else {
                t.setThreadPoolFinder(poolFinder);
            }
            t.start();
        }

        int getPort() {
            return this.port;
        }

        RpcProgram findProgram(int programId) {
            for (RpcExport p : this.programTable) {
                if (p == null) {
                    return null;
                }
                if (p.programId != programId) continue;
                return p.program;
            }
            return null;
        }

        void exportProgram(int programId, RpcProgram program) throws Exception {
            for (int i = 0; i < this.programTable.length; ++i) {
                if (this.programTable[i] != null) continue;
                this.programTable[i] = new RpcExport(programId, program);
                break;
            }
            Rpc.registerProgramId(programId, this.myServerIdx);
        }
    }
}

