/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.acls;

import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SecurityCommandHelper {
    public static int CLUSTER_FULL_CONTROL_MASK = 1 << CLDBProto.ClusterActions.CLUSTER_FULL_CONTROL.getNumber();
    public static int CLUSTER_ADMIN_MASK = 1 << CLDBProto.ClusterActions.CLUSTER_ADMIN.getNumber();
    public static int CLUSTER_VOLUME_CREATE_MASK = 1 << CLDBProto.ClusterActions.CLUSTER_CREATE_VOLUMES.getNumber() | CLUSTER_FULL_CONTROL_MASK;
    public static int CLUSTER_READ_MASK = 1 << CLDBProto.ClusterActions.CLUSTER_READ_ONLY.getNumber() | 1 << CLDBProto.ClusterActions.CLUSTER_CREATE_VOLUMES.getNumber() | 1 << CLDBProto.ClusterActions.CLUSTER_START_STOP_SERVICES.getNumber() | CLUSTER_FULL_CONTROL_MASK;
    public static int CLUSTER_EDIT_CONFIGURATION_MASK = CLUSTER_FULL_CONTROL_MASK;
    public static int CLUSTER_EDIT_ACL_MASK = 1 << CLDBProto.ClusterActions.CLUSTER_ADMIN.getNumber();
    public static int CLUSTER_VIEW_QUOTAS_MASK = CLUSTER_READ_MASK;
    public static int CLUSTER_SET_QUOTAS_MASK = CLUSTER_FULL_CONTROL_MASK;
    public static int CLUSTER_START_STOP_SERVICES_MASK = 1 << CLDBProto.ClusterActions.CLUSTER_START_STOP_SERVICES.getNumber() | CLUSTER_FULL_CONTROL_MASK;
    public static int VOLUME_FULL_CONTROL_MASK = 1 << Common.VolumeActions.VOLUME_FULL_CONTROL.getNumber();
    public static int VOLUME_ADMIN_MASK = 1 << Common.VolumeActions.VOLUME_ADMIN.getNumber();
    public static int VOLUME_CONTAINER_CREATE_DELETE_MASK = 1 << Common.VolumeActions.VOLUME_EDIT_CONFIGURATION.getNumber() | 1 << Common.VolumeActions.VOLUME_CAN_MIRROR.getNumber() | VOLUME_FULL_CONTROL_MASK;
    public static int VOLUME_DELETE_MASK = 1 << Common.VolumeActions.VOLUME_DELETE.getNumber() | VOLUME_FULL_CONTROL_MASK;
    public static int VOLUME_SNAPSHOT_CREATE_DELETE_MASK = 1 << Common.VolumeActions.VOLUME_EDIT_CONFIGURATION.getNumber() | VOLUME_FULL_CONTROL_MASK;
    public static int VOLUME_VIEW_CONFIGURATION_MASK = CLUSTER_READ_MASK | VOLUME_FULL_CONTROL_MASK;
    public static int VOLUME_EDIT_CONFIGURATION_MASK = 1 << Common.VolumeActions.VOLUME_EDIT_CONFIGURATION.getNumber() | VOLUME_FULL_CONTROL_MASK;
    public static int VOLUME_EDIT_SNAPSHOT_INTERVAL_MASK = VOLUME_SNAPSHOT_CREATE_DELETE_MASK | VOLUME_FULL_CONTROL_MASK;
    public static int VOLUME_EDIT_ACL_MASK = VOLUME_ADMIN_MASK;
    public static int VOLUME_VIEW_CONTAINERS_MAP_MASK = 1 << Common.VolumeActions.VOLUME_CAN_DUMP.getNumber() | 1 << Common.VolumeActions.VOLUME_CAN_MIRROR.getNumber() | VOLUME_FULL_CONTROL_MASK;
    public static int VOLUME_DUMP_MASK = 1 << Common.VolumeActions.VOLUME_CAN_DUMP.getNumber() | VOLUME_FULL_CONTROL_MASK;
    public static int VOLUME_RESTORE_MASK = 1 << Common.VolumeActions.VOLUME_CAN_MIRROR.getNumber() | VOLUME_FULL_CONTROL_MASK;
    public static int VOLUME_TIER_OP_MASK = 1 << Common.VolumeActions.VOLUME_EDIT_CONFIGURATION.getNumber() | VOLUME_FULL_CONTROL_MASK;
    public static final String ClusterPerms = "[login, ss, cv, a, fc]";
    public static final String VolumePerms = "[dump, restore, m, d, a, fc]";
    public static final String[] clusterActionsDescription = new String[]{"login", "Login access", null, null, null, null, null, null, "ss", "Start/stop services in the cluster", "cv", "Create volumes", "a", "Administrator", "fc", "Full control", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    public static final String[] volumeActionsDescription = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, "dump", "Dump/backup the volume", "restore", "Mirror/Restore the volume", "m", "Edit volume configuration", "a", "Administrator", null, null, null, null, "d", "Delete the volume", null, null, null, null, null, null, "fc", "Full control", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};

    public static List<String> formatActionMask(int actionMask, CLDBProto.SecureObjectType objType, boolean shortFormat) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < 32; ++i) {
            String actionDesc;
            int mask = 1 << i;
            if ((actionMask & mask) != mask || (actionDesc = SecurityCommandHelper.getActionDescription(objType, i, shortFormat)) == null) continue;
            result.add(actionDesc);
        }
        return result;
    }

    static String getActionDescription(CLDBProto.SecureObjectType objType, int index, boolean shortFormat) {
        int i = index * 2;
        if (!shortFormat) {
            ++i;
        }
        if (objType == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER) {
            return clusterActionsDescription[i];
        }
        if (objType == CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME) {
            return volumeActionsDescription[i];
        }
        return null;
    }

    public static int convertActionsToMask(String actions, String separator, CLDBProto.SecureObjectType oType) throws Exception {
        int mask = 0;
        List<String> aList = Arrays.asList(actions.split(separator));
        for (String action : aList) {
            if (oType.getNumber() == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER.getNumber()) {
                if (action.equalsIgnoreCase("login")) {
                    mask |= 1 << CLDBProto.ClusterActions.CLUSTER_READ_ONLY.getNumber();
                    continue;
                }
                if (action.equalsIgnoreCase("ss")) {
                    mask |= 1 << CLDBProto.ClusterActions.CLUSTER_START_STOP_SERVICES.getNumber();
                    mask |= 1 << CLDBProto.ClusterActions.CLUSTER_READ_ONLY.getNumber();
                    continue;
                }
                if (action.equalsIgnoreCase("cv")) {
                    mask |= 1 << CLDBProto.ClusterActions.CLUSTER_CREATE_VOLUMES.getNumber();
                    mask |= 1 << CLDBProto.ClusterActions.CLUSTER_READ_ONLY.getNumber();
                    continue;
                }
                if (action.equalsIgnoreCase("a")) {
                    mask |= 1 << CLDBProto.ClusterActions.CLUSTER_ADMIN.getNumber();
                    continue;
                }
                if (action.equalsIgnoreCase("fc")) {
                    mask |= 1 << CLDBProto.ClusterActions.CLUSTER_READ_ONLY.getNumber();
                    mask |= 1 << CLDBProto.ClusterActions.CLUSTER_START_STOP_SERVICES.getNumber();
                    mask |= 1 << CLDBProto.ClusterActions.CLUSTER_CREATE_VOLUMES.getNumber();
                    mask |= 1 << CLDBProto.ClusterActions.CLUSTER_FULL_CONTROL.getNumber();
                    continue;
                }
                throw new Exception("unknown action: '" + action + "': valid cluster actions are: " + ClusterPerms);
            }
            if (action.equalsIgnoreCase("dump")) {
                mask |= 1 << Common.VolumeActions.VOLUME_CAN_DUMP.getNumber();
                continue;
            }
            if (action.equalsIgnoreCase("restore")) {
                mask |= 1 << Common.VolumeActions.VOLUME_CAN_MIRROR.getNumber();
                continue;
            }
            if (action.equalsIgnoreCase("m")) {
                mask |= 1 << Common.VolumeActions.VOLUME_EDIT_CONFIGURATION.getNumber();
                continue;
            }
            if (action.equalsIgnoreCase("d")) {
                mask |= 1 << Common.VolumeActions.VOLUME_DELETE.getNumber();
                continue;
            }
            if (action.equalsIgnoreCase("a")) {
                mask |= 1 << Common.VolumeActions.VOLUME_ADMIN.getNumber();
                continue;
            }
            if (action.equalsIgnoreCase("fc")) {
                mask |= 1 << Common.VolumeActions.VOLUME_CAN_DUMP.getNumber();
                mask |= 1 << Common.VolumeActions.VOLUME_CAN_MIRROR.getNumber();
                mask |= 1 << Common.VolumeActions.VOLUME_EDIT_CONFIGURATION.getNumber();
                mask |= 1 << Common.VolumeActions.VOLUME_DELETE.getNumber();
                mask |= 1 << Common.VolumeActions.VOLUME_FULL_CONTROL.getNumber();
                continue;
            }
            throw new Exception("unknown action: '" + action + "': valid volume actions are: " + VolumePerms);
        }
        return mask;
    }
}

