/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.threadpool.TimeStampedRunnableTask;
import com.mapr.fs.RpcCallContext;
import com.mapr.fs.RpcExport;
import com.mapr.fs.RpcProgram;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.ThreadPoolFinder;
import com.mapr.fs.jni.RpcNative;
import com.mapr.fs.proto.Security;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Rpc
extends RpcNative {
    private static RpcExport[] programTable;
    private static int port_;
    private static ThreadPoolFinder threadPoolFinder;

    public static int initialize(int port, int numThreads, String clusterName) throws Exception {
        return Rpc.initialize(port, numThreads, clusterName, null, null);
    }

    public static int initialize(int port, int numThreads, String clusterName, RpcExport[] rpcPrograms, ThreadPoolFinder poolFinder) throws Exception {
        if (programTable == null) {
            int numPrograms = 0;
            if (rpcPrograms == null) {
                port_ = Rpc.init(port, clusterName);
            } else {
                numPrograms = rpcPrograms.length;
                int[] programIds = new int[numPrograms];
                for (int i = 0; i < numPrograms; ++i) {
                    programIds[i] = rpcPrograms[i].getProgramId();
                }
                port_ = Rpc.initAndExport(port, clusterName, programIds);
            }
            if (port_ < 0) {
                return port_;
            }
            programTable = new RpcExport[numPrograms + 4];
            if (rpcPrograms != null) {
                int i = 0;
                for (RpcExport e : rpcPrograms) {
                    Rpc.programTable[i] = new RpcExport(e.getProgramId(), e.getProgram());
                    ++i;
                }
            }
            ExecutorService threadPool = null;
            if (poolFinder == null) {
                threadPool = Executors.newCachedThreadPool();
            } else {
                Rpc.setThreadPoolFinder(poolFinder);
            }
            RpcListenerThread t = new RpcListenerThread();
            t.setThreadPool(threadPool);
            t.setDaemon(true);
            t.start();
        }
        return port_;
    }

    public static void setThreadPoolFinder(ThreadPoolFinder finder) {
        threadPoolFinder = finder;
    }

    static RpcProgram findProgram(int programId) {
        for (RpcExport p : programTable) {
            if (p == null) {
                return null;
            }
            if (p.programId != programId) continue;
            return p.program;
        }
        return null;
    }

    public static byte[] sendRequest(long binding, int programId, int procedureId, MessageLite request) throws Exception {
        byte[] serializedReq = request.toByteArray();
        return Rpc.sendRequest(binding, programId, procedureId, serializedReq);
    }

    public static void exportProgram(int programId, RpcProgram program) throws Exception {
        for (int i = 0; i < programTable.length; ++i) {
            if (programTable[i] != null) continue;
            Rpc.programTable[i] = new RpcExport(programId, program);
            break;
        }
        Rpc.registerProgramId(programId);
    }

    public static void sendReply(RpcCallContext c, MessageLite reply) throws Exception {
        byte[] serReply = reply.toByteArray();
        Rpc.sendReply(c.binding, c.context, serReply);
    }

    public static void rejectCall(RpcCallContext c) throws Exception {
        Rpc.rejectCall(c.binding, c.context);
    }

    public static void closeBinding(RpcCallContext c) throws Exception {
        Rpc.closeBinding(c.binding);
    }

    public static Security.Ticket getAuthenticatedTicket(RpcCallContext c) {
        byte[] ticket = Rpc.getTicketFromContext(c.binding);
        if (ticket == null) {
            return null;
        }
        try {
            return Security.Ticket.parseFrom((byte[])ticket);
        }
        catch (InvalidProtocolBufferException ibe) {
            ibe.printStackTrace();
            return null;
        }
    }

    static {
        ShimLoader.load();
    }

    static class RpcListenerThread
    extends Thread {
        private ExecutorService threadPool;

        RpcListenerThread() {
        }

        public void setThreadPool(ExecutorService threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        RpcCallContext rpcContext = new RpcCallContext();
                        byte[] req = Rpc.waitForRequest(rpcContext);
                        RpcProgram rpcProgram = Rpc.findProgram(rpcContext.programId);
                        if (rpcProgram == null) continue;
                        RpcExecutor task = new RpcExecutor(rpcProgram, rpcContext, req);
                        ExecutorService pool = this.threadPool;
                        if (threadPoolFinder != null) {
                            pool = threadPoolFinder.getThreadPool(rpcContext);
                        }
                        pool.execute(task);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                catch (OutOfMemoryError oom) {
                    oom.printStackTrace();
                    System.exit(0);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(0);
                    continue;
                }
                break;
            }
        }
    }

    static class RpcExecutor
    implements TimeStampedRunnableTask {
        private RpcProgram prog;
        private RpcCallContext ctx;
        private byte[] req;

        RpcExecutor(RpcProgram p, RpcCallContext c, byte[] r) {
            this.prog = p;
            this.ctx = c;
            this.req = r;
            this.ctx.arrTime = System.currentTimeMillis();
        }

        @Override
        public long arrTime() {
            return this.ctx.arrTime;
        }

        @Override
        public void run() {
            this.prog.requestArrived(this.ctx, this.req);
        }
    }
}

