/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.UnixUserGroupHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.List;

public class Security {
    private static int KeySizeInBytes;
    public static long MAX_EXPIRY_TIME;

    private Security() {
    }

    public static Security.Key GenerateRandomKey() {
        Security.Key.Builder key = Security.Key.newBuilder();
        byte[] keyBuf = new byte[KeySizeInBytes];
        JNISecurity.GenerateRandomBlock(keyBuf);
        key.setKey(ByteString.copyFrom((byte[])keyBuf));
        return key.build();
    }

    public static byte[] Encrypt(Security.Key key, byte[] inBuf, MutableInt erri) {
        JNISecurity.MutableErr err = new JNISecurity.MutableErr();
        byte[] encrypted = JNISecurity.Encrypt(key.getKey().toByteArray(), inBuf, err);
        if (err.GetValue() != 0) {
            erri.SetValue(err.GetValue());
        }
        return encrypted;
    }

    public static byte[] Decrypt(Security.Key key, byte[] inBuf, MutableInt erri) {
        JNISecurity.MutableErr err = new JNISecurity.MutableErr();
        byte[] decrypted = JNISecurity.Decrypt(key.getKey().toByteArray(), inBuf, err);
        if (err.GetValue() != 0) {
            erri.SetValue(err.GetValue());
        }
        return decrypted;
    }

    public static byte[] EncodeDataForWritingToKeyFile(byte[] serializedProtobuf, MutableInt erri) {
        JNISecurity.MutableErr err = new JNISecurity.MutableErr();
        byte[] encoded = JNISecurity.EncodeDataForWritingToKeyFile(serializedProtobuf, err);
        if (err.GetValue() != 0) {
            erri.SetValue(err.GetValue());
        }
        return encoded;
    }

    public static byte[] DecodeDataFromKeyFile(byte[] encodedData, MutableInt erri) {
        JNISecurity.MutableErr err = new JNISecurity.MutableErr();
        byte[] decoded = JNISecurity.DecodeDataFromKeyFile(encodedData, err);
        if (err.GetValue() != 0) {
            erri.SetValue(err.GetValue());
        }
        return decoded;
    }

    public static int SetKeyFile(Security.ServerKeyType keyType, String path) {
        return JNISecurity.SetKeyFileInternal(keyType.getNumber(), path);
    }

    public static int SetKey(Security.ServerKeyType keyType, Security.Key key) {
        return JNISecurity.SetKeyInternal(keyType.getNumber(), key.getKey().toByteArray());
    }

    public static Security.Key GetKey(Security.ServerKeyType keyType, MutableInt erri) {
        JNISecurity.MutableErr err = new JNISecurity.MutableErr();
        byte[] keyBuf = JNISecurity.GetKeyInternal(keyType.getNumber(), err);
        if (keyBuf != null) {
            Security.Key.Builder key = Security.Key.newBuilder();
            key.setKey(ByteString.copyFrom((byte[])keyBuf));
            return key.build();
        }
        if (err.GetValue() != 0) {
            erri.SetValue(err.GetValue());
        }
        return null;
    }

    public static Security.TicketAndKey GenerateTicketAndKey(Security.ServerKeyType keyType, String userName, int uid, int[] gids, long expiryTime, long maxRenewalTimeSec, boolean isExternal, boolean canUserImpersonate, int[] ips, MutableInt erri) {
        JNISecurity.MutableErr err = new JNISecurity.MutableErr();
        byte[] serializedTicketAndKey = JNISecurity.GenerateTicketAndKeyInternal(keyType.getNumber(), userName, uid, gids, expiryTime, maxRenewalTimeSec, isExternal, canUserImpersonate, ips, err);
        if (serializedTicketAndKey != null) {
            try {
                return Security.TicketAndKey.parseFrom((byte[])serializedTicketAndKey);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (err.GetValue() != 0) {
            erri.SetValue(err.GetValue());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GenerateAndWriteTicketAndKey(String userName, long expiration, DataOutputStream outTicket) throws IOException {
        MutableInt mutableerr;
        int[] gids;
        UnixUserGroupHelper uugh = new UnixUserGroupHelper();
        int uid = uugh.getUserId(userName);
        Security.TicketAndKey ticketAndKey = Security.GenerateTicketAndKey(Security.ServerKeyType.ServerKey, userName, uid, gids = uugh.getGroups(userName), expiration / 1000L, 0L, true, false, null, mutableerr = new MutableInt());
        if (ticketAndKey != null && mutableerr.GetValue() == 0) {
            byte[] encodedticket = Security.EncodeDataForWritingToKeyFile(ticketAndKey.toByteArray(), mutableerr);
            if (mutableerr.GetValue() != 0 || encodedticket == null) {
                throw new IOException("Security Ticket for user: " + userName + " can not be encoded with error: " + mutableerr.GetValue());
            }
            try {
                String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
                outTicket.write(currentClusterName.getBytes("UTF-8"));
                outTicket.write(new String(" ").getBytes("UTF-8"));
                outTicket.write(encodedticket);
                outTicket.write(new String("\n").getBytes("UTF-8"));
            }
            finally {
                outTicket.close();
            }
        } else {
            throw new IOException("Security Ticket for user: " + userName + " can not be generated with error: " + mutableerr.GetValue());
        }
    }

    public static void CloneAndGenerateTicketFile(DataInputStream fsin, long expiration, DataOutputStream outTicket) throws IOException {
        if (fsin == null) {
            throw new IOException("Security Ticket can not be cloned as DataInputStream is null");
        }
        Security.MergeAndGenerateTicketFile(fsin, null, expiration, outTicket, true);
    }

    public static void MergeAndGenerateTicketFile(DataInputStream fsin, String userName, long expiration, DataOutputStream outTicket) throws IOException {
        if (fsin == null) {
            Security.GenerateAndWriteTicketAndKey(userName, expiration, outTicket);
            return;
        }
        Security.MergeAndGenerateTicketFile(fsin, userName, expiration, outTicket, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void MergeAndGenerateTicketFile(DataInputStream fsin, String userName, long expiration, DataOutputStream outTicket, boolean cloneTicket) throws IOException {
        boolean isTicketGenerated = false;
        MutableInt err = new MutableInt();
        String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fsin, "UTF-8"));
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                String[] splits = line.split(" ");
                if (splits == null || splits.length < 2) continue;
                String cluster = splits[0];
                if (currentClusterName.equals(cluster)) {
                    int[] gids;
                    String encodedTicket = splits[1];
                    byte[] ticketBytes = Security.DecodeDataFromKeyFile(encodedTicket.getBytes(), err);
                    Security.TicketAndKey tk = Security.TicketAndKey.parseFrom((byte[])ticketBytes);
                    Security.TicketAndKey ticketAndKey = null;
                    MutableInt mutableerr = new MutableInt();
                    if (tk != null && err.GetValue() == 0 && tk.getUserCreds() != null) {
                        boolean canImpersonate = cloneTicket ? tk.getCanUserImpersonate() : false;
                        List gidList = tk.getUserCreds().getGidsList();
                        gids = new int[gidList.size()];
                        for (int i = 0; i < gidList.size(); ++i) {
                            gids[i] = (Integer)gidList.get(i);
                        }
                        ticketAndKey = Security.GenerateTicketAndKey(Security.ServerKeyType.ServerKey, tk.getUserCreds().getUserName(), tk.getUserCreds().getUid(), gids, expiration / 1000L, 0L, true, canImpersonate, null, mutableerr);
                    } else {
                        if (cloneTicket) {
                            throw new IOException("Security Ticket  can not be cloned as parameters to be cloned cannot be retreived from ticket");
                        }
                        UnixUserGroupHelper uugh = new UnixUserGroupHelper();
                        int uid = uugh.getUserId(userName);
                        gids = uugh.getGroups(userName);
                        ticketAndKey = Security.GenerateTicketAndKey(Security.ServerKeyType.ServerKey, userName, uid, gids, expiration / 1000L, 0L, true, false, null, mutableerr);
                    }
                    if (ticketAndKey != null && mutableerr.GetValue() == 0) {
                        byte[] encodedticket = Security.EncodeDataForWritingToKeyFile(ticketAndKey.toByteArray(), mutableerr);
                        if (mutableerr.GetValue() != 0 || encodedticket == null) {
                            throw new IOException("Security Ticket for user: " + userName + " can not be encoded with error: " + mutableerr.GetValue());
                        }
                        outTicket.write(currentClusterName.getBytes("UTF-8"));
                        outTicket.write(new String(" ").getBytes("UTF-8"));
                        outTicket.write(encodedticket);
                        outTicket.write(new String("\n").getBytes("UTF-8"));
                        isTicketGenerated = true;
                        continue;
                    }
                    throw new IOException("Security Ticket for user: " + userName + " can not be generated with error: " + mutableerr.GetValue());
                }
                outTicket.write(line.getBytes("UTF-8"));
                outTicket.write(new String("\n").getBytes("UTF-8"));
            }
            if (!isTicketGenerated && !cloneTicket) {
                Security.GenerateAndWriteTicketAndKey(userName, expiration, outTicket);
                return;
            }
        }
        finally {
            outTicket.close();
        }
    }

    public static Security.TicketAndKey GenerateTicketAndKeyUsingServerKey(Security.ServerKeyType keyType, Security.Key key, String userName, int uid, int[] gids, long expiryTime, long maxRenewalTimeSec, boolean isExternal, MutableInt erri) {
        JNISecurity.MutableErr err = new JNISecurity.MutableErr();
        byte[] serializedTicketAndKey = JNISecurity.GenerateTicketAndKeyUsingServerKeyInternal(keyType.getNumber(), key.getKey().toByteArray(), userName, uid, gids, expiryTime, maxRenewalTimeSec, isExternal, err);
        if (serializedTicketAndKey != null) {
            try {
                return Security.TicketAndKey.parseFrom((byte[])serializedTicketAndKey);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (err.GetValue() != 0) {
            erri.SetValue(err.GetValue());
        }
        return null;
    }

    public static Security.TicketAndKey RenewTicketAndKey(Security.ServerKeyType keyType, Security.TicketAndKey ticketAndKey, long expiryTime, MutableInt erri) {
        JNISecurity.MutableErr err = new JNISecurity.MutableErr();
        byte[] serializedInTicketAndKey = ticketAndKey.toByteArray();
        byte[] serializedTicketAndKey = JNISecurity.RenewTicketAndKeyInternal(keyType.getNumber(), serializedInTicketAndKey, expiryTime, err);
        if (serializedTicketAndKey != null) {
            try {
                return Security.TicketAndKey.parseFrom((byte[])serializedTicketAndKey);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (err.GetValue() != 0) {
            erri.SetValue(err.GetValue());
        }
        return null;
    }

    public static Security.Ticket DecryptTicket(byte[] encryptedTicket, MutableInt erri) {
        JNISecurity.MutableErr err = new JNISecurity.MutableErr();
        byte[] serializedTicket = JNISecurity.DecryptTicketInternal2(encryptedTicket, err, 0);
        if (serializedTicket != null) {
            try {
                return Security.Ticket.parseFrom((byte[])serializedTicket);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (err.GetValue() != 0) {
            erri.SetValue(err.GetValue());
        }
        return null;
    }

    public static int SetTicketAndKeyFile(String path) {
        return JNISecurity.SetTicketAndKeyFileInternal(path);
    }

    public static int SetTicketAndKey(Security.ServerKeyType keyType, String clusterName, Security.TicketAndKey ticketAndKey) {
        return JNISecurity.SetTicketAndKeyInternal(keyType.getNumber(), clusterName, ticketAndKey.toByteArray());
    }

    public static void UseClusterTicketAsServerTicket() {
        JNISecurity.UseClusterTicketAsServerTicketInternal();
    }

    public static Security.TicketAndKey GetTicketAndKeyForCluster(Security.ServerKeyType keyType, String clusterName, MutableInt erri) {
        JNISecurity.MutableErr err = new JNISecurity.MutableErr();
        byte[] serializedTicketAndKey = JNISecurity.GetTicketAndKeyForClusterInternal(keyType.getNumber(), clusterName, err);
        if (serializedTicketAndKey != null) {
            try {
                return Security.TicketAndKey.parseFrom((byte[])serializedTicketAndKey);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (err.GetValue() != 0) {
            erri.SetValue(err.GetValue());
        }
        return null;
    }

    public static Security.Key GetServerKey(Security.Key CldbKey, long time) {
        ByteBuffer bBuffer = ByteBuffer.allocate(KeySizeInBytes + 8);
        time = 0L;
        bBuffer.putLong(time);
        bBuffer.put(CldbKey.getKey().toByteArray());
        byte[] hash = JNISecurity.GetHash(0, bBuffer.array());
        Security.Key.Builder key = Security.Key.newBuilder();
        key.setKey(ByteString.copyFrom((byte[])hash));
        return key.build();
    }

    public static Security.Key GetClusterKey(Security.Key CldbKey, long time) {
        ByteBuffer bBuffer = ByteBuffer.allocate(KeySizeInBytes + 8);
        time = 97L;
        bBuffer.putLong(time);
        bBuffer.put(CldbKey.getKey().toByteArray());
        byte[] hash = JNISecurity.GetHash(0, bBuffer.array());
        Security.Key.Builder key = Security.Key.newBuilder();
        key.setKey(ByteString.copyFrom((byte[])hash));
        return key.build();
    }

    public static String ByteArrayToString(String preFix, byte[] bArray) {
        StringBuffer buf = new StringBuffer();
        buf.append(preFix + "\n");
        for (byte b : bArray) {
            buf.append(String.format("%02X", b));
        }
        return buf.toString();
    }

    public static String UserCredsToString(String prefix, Security.CredentialsMsg c) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix + "\n");
        buf.append("UserName " + c.getUserName() + "\n");
        buf.append("UID " + c.getUid() + "\n");
        buf.append("GIDS " + c.getGids(0) + "\n");
        return buf.toString();
    }

    public static String TicketAndKeyToString(String prefix, Security.TicketAndKey t) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix + "\n");
        buf.append(Security.ByteArrayToString("EncryptedTicket", t.getEncryptedTicket().toByteArray()) + "\n");
        buf.append(Security.UserCredsToString("UserCreds ", t.getUserCreds()) + "\n");
        buf.append(Security.ByteArrayToString("UserKey ", t.getUserKey().getKey().toByteArray()) + "\n");
        return buf.toString();
    }

    public static String TicketToString(String prefix, Security.Ticket t) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix + "\n");
        buf.append(Security.UserCredsToString("UserCreds ", t.getUserCreds()) + "\n");
        buf.append(Security.ByteArrayToString("UserKey ", t.getUserKey().getKey().toByteArray()) + "\n");
        return buf.toString();
    }

    public static Security.Ticket ValidateTicketAndKey(Security.TicketAndKey t, MutableInt err) {
        byte[] keyInTicket;
        Security.Ticket ticket = Security.DecryptTicket(t.getEncryptedTicket().toByteArray(), err);
        if (ticket == null) {
            err.SetValue(22);
            return null;
        }
        byte[] userKey = t.getUserKey().getKey().toByteArray();
        if (userKey.length != (keyInTicket = ticket.getUserKey().getKey().toByteArray()).length) {
            err.SetValue(22);
            return null;
        }
        for (int i = 0; i < userKey.length; ++i) {
            if (userKey[i] == keyInTicket[i]) continue;
            err.SetValue(22);
            return null;
        }
        return ticket;
    }

    public static boolean IsTicketAndKeyUsable(Security.TicketAndKey ticketAndKey) {
        if (ticketAndKey != null) {
            long expiryTimeSec;
            long currentTimeSec = System.currentTimeMillis() / 1000L;
            return currentTimeSec < (expiryTimeSec = ticketAndKey.getExpiryTime());
        }
        return false;
    }

    public static void BlacklistAndCloseConnections(int[] uids, long[] blacklistTimes, boolean reinitList) {
        if (uids == null || uids.length == 0) {
            System.out.println("Incorrect uids specified for blacklisting");
            return;
        }
        if (blacklistTimes == null || blacklistTimes.length == 0) {
            System.out.println("Incorrect uids specified for blacklisting");
            return;
        }
        if (uids.length != blacklistTimes.length) {
            System.out.println("Number of uids passed does not match number of blacklist times passed");
            return;
        }
        JNISecurity.BlacklistAndCloseConnections(uids, blacklistTimes, reinitList);
    }

    public static void RemoveFromBlacklist(int[] uids) {
        if (uids == null || uids.length == 0) {
            System.out.println("No uids to be cleaned up from blacklist");
            return;
        }
        JNISecurity.RemoveFromBlacklist(uids);
    }

    public static void TestSecurity() {
        try {
            MutableInt err = new MutableInt();
            Security.Key k = Security.GenerateRandomKey();
            byte[] fileData = Security.EncodeDataForWritingToKeyFile(k.toByteArray(), err);
            FileOutputStream fout = new FileOutputStream("/tmp/key-file");
            fout.write(fileData);
            fout.write(new String("\n").getBytes("UTF-8"));
            fout.close();
            System.out.println(Security.ByteArrayToString("Key", k.getKey().toByteArray()));
            Security.SetKeyFile(Security.ServerKeyType.CldbKey, "/tmp/key-file");
            int[] gids = new int[]{0};
            Security.TicketAndKey ticketAndKey = Security.GenerateTicketAndKey(Security.ServerKeyType.CldbKey, "root", 0, gids, MAX_EXPIRY_TIME, 0L, true, false, null, err);
            fileData = Security.EncodeDataForWritingToKeyFile(ticketAndKey.toByteArray(), err);
            String clusterName = "default ";
            fout = new FileOutputStream("/tmp/ticket-file");
            fout.write(clusterName.getBytes("UTF-8"));
            fout.write(fileData);
            fout.write(new String("\n").getBytes("UTF-8"));
            fout.close();
            Security.SetTicketAndKeyFile("/tmp/ticket-file");
            System.out.println("Calling GetTicketAndKeyForCluster");
            Security.Key cldbKey = Security.GetKey(Security.ServerKeyType.CldbKey, err);
            Security.Key serverKey = Security.GetServerKey(cldbKey, System.currentTimeMillis());
            System.out.println(Security.ByteArrayToString("CLDB Key", cldbKey.getKey().toByteArray()));
            System.out.println(Security.ByteArrayToString("Server Key", serverKey.getKey().toByteArray()));
            Security.Ticket t = Security.ValidateTicketAndKey(ticketAndKey, err);
            System.out.println(Security.TicketToString(" Anurag - Validated Ticket ", t));
            Security.TicketAndKey ticketAndKey2 = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.CldbKey, "default", err);
            System.out.println(Security.TicketAndKeyToString("default", ticketAndKey2));
            System.out.println("\n");
            Security.Ticket ticket = Security.DecryptTicket(ticketAndKey2.getEncryptedTicket().toByteArray(), err);
            System.out.println(Security.TicketToString("Ticket ", ticket));
            System.out.println("\n");
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
        }
    }

    public static void main(String[] args) {
        System.out.println("Hello, World");
        Security.TestSecurity();
    }

    static {
        ShimLoader.load();
        KeySizeInBytes = 32;
        MAX_EXPIRY_TIME = 922337203685477L;
    }
}

