/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.security;

import com.mapr.baseutils.BaseUtilTests;
import com.mapr.fs.proto.Security;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class SecurityTests
extends BaseUtilTests {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        MutableInt err = new MutableInt();
        Security.Key k = Security.GenerateRandomKey();
        byte[] fileData = Security.EncodeDataForWritingToKeyFile((byte[])k.toByteArray(), (MutableInt)err);
        FileOutputStream fout = new FileOutputStream("/tmp/key-file");
        fout.write(fileData);
        fout.write(new String("\n").getBytes("UTF-8"));
        fout.close();
        System.out.println(Security.ByteArrayToString((String)"Key", (byte[])k.getKey().toByteArray()));
        Security.SetKeyFile((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)"/tmp/key-file");
        int[] gids = new int[]{0};
        Security.TicketAndKey ticketAndKey = Security.GenerateTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)"root", (int)0, (int[])gids, (long)Security.MAX_EXPIRY_TIME, (long)0L, (boolean)true, (boolean)false, null, (MutableInt)err);
        fileData = Security.EncodeDataForWritingToKeyFile((byte[])ticketAndKey.toByteArray(), (MutableInt)err);
        String clusterName = "default ";
        fout = new FileOutputStream("/tmp/ticket-file");
        fout.write(clusterName.getBytes("UTF-8"));
        fout.write(fileData);
        fout.write(new String("\n").getBytes("UTF-8"));
        fout.close();
        Security.SetTicketAndKeyFile((String)"/tmp/ticket-file");
        System.out.println("Calling GetTicketAndKeyForCluster");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        File delTicketFile;
        File delFile = new File("/tmp/key-file");
        if (delFile.canWrite()) {
            delFile.delete();
        }
        if ((delTicketFile = new File("/tmp/ticket-file")).canWrite()) {
            delTicketFile.delete();
        }
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27468")
    public void testMergeTicket() throws Exception {
        String line;
        DataOutputStream dout = new DataOutputStream(new FileOutputStream(new File("/tmp/repro-ticket")));
        Security.MergeAndGenerateTicketFile(null, (String)"root", (long)30000L, (DataOutputStream)dout);
        Assert.assertNotNull((Object)dout);
        dout.close();
        File ticketFile = new File("/tmp/repro-ticket");
        Assert.assertNotNull((Object)ticketFile);
        Assert.assertTrue((boolean)ticketFile.canRead());
        BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ticketFile), "UTF-8"));
        boolean readLine = false;
        MutableInt err = new MutableInt();
        while ((line = fis.readLine()) != null) {
            Assert.assertFalse((boolean)readLine);
            String[] lines = line.split(" ");
            Assert.assertNotNull((Object)lines);
            Assert.assertEquals((long)lines.length, (long)2L);
            Assert.assertEquals((Object)"default", (Object)lines[0]);
            byte[] ticketBytes = Security.DecodeDataFromKeyFile((byte[])lines[1].getBytes(), (MutableInt)err);
            Assert.assertTrue((err.GetValue() == 0 ? 1 : 0) != 0);
            Security.TicketAndKey tk = Security.TicketAndKey.parseFrom((byte[])ticketBytes);
            Assert.assertTrue((boolean)tk.getUserCreds().getUserName().equals("root"));
            Assert.assertEquals((long)tk.getExpiryTime(), (long)30L);
            readLine = true;
        }
        fis.close();
        ticketFile.delete();
        dout = new DataOutputStream(new FileOutputStream(new File("/tmp/repro-ticket")));
        DataInputStream dis = new DataInputStream(new FileInputStream("/tmp/ticket-file"));
        Security.MergeAndGenerateTicketFile((DataInputStream)dis, (String)"root", (long)30000L, (DataOutputStream)dout);
        ticketFile = new File("/tmp/repro-ticket");
        Assert.assertNotNull((Object)ticketFile);
        Assert.assertTrue((boolean)ticketFile.canRead());
        dout.close();
        readLine = false;
        fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/tmp/repro-ticket"), "UTF-8"));
        while ((line = fis.readLine()) != null) {
            Assert.assertFalse((boolean)readLine);
            String[] lines = line.split(" ");
            Assert.assertNotNull((Object)lines);
            Assert.assertEquals((long)lines.length, (long)2L);
            Assert.assertTrue((boolean)lines[0].equals("default"));
            byte[] ticketBytes = Security.DecodeDataFromKeyFile((byte[])lines[1].getBytes(), (MutableInt)err);
            Assert.assertTrue((err.GetValue() == 0 ? 1 : 0) != 0);
            Security.TicketAndKey tk = Security.TicketAndKey.parseFrom((byte[])ticketBytes);
            Assert.assertTrue((boolean)tk.getUserCreds().getUserName().equals("root"));
            Assert.assertEquals((long)tk.getExpiryTime(), (long)30L);
            readLine = true;
        }
        dis.close();
        ticketFile.delete();
    }

    @Test
    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27468")
    public void testMergeTicket2() throws Exception {
        String line;
        MutableInt err = new MutableInt();
        int[] gids = new int[]{0};
        Security.TicketAndKey ticketAndKey = Security.GenerateTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)"root", (int)0, (int[])gids, (long)Security.MAX_EXPIRY_TIME, (long)0L, (boolean)true, (boolean)false, null, (MutableInt)err);
        byte[] fileData = Security.EncodeDataForWritingToKeyFile((byte[])ticketAndKey.toByteArray(), (MutableInt)err);
        String clusterName = "default ";
        File tempTicket = new File("/tmp/ticket-file2");
        FileOutputStream fout = new FileOutputStream("/tmp/ticket-file2");
        fout.write(clusterName.getBytes("UTF-8"));
        fout.write(fileData);
        fout.write(new String("\n").getBytes("UTF-8"));
        fout.write("cluster1 ".getBytes("UTF-8"));
        fout.write(fileData);
        fout.write(new String("\n").getBytes("UTF-8"));
        fout.close();
        Security.SetTicketAndKeyFile((String)"/tmp/ticket-file2");
        DataInputStream dis = new DataInputStream(new FileInputStream("/tmp/ticket-file2"));
        DataOutputStream dout = new DataOutputStream(new FileOutputStream(new File("/tmp/repro-ticket")));
        Security.MergeAndGenerateTicketFile((DataInputStream)dis, (String)"root", (long)30000L, (DataOutputStream)dout);
        Assert.assertNotNull((Object)dout);
        dout.close();
        dis.close();
        File ticketFile = new File("/tmp/repro-ticket");
        Assert.assertNotNull((Object)ticketFile);
        Assert.assertTrue((boolean)ticketFile.canRead());
        BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ticketFile), "UTF-8"));
        int linesCount = 0;
        while ((line = fis.readLine()) != null) {
            Security.TicketAndKey tk;
            byte[] ticketBytes;
            String[] lines = line.split(" ");
            Assert.assertNotNull((Object)lines);
            Assert.assertEquals((long)lines.length, (long)2L);
            if (++linesCount == 1) {
                Assert.assertEquals((Object)"default", (Object)lines[0]);
                ticketBytes = Security.DecodeDataFromKeyFile((byte[])lines[1].getBytes(), (MutableInt)err);
                Assert.assertTrue((err.GetValue() == 0 ? 1 : 0) != 0);
                tk = Security.TicketAndKey.parseFrom((byte[])ticketBytes);
                Assert.assertEquals((Object)"root", (Object)tk.getUserCreds().getUserName());
                Assert.assertEquals((long)30L, (long)tk.getExpiryTime());
            }
            if (linesCount != 2) continue;
            Assert.assertTrue((boolean)lines[0].equals("cluster1"));
            ticketBytes = Security.DecodeDataFromKeyFile((byte[])lines[1].getBytes(), (MutableInt)err);
            Assert.assertTrue((err.GetValue() == 0 ? 1 : 0) != 0);
            tk = Security.TicketAndKey.parseFrom((byte[])ticketBytes);
            Assert.assertTrue((boolean)tk.getUserCreds().getUserName().equals("root"));
            Assert.assertEquals((long)tk.getExpiryTime(), (long)Security.MAX_EXPIRY_TIME);
        }
        Assert.assertEquals((long)linesCount, (long)2L);
        fis.close();
        ticketFile.delete();
        tempTicket.delete();
    }

    @Test
    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27468")
    public void testMergeTicket3() throws Exception {
        String line;
        File ticketFile = new File("/tmp/ticket-file3");
        ticketFile.createNewFile();
        DataInputStream dis = new DataInputStream(new FileInputStream("/tmp/ticket-file3"));
        File ticketReproFile = new File("/tmp/repro-ticket");
        DataOutputStream dout = new DataOutputStream(new FileOutputStream(new File("/tmp/repro-ticket")));
        Security.MergeAndGenerateTicketFile((DataInputStream)dis, (String)"root", (long)30000L, (DataOutputStream)dout);
        Assert.assertNotNull((Object)dout);
        dout.close();
        dis.close();
        boolean readLine = false;
        MutableInt err = new MutableInt();
        BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/tmp/repro-ticket"), "UTF-8"));
        while ((line = fis.readLine()) != null) {
            Assert.assertFalse((boolean)readLine);
            String[] lines = line.split(" ");
            Assert.assertNotNull((Object)lines);
            Assert.assertEquals((long)lines.length, (long)2L);
            Assert.assertEquals((Object)"default", (Object)lines[0]);
            byte[] ticketBytes = Security.DecodeDataFromKeyFile((byte[])lines[1].getBytes(), (MutableInt)err);
            Assert.assertTrue((err.GetValue() == 0 ? 1 : 0) != 0);
            Security.TicketAndKey tk = Security.TicketAndKey.parseFrom((byte[])ticketBytes);
            Assert.assertTrue((boolean)tk.getUserCreds().getUserName().equals("root"));
            Assert.assertEquals((long)tk.getExpiryTime(), (long)30L);
            readLine = true;
        }
        fis.close();
        ticketFile.delete();
        ticketReproFile.delete();
    }
}

