/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.login;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.proto.Security;
import com.mapr.login.MapRLoginException;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.login.common.GenTicketTypeRequest;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import com.mapr.security.UnixUserGroupHelper;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class MapRLogin {
    private static final Logger LOG = Logger.getLogger(MapRLogin.class);
    private static final String PASSWORD = "password";
    private static final String PASSWORD_HELP = "authenticate to a mapr cluster using a valid password";
    private static final String KERBEROS = "kerberos";
    private static final String KERBEROS_HELP = "authenticate to a mapr cluster using kerberos";
    private static final String RENEW = "renew";
    private static final String RENEW_HELP = "renew existing credentials for a mapr cluster";
    private static final String PRINT = "print";
    private static final String PRINT_HELP = "print information on your existing credentials";
    private static final String AUTHTEST = "authtest";
    private static final String AUTHTEST_HELP = "test authentication as a generic client";
    private static final String GENERATE_TICKET = "generateticket";
    private static final String GENERATE_TICKET_HELP = "generate a ticket of particular type";
    private static final String END1 = "end";
    private static final String END2 = "logout";
    private static final String END_HELP = "logout of cluster";
    private static final long MAPRLOGIN_TICKET_GENERATION_INTERVAL = 86400L;

    private static void printDurationUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append("-duration|renewal [Days:]Hours:Minutes \n");
        builder.append("OR -duration|renewal seconds");
        System.out.println(builder.toString());
    }

    private static void printGenerateTicketHelp() {
        UnixUserGroupHelper helper = new UnixUserGroupHelper();
        String userName = helper.getLoggedinUsername();
        StringBuilder builder = new StringBuilder();
        builder.append(GENERATE_TICKET);
        builder.append("\n");
        builder.append("\t");
        builder.append("-type service/crosscluster");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -cluster mapr cluster name ]");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -user UNIX user name of service identity. default: '");
        builder.append(userName);
        builder.append("' ]");
        builder.append("\n");
        builder.append("\t");
        builder.append("-out ticket location");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -duration [Days:]Hours:Minutes OR -duration Seconds.default: cluster's ticket duration setting ]");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -renewal [Days:]Hours:Minutes OR -duration Seconds.default: cluster's ticket duration setting ]");
        System.out.println(builder.toString());
        LOG.info((Object)builder.toString());
    }

    private static void printPasswordHelp() {
        UnixUserGroupHelper helper = new UnixUserGroupHelper();
        String userName = helper.getLoggedinUsername();
        StringBuilder builder = new StringBuilder();
        builder.append(PASSWORD);
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -cluster mapr cluster name ]");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -user UNIX user name on MapR cluster. default: '");
        builder.append(userName);
        builder.append("' ]");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -duration desired ticket duration in seconds. default: cluster's ticket duration setting ]");
        System.out.println(builder.toString());
        LOG.info((Object)builder.toString());
    }

    private static void printKerberosHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(KERBEROS);
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -cluster mapr cluster name ]");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -duration desired ticket duration in seconds. default: cluster's ticket duration setting ]");
        System.out.println(builder.toString());
        LOG.info((Object)builder.toString());
    }

    private static void printAuthTestHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(AUTHTEST);
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -cluster mapr cluster name ]");
        System.out.println(builder.toString());
    }

    private static void printEndHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(END1);
        builder.append(" / ");
        builder.append(END2);
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -cluster mapr cluster name ]");
        System.out.println(builder.toString());
    }

    private static void printPrintHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(PRINT);
        builder.append("\n");
        System.out.println(builder.toString());
    }

    private static void printRenewHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(RENEW);
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -cluster mapr cluster name ]");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -duration desired ticket renew duration in seconds. default: cluster's ticket renew duration setting ]");
        System.out.println(builder.toString());
    }

    private static void printUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append("List of commands: \n");
        builder.append("\n");
        builder.append("\t");
        builder.append(PASSWORD);
        builder.append("\t");
        builder.append(PASSWORD_HELP);
        builder.append("\n");
        builder.append("\t");
        builder.append(KERBEROS);
        builder.append("\t");
        builder.append(KERBEROS_HELP);
        builder.append("\n");
        builder.append("\t");
        builder.append("print   ");
        builder.append("\t");
        builder.append(PRINT_HELP);
        builder.append("\n");
        builder.append("\t");
        builder.append("authtest   ");
        builder.append("\t");
        builder.append(AUTHTEST_HELP);
        builder.append("\n");
        builder.append("\t");
        builder.append("end / logout");
        builder.append("\t");
        builder.append(END_HELP);
        builder.append("\n");
        builder.append("\t");
        builder.append(RENEW);
        builder.append("\t");
        builder.append(RENEW_HELP);
        builder.append("\n");
        builder.append("\t");
        builder.append(GENERATE_TICKET);
        builder.append("\t");
        builder.append(GENERATE_TICKET_HELP);
        System.out.println(builder.toString());
        LOG.info((Object)builder.toString());
    }

    private static void printHelp(String command) {
        if (command.equals(PRINT)) {
            MapRLogin.printPrintHelp();
        } else if (command.equals(AUTHTEST)) {
            MapRLogin.printAuthTestHelp();
        } else if (command.equals(KERBEROS)) {
            MapRLogin.printKerberosHelp();
        } else if (command.equals(PASSWORD)) {
            MapRLogin.printPasswordHelp();
        } else if (command.equals(END1) || command.equals(END2)) {
            MapRLogin.printEndHelp();
        } else if (command.equals(RENEW)) {
            MapRLogin.printRenewHelp();
        } else if (command.equals(GENERATE_TICKET)) {
            MapRLogin.printGenerateTicketHelp();
        } else {
            MapRLogin.printUsage();
        }
    }

    private static void printTicket(String cluster, Security.TicketAndKey tk) throws MapRLoginException {
        long expiration = tk.getExpiryTime();
        int uid = tk.getUserCreds().getUid();
        List gids = tk.getUserCreds().getGidsList();
        String user = tk.getUserCreds().getUserName();
        System.out.print(cluster + ": ");
        String creationTime = new Date(tk.getCreationTimeSec() * 1000L).toString();
        String renewalMsg = tk.getMaxRenewalDurationSec() == 0L ? "Not renewable" : "RenewalTill = '" + new Date((tk.getCreationTimeSec() + tk.getMaxRenewalDurationSec()) * 1000L).toString() + "'";
        System.out.print("user = " + user + ", created = '" + creationTime + "', expires = '" + new Date(expiration * 1000L) + "', " + renewalMsg + ", uid = " + uid + ", gids = ");
        Iterator iter = gids.iterator();
        while (iter.hasNext()) {
            Integer gid = (Integer)iter.next();
            System.out.print(gid);
            if (!iter.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.println();
    }

    private static void handlePrint() throws Exception {
        MutableInt err = new MutableInt();
        String loc = JNISecurity.GetUserTicketAndKeyFileLocation();
        System.out.println("Opening keyfile " + loc);
        File file = new File(loc);
        if (!file.exists()) {
            throw new MapRLoginException("keyfile not found");
        }
        int errno = Security.SetTicketAndKeyFile(loc);
        if (errno != 0) {
            throw new MapRLoginException("Problem reading keyfile, error = " + errno);
        }
        FileInputStream inraw = new FileInputStream(file);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)inraw, "UTF-8"));
        String line = in.readLine();
        while (line != null) {
            String cluster = line.split(" ")[0];
            Security.TicketAndKey tk = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.ServerKey, cluster, err);
            MapRLogin.printTicket(cluster, tk);
            line = in.readLine();
        }
    }

    private static long getDesiredDurationInSecs(String desiredDuration) {
        if (desiredDuration == null || desiredDuration.isEmpty()) {
            System.out.println("Invalid input for -duration. Please enter a numeric value");
            System.exit(1);
        }
        String[] times = desiredDuration.split(":");
        long durationInSecs = 0L;
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        try {
            switch (times.length) {
                case 1: {
                    durationInSecs = Long.parseLong(times[0]);
                    break;
                }
                case 2: {
                    hours = Long.parseLong(times[0]);
                    minutes = Long.parseLong(times[1]);
                    if (hours < 0L) {
                        System.out.println("Invalid hours specified");
                        MapRLogin.printDurationUsage();
                        System.exit(1);
                    }
                    if (minutes < 0L || minutes > 60L) {
                        System.out.println("Invalid minutes specified");
                        MapRLogin.printDurationUsage();
                        System.exit(1);
                    }
                    durationInSecs = 3600L * hours + 60L * minutes;
                    break;
                }
                case 3: {
                    days = Long.parseLong(times[0]);
                    hours = Long.parseLong(times[1]);
                    minutes = Long.parseLong(times[2]);
                    if (days < 0L) {
                        System.out.println("Invalid days specified");
                        MapRLogin.printDurationUsage();
                        System.exit(1);
                    }
                    if (hours < 0L) {
                        System.out.println("Invalid hours specified");
                        MapRLogin.printDurationUsage();
                        System.exit(1);
                    }
                    if (minutes < 0L || minutes > 60L) {
                        System.out.println("Invalid minutes specified");
                        MapRLogin.printDurationUsage();
                        System.exit(1);
                    }
                    durationInSecs = 86400L * days + 3600L * hours + 60L * minutes;
                    break;
                }
                default: {
                    System.out.println("Incorrect usage of duration.");
                    MapRLogin.printDurationUsage();
                    System.exit(1);
                    break;
                }
            }
        }
        catch (NumberFormatException nfe) {
            System.out.println("Invalid input for duration " + desiredDuration + " Please enter a numeric value");
            MapRLogin.printDurationUsage();
            System.exit(1);
        }
        if (durationInSecs <= 0L) {
            System.out.println("Invalid time specified");
            MapRLogin.printDurationUsage();
            System.exit(1);
        }
        return durationInSecs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void execute(String[] args) throws Exception {
        String command = args[0];
        if (command.equals(PRINT)) {
            MapRLogin.handlePrint();
            return;
        }
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        boolean clusterNameSpecified = false;
        String user = new UnixUserGroupHelper().getLoggedinUsername();
        Long desiredDurationInSecs = null;
        Long renewalDurationInSecs = null;
        String ticketLocation = null;
        GenTicketTypeRequest.TicketType type = null;
        boolean checkTicketValidity = false;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-cluster") && i != args.length - 1) {
                clusterName = args[i + 1];
                clusterNameSpecified = true;
                ++i;
                continue;
            }
            if (args[i].equals("-out") && i != args.length - 1) {
                ticketLocation = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-user") && i != args.length - 1) {
                user = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-type") && i != args.length - 1) {
                type = GenTicketTypeRequest.TicketType.valueOf(args[i + 1].toUpperCase());
                ++i;
                continue;
            }
            if (args[i].equals("-duration") && i != args.length - 1) {
                try {
                    desiredDurationInSecs = MapRLogin.getDesiredDurationInSecs(args[i + 1]);
                    ++i;
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Invalid input for -duration. Please enter a numeric value.");
                    System.exit(1);
                }
                continue;
            }
            if (args[i].equals("-renewal") && i != args.length - 1) {
                try {
                    renewalDurationInSecs = MapRLogin.getDesiredDurationInSecs(args[i + 1]);
                    ++i;
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Invalid input for -renewal " + args[i + 1] + ". Please enter a numeric value.");
                    System.exit(1);
                }
                continue;
            }
            if (args[i].equals("-checkvalidity")) {
                checkTicketValidity = true;
                continue;
            }
            MapRLogin.printHelp(command);
            System.exit(1);
        }
        if (!JNISecurity.IsSecurityEnabled(clusterName)) {
            String error = "Security is not enabled on the cluster: " + clusterName + ". Running maprlogin will not login. If you think security should be enabled - " + " please check your cluster configuration.";
            throw new IOException(error);
        }
        MapRLoginHttpsClient client = new MapRLoginHttpsClient();
        if (command.equals(KERBEROS)) {
            String kerberosConfigFilePath = System.getProperty("java.security.auth.login.config");
            if (kerberosConfigFilePath == null || kerberosConfigFilePath.isEmpty()) {
                String error = "Kerberos configuration file not specified. Please specify it via -Djava.security.auth.login.config.";
                LOG.error((Object)error);
                throw new IOException(error);
            }
            File file = new File(kerberosConfigFilePath);
            if (!file.exists()) {
                String error = "Kerberos configuration does not exist: '" + kerberosConfigFilePath + "'. Cannot proceed without it.";
                LOG.error((Object)error);
                throw new IOException(error);
            }
            client.setCheckUGI(false);
            client.getMapRCredentialsViaKerberos(clusterName, desiredDurationInSecs);
            return;
        }
        if (command.equals(PASSWORD)) {
            String password;
            char[] passwd;
            if (checkTicketValidity) {
                MutableInt err = new MutableInt();
                Security.TicketAndKey tk = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.ServerKey, clusterName, err);
                if (err.GetValue() == 0) {
                    long currentTime = System.currentTimeMillis() / 1000L;
                    long prevTicketGenIntervalTime = currentTime - 86400L;
                    if (tk.getExpiryTime() > currentTime && tk.getCreationTimeSec() > prevTicketGenIntervalTime) {
                        LOG.info((Object)"A valid ticket is already present.");
                        return;
                    }
                }
            }
            String passwordPrompt = "Password for user '" + user + "' at cluster '" + clusterName + "': ";
            Console cons = System.console();
            if (cons != null && (passwd = cons.readPassword("[%s] ", passwordPrompt)) != null) {
                password = new String(passwd);
                Arrays.fill(passwd, ' ');
                client.getMapRCredentialsViaPassword(clusterName, user, password, desiredDurationInSecs);
                return;
            }
            if (System.in.available() > 0) {
                int numAvailable = System.in.available();
                byte[] bytes = new byte[numAvailable];
                System.in.read(bytes);
                password = new String(bytes);
                password = password.trim();
                client.getMapRCredentialsViaPassword(clusterName, user, password, desiredDurationInSecs);
                return;
            }
            String error = "Error obtaining user password from console";
            LOG.error((Object)error);
            throw new IOException(error);
        }
        if (command.equals(AUTHTEST)) {
            System.out.println("Attempting to pick up default credentials for cluster " + clusterName);
            client.authenticateIfNeeded(clusterName);
            System.out.println("Successfully obtained credentials.");
            return;
        }
        if (command.equals(END1) || command.equals(END2)) {
            if (clusterNameSpecified) {
                client.logOut(clusterName);
                return;
            }
            client.logOut();
            return;
        }
        if (command.equals(RENEW)) {
            client.renew(clusterName, desiredDurationInSecs);
            return;
        }
        if (!command.equals(GENERATE_TICKET)) {
            MapRLogin.printUsage();
            System.exit(1);
            return;
        }
        if (type == null) {
            System.out.println("Specify the type of the ticket");
            MapRLogin.printGenerateTicketHelp();
            System.exit(1);
        }
        if (ticketLocation == null || ticketLocation.isEmpty()) {
            System.out.println("Specify the  of location of the ticket");
            MapRLogin.printGenerateTicketHelp();
            System.exit(1);
        }
        if (renewalDurationInSecs == null) {
            renewalDurationInSecs = desiredDurationInSecs;
        }
        if (desiredDurationInSecs != null && desiredDurationInSecs > renewalDurationInSecs) {
            String error = "Duration value cannot be more than renewal value";
            throw new IOException(error);
        }
        client.generateTicket(type, user, clusterName, desiredDurationInSecs, renewalDurationInSecs, ticketLocation);
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            MapRLogin.printUsage();
            return;
        }
        try {
            MapRLogin.execute(args);
        }
        catch (Exception e) {
            LOG.error((Object)"Login exception", (Throwable)e);
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    static {
        ShimLoader.load();
    }
}

