/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import com.mapr.baseutils.BaseUtilsHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.security.JNISecurity;
import org.apache.log4j.Logger;

public class JVMProperties {
    private static final Logger LOG = Logger.getLogger(JVMProperties.class);
    private static String MAPRHOME = BaseUtilsHelper.getPathToMaprHome();
    private static String defaultCluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
    private static boolean securityEnabled;

    private static void setPropIfUnset(String property, String value) {
        String current = System.getProperty(property);
        if (current == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting JVM property " + property + " to " + value));
            }
            System.setProperty(property, value);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("JVM property " + property + " already set to " + current + ", leaving unchanged"));
        }
    }

    public static void init() {
    }

    static {
        JNISecurity.Initialize();
        securityEnabled = JNISecurity.IsSecurityEnabled(defaultCluster);
        if (securityEnabled) {
            JVMProperties.setPropIfUnset("javax.net.ssl.trustStore", MAPRHOME + "/conf/ssl_truststore");
            JVMProperties.setPropIfUnset("http.auth.preference", "basic");
            JVMProperties.setPropIfUnset("zookeeper.saslprovider", "com.mapr.security.maprsasl.MaprSaslProvider");
        } else {
            JVMProperties.setPropIfUnset("zookeeper.saslprovider", "com.mapr.security.simplesasl.SimpleSaslProvider");
            JVMProperties.setPropIfUnset("zookeeper.sasl.clientconfig", "Client_simple");
        }
        JVMProperties.setPropIfUnset("java.security.auth.login.config", MAPRHOME + "/conf/mapr.login.conf");
    }
}

