/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.metric;

import com.mapr.baseutils.metric.MetricRepo;
import com.mapr.baseutils.metric.MetricRepoBase;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class JobMetricRepo
extends MetricRepoBase
implements MetricRepo {
    private static final Logger LOG = Logger.getLogger(JobMetricRepo.class);
    private static final String JOB_INSERT_SQL = "insert into metrics.JOB (JOB_ID, JOB_NAME, PARENT_JOB_ID, USER_SUBMITTED, TIME_SUBMITTED, CLUSTER_ID) values(?, ?, ?, ?, ?, ?)";
    private static final String JOB_UPDATE_SQL = "update metrics.JOB set TIME_STARTED = IFNULL(TIME_STARTED, ?), TIME_FINISHED = IFNULL(TIME_FINISHED, ?) WHERE JOB_ID = ?";
    private static final String JOB_ATTR_INSERT_SQL = "insert into metrics.JOB_ATTRIBUTES (ATTR_ID, JOB_ID, ATTR_NAME, ATTR_VALUE) values(default, ?, ?, ?)";
    private ClusterMetricsProto.JobMetric jobMetric;

    public JobMetricRepo(ClusterMetricsProto.JobMetric jobMetric) {
        this.jobMetric = jobMetric;
    }

    @Override
    public List<ClusterMetricsProto.Counters> prepareTransactions() {
        ArrayList<ClusterMetricsProto.Counters> metricTransactions = new ArrayList<ClusterMetricsProto.Counters>();
        if (this.jobMetric.hasAttributes()) {
            return this.jobMetric.getTimeBasedCountersList();
        }
        return metricTransactions;
    }

    @Override
    public ClusterMetricsProto.MetricAttributes getMetricAttributes() {
        if (this.jobMetric.hasAttributes()) {
            return this.jobMetric.getAttributes();
        }
        return null;
    }

    @Override
    public MetricRepo.MetricType getMetricType() {
        return MetricRepo.MetricType.JOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeDBOperations(Connection dbConnection) throws SQLException {
        if (dbConnection == null || dbConnection.isClosed()) {
            LOG.error((Object)"DBConnection is null or closed. No Job Metric related DB operation will be performed");
            return;
        }
        if (this.jobMetric.hasFinalMetric()) {
            String jobId;
            ClusterMetricsProto.JobMetric.FinalMetric jFinalMetric;
            block25: {
                jFinalMetric = this.jobMetric.getFinalMetric();
                jobId = jFinalMetric.getId();
                try (PreparedStatement jobInsertPrepStmt = dbConnection.prepareStatement(JOB_INSERT_SQL);){
                    jobInsertPrepStmt.setString(1, jobId);
                    if (jFinalMetric.hasName()) {
                        jobInsertPrepStmt.setString(2, jFinalMetric.getName());
                    } else {
                        jobInsertPrepStmt.setNull(2, 12);
                    }
                    if (jFinalMetric.hasParentJobId()) {
                        jobInsertPrepStmt.setString(3, jFinalMetric.getParentJobId());
                    } else {
                        jobInsertPrepStmt.setNull(3, 12);
                    }
                    if (jFinalMetric.hasUser()) {
                        jobInsertPrepStmt.setString(4, jFinalMetric.getUser());
                    } else {
                        jobInsertPrepStmt.setNull(4, 12);
                    }
                    if (jFinalMetric.hasSubmitTime()) {
                        jobInsertPrepStmt.setLong(5, jFinalMetric.getSubmitTime());
                    } else {
                        jobInsertPrepStmt.setNull(5, -5);
                    }
                    jobInsertPrepStmt.setString(6, this.getClusterId());
                    try {
                        jobInsertPrepStmt.executeUpdate();
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 1062) {
                            break block25;
                        }
                        throw e;
                    }
                }
            }
            try (PreparedStatement jobUpdatePrepStmt = dbConnection.prepareStatement(JOB_UPDATE_SQL);){
                if (jFinalMetric.hasStartTime()) {
                    jobUpdatePrepStmt.setLong(1, jFinalMetric.getStartTime());
                } else {
                    jobUpdatePrepStmt.setNull(1, -5);
                }
                if (jFinalMetric.hasFinishTime()) {
                    jobUpdatePrepStmt.setLong(2, jFinalMetric.getFinishTime());
                } else {
                    jobUpdatePrepStmt.setNull(2, -5);
                }
                jobUpdatePrepStmt.setString(3, jobId);
                try {
                    jobUpdatePrepStmt.executeUpdate();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Exception while trying to update Job data", (Throwable)e);
                    throw e;
                }
            }
            this.insertJObAttributes(dbConnection, jFinalMetric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertJObAttributes(Connection dbConnection, ClusterMetricsProto.JobMetric.FinalMetric jFinalMetric) throws SQLException {
        try (PreparedStatement jobAttrInsertPrepStmt = dbConnection.prepareStatement(JOB_ATTR_INSERT_SQL);){
            jobAttrInsertPrepStmt.setString(1, jFinalMetric.getId());
            if (jFinalMetric.hasMapTasksCount()) {
                jobAttrInsertPrepStmt.setString(2, "MAP_TASK_COUNT");
                jobAttrInsertPrepStmt.setLong(3, jFinalMetric.getMapTasksCount());
                jobAttrInsertPrepStmt.addBatch();
            }
            if (jFinalMetric.hasReduceTasksCount()) {
                jobAttrInsertPrepStmt.setString(2, "REDUCE_TASK_COUNT");
                jobAttrInsertPrepStmt.setLong(3, jFinalMetric.getReduceTasksCount());
                jobAttrInsertPrepStmt.addBatch();
            }
            if (jFinalMetric.hasInputSize()) {
                jobAttrInsertPrepStmt.setString(2, "INPUT_SIZE");
                jobAttrInsertPrepStmt.setLong(3, jFinalMetric.getInputSize());
                jobAttrInsertPrepStmt.addBatch();
            }
            if (jFinalMetric.hasPriority()) {
                jobAttrInsertPrepStmt.setString(2, "PRIORITY");
                jobAttrInsertPrepStmt.setString(3, jFinalMetric.getPriority());
                jobAttrInsertPrepStmt.addBatch();
            }
            for (String group : jFinalMetric.getGroupList()) {
                jobAttrInsertPrepStmt.setString(2, "GROUP");
                jobAttrInsertPrepStmt.setString(3, group);
                jobAttrInsertPrepStmt.addBatch();
            }
            for (String label : jFinalMetric.getLabelList()) {
                jobAttrInsertPrepStmt.setString(2, "LABEL");
                jobAttrInsertPrepStmt.setString(3, label);
                jobAttrInsertPrepStmt.addBatch();
            }
            for (ClusterMetricsProto.Counters counter : jFinalMetric.getSummarizedCountersList()) {
                jobAttrInsertPrepStmt.setString(2, counter.getCounterName());
                jobAttrInsertPrepStmt.setLong(3, counter.getCounterValue());
                jobAttrInsertPrepStmt.addBatch();
            }
            jobAttrInsertPrepStmt.executeBatch();
        }
    }

    @Override
    public List<ClusterMetricsProto.Pair> prepareEvents() {
        ArrayList<ClusterMetricsProto.Pair> events = new ArrayList<ClusterMetricsProto.Pair>();
        if (this.jobMetric.hasEventMetric() && this.jobMetric.hasAttributes()) {
            ClusterMetricsProto.JobMetric.EventMetric jEventMetric = this.jobMetric.getEventMetric();
            if (jEventMetric.hasStatus()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("STATUS").setValue(jEventMetric.getStatus()).build());
            }
            if (jEventMetric.hasPriority()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("PRIORITY").setValue(jEventMetric.getPriority()).build());
            }
            if (jEventMetric.hasFailureInfo()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("FAILINFO").setValue(jEventMetric.getFailureInfo()).build());
            }
            if (jEventMetric.hasSchedulingInfo()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("SCHEDINFO").setValue(jEventMetric.getSchedulingInfo()).build());
            }
        }
        return events;
    }
}

