/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;

public class URLProbingUtility {
    private static final Logger LOG = Logger.getLogger(URLProbingUtility.class);

    public static boolean isURLReachable(String testUrl) {
        try {
            HttpURLConnection connection;
            URL url = new URL(testUrl);
            String protocol = url.getProtocol();
            if ("http".equalsIgnoreCase(protocol)) {
                connection = (HttpURLConnection)url.openConnection();
            } else if ("https".equalsIgnoreCase(protocol)) {
                connection = (HttpsURLConnection)url.openConnection();
            } else {
                LOG.error((Object)"URL has to be either http or https. No other formats are supported");
                return false;
            }
            connection.setDoInput(true);
            connection.setDoOutput(true);
            HttpsURLConnection.setFollowRedirects(true);
            String query = url.getQuery();
            try {
                DataOutputStream output = new DataOutputStream(connection.getOutputStream());
                if (query != null) {
                    output.writeBytes(URLEncoder.encode(query.toString(), "UTF-8"));
                }
                output.flush();
                output.close();
            }
            catch (IOException x) {
                LOG.error((Object)("URL: " + testUrl + " can not be reached"), (Throwable)x);
                return false;
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                Map<String, List<String>> headers;
                if (responseCode > 400 && responseCode < 500 && (headers = connection.getHeaderFields()).containsKey("WWW-Authenticate")) {
                    LOG.warn((Object)(testUrl + " requires authentication"));
                    return true;
                }
                LOG.error((Object)("URL: " + testUrl + " returns invalid code: " + responseCode));
                return false;
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("URL: " + testUrl + " is malformed"), (Throwable)e);
            return false;
        }
        catch (IOException x) {
            LOG.error((Object)("URL: " + testUrl + " can not be reached"), (Throwable)x);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        System.out.println(URLProbingUtility.isURLReachable(args[0]));
    }
}

