/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.metric;

import com.mapr.baseutils.metric.MetricRepo;
import com.mapr.baseutils.metric.MetricRepoBase;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TaskAttemptMetricRepo
extends MetricRepoBase
implements MetricRepo {
    private static final Logger LOG = Logger.getLogger(TaskAttemptMetricRepo.class);
    private static final String insertTaskAtSQL = "insert into metrics.TASK_ATTEMPT (TASK_ATTEMPT_ID, TASK_ID, TYPE, TIME_STARTED, HOST, LOG_LOCATION, STATUS) values(?, ?, ?, ?, ?, ?, ?)";
    private static final String updateTaskAtSQL = "update metrics.TASK_ATTEMPT set SHUFFLE_FINISHED = IFNULL(SHUFFLE_FINISHED, ?), SORT_FINISHED = IFNULL(SORT_FINISHED,?), TIME_FINISHED = IFNULL(TIME_FINISHED, ?), STATUS = IFNULL(STATUS, ?) WHERE TASK_ATTEMPT_ID = ?";
    private ClusterMetricsProto.TaskAttemptMetric taskAMetric;

    public TaskAttemptMetricRepo(ClusterMetricsProto.TaskAttemptMetric taskAMetric) {
        this.taskAMetric = taskAMetric;
    }

    @Override
    public List<ClusterMetricsProto.Counters> prepareTransactions() {
        ArrayList<ClusterMetricsProto.Counters> metricTransactions = new ArrayList<ClusterMetricsProto.Counters>();
        if (this.taskAMetric.hasAttributes()) {
            if (this.taskAMetric.hasProgressPercent()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("PROGRESS").setCounterValue((long)this.taskAMetric.getProgressPercent()).build());
            }
            metricTransactions.addAll(this.taskAMetric.getCountersList());
        }
        return metricTransactions;
    }

    @Override
    public ClusterMetricsProto.MetricAttributes getMetricAttributes() {
        if (this.taskAMetric.hasAttributes()) {
            return this.taskAMetric.getAttributes();
        }
        return null;
    }

    @Override
    public MetricRepo.MetricType getMetricType() {
        return MetricRepo.MetricType.TASKATTEMPT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeDBOperations(Connection dbConnection) throws SQLException {
        block32: {
            if (this.taskAMetric.hasFinalMetric()) {
                String taskAttemptId;
                ClusterMetricsProto.TaskAttemptMetric.FinalMetric taFinalMetric;
                block31: {
                    taFinalMetric = this.taskAMetric.getFinalMetric();
                    taskAttemptId = taFinalMetric.getId();
                    String taskId = taFinalMetric.getTaskId();
                    PreparedStatement taskAttInsertPrepStmt = dbConnection.prepareStatement(insertTaskAtSQL);
                    try {
                        taskAttInsertPrepStmt.setString(1, taskAttemptId);
                        taskAttInsertPrepStmt.setString(2, taskId);
                        if (taFinalMetric.hasType()) {
                            taskAttInsertPrepStmt.setString(3, taFinalMetric.getType());
                        } else {
                            taskAttInsertPrepStmt.setNull(3, 1);
                        }
                        if (taFinalMetric.hasStartTime()) {
                            taskAttInsertPrepStmt.setLong(4, taFinalMetric.getStartTime());
                        } else {
                            taskAttInsertPrepStmt.setNull(4, -5);
                        }
                        if (taFinalMetric.hasHost()) {
                            taskAttInsertPrepStmt.setString(5, taFinalMetric.getHost());
                        } else {
                            taskAttInsertPrepStmt.setNull(5, 1);
                        }
                        if (taFinalMetric.hasLogLocation()) {
                            taskAttInsertPrepStmt.setString(6, taFinalMetric.getLogLocation());
                        } else {
                            taskAttInsertPrepStmt.setNull(6, 1);
                        }
                        if (taFinalMetric.hasState()) {
                            taskAttInsertPrepStmt.setString(7, taFinalMetric.getState());
                        } else {
                            taskAttInsertPrepStmt.setNull(7, 1);
                        }
                        try {
                            taskAttInsertPrepStmt.executeUpdate();
                        }
                        catch (SQLException e) {
                            if (e.getErrorCode() == 1062) {
                                break block31;
                            }
                            LOG.error((Object)"Exception while trying to insert TaskAttempt: ", (Throwable)e);
                            throw e;
                        }
                    }
                    finally {
                        taskAttInsertPrepStmt.close();
                    }
                }
                PreparedStatement taskAttUpdatePrepStmt = dbConnection.prepareStatement(updateTaskAtSQL);
                try {
                    boolean isUpdateNeeded = false;
                    if (taFinalMetric.hasShuffleFinished()) {
                        isUpdateNeeded = true;
                        taskAttUpdatePrepStmt.setLong(1, taFinalMetric.getShuffleFinished());
                    } else {
                        taskAttUpdatePrepStmt.setNull(1, -5);
                    }
                    if (taFinalMetric.hasSortFinished()) {
                        isUpdateNeeded = true;
                        taskAttUpdatePrepStmt.setLong(2, taFinalMetric.getSortFinished());
                    } else {
                        taskAttUpdatePrepStmt.setNull(2, -5);
                    }
                    if (taFinalMetric.hasFinishTime()) {
                        isUpdateNeeded = true;
                        taskAttUpdatePrepStmt.setLong(3, taFinalMetric.getFinishTime());
                    } else {
                        taskAttUpdatePrepStmt.setNull(3, -5);
                    }
                    if (taFinalMetric.hasState()) {
                        isUpdateNeeded = true;
                        taskAttUpdatePrepStmt.setString(4, taFinalMetric.getState());
                    } else {
                        taskAttUpdatePrepStmt.setNull(4, 1);
                    }
                    if (!isUpdateNeeded) break block32;
                    taskAttUpdatePrepStmt.setString(5, taskAttemptId);
                    try {
                        taskAttUpdatePrepStmt.executeUpdate();
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 1062) {
                            break block32;
                        }
                        LOG.error((Object)"Exception while trying to update TaskAttempt: ", (Throwable)e);
                        throw e;
                    }
                }
                finally {
                    taskAttUpdatePrepStmt.close();
                }
            }
        }
    }

    @Override
    public List<ClusterMetricsProto.Pair> prepareEvents() {
        ArrayList<ClusterMetricsProto.Pair> events = new ArrayList<ClusterMetricsProto.Pair>();
        if (this.taskAMetric.hasEventMetric() && this.taskAMetric.hasAttributes()) {
            ClusterMetricsProto.TaskAttemptMetric.EventMetric taEventMetric = this.taskAMetric.getEventMetric();
            int i = 0;
            for (String diagnosticInfo : taEventMetric.getDiagnosticInfoList()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("DIAGINFO" + i++).setValue(diagnosticInfo).build());
            }
            if (taEventMetric.hasState()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("STATE").setValue(taEventMetric.getState()).build());
            }
            if (taEventMetric.hasStateString()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("STATESTRING").setValue(taEventMetric.getStateString()).build());
            }
        }
        return events;
    }
}

