/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.maprauth;

import com.mapr.login.PasswordAuthentication;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler;
import org.apache.log4j.Logger;

public class BasicAuthHandler
extends MultiMechsAuthenticationHandler {
    private static final Logger LOG = Logger.getLogger(BasicAuthHandler.class);
    private static final String BASIC_AUTH = "Basic";

    public void init(Properties config) throws ServletException {
    }

    public AuthenticationToken postauthenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken authToken = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith(BASIC_AUTH)) {
            try {
                String password;
                int i;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Credentials: " + authorization));
                }
                authorization = authorization.substring(authorization.indexOf(32) + 1);
                String username = (authorization = new String(Base64.decodeBase64((String)authorization))).substring(0, i = authorization.indexOf(58));
                if (PasswordAuthentication.authenticate(username, password = authorization.substring(i + 1))) {
                    authToken = new AuthenticationToken(username, username, this.getType());
                    response.setStatus(200);
                } else {
                    response.setStatus(401);
                    LOG.error((Object)"User Principal is null while trying to authenticate with Basic Auth");
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("AUTH FAILURE: " + e.toString()));
            }
        }
        return authToken;
    }

    public void addHeader(HttpServletResponse response) {
        response.addHeader("WWW-Authenticate", "Basic realm=\"WebLogin\"");
    }

    public MultiMechsAuthenticationHandler getAuthBasedEntity(String authorization) {
        if (authorization != null && authorization.startsWith(BASIC_AUTH)) {
            return this;
        }
        return null;
    }
}

