/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.protobuf.MessageLite;
import com.mapr.baseutils.threadpool.TimeStampedRunnableTask;
import com.mapr.fs.RpcCallContext;
import com.mapr.fs.RpcExport;
import com.mapr.fs.RpcProgram;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.ThreadPoolFinder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class Rpc {
    static RpcExport[] progTab_;
    static int port_;
    static ThreadPoolFinder poolFinder_;

    public static int initialize(int port, int numThreads) throws Exception {
        return Rpc.initialize(port, numThreads, null, null);
    }

    public static int initialize(int port, int numThreads, RpcExport[] exports, ThreadPoolFinder thrPool) throws Exception {
        if (progTab_ == null) {
            int numExports = 4;
            if (exports == null) {
                port_ = Rpc.init(port);
            } else {
                int numPrograms = exports.length;
                numExports += numPrograms;
                int[] ids = new int[numPrograms];
                for (int i = 0; i < numPrograms; ++i) {
                    ids[i] = exports[i].getProgramId();
                }
                port_ = Rpc.initAndExport(port, ids);
            }
            if (port_ < 0) {
                return port_;
            }
            progTab_ = new RpcExport[numExports];
            poolFinder_ = null;
            if (exports != null) {
                int i = 0;
                for (RpcExport e : exports) {
                    Rpc.progTab_[i] = new RpcExport(e.getProgramId(), e.getProgram());
                    ++i;
                }
            }
            ExecutorService threadPool = null;
            if (thrPool == null) {
                threadPool = Executors.newCachedThreadPool();
            } else {
                Rpc.setThreadPoolFinder(thrPool);
            }
            RpcListenerThread t = new RpcListenerThread();
            t.setThreadPool(threadPool);
            t.setDaemon(true);
            t.start();
        }
        return port_;
    }

    public static native long createBindingFor(int var0, int var1);

    public static native long createBindingForIps(int[] var0, int var1);

    public static native long getIpPortFromBinding(long var0);

    public static byte[] sendRequest(long binding, int programId, int procedureId, MessageLite request) throws Exception {
        byte[] serializedReq = request.toByteArray();
        return Rpc.sendRequest(binding, programId, procedureId, serializedReq);
    }

    public static native void doNotTimeout(long var0);

    public static void exportProgram(int programId, RpcProgram program) throws Exception {
        for (int i = 0; i < progTab_.length; ++i) {
            if (progTab_[i] != null) continue;
            Rpc.progTab_[i] = new RpcExport(programId, program);
            break;
        }
        Rpc.registerProgramId(programId);
    }

    public static void sendReply(RpcCallContext c, MessageLite reply) throws Exception {
        byte[] serReply = reply.toByteArray();
        Rpc.sendReply(c.binding, c.context, serReply);
    }

    public static void rejectCall(RpcCallContext c) throws Exception {
        Rpc.rejectCall(c.binding, c.context);
    }

    public static void setThreadPoolFinder(ThreadPoolFinder finder) {
        poolFinder_ = finder;
    }

    static RpcProgram findExported(int programId) {
        for (RpcExport p : progTab_) {
            if (p == null) {
                return null;
            }
            if (p.programId != programId) continue;
            return p.program;
        }
        return null;
    }

    static native int init(int var0);

    static native int initAndExport(int var0, int[] var1);

    static native byte[] sendRequest(long var0, int var2, int var3, byte[] var4);

    static native void sendReply(long var0, long var2, byte[] var4);

    static native void rejectCall(long var0, long var2);

    static native void registerProgramId(int var0);

    static native byte[] waitForRequest(RpcCallContext var0);

    static {
        ShimLoader.load();
    }

    static class RpcListenerThread
    extends Thread {
        ExecutorService threadPool;

        RpcListenerThread() {
        }

        public void setThreadPool(ExecutorService pool) {
            this.threadPool = pool;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        RpcCallContext c = new RpcCallContext();
                        byte[] req = Rpc.waitForRequest(c);
                        RpcProgram p = Rpc.findExported(c.programId);
                        if (p == null) continue;
                        RpcExecutor rpc = new RpcExecutor(p, c, req);
                        ExecutorService pool = this.threadPool;
                        if (poolFinder_ != null) {
                            pool = poolFinder_.getThreadPool(c);
                        }
                        pool.execute(rpc);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                catch (OutOfMemoryError oom) {
                    oom.printStackTrace();
                    System.exit(0);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(0);
                    continue;
                }
                break;
            }
        }
    }

    static class RpcExecutor
    implements TimeStampedRunnableTask {
        RpcProgram prog;
        RpcCallContext ctx;
        byte[] req;

        RpcExecutor(RpcProgram p, RpcCallContext c, byte[] r) {
            this.prog = p;
            this.ctx = c;
            this.req = r;
            this.ctx.arrTime = System.currentTimeMillis();
        }

        @Override
        public long arrTime() {
            return this.ctx.arrTime;
        }

        @Override
        public void run() {
            this.prog.requestArrived(this.ctx, this.req);
        }
    }
}

