/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.metric;

import com.mapr.baseutils.metric.MetricRepo;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class MetricRepoBase
implements MetricRepo {
    public static String clusterId = null;
    private static final Logger LOG = Logger.getLogger(MetricRepoBase.class);

    @Override
    public boolean prepareMetricAttrs(PreparedStatement insertStmt, long time) throws SQLException {
        boolean isAtleastOnePresent = false;
        ClusterMetricsProto.MetricAttributes metricAttrs = this.getMetricAttributes();
        if (metricAttrs == null) {
            return isAtleastOnePresent;
        }
        insertStmt.setLong(1, time);
        if (metricAttrs.hasTaskAttemptId()) {
            insertStmt.setString(4, metricAttrs.getTaskAttemptId());
            isAtleastOnePresent = true;
        } else {
            insertStmt.setNull(4, 12);
        }
        if (metricAttrs.hasTaskId()) {
            insertStmt.setString(5, metricAttrs.getTaskId());
            isAtleastOnePresent = true;
        } else {
            insertStmt.setNull(5, 12);
        }
        if (metricAttrs.hasJobId()) {
            insertStmt.setString(6, metricAttrs.getJobId());
            isAtleastOnePresent = true;
        } else {
            insertStmt.setNull(6, 12);
        }
        if (metricAttrs.hasNodeId()) {
            insertStmt.setString(7, metricAttrs.getNodeId());
            isAtleastOnePresent = true;
        } else {
            insertStmt.setNull(7, 12);
        }
        insertStmt.setNull(8, 12);
        insertStmt.setNull(9, 12);
        insertStmt.setNull(10, 12);
        return isAtleastOnePresent;
    }

    public String getClusterId() {
        if (clusterId != null) {
            return clusterId;
        }
        String maprHome = System.getProperty("mapr.home.dir", "/opt/mapr");
        if (maprHome != null) {
            BufferedReader fis = null;
            try {
                fis = new BufferedReader(new FileReader(maprHome + "/conf/clusterid"));
                String clusterString = fis.readLine();
                String[] clusterNames = clusterString.split("\\s");
                clusterId = clusterNames[0];
                fis.close();
            }
            catch (FileNotFoundException fne) {
                LOG.error((Object)"Exception while trying to get info from clusterid file", (Throwable)fne);
            }
            catch (IOException ioe) {
                LOG.error((Object)("Exception while trying to read file: " + maprHome + "/conf/clusterid"), (Throwable)ioe);
            }
        }
        return clusterId;
    }
}

