/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.tools.Import;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.ojai.Document;
import org.ojai.types.ODate;

public class TestDiffCrc
extends Configured
implements Tool {
    private static String SRC_PATH = "/tmp/testtable-TestDiffTablesWithCrcSrc";
    private static String DST_PATH = "/tmp/testtable-TestDiffTablesWithCrcDst";
    private static String OUTDIR = null;
    private static AdminImpl admin = null;
    private static MapRDBTableImpl srcTable = null;
    private static MapRDBTableImpl dstTable = null;
    private static String columnSpec = null;
    private static final Log LOG = LogFactory.getLog(TestDiffCrc.class);

    private void setuptable() {
        admin = (AdminImpl)MapRDBImpl.newAdmin();
        TableDescriptor srcTableDesc = MapRDBImpl.newTableDescriptor((String)SRC_PATH).addFamily(MapRDBImpl.newDefaultFamilyDescriptor());
        TableDescriptor dstTableDesc = MapRDBImpl.newTableDescriptor((String)DST_PATH).addFamily(MapRDBImpl.newDefaultFamilyDescriptor());
        if (admin.tableExists(SRC_PATH)) {
            admin.deleteTable(SRC_PATH);
        }
        if (admin.tableExists(DST_PATH)) {
            admin.deleteTable(DST_PATH);
        }
        Integer count = 1000;
        System.out.println("src split ");
        String[] srcSplitPoints = new String[14];
        for (int i = 1; i < 15; ++i) {
            srcSplitPoints[i - 1] = Integer.toString(i * count);
            System.out.println("\t" + (i - 1) + ": " + srcSplitPoints[i - 1]);
        }
        count = 1200;
        System.out.println("dst split ");
        String[] dstSplitPoints = new String[12];
        for (int i = 1; i < 13; ++i) {
            dstSplitPoints[i - 1] = Integer.toString(i * count);
            System.out.println("\t" + (i - 1) + ": " + dstSplitPoints[i - 1]);
        }
        srcTable = (MapRDBTableImpl)admin.createTable(srcTableDesc, srcSplitPoints);
        dstTable = (MapRDBTableImpl)admin.createTable(dstTableDesc, dstSplitPoints);
        this.loadJSONData(srcTable);
    }

    private void loadJSONData(MapRDBTableImpl table) {
        Integer start = 2000;
        if (table != null) {
            while (start < 15000) {
                String key = Integer.toString(start);
                byte bvalue = (byte)(start % 128);
                String nvalue = new String("n" + key);
                Document d = MapRDBImpl.newDocument();
                d.set("name", nvalue).set("fbyte", bvalue).set("dvalue", ODate.parse((String)"2015-11-20")).setArray("farray", new Object[]{1, 2, 3, 4}).set("fbool", false);
                table.insertOrReplace(key, d);
                table.flush();
                Integer n = start;
                start = start + 1;
            }
        }
    }

    private void insertChanges(MapRDBTableImpl sTable, MapRDBTableImpl dTable) {
        Integer key1 = 100;
        String key = Integer.toString(key1);
        byte bvalue = (byte)(key1 % 128);
        String nvalue = new String("n" + key);
        Document d = MapRDBImpl.newDocument().set("name", nvalue).set("fbyte", bvalue).set("dvalue", ODate.parse((String)"2015-11-20")).setArray("farray", new Object[]{1, 2, 3, 4}).set("fbool", false);
        System.out.println("insert/replace " + key + " with " + d.asJsonString());
        sTable.insertOrReplace(key, d);
        sTable.flush();
        key1 = 9999;
        key = Integer.toString(key1);
        bvalue = (byte)(key1 % 128);
        nvalue = new String("n" + key);
        d = MapRDBImpl.newDocument();
        d.set("name", nvalue).set("fbyte", bvalue).set("dvalue", ODate.parse((String)"2015-11-20")).setArray("farray", new Object[]{1, 2, 3, 4}).set("fbool", false);
        dTable.insertOrReplace(key, d);
        dTable.flush();
        Random random = new Random();
        key1 = random.nextInt(16000);
        key = Integer.toString(key1);
        bvalue = (byte)(key1 % 128);
        nvalue = new String("n" + key);
        d = MapRDBImpl.newDocument();
        d.set("name", nvalue).set("fbyte", bvalue).set("dvalue", ODate.parse((String)"2015-11-20")).setArray("farray", new Object[]{1, 2, 3, 4}).set("fbool", false);
        sTable.insertOrReplace(key, d);
        sTable.flush();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            System.out.println("row " + key + ": failed to sleep, the timestamp of this row may not be different between src and dst table");
        }
        dTable.insertOrReplace(key, d);
        dTable.flush();
        System.out.println("row " + key + ": src and dst table have different timestamp.");
        key1 = random.nextInt(16000);
        key = Integer.toString(key1);
        bvalue = (byte)(key1 % 128);
        nvalue = new String("n" + key);
        d = MapRDBImpl.newDocument();
        d.set("name", nvalue).set("fbyte", bvalue).set("dvalue", ODate.parse((String)"2015-11-21")).setArray("farray", new Object[]{1, 2, 3, 4}).set("fbool", false);
        System.out.println("row " + key + ": change dvalue from 2015-11-20 to 2015-11-21");
        sTable.insertOrReplace(key, d);
        sTable.flush();
        key1 = random.nextInt(16000);
        key = Integer.toString(key1);
        bvalue = (byte)(key1 % 128);
        nvalue = new String("changed name" + key);
        d = MapRDBImpl.newDocument();
        d.set("name", nvalue).set("fbyte", bvalue).set("dvalue", ODate.parse((String)"2015-11-20")).setArray("farray", new Object[]{1, 2, 3, 4}).set("fbool", false);
        System.out.println("row " + key + ": change name from n" + key + " to " + nvalue);
        sTable.insertOrReplace(key, d);
        sTable.flush();
        key1 = random.nextInt(16000);
        key = Integer.toString(key1);
        bvalue = (byte)(key1 % 128);
        nvalue = new String("n" + key);
        d = MapRDBImpl.newDocument();
        d.set("name", nvalue).set("fbyte", bvalue).set("dvalue", ODate.parse((String)"2015-11-20")).setArray("farray", new Object[]{11, 12, 13, 14}).set("fbool", false);
        System.out.println("row " + key + ": change array val from 1,2,3,4 to 11,12,13,14");
        dTable.insertOrReplace(key, d);
        dTable.flush();
        key1 = random.nextInt(16000);
        key = Integer.toString(key1);
        bvalue = (byte)(key1 % 128);
        nvalue = new String("n" + key);
        d = MapRDBImpl.newDocument();
        d.set("name", nvalue).set("fbyte", bvalue).set("dvalue", ODate.parse((String)"2015-11-20")).setArray("farray", new Object[]{1, 2, 3, 4}).set("fbool", true);
        System.out.println("row " + key + ": change bool val from false to true");
        dTable.insertOrReplace(key, d);
        dTable.flush();
    }

    private static void importFromDir(String dstTableName, String srcDir) throws IOException, InterruptedException, Exception {
        int ret = ToolRunner.run(null, (Tool)new Import(), (String[])new String[]{"-src", srcDir, "-dst", dstTableName, "-bulkload", "false", "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private static void formatResult(String inDir, String outDir) throws IOException, InterruptedException {
        TestDiffCrc.rmDir(outDir);
        ProcessBuilder proc = new ProcessBuilder("mapr", "formatresult", "-indir", inDir, "-outdir", outDir);
        System.out.println("Running command " + proc.command());
        Process p = proc.start();
        p.waitFor();
        System.out.println("formatresult process exit code: " + p.exitValue());
        Assert.assertEquals((long)0L, (long)p.exitValue());
    }

    private static String[] getCopyTableCmdParams() {
        ArrayList<String> cmdArgsList = new ArrayList<String>();
        cmdArgsList.add("hadoop");
        cmdArgsList.add("com.mapr.db.mapreduce.tools.CopyTable");
        cmdArgsList.add("-src");
        cmdArgsList.add(SRC_PATH);
        cmdArgsList.add("-dst");
        cmdArgsList.add(DST_PATH);
        cmdArgsList.add("-mapreduce");
        cmdArgsList.add("false");
        cmdArgsList.add("-bulkload");
        cmdArgsList.add("false");
        String[] cmdArgs = new String[cmdArgsList.size()];
        return cmdArgsList.toArray(cmdArgs);
    }

    private static List<String> getDiffTablesWithCrcCmdParams(String outsubdir) {
        ArrayList<String> cmdArgsList = new ArrayList<String>();
        cmdArgsList.add("hadoop");
        cmdArgsList.add("com.mapr.db.mapreduce.tools.DiffTablesWithCrc");
        cmdArgsList.add("-src");
        cmdArgsList.add(SRC_PATH);
        cmdArgsList.add("-dst");
        cmdArgsList.add(DST_PATH);
        if (columnSpec != null) {
            cmdArgsList.add("-columns");
            cmdArgsList.add(columnSpec);
        }
        cmdArgsList.add("-outdir");
        cmdArgsList.add(OUTDIR + "/" + outsubdir);
        return cmdArgsList;
    }

    private static void copytable(Configuration config) throws Exception {
        String[] args = TestDiffCrc.getCopyTableCmdParams();
        ProcessBuilder proc = new ProcessBuilder(args);
        proc.inheritIO();
        System.out.println("Running command " + proc.command());
        Process p = proc.start();
        p.waitFor();
        System.out.println("CopyTable process exit code: " + p.exitValue());
        Assert.assertEquals((long)0L, (long)p.exitValue());
    }

    private static void runDiffTablesWithCrc(Configuration config, String columnSpec, String outsubdir) throws Exception {
        List<String> diffArgs = TestDiffCrc.getDiffTablesWithCrcCmdParams(outsubdir);
        File diffcrcOutput = new File(OUTDIR + "/syslog");
        ProcessBuilder proc = new ProcessBuilder(diffArgs);
        proc.inheritIO();
        System.out.println("Running command " + proc.command());
        Process p = proc.start();
        p.waitFor();
        System.out.println("DiffTablesWithCrc process exit code: " + p.exitValue());
        Assert.assertEquals((long)0L, (long)p.exitValue());
    }

    static int ls(String path) throws IOException, InterruptedException {
        ProcessBuilder proc = new ProcessBuilder("hadoop", "fs", "-ls", path);
        Process p = proc.start();
        p.waitFor();
        return p.exitValue();
    }

    static void rmDir(String path) throws IOException, InterruptedException {
        ProcessBuilder proc = new ProcessBuilder("hadoop", "fs", "-rmr", path);
        Process p = proc.start();
        p.waitFor();
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("This test difftableswithcrc with single column family.\nUsage:   hadoop com.mapr.db.mapreduce.test.TestDiffCrc -src srcTablePath -dst dstTablePath -outdir outputDirectory\n");
        System.exit(-1);
    }

    private static boolean doCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                TestDiffCrc.printUsage(null);
                continue;
            }
            if (args[i].equalsIgnoreCase("-src")) {
                SRC_PATH = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                DST_PATH = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-outdir")) {
                OUTDIR = args[++i];
                continue;
            }
            TestDiffCrc.printUsage("Unrecognized parameter " + args[i]);
        }
        return true;
    }

    public int run(String[] args) throws Exception {
        if (!TestDiffCrc.doCommandLine(args)) {
            return -1;
        }
        Configuration conf = this.getConf();
        try {
            this.setuptable();
            TestDiffCrc.copytable(conf);
            Thread.sleep(20000L);
            TestDiffCrc.runDiffTablesWithCrc(conf, null, "samerun1");
            System.out.println("Should contain no diffs for all column families. Check the formatresult at " + OUTDIR);
            int ret = TestDiffCrc.ls(OUTDIR + "/samerun1/OpsForDstTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            ret = TestDiffCrc.ls(OUTDIR + "/samerun1/OpsForSrcTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            this.insertChanges(srcTable, dstTable);
            TestDiffCrc.runDiffTablesWithCrc(conf, null, "diffrun2");
            System.out.println("Should contain difference from all columnspec. Check the formatresult at " + OUTDIR);
            TestDiffCrc.formatResult(OUTDIR + "/diffrun2/OpsForDstTable", OUTDIR + "/OpsForDstTableDecoded");
            TestDiffCrc.formatResult(OUTDIR + "/diffrun2/OpsForSrcTable", OUTDIR + "/OpsForSrcTableDecoded");
            System.out.println("Import the result from the diff results at " + OUTDIR);
            TestDiffCrc.importFromDir(dstTable.getPath().toString(), OUTDIR + "/diffrun2/OpsForDstTable");
            TestDiffCrc.importFromDir(srcTable.getPath().toString(), OUTDIR + "/diffrun2/OpsForSrcTable");
            System.out.println("Run diff again after imported results");
            TestDiffCrc.runDiffTablesWithCrc(conf, null, "samerun3");
            System.out.println("There should be no difference. Check the formatresult at " + OUTDIR);
            ret = TestDiffCrc.ls(OUTDIR + "/samerun3/OpsForDstTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            ret = TestDiffCrc.ls(OUTDIR + "/samerun3/OpsForSrcTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] args) {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new TestDiffCrc(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }
}

