/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cldb.tools;

import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CreateContainerGroups
extends Configured
implements Tool {
    public final int DEFAULT_CREATE_CONTAINER_GROUP_COUNT = 10;
    public final int MAX_CREATE_CONTAINER_GROUP_COUNT = 10;
    int ret = 0;
    String volumeName = "";
    int count = 0;

    public int run(String[] args) throws Exception {
        this.parseArgs(args);
        this.validateArgs();
        return this.sendRequestToCLDB(this.volumeName, this.count);
    }

    public void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                CreateContainerGroups.Usage(null);
                continue;
            }
            if (args[i].equalsIgnoreCase("-volumename")) {
                this.volumeName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-count")) {
                try {
                    this.count = Integer.valueOf(args[++i]);
                }
                catch (Exception e) {
                    System.err.println("Invalid value for count. Considering default value(10) for count to create CG.");
                    this.count = 10;
                }
                continue;
            }
            CreateContainerGroups.Usage("Invalid arguments '" + args[i] + "'");
        }
    }

    public void validateArgs() {
        if (this.volumeName == null && this.volumeName.length() > 0) {
            CreateContainerGroups.Usage("volume name needed");
        }
        if (this.count < 1) {
            System.err.println("Invalid value for count. Considering default value(10) for count to create CG.");
            this.count = 10;
        }
        if (this.count > 10) {
            System.err.println("Invalid value for count. Considering max value(32) for count to create CG.");
            this.count = 10;
        }
    }

    public static void Usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: -volumename <volume name> -count <+ve, default:10, max:32>\n");
        System.exit(1);
    }

    public int sendRequestToCLDB(String volumeName, int count) {
        try {
            byte[] data = null;
            CLDBProto.CGCreateRequest.Builder cgCreateReq = CLDBProto.CGCreateRequest.newBuilder().setVolumeName(volumeName).setCount(count);
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.CGCreateProc.getNumber(), (MessageLite)cgCreateReq.build(), CLDBProto.CGCreateResponse.class);
            if (data == null) {
                System.err.println("Exception while sending RPC to CLDB, Received null.");
                return -1;
            }
            CLDBProto.CGCreateResponse resp = CLDBProto.CGCreateResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                System.err.println(resp.getErrorMsg() + " Error: " + resp.getStatus());
            } else {
                System.err.println(resp.getErrorMsg());
                System.err.println("Container Group IDs : " + Arrays.toString(resp.getContainerGroupIdsList().toArray()));
            }
            return resp.getStatus();
        }
        catch (Exception e) {
            System.err.println("Exception while sending RPC to CLDB" + e);
            e.printStackTrace();
            return -1;
        }
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CreateContainerGroups(), (String[])args);
            System.err.println(ret == 0 ? "Success" : "Failure");
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }
}

