/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools.impl;

import com.mapr.db.impl.IdCodec;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.mapreduce.tools.impl.FailureTracker;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.SequenceFileRowColCodec;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.ojai.Document;
import org.ojai.Value;

public class DiffTableCounterCollector {
    long numTable1Rows;
    long numTable2Rows;
    long numTable1DiffRows;
    long numTable2DiffRows;
    FileSystem fs;
    Path opsForTable1Path;
    Path opsForTable2Path;
    boolean shouldExit;
    private Configuration conf;
    SequenceFile.Writer opsForTable1File;
    SequenceFile.Writer opsForTable2File;
    private FailureTracker tracker;

    public DiffTableCounterCollector(FileSystem fs, Path opsForTable1Path, Path opsForTable2Path, Configuration conf, FailureTracker tracker) {
        this.fs = fs;
        this.opsForTable1Path = opsForTable1Path;
        this.opsForTable2Path = opsForTable2Path;
        this.conf = conf;
        this.tracker = tracker;
    }

    public long getTable1TotalRows() {
        return this.numTable1Rows;
    }

    public long getTable2TotalRows() {
        return this.numTable2Rows;
    }

    public long getTable1DiffRows() {
        return this.numTable1DiffRows;
    }

    public long getTable2DiffRows() {
        return this.numTable2DiffRows;
    }

    public boolean incTable1Rows() {
        ++this.numTable1Rows;
        return this.tracker.shouldExit();
    }

    public boolean incTable2Rows() {
        ++this.numTable2Rows;
        return this.tracker.shouldExit();
    }

    public boolean shouldExit() {
        return this.tracker.shouldExit();
    }

    boolean incTable1RowsMismatch(DBDocumentImpl doc) throws IOException {
        ++this.numTable1DiffRows;
        this.tracker.notifyMismatch();
        if (this.opsForTable2File == null) {
            SequenceFile.Writer.Option path = SequenceFile.Writer.file((Path)this.opsForTable2Path);
            SequenceFile.Writer.Option keyClass = SequenceFile.Writer.keyClass(ByteBufWritableComparable.class);
            SequenceFile.Writer.Option valueClass = SequenceFile.Writer.valueClass(ByteBufWritableComparable.class);
            SequenceFile.Writer.Option compression = SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
            this.opsForTable2File = SequenceFile.createWriter((Configuration)this.conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{path, keyClass, valueClass, compression});
        }
        ByteBufWritableComparable key = new ByteBufWritableComparable(IdCodec.encode((Value)doc.getId()));
        ByteBufWritableComparable value = new ByteBufWritableComparable(SequenceFileRowColCodec.encode((Document)doc));
        this.opsForTable2File.append((Writable)key, (Writable)value);
        return this.tracker.shouldExit();
    }

    boolean incTable2RowsMismatch(DBDocumentImpl doc) throws IOException {
        ++this.numTable2DiffRows;
        this.tracker.notifyMismatch();
        if (this.opsForTable1File == null) {
            SequenceFile.Writer.Option path = SequenceFile.Writer.file((Path)this.opsForTable1Path);
            SequenceFile.Writer.Option keyClass = SequenceFile.Writer.keyClass(ByteBufWritableComparable.class);
            SequenceFile.Writer.Option valueClass = SequenceFile.Writer.valueClass(ByteBufWritableComparable.class);
            SequenceFile.Writer.Option compression = SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
            this.opsForTable1File = SequenceFile.createWriter((Configuration)this.conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{path, keyClass, valueClass, compression});
        }
        ByteBufWritableComparable key = new ByteBufWritableComparable(IdCodec.encode((Value)doc.getId()));
        ByteBufWritableComparable value = new ByteBufWritableComparable(SequenceFileRowColCodec.encode((Document)doc));
        this.opsForTable1File.append((Writable)key, (Writable)value);
        return this.tracker.shouldExit();
    }

    public void close() throws IOException {
        if (this.opsForTable1File != null) {
            this.opsForTable1File.close();
            this.opsForTable1File = null;
        }
        if (this.opsForTable2File != null) {
            this.opsForTable2File.close();
            this.opsForTable2File = null;
        }
    }

    public void incTable1NumDiffRows() {
        ++this.numTable1DiffRows;
    }

    public void incTable2NumDiffRows() {
        ++this.numTable2DiffRows;
    }
}

