/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.index.tools;

import com.mapr.db.Admin;
import com.mapr.db.MetaTable;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.mapreduce.tools.impl.FailureTracker;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.scan.ScanRange;
import com.mapr.db.util.DocumentProjectionComparator;
import com.mapr.db.util.IndexKeyComponentValueExtractor;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Dbserver;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyIndex
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(VerifyIndex.class);
    public static final String NAME = "verifyindex";
    String PriPath;
    Table priTable = null;
    String IndexName;
    String IndexFid;
    Table indexTable = null;
    int defaultNumThreads = 16;
    int numThreads = 0;
    List<String> indexFields = null;
    List<String> includedFields = null;
    List<String> allFields = null;
    String[] allFieldsArr = null;
    boolean exitOnFirstDiff;
    List<IndexFieldDesc> indexFieldList = new ArrayList<IndexFieldDesc>();
    Dbserver.SIndexInfo.Version siVersion = Dbserver.SIndexInfo.Version.v6dot0;
    static final String priPathConf = "maprdb.mapreduce.inputtable";
    static final String indexNameConf = "indexNameconf";
    static final String exitOnFirstDiffConf = "exitonfirstdiffconf";

    public static String getOpsForTableName(String table) {
        return "OpsForTable_" + table;
    }

    public int run(String[] args) throws Exception {
        this.parseArgs(args);
        boolean ret = false;
        Configuration conf = this.getConf();
        this.setupConfParmas(conf);
        DoVerifyIndex dowork = new DoVerifyIndex();
        return dowork.runVerify();
    }

    private void setupConfParmas(Configuration conf) {
        conf.set(priPathConf, this.PriPath);
        conf.set(indexNameConf, this.IndexName);
        conf.setBoolean(exitOnFirstDiffConf, this.exitOnFirstDiff);
    }

    public void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                VerifyIndex.Usage(null);
                continue;
            }
            if (args[i].equalsIgnoreCase("-path")) {
                this.PriPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-index")) {
                this.IndexName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                this.numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-first_exit")) {
                this.exitOnFirstDiff = true;
                continue;
            }
            VerifyIndex.Usage(null);
        }
        if (this.PriPath == null || this.IndexName == null) {
            VerifyIndex.Usage("missing table path or index name.");
        }
        if (this.numThreads == 0) {
            this.numThreads = this.defaultNumThreads;
        }
        Configuration conf = new Configuration();
        MapRFileSystem mfs = (MapRFileSystem)FileSystem.get((Configuration)conf);
        Admin admin = MapRDBImpl.newAdmin((Configuration)conf);
        Path priPath = new Path(this.PriPath);
        if (!mfs.exists(priPath)) {
            VerifyIndex.Usage("table: " + priPath + " does not exist");
        }
        if (!mfs.isJsonTable(priPath)) {
            VerifyIndex.Usage("table: " + priPath + " is not a JSON table. This tool only supports JSON tables");
        }
        Collection tableIndexList = admin.getTableIndexes(priPath);
        boolean isIndexFind = false;
        for (IndexDesc rd : tableIndexList) {
            Integer[] cfIdSet;
            Map cfQual;
            List famattr;
            if (!rd.getIndexName().equals(this.IndexName)) continue;
            if (rd.getIndexInfo().hasVersion()) {
                this.siVersion = rd.getIndexInfo().getVersion();
            }
            this.IndexFid = rd.getIndexFid();
            List idxFieldsDesc = rd.getIndexedFields();
            Collection incFieldsDesc = rd.getIncludedFields();
            this.indexFieldList.addAll(idxFieldsDesc);
            this.indexFields = new ArrayList<String>();
            this.includedFields = new ArrayList<String>();
            this.allFields = new ArrayList<String>();
            for (IndexFieldDesc id : idxFieldsDesc) {
                famattr = mfs.listColumnFamily(new Path(this.PriPath), false);
                cfQual = MapRDBTableImplHelper.getOneCFQualifier((FieldPath)id.getFieldPath(), (Map)MapRDBTableImplHelper.getCFIdPathMap((List)famattr), (boolean)false);
                cfIdSet = cfQual.keySet().toArray(new Integer[1]);
                for (Dbserver.ColumnFamilyAttr cf : famattr) {
                    if (cf.getSchFamily().getId() != cfIdSet[0].intValue()) continue;
                    this.indexFields.add(MapRDBTableImplHelper.cfQualifierToJsonPath((String)cf.getSchFamily().getName(), (String)((FieldPath)cfQual.get(cfIdSet[0])).asPathString(), (List)famattr).toString());
                }
            }
            for (IndexFieldDesc id : incFieldsDesc) {
                famattr = mfs.listColumnFamily(new Path(this.PriPath), false);
                cfQual = MapRDBTableImplHelper.getOneCFQualifier((FieldPath)id.getFieldPath(), (Map)MapRDBTableImplHelper.getCFIdPathMap((List)famattr), (boolean)false);
                cfIdSet = cfQual.keySet().toArray(new Integer[1]);
                for (Dbserver.ColumnFamilyAttr cf : famattr) {
                    if (cf.getSchFamily().getId() != cfIdSet[0].intValue()) continue;
                    this.includedFields.add(MapRDBTableImplHelper.cfQualifierToJsonPath((String)cf.getSchFamily().getName(), (String)((FieldPath)cfQual.get(cfIdSet[0])).asPathString(), (List)famattr).toString());
                }
            }
            this.allFields.addAll(this.indexFields);
            this.allFields.addAll(this.includedFields);
            this.allFieldsArr = this.allFields.toArray(new String[this.allFields.size()]);
            isIndexFind = true;
            this.indexTable = MapRDBImpl.getIndexTable((IndexDesc)rd);
            break;
        }
        if (!isIndexFind) {
            VerifyIndex.Usage("Index: " + this.IndexName + " is not a valid index of table " + this.PriPath);
        }
    }

    public static void Usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: verifyindex -path <table path> -index <index name>\n[-first_exit] Exit when first difference is found.\n[-numthreads <numThreads> (default:16)]\n");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)conf, (Tool)new VerifyIndex(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    private class DoVerifyIndex
    implements FailureTracker {
        private final Logger logger = LoggerFactory.getLogger(DoVerifyIndex.class);

        private DoVerifyIndex() {
        }

        public int runVerify() throws Exception {
            int i;
            VerifyIndex.this.priTable = MapRDBImpl.getTable((String)VerifyIndex.this.PriPath);
            TabletInfo[] tablets = VerifyIndex.this.priTable.getTabletInfos();
            TabletInfo[] itablets = VerifyIndex.this.indexTable.getTabletInfos();
            ExecutorService executor = Executors.newFixedThreadPool(VerifyIndex.this.numThreads);
            VerifyThread[] threads = tablets.length > itablets.length ? new VerifyThread[tablets.length] : new VerifyThread[itablets.length];
            VerifyIndexCounter c = new VerifyIndexCounter();
            for (int i2 = 0; i2 < tablets.length; ++i2) {
                threads[i2] = new VerifyThread(tablets[i2].getCondition(), c, true);
                executor.execute(threads[i2]);
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            ExecutorService executor2 = Executors.newFixedThreadPool(VerifyIndex.this.numThreads);
            for (i = 0; i < threads.length; ++i) {
                if (threads[i].isCompleted()) continue;
                this.logger.error("Thread '{}' did not finish successfully. Exiting...", (Object)i);
                return -1;
            }
            for (i = 0; i < itablets.length; ++i) {
                threads[i] = new VerifyThread(itablets[i].getCondition(), c, false);
                executor2.execute(threads[i]);
            }
            executor2.shutdown();
            while (!executor2.isTerminated()) {
            }
            for (i = 0; i < threads.length; ++i) {
                if (threads[i].isCompleted()) continue;
                this.logger.error("Thread '{}' did not finish successfully. Exiting...", (Object)i);
                return -1;
            }
            if (VerifyIndex.this.exitOnFirstDiff) {
                System.out.println("Exiting after finding first mismatch");
                return -1;
            }
            int numMissingIndexEntries = c.getNumMissingEntriesInIndex();
            int numMissingPrimaryEntries = c.getNumMissingEntriesInPrimary();
            int numMismatchEntries = c.getNumMissMatchEntries();
            System.out.println("Number of rows in table but not in index: " + numMissingIndexEntries);
            System.out.println("Number of rows in index but not in table: " + numMissingPrimaryEntries);
            System.out.println("Mismatch row count: " + numMismatchEntries);
            if (c.getNumMissMatchEntries() == 0) {
                assert (c.getNumMissingEntriesInIndex() == 0);
                assert (c.getNumMissingEntriesInPrimary() == 0);
                return 0;
            }
            return -1;
        }

        @Override
        public void notifyMismatch() {
        }

        @Override
        public boolean shouldExit() {
            return VerifyIndex.this.exitOnFirstDiff;
        }

        class VerifyThread
        implements Runnable {
            private boolean completed = false;
            Iterator<Document> itr = null;
            VerifyIndexCounter vic = null;
            boolean ScanPri = false;

            public boolean isCompleted() {
                return this.completed;
            }

            public VerifyThread(QueryCondition qcond, VerifyIndexCounter vc, boolean direction) throws Exception {
                this.itr = direction ? VerifyIndex.this.priTable.find(qcond, VerifyIndex.this.allFieldsArr).iterator() : ((MapRDBIndexImpl)VerifyIndex.this.indexTable).setDecodeIndexValues(true).find(qcond).iterator();
                this.vic = vc;
                this.ScanPri = direction;
            }

            @Override
            public void run() {
                if (VerifyIndex.this.siVersion == Dbserver.SIndexInfo.Version.v6dot0) {
                    this.run6dot0();
                } else {
                    this.run6dot1();
                }
            }

            public void run6dot0() {
                Document siDoc = null;
                Document priDoc = null;
                if (this.ScanPri) {
                    while (this.itr.hasNext()) {
                        priDoc = this.itr.next();
                        ConditionImpl c = MapRDBImpl.newCondition().and();
                        c.is("_id", QueryCondition.Op.EQUAL, priDoc.getIdString());
                        for (IndexFieldDesc fd : VerifyIndex.this.indexFieldList) {
                            FieldPath fp = fd.getFieldPath();
                            if (priDoc.getValue(fp) == null) {
                                c.notExists(fp);
                                continue;
                            }
                            switch (priDoc.getValue(fp).getType()) {
                                case NULL: {
                                    c.typeOf(fp, Value.Type.NULL);
                                    break;
                                }
                                case STRING: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getString(fp));
                                    break;
                                }
                                case BYTE: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getByte(fp));
                                    break;
                                }
                                case SHORT: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getShort(fp));
                                    break;
                                }
                                case INT: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getInt(fp));
                                    break;
                                }
                                case LONG: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getLong(fp));
                                    break;
                                }
                                case FLOAT: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getFloat(fp));
                                    break;
                                }
                                case DOUBLE: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getDouble(fp));
                                    break;
                                }
                                case DECIMAL: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getDecimal(fp));
                                    break;
                                }
                                case DATE: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getDate(fp));
                                    break;
                                }
                                case TIME: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getTime(fp));
                                    break;
                                }
                                case TIMESTAMP: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getTimestamp(fp));
                                    break;
                                }
                                case INTERVAL: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getInterval(fp));
                                    break;
                                }
                                case BINARY: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getBinary(fp));
                                    break;
                                }
                                case BOOLEAN: {
                                    c.is(fp, QueryCondition.Op.EQUAL, priDoc.getBoolean(fp));
                                }
                            }
                        }
                        c.close().build();
                        MetaTable indexMetaTable = VerifyIndex.this.indexTable.getMetaTable();
                        List scanRanges = indexMetaTable.getScanRanges((QueryCondition)c);
                        boolean idFound = false;
                        for (ScanRange range : scanRanges) {
                            Value indexDocId;
                            ConditionImpl finalCond = null;
                            finalCond = !range.getCondition().isEmpty() ? MapRDBImpl.newCondition().and().condition((QueryCondition)c).condition(range.getCondition()).close().build() : c;
                            Iterator siitr = VerifyIndex.this.indexTable.find((QueryCondition)finalCond).iterator();
                            if (!siitr.hasNext()) continue;
                            siDoc = (Document)siitr.next();
                            Value priDocId = priDoc.getId();
                            if (priDocId.equals(indexDocId = siDoc.getId())) {
                                if (idFound) {
                                    throw new DBException("Multiple documents with the same Id found in different Scan Ranges!");
                                }
                                idFound = true;
                                if (siitr.hasNext()) {
                                    throw new DBException("Multiple documents with the same Id found within one Scan Range!");
                                }
                                if (!siDoc.equals(priDoc)) continue;
                                break;
                            }
                            throw new DBException("Verify process fails with wrong matching result!");
                        }
                        if (idFound) continue;
                        this.vic.incrementNumMissingEntriesInIndex();
                        System.out.println("Missing Document in Index:\n" + priDoc + "\n");
                        if (!VerifyIndex.this.exitOnFirstDiff) continue;
                        this.completed = true;
                        return;
                    }
                } else {
                    while (this.itr.hasNext()) {
                        siDoc = this.itr.next();
                        Value _idValue = siDoc.getId();
                        priDoc = VerifyIndex.this.priTable.findById(_idValue, VerifyIndex.this.allFieldsArr);
                        if (priDoc == null) {
                            this.vic.incrementNumMissingEntriesInPrimary();
                            System.out.println("Unknown Document in Index:\n" + siDoc + "\n");
                            if (!VerifyIndex.this.exitOnFirstDiff) continue;
                            this.completed = true;
                            return;
                        }
                        if (priDoc.equals(siDoc)) continue;
                        this.vic.incrementNumMissMatchEntries();
                        System.out.println("Mismatch Document Found!\nTable side --> " + priDoc + "\nIndex side --> " + siDoc);
                        if (!VerifyIndex.this.exitOnFirstDiff) continue;
                        this.completed = true;
                        return;
                    }
                }
                this.completed = true;
            }

            void printValues(Object[] l) {
                for (Object o : l) {
                    if (o instanceof IndexKeyComponentValueExtractor.MissingValue) {
                        System.out.print("MissingValue, ");
                        continue;
                    }
                    System.out.print(o + ", ");
                }
                System.out.println("");
            }

            private void addCondition(QueryCondition c, String idxField, Object value) {
                if (value instanceof KeyValue) {
                    Object objValue;
                    value = objValue = ((KeyValue)value).getObject();
                }
                if (value == null) {
                    c.typeOf(idxField, Value.Type.NULL);
                } else if (value instanceof IndexKeyComponentValueExtractor.MissingValue) {
                    c.notExists(idxField);
                } else if (value instanceof String) {
                    String s = (String)value;
                    if (s.equals("$JSONMISSINGVALUE")) {
                        c.notExists(idxField);
                    } else {
                        c.is(idxField, QueryCondition.Op.EQUAL, (String)value);
                    }
                } else if (value instanceof Byte) {
                    c.is(idxField, QueryCondition.Op.EQUAL, ((Byte)value).byteValue());
                } else if (value instanceof Short) {
                    c.is(idxField, QueryCondition.Op.EQUAL, ((Short)value).shortValue());
                } else if (value instanceof Integer) {
                    c.is(idxField, QueryCondition.Op.EQUAL, ((Integer)value).intValue());
                } else if (value instanceof Long) {
                    c.is(idxField, QueryCondition.Op.EQUAL, ((Long)value).longValue());
                } else if (value instanceof Float) {
                    c.is(idxField, QueryCondition.Op.EQUAL, ((Float)value).floatValue());
                } else if (value instanceof Double) {
                    c.is(idxField, QueryCondition.Op.EQUAL, ((Double)value).doubleValue());
                } else if (value instanceof ODate) {
                    c.is(idxField, QueryCondition.Op.EQUAL, (ODate)value);
                } else if (value instanceof OTime) {
                    c.is(idxField, QueryCondition.Op.EQUAL, (OTime)value);
                } else if (value instanceof OTimestamp) {
                    c.is(idxField, QueryCondition.Op.EQUAL, (OTimestamp)value);
                } else if (value instanceof Boolean) {
                    c.is(idxField, QueryCondition.Op.EQUAL, ((Boolean)value).booleanValue());
                } else if (value instanceof byte[]) {
                    c.is(idxField, QueryCondition.Op.EQUAL, ByteBuffer.wrap((byte[])value));
                } else if (value instanceof ByteBuffer) {
                    c.is(idxField, QueryCondition.Op.EQUAL, (ByteBuffer)value);
                } else if (value instanceof List) {
                    c.equals(idxField, (List)value);
                } else if (value instanceof Map) {
                    c.equals(idxField, (Map)value);
                } else {
                    DoVerifyIndex.this.logger.error("Object of type " + value.getClass() + " not handled in adding index condition");
                }
            }

            private void addIndexConditions(QueryCondition c, List<String> idxFields, Object[] values) {
                int i = 0;
                for (String idxField : idxFields) {
                    this.addCondition(c, idxField, values[i++]);
                }
            }

            private QueryCondition createIndexCondition(String docId, List<String> idxFields, Object[] vc) {
                ConditionImpl c = MapRDBImpl.newCondition().and();
                c.is("_id", QueryCondition.Op.EQUAL, docId);
                this.addIndexConditions((QueryCondition)c, idxFields, vc);
                c.close().build();
                return c;
            }

            private QueryCondition createPrimaryCondition(DocumentProjectionComparator dpc, Document doc, List<String> idxFields) {
                Object[] prep = dpc.getIndexFieldsPreprocessedForConditionGeneration();
                String commonPrefix = prep[0] == null ? null : (String)prep[0];
                HashMap m1 = (HashMap)prep[1];
                HashMap m2 = (HashMap)prep[2];
                List indexedValues = doc.getList("$idx");
                ConditionImpl c = MapRDBImpl.newCondition().and();
                c.is("_id", QueryCondition.Op.EQUAL, doc.getIdString());
                if (m1.size() > 0) {
                    c.elementAnd(commonPrefix);
                    for (String k : m1.keySet()) {
                        this.addCondition((QueryCondition)c, k, indexedValues.get((Integer)m1.get(k)));
                    }
                    c.close();
                }
                for (String k : m2.keySet()) {
                    this.addCondition((QueryCondition)c, k, indexedValues.get((Integer)m2.get(k)));
                }
                c.close().build();
                return c;
            }

            public void run6dot1() {
                DocumentProjectionComparator dpc = new DocumentProjectionComparator(VerifyIndex.this.indexFields, VerifyIndex.this.includedFields);
                String[] includedFieldsArr = VerifyIndex.this.includedFields.toArray(new String[VerifyIndex.this.includedFields.size()]);
                if (this.ScanPri) {
                    while (this.itr.hasNext()) {
                        Document priDoc = this.itr.next();
                        String priDocId = priDoc.getIdString();
                        for (Object[] vc : dpc.getIndexKeyComponentValueCombinations(priDoc)) {
                            QueryCondition c = this.createIndexCondition(priDocId, VerifyIndex.this.indexFields, vc);
                            ArrayList<Document> siDL = new ArrayList<Document>();
                            int siDocCount = 0;
                            try (DocumentStream stream = VerifyIndex.this.indexTable.find(c, includedFieldsArr);){
                                for (Document siDoc : stream) {
                                    if (++siDocCount > 1) {
                                        DoVerifyIndex.this.logger.error("Got multiple index rows for indexFields");
                                        int i = 0;
                                        for (String idxField : VerifyIndex.this.indexFields) {
                                            DoVerifyIndex.this.logger.error("IndexFields " + idxField + " value " + vc[i++]);
                                        }
                                        throw new DBException("Index contains redundant entries for primary table document with 'id' = '" + priDoc.getId() + "'");
                                    }
                                    siDL.add(siDoc);
                                }
                            }
                            if (siDocCount == 0) {
                                throw new DBException("Index lacks entries for primary table document with 'id' = '" + priDoc.getId() + "'");
                            }
                            if (dpc.matchIncluded(priDoc, (Document)siDL.get(0))) continue;
                            throw new DBException("Index contains redundant entries for primary table document with 'id' = '" + priDoc.getId() + "'");
                        }
                    }
                } else {
                    while (this.itr.hasNext()) {
                        Document siDoc = this.itr.next();
                        QueryCondition c = this.createPrimaryCondition(dpc, siDoc, VerifyIndex.this.indexFields);
                        int docCounter = 0;
                        try (DocumentStream stream = VerifyIndex.this.priTable.find(c, includedFieldsArr);){
                            for (Document priDoc : stream) {
                                if (++docCounter <= 1 && dpc.matchIncluded(priDoc, siDoc)) continue;
                                this.vic.incrementNumMissMatchEntries();
                                System.out.println("Mismatch Document Found!\nTable side --> " + priDoc + "\nIndex side --> " + siDoc);
                                if (!VerifyIndex.this.exitOnFirstDiff) continue;
                                this.completed = true;
                                return;
                            }
                        }
                        if (docCounter != 0) continue;
                        this.vic.incrementNumMissingEntriesInPrimary();
                        System.out.println("Unknown Document in Index:\n" + siDoc + "\n");
                        if (!VerifyIndex.this.exitOnFirstDiff) continue;
                        this.completed = true;
                        return;
                    }
                }
                this.completed = true;
            }
        }
    }

    class VerifyIndexCounter {
        private AtomicInteger numMissingEntriesInPrimary = new AtomicInteger(0);
        private AtomicInteger numMissingEntriesInIndex = new AtomicInteger(0);
        private AtomicInteger numMissMatchEntries = new AtomicInteger(0);

        VerifyIndexCounter() {
        }

        int getNumMissingEntriesInPrimary() {
            return this.numMissingEntriesInPrimary.get();
        }

        void incrementNumMissingEntriesInPrimary() {
            this.numMissingEntriesInPrimary.incrementAndGet();
        }

        int getNumMissingEntriesInIndex() {
            return this.numMissingEntriesInIndex.get();
        }

        void incrementNumMissingEntriesInIndex() {
            this.numMissingEntriesInIndex.incrementAndGet();
        }

        int getNumMissMatchEntries() {
            return this.numMissMatchEntries.get();
        }

        void incrementNumMissMatchEntries() {
            this.numMissMatchEntries.incrementAndGet();
        }
    }

    public static enum COUNTERS {
        NUM_ROWS_MISSING_IN_PRIMARY,
        NUM_ROWS_MISSING_IN_INDEX,
        NUM_ROWS_MISMATCH;

    }
}

