/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.JsonTable;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.tools.DiffTables;
import com.mapr.db.mapreduce.tools.Export;
import com.mapr.db.mapreduce.tools.Import;
import com.mapr.db.mapreduce.tools.ImportJSON;
import com.mapr.db.tests.tableops.TestMapRDBWithCluster;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.IntegrationTest;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTest.class})
public class TestImportUtility
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestImportUtility.class);
    private static final String jsonFilePath = "/tmp/jsonpath/jsonfile";
    private static final String jsonPath = "/tmp/jsonpath";
    private static final String srcTableName = "/srctab1";
    private static final String destTableName = "/desttab1";
    private static final String exportPath = "/tmp/export1";
    private static final String DIFF_TABLE_OUT_DIR = "/tmp/difftable";

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        DBTests.deleteTables((String[])new String[]{srcTableName});
        DBTests.deleteTables((String[])new String[]{destTableName});
    }

    void rmDir(String path) throws IOException, InterruptedException {
        ProcessBuilder proc = new ProcessBuilder("hadoop", "fs", "-rm", "-r", "-f", path);
        Process p = proc.start();
        p.waitFor();
    }

    void compareTables(String srcTable, String dstTable, boolean expectedPass) throws Exception {
        String outdir = DIFF_TABLE_OUT_DIR;
        this.rmDir(outdir);
        int ret = ToolRunner.run(null, (Tool)new DiffTables(), (String[])new String[]{"-src", srcTable, "-dst", dstTable, "-outdir", outdir, "-mapreduce", "false"});
        if (expectedPass) {
            Assert.assertEquals((long)0L, (long)ret);
        }
    }

    void verifyIO(String tblpath) {
        JsonTable tbl = MapRDBImpl.getTable((String)tblpath);
        Document r = MapRDBImpl.newDocument();
        r.set("f1", "abc");
        tbl.insertOrReplace("key", r);
        tbl.flush();
        Document d = tbl.findById("key");
        Assert.assertEquals((Object)"abc", (Object)d.getString("f1"));
    }

    private void runImportJSON(String destTab, String blkLoad, String textFilePath) throws Exception {
        int ret = ToolRunner.run(null, (Tool)new ImportJSON(), (String[])new String[]{"-src", textFilePath, "-dst", destTab, "-bulkload", "false", "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    public void runExport(String srcTable) throws Exception {
        int ret = ToolRunner.run(null, (Tool)new Export(), (String[])new String[]{"-src", srcTable, "-dst", exportPath, "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private void runImport(String destTable, String blkLoad) throws Exception {
        int ret = ToolRunner.run(null, (Tool)new Import(), (String[])new String[]{"-src", exportPath, "-dst", destTable, "-bulkload", blkLoad, "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private void initializeWithData(FileSystem fs, Configuration conf) throws Exception {
        Document d = TestMapRDBWithCluster.getMedRecord();
        if (fs.exists(new Path(jsonPath))) {
            fs.delete(new Path(jsonPath), true);
        }
        FSDataOutputStream os = fs.create(new Path(jsonFilePath), true);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
        for (int i = 0; i < 10; ++i) {
            d.set("_id", "k" + i);
            writer.write(d.toString() + "\n");
        }
        writer.close();
    }

    private void runTest(String blkLoadOption, String textFilePath) throws Exception {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.initializeWithData(fs, conf);
        MapRDBTableImpl srcTab = (MapRDBTableImpl)DBTests.createOrReplaceTable((String)srcTableName);
        this.runImportJSON(srcTab.getPath().toString(), blkLoadOption, textFilePath);
        if (fs.exists(new Path(exportPath))) {
            fs.delete(new Path(exportPath), true);
        }
        srcTab.setPrivateOption(BaseJsonTable.TablePrivateOption.PRESERVE_TIMESTAMP, true);
        this.runExport(srcTab.getPath().toString());
        _logger.info("Run import");
        JsonTable destTab = DBTests.createOrReplaceTable((String)destTableName);
        this.runImport(destTab.getPath().toString(), blkLoadOption);
        _logger.info("Comparing tables");
        this.compareTables(srcTab.getPath().toString(), destTab.getPath().toString(), true);
        _logger.info("VerifyIO");
        this.verifyIO(srcTab.getPath().toString());
        this.verifyIO(destTab.getPath().toString());
    }

    private void runNegativeTests() throws Exception {
        String filePath;
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(new Path(filePath = "/tmp/fpath"))) {
            fs.delete(new Path(filePath), true);
        }
        int ret = ToolRunner.run(null, (Tool)new ImportJSON(), (String[])new String[]{"-src", filePath, "-dst", "/tmp/dtab1", "-bulkload", "false", "-mapreduce", "false"});
        Assert.assertEquals((long)1L, (long)ret);
    }

    @Test
    public void testExportImportNonMRWithDiffTable() throws Exception {
        this.runTest("false", jsonPath);
    }

    @Test
    public void testExportImportNonMRWithDiffTableWithBulkLoad() throws Exception {
        this.runTest("true", jsonPath);
    }

    @Test
    public void testExportImportNonMRWithDiffTableAndFile() throws Exception {
        this.runTest("false", jsonFilePath);
    }

    @Test
    public void testExportImportWithProjectionNonMR() throws Exception {
        String exportTableName = "/export_table";
        String importTableName1 = "/import_table1";
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(new Path(exportPath))) {
            fs.delete(new Path(exportPath), true);
        }
        ImmutableMap cfMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"a.b.c.d", (Object)"cf3", (Object)"x.y");
        JsonTable exportTable = DBTests.createOrReplaceTable((String)exportTableName, (Map)cfMap);
        JsonTable importTable1 = DBTests.createOrReplaceTable((String)importTableName1, (Map)cfMap);
        Document doc1 = MapRDBImpl.newDocument();
        doc1.set("a.b.d", "abd").set("a.b.c.d.e", "abcde").set("a.c.d", "acd").set("x.y.z", "xyz");
        Document doc2 = MapRDBImpl.newDocument();
        doc2.set("a.b.d", "abd").set("a.b.c.d.f", "abcdf").set("a.c.e", "ace").set("x.y.w", "xyw");
        int numRecords = 10000;
        int endKey = numRecords * 2;
        int count = numRecords;
        ArrayList<CallSite> list1 = new ArrayList<CallSite>();
        ArrayList<CallSite> list2 = new ArrayList<CallSite>();
        while (count++ < endKey) {
            String key = "key" + Integer.toString(count);
            if (count % 2 == 1) {
                exportTable.insertOrReplace(key, doc1);
                list1.add((CallSite)((Object)key));
                continue;
            }
            exportTable.insertOrReplace(key, doc2);
            list2.add((CallSite)((Object)key));
        }
        try {
            int ret = ToolRunner.run(null, (Tool)new Export(), (String[])new String[]{"-src", exportTable.getPath().toString(), "-dst", exportPath, "-columns", "a.b.c.d.e", "-mapreduce", "false"});
            Assert.assertEquals((long)0L, (long)ret);
        }
        catch (Exception e) {
            Assert.fail((String)"IExport should not fail here");
        }
        try {
            int ret = ToolRunner.run(null, (Tool)new Import(), (String[])new String[]{"-src", exportPath, "-dst", importTable1.getPath().toString(), "-bulkload", "false", "-mapreduce", "false"});
            Assert.assertEquals((long)0L, (long)ret);
        }
        catch (Exception e) {
            Assert.fail((String)"Import should not fail here");
        }
        DocumentStream ds = importTable1.find();
        for (Document readDoc : ds) {
            Assert.assertTrue((boolean)list1.contains(readDoc.getIdString()));
            Assert.assertTrue((!list2.contains(readDoc.getIdString()) ? 1 : 0) != 0);
            Assert.assertEquals((Object)"abcde", (Object)readDoc.getString("a.b.c.d.e"));
            Assert.assertNull((Object)readDoc.getValue("a.b.d"));
            Assert.assertNull((Object)readDoc.getValue("a.c.d"));
            Assert.assertNull((Object)readDoc.getValue("x.y.z"));
        }
        ds.close();
    }

    @Test
    public void testUtilitiesWithFailure() throws Exception {
        this.runNegativeTests();
    }
}

