/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.mapr.db.Admin;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.mapreduce.impl.DiffTableUtils;
import com.mapr.db.mapreduce.impl.DocEmptySerialization;
import com.mapr.db.mapreduce.impl.MapReduceUtilMethods;
import com.mapr.db.mapreduce.impl.TableSplit;
import com.mapr.db.mapreduce.tools.DiffTablesMeta;
import com.mapr.db.mapreduce.tools.impl.DiffTableComparator;
import com.mapr.db.mapreduce.tools.impl.DiffTableCounterCollector;
import com.mapr.db.mapreduce.tools.impl.DiffTableNonMR;
import com.mapr.db.mapreduce.tools.impl.DocScanner;
import com.mapr.db.mapreduce.tools.impl.FailureTracker;
import com.mapr.db.mapreduce.tools.impl.RowDiff;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.SequenceFileRowColCodec;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffTables
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(DiffTables.class);
    public static final String NAME = "difftables";
    String table1Path;
    String table2Path;
    String columnSpec;
    boolean mapreduce = true;
    int defaultNumThreads = 16;
    int numThreads = 0;
    String outDir;
    boolean exitOnFirstDiff;
    boolean cmpMeta = true;
    boolean excludedEmbeddedFamily = true;
    boolean getDeletes = true;
    String splitKeyRangeFileName = null;
    String includeKeyRangeFileName = null;
    static final String table1PathConf = "maprdb.mapreduce.inputtable";
    static final String table2PathConf = "table2Pathconf";
    static final String outDirConf = "outdirconf";
    static final String columnSpecConf = "columnspeccconf";
    static final String exitOnFirstDiffConf = "exitonfirstdiffconf";
    static final String getDeletesConf = "getdeletesconf";

    public static String getOpsForTableName(String table) {
        return "OpsForTable_" + table;
    }

    private Job setupJobWithMR() throws Exception {
        Configuration conf = this.getConf();
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), DocEmptySerialization.class.getName()});
        conf.setBoolean("maprdb.get.deletes", this.getDeletes);
        Job job = Job.getInstance((Configuration)conf, (String)NAME);
        job.setJarByClass(DiffTables.class);
        job.setInputFormatClass(TableInputFormat.class);
        job.setMapperClass(DiffTableMapper.class);
        job.setOutputKeyClass(ByteBufWritableComparable.class);
        job.setOutputValueClass(ByteBufWritableComparable.class);
        SequenceFileOutputFormat.setOutputPath((Job)job, (Path)new Path(conf.get(outDirConf)));
        job.setSpeculativeExecution(false);
        LazyOutputFormat.setOutputFormatClass((Job)job, SequenceFileOutputFormat.class);
        job.setNumReduceTasks(0);
        return job;
    }

    public int run(String[] args) throws Exception {
        this.parseArgs(args);
        int ret = 0;
        if (this.cmpMeta && (ret = this.compareMeta(args)) != 0) {
            return ret;
        }
        if (!this.cmpMeta) {
            System.out.println("Skip metadata check.");
        }
        Configuration conf = this.getConf();
        this.setupConfParmas(conf);
        if (!this.mapreduce) {
            DiffTableNonMR d = new DiffTableNonMR(conf, this.table1Path, this.table2Path, this.columnSpec, this.numThreads, this.exitOnFirstDiff, this.excludedEmbeddedFamily, this.outDir, this.getDeletes);
            return d.runWithoutMapReduce();
        }
        Job job = this.setupJobWithMR();
        int n = ret = job.waitForCompletion(true) ? 0 : 1;
        if (ret == 0) {
            Path srcDir = new Path(this.outDir);
            FileSystem fs = srcDir.getFileSystem(conf);
            boolean mv1 = DiffTableUtils.copyFileWithPrefix((FileSystem)fs, (Path)srcDir, (Path)new Path(this.outDir + "/OpsForDstTable"), (Configuration)conf, (String)"OpsForDstTable", (Logger)LOG);
            boolean mv2 = DiffTableUtils.copyFileWithPrefix((FileSystem)fs, (Path)srcDir, (Path)new Path(this.outDir + "/OpsForSrcTable"), (Configuration)conf, (String)"OpsForSrcTable", (Logger)LOG);
            if (!mv1 || !mv2) {
                LOG.info("Failed to move output diff results " + this.outDir + " into its sub folder opsForSrc or opsForDst");
            }
            Counters counters = job.getCounters();
            Counter srcMismatch = counters.findCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_SRC);
            Counter dstMismatch = counters.findCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_DST);
            System.out.print("Mapreduce job " + (ret == 0 ? "completed. " : "failed. "));
            boolean printcounter = false;
            if (ret == 0) {
                if (srcMismatch.getValue() == 0L && dstMismatch.getValue() == 0L) {
                    System.out.println("The tables match.");
                } else {
                    System.out.println("The tables mismatch.");
                    printcounter = true;
                }
            } else {
                printcounter = true;
            }
            if (printcounter) {
                System.out.println(srcMismatch.getDisplayName() + ":" + srcMismatch.getValue() + "; " + dstMismatch.getDisplayName() + ":" + dstMismatch.getValue() + ". Please check diff in " + this.outDir);
            }
        }
        return ret;
    }

    private int compareMeta(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)this.getConf(), (Tool)new DiffTablesMeta(true), (String[])args);
        if (ret == 1) {
            System.out.println("ERROR: Metadata is different.");
            System.out.println("To skip metadata comparison, use the option -cmpmeta false.");
            System.exit(ret);
        } else if (ret == 0) {
            System.out.println("DiffTablesMeta completed. Metadata of the two tables is same.");
        }
        return ret;
    }

    private void setupConfParmas(Configuration conf) {
        conf.set(table1PathConf, this.table1Path);
        conf.set(table2PathConf, this.table2Path);
        conf.set(outDirConf, this.outDir);
        if (this.columnSpec != null) {
            conf.set(columnSpecConf, this.columnSpec);
            conf.set("maprdb.mapreduce.fieldpath", this.columnSpec);
        }
        conf.setBoolean(exitOnFirstDiffConf, this.exitOnFirstDiff);
        conf.setBoolean(getDeletesConf, this.getDeletes);
        conf.setBoolean("maprdb.exclude.embedded", this.excludedEmbeddedFamily);
        if (this.splitKeyRangeFileName != null) {
            conf.set("splitfilename", this.splitKeyRangeFileName);
        }
        if (this.includeKeyRangeFileName != null) {
            conf.set("includedregionfilename", this.includeKeyRangeFileName);
        }
    }

    public void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                DiffTables.Usage(null);
                continue;
            }
            if (args[i].equalsIgnoreCase("-src")) {
                this.table1Path = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                this.table2Path = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                this.columnSpec = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-exclude_embedded_families")) {
                this.excludedEmbeddedFamily = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapreduce")) {
                this.mapreduce = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                this.numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-outdir")) {
                this.outDir = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-first_exit")) {
                this.exitOnFirstDiff = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-cmpmeta")) {
                this.cmpMeta = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-split_keyrange")) {
                this.splitKeyRangeFileName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-keyrange_included")) {
                this.includeKeyRangeFileName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-getdeletes")) {
                this.getDeletes = Boolean.valueOf(args[++i]);
                continue;
            }
            DiffTables.Usage(null);
        }
        if (this.table1Path == null || this.table2Path == null) {
            DiffTables.Usage("missing -src or -dst table path.");
        }
        if (this.table1Path.equals(this.table2Path)) {
            System.out.println("Source table " + this.table1Path + " and destination table " + this.table2Path + " refers to the same table");
            System.exit(-1);
        }
        if (this.outDir == null) {
            DiffTables.Usage("Missing -outdir");
        }
        if (this.mapreduce && this.numThreads != 0) {
            System.out.println("numthreads = " + this.numThreads);
            DiffTables.Usage("-numthreads can't be specified when -mapreduce is true");
        }
        if (!this.mapreduce && this.numThreads == 0) {
            this.numThreads = this.defaultNumThreads;
        }
        Configuration conf = new Configuration();
        MapRFileSystem mfs = (MapRFileSystem)FileSystem.get((Configuration)conf);
        Path t1Path = new Path(this.table1Path);
        Path t2Path = new Path(this.table2Path);
        if (!mfs.exists(t1Path)) {
            DiffTables.Usage(t1Path + " does not exist");
        }
        if (!mfs.isJsonTable(t1Path)) {
            DiffTables.Usage(t1Path + " is not a JSON table. This tool only supports JSON tables");
        }
        if (!mfs.exists(t2Path)) {
            DiffTables.Usage(t2Path + " does not exist");
        }
        if (!mfs.isJsonTable(t2Path)) {
            DiffTables.Usage(t2Path + " is not a JSON table. This tool only supports JSON tables");
        }
        this.columnSpec = MapReduceUtilMethods.processColumnSpec((String)this.columnSpec, (String)this.table1Path);
        LOG.info("Comparing {} column families from {} to {}.", new Object[]{this.columnSpec != null ? this.columnSpec : "all", this.table1Path, this.table2Path});
        Admin admin = MapRDBImpl.newAdmin();
        TableDescriptorImpl desc = (TableDescriptorImpl)admin.getTableDescriptor(this.table1Path);
        if (desc.isStream()) {
            this.excludedEmbeddedFamily = true;
        }
    }

    public static void Usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: difftables -src <source table path> -dst <destination table path> -outdir <output directory>\n[-first_exit] Exit when first difference is found.\n[-columns <JSON Fieldpaths specified as \"path1,...,pathN\">]\n[-exclude_embedded_families <true|false>] (default: false)\n  Don't include the  other column families with path embedded in specified columns\n[-mapreduce] <true|false> (default: true)]\n[-numthreads <numThreads> (default:16, valid only when -mapreduce is false)]\n[-cmpmeta <true|false> (default: true)]\n");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)conf, (Tool)new DiffTables(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    public static class DiffTableMapper
    extends Mapper<Value, DBDocumentImpl, ByteBufWritableComparable, ByteBufWritableComparable>
    implements FailureTracker {
        private DocScanner scanner2 = null;
        private Path opsTable1Dir = null;
        private Path opsTable2Dir = null;
        private DiffTableCounterCollector counter = null;
        private DiffTableComparator comparator = null;
        private boolean excludedEmbeddedFamily = true;
        private boolean exitOnFirstMismatch = false;
        private boolean shouldExit = false;
        private boolean getDeletes = true;
        private MultipleOutputs<ByteBufWritableComparable, ByteBufWritableComparable> mos = null;

        public void setup(Mapper.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            String table2Path = conf.get(DiffTables.table2PathConf);
            this.getDeletes = conf.getBoolean(DiffTables.getDeletesConf, true);
            String[] fields = null;
            String cols = conf.get(DiffTables.columnSpecConf);
            if (cols != null) {
                fields = cols.split(",");
            }
            TableSplit currentSplit = (TableSplit)context.getInputSplit();
            this.scanner2 = new DocScanner(table2Path, (QueryCondition)currentSplit.getCondition(), fields, this.excludedEmbeddedFamily, this.getDeletes);
            String outDir = conf.get(DiffTables.outDirConf);
            Path[] paths = DiffTableUtils.createOutputDirs((FileSystem)FileSystem.get((Configuration)conf), (Path)new Path(outDir));
            this.opsTable1Dir = paths[0];
            this.opsTable2Dir = paths[1];
            this.excludedEmbeddedFamily = conf.getBoolean("maprdb.exclude.embedded", true);
            this.counter = new DiffTableCounterCollector(FileSystem.get((Configuration)conf), this.opsTable1Dir, this.opsTable2Dir, conf, this);
            this.comparator = new DiffTableComparator(conf.get(DiffTables.table1PathConf), conf.get(DiffTables.table2PathConf), cols, this.excludedEmbeddedFamily, this.counter);
            this.exitOnFirstMismatch = conf.getBoolean(DiffTables.exitOnFirstDiffConf, false);
            if (this.mos == null) {
                this.mos = new MultipleOutputs((TaskInputOutputContext)context);
            }
        }

        public void map(Value key, DBDocumentImpl value, Mapper.Context context) throws IOException, InterruptedException {
            this.counter.incTable1Rows();
            ArrayList<RowDiff> diffs = this.comparator.processNextRowAndReturnDiff(value, this.scanner2);
            this.writeDiffsToFile(diffs, context);
        }

        private void writeDiffsToFile(ArrayList<RowDiff> diffs, Mapper.Context context) throws IOException, InterruptedException {
            for (RowDiff d : diffs) {
                if (d.forSrc != null) {
                    this.writeDiff(d.key, d.forSrc, true, context);
                }
                if (d.forDst == null) continue;
                this.writeDiff(d.key, d.forDst, false, context);
            }
        }

        private void writeDiff(ByteBufWritableComparable key, ByteBufWritableComparable value, boolean isSrc, Mapper.Context context) throws IOException, InterruptedException {
            LOG.debug(this.opsTable1Dir.getName());
            LOG.debug(this.opsTable2Dir.getName());
            if (isSrc) {
                this.mos.write((Object)key, (Object)value, this.opsTable1Dir.getName());
                context.getCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_SRC).increment(1L);
            } else {
                this.mos.write((Object)key, (Object)value, this.opsTable2Dir.getName());
                context.getCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_DST).increment(1L);
            }
        }

        @Override
        public void notifyMismatch() {
            if (this.exitOnFirstMismatch) {
                this.shouldExit = true;
            }
        }

        @Override
        public boolean shouldExit() {
            return this.shouldExit;
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            ArrayList<RowDiff> remainingRows = this.dumpRemainingRows();
            LOG.debug("cleanup find " + remainingRows.size() + " remaining rows");
            this.writeDiffsToFile(remainingRows, context);
            this.mos.close();
        }

        private ArrayList<RowDiff> dumpRemainingRows() {
            DBDocumentImpl doc2 = this.scanner2.getNext();
            ArrayList<RowDiff> diffs = new ArrayList<RowDiff>();
            while (doc2 != null) {
                RowDiff d = new RowDiff();
                d.key = new ByteBufWritableComparable(IdCodec.encode((Value)doc2.getId()));
                d.forSrc = new ByteBufWritableComparable(SequenceFileRowColCodec.encode((Document)doc2));
                diffs.add(d);
                doc2 = this.scanner2.getNext();
            }
            return diffs;
        }
    }

    public static enum COUNTERS {
        NUM_ROWS_MISMATCH_IN_SRC,
        NUM_ROWS_MISMATCH_IN_DST;

    }
}

