/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools.impl;

import com.mapr.db.Admin;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.FamilyDescriptorImpl;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.mapreduce.tools.impl.DiffTableCounterCollector;
import com.mapr.db.mapreduce.tools.impl.DocScanner;
import com.mapr.db.mapreduce.tools.impl.RowDiff;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueWithTS;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SequenceFileRowColCodec;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.db.rowcol.TimeDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mortbay.log.Log;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;

public class DiffTableComparator {
    String table1Path;
    String table2Path;
    String[] projectedFields;
    public DiffTableCounterCollector counter;
    Map<Integer, FieldPath> table1IdToPathMap;
    Map<Integer, FieldPath> table2IdToPathMap;
    Map<FieldPath, Integer> table1PathToIdMap;
    Map<FieldPath, Integer> table2PathToIdMap;
    Map<Integer, List<String>> table1projectionMap;
    Map<Integer, List<String>> table2projectionMap;

    public DiffTableComparator(String table1Path, String table2Path, String projectedFields, boolean excludeEmbeddedFamilies, DiffTableCounterCollector c) throws IOException {
        this.table1Path = table1Path;
        this.table2Path = table2Path;
        this.projectedFields = projectedFields != null ? projectedFields.split(",") : null;
        this.counter = c;
        this.table1IdToPathMap = new HashMap<Integer, FieldPath>();
        this.table2IdToPathMap = new HashMap<Integer, FieldPath>();
        this.table1PathToIdMap = new HashMap<FieldPath, Integer>();
        this.table2PathToIdMap = new HashMap<FieldPath, Integer>();
        DiffTableComparator.getIdToFieldPathMap(table1Path, this.table1IdToPathMap, this.table1PathToIdMap);
        DiffTableComparator.getIdToFieldPathMap(table2Path, this.table2IdToPathMap, this.table2PathToIdMap);
        if (this.projectedFields != null) {
            this.table1projectionMap = MapRDBTableImplHelper.getMultipleCFQualifiers(this.table1PathToIdMap, (boolean)excludeEmbeddedFamilies, (String[])this.projectedFields);
            this.table2projectionMap = MapRDBTableImplHelper.getMultipleCFQualifiers(this.table2PathToIdMap, (boolean)excludeEmbeddedFamilies, (String[])this.projectedFields);
        } else {
            this.table1projectionMap = null;
            this.table2projectionMap = null;
        }
        Log.debug((String)"DifftableComparator table1 {}, id to path map {}", (Object)table1Path, this.table1IdToPathMap);
        Log.debug((String)"DifftableComparator table2 {}, id to path map {}", (Object)table2Path, this.table2IdToPathMap);
    }

    public Map<Integer, FieldPath> getTable1IdToFieldPathMap() {
        return this.table1IdToPathMap;
    }

    public Map<Integer, FieldPath> getTable2IdToFieldPathMap() {
        return this.table2IdToPathMap;
    }

    public Map<FieldPath, Integer> getTable1PathToIdPathMap() {
        return this.table1PathToIdMap;
    }

    public Map<FieldPath, Integer> getTable2PathToIdPathMap() {
        return this.table2PathToIdMap;
    }

    public static void getIdToFieldPathMap(String table, Map<Integer, FieldPath> idToPathMap, Map<FieldPath, Integer> pathToIdMap) throws IOException {
        Admin admin = MapRDBImpl.newAdmin();
        TableDescriptor d = admin.getTableDescriptor(table);
        List families = d.getFamilies();
        for (FamilyDescriptor family : families) {
            Integer familyId = ((FamilyDescriptorImpl)family).getId();
            idToPathMap.put(familyId, family.getJsonFieldPath());
            pathToIdMap.put(family.getJsonFieldPath(), familyId);
        }
    }

    private RowDiff createRowDiff(Value k, DBDocumentImpl doc1, DBDocumentImpl doc2) {
        ByteBufWritableComparable key = new ByteBufWritableComparable(IdCodec.encode((Value)k));
        ByteBufWritableComparable value1 = null;
        ByteBufWritableComparable value2 = null;
        if (doc1 != null) {
            value1 = new ByteBufWritableComparable(SequenceFileRowColCodec.encode((Document)doc1));
        }
        if (doc2 != null) {
            value2 = new ByteBufWritableComparable(SequenceFileRowColCodec.encode((Document)doc2));
        }
        RowDiff d = new RowDiff();
        d.key = key;
        d.forSrc = value1;
        d.forDst = value2;
        return d;
    }

    public ArrayList<RowDiff> processNextRowAndReturnDiff(DBDocumentImpl doc1, DocScanner scan2) throws IOException {
        ArrayList<RowDiff> diffs = new ArrayList<RowDiff>();
        DBDocumentImpl doc2 = scan2.peekNext();
        boolean shouldExit = false;
        if (doc2 == null) {
            this.counter.incTable1NumDiffRows();
            diffs.add(this.createRowDiff(doc1.getId(), null, doc1));
            return diffs;
        }
        ByteBuffer k1 = IdCodec.encode((Value)doc1.getId());
        ByteBuffer k2 = IdCodec.encode((Value)doc2.getId());
        boolean recordMatched = false;
        boolean doMatch = true;
        while (doMatch) {
            shouldExit = this.counter.shouldExit();
            if (shouldExit) {
                return diffs;
            }
            int res = k1.compareTo(k2);
            if (res == 0) {
                recordMatched = this.matchDocs(doc1, doc2);
                if (!recordMatched) {
                    this.counter.incTable1NumDiffRows();
                    this.counter.incTable2NumDiffRows();
                    diffs.add(this.createRowDiff(doc1.getId(), doc2, doc1));
                }
                scan2.consume();
                this.counter.incTable2Rows();
                return diffs;
            }
            if (res < 0) {
                this.counter.incTable1NumDiffRows();
                diffs.add(this.createRowDiff(doc1.getId(), null, doc1));
                recordMatched = false;
                return diffs;
            }
            recordMatched = false;
            doMatch = true;
            scan2.consume();
            this.counter.incTable2Rows();
            this.counter.incTable2NumDiffRows();
            diffs.add(this.createRowDiff(doc2.getId(), doc2, null));
            doc2 = scan2.peekNext();
            if (doc2 != null) continue;
            doMatch = false;
        }
        if (!recordMatched) {
            this.counter.incTable1NumDiffRows();
            diffs.add(this.createRowDiff(doc1.getId(), null, doc1));
        }
        return diffs;
    }

    public boolean processNextRow(DBDocumentImpl doc1, DocScanner scan) throws IOException {
        DBDocumentImpl doc2 = scan.peekNext();
        boolean shouldExit = false;
        if (doc2 == null) {
            this.counter.incTable1RowsMismatch(doc1);
            return true;
        }
        ByteBuffer k1 = IdCodec.encode((Value)doc1.getId());
        ByteBuffer k2 = IdCodec.encode((Value)doc2.getId());
        boolean recordMatched = false;
        boolean doMatch = true;
        while (doMatch) {
            shouldExit = this.counter.shouldExit();
            if (shouldExit) {
                return true;
            }
            int res = k1.compareTo(k2);
            if (res == 0) {
                scan.consume();
                this.counter.incTable2Rows();
                recordMatched = this.matchDocs(doc1, doc2);
                if (!recordMatched) {
                    this.counter.incTable1RowsMismatch(doc1);
                    this.counter.incTable2RowsMismatch(doc2);
                }
                return !recordMatched;
            }
            if (res < 0) {
                this.counter.incTable1RowsMismatch(doc1);
                recordMatched = false;
                return true;
            }
            recordMatched = false;
            doMatch = true;
            scan.consume();
            this.counter.incTable2Rows();
            boolean bl = doMatch = !this.counter.incTable2RowsMismatch(doc2);
            doc2 = scan.peekNext();
            if (doc2 != null) continue;
            doMatch = false;
        }
        if (!recordMatched) {
            this.counter.incTable1RowsMismatch(doc1);
        }
        return !recordMatched;
    }

    private boolean matchDocs(DBDocumentImpl doc1, DBDocumentImpl doc2) throws IOException {
        SerializedFamilyInfo[] doc1Data = RowcolCodec.encode((Document)doc1, this.table1PathToIdMap, (boolean)false, (boolean)true);
        SerializedFamilyInfo[] doc2Data = RowcolCodec.encode((Document)doc2, this.table2PathToIdMap, (boolean)false, (boolean)true);
        Arrays.sort(doc1Data, new DBDocComparator(this.table1IdToPathMap));
        Arrays.sort(doc2Data, new DBDocComparator(this.table2IdToPathMap));
        int index1 = 0;
        int index2 = 0;
        while (index1 < doc1Data.length && index2 < doc2Data.length) {
            FieldPath family2;
            SerializedFamilyInfo i1 = null;
            SerializedFamilyInfo i2 = null;
            if (index1 < doc1Data.length) {
                i1 = doc1Data[index1];
                if (this.table1projectionMap != null && !this.table1projectionMap.containsKey(i1.getFamilyId())) {
                    ++index1;
                    continue;
                }
            }
            if (index2 < doc2Data.length) {
                i2 = doc2Data[index2];
                if (this.table2projectionMap != null && !this.table2projectionMap.containsKey(i2.getFamilyId())) {
                    ++index2;
                    continue;
                }
            }
            if (i1 == null) {
                if (i2.getAction() != SerializationAction.NO_ACTION) {
                    return false;
                }
                ++index1;
                ++index2;
                continue;
            }
            if (i2 == null) {
                if (i1.getAction() != SerializationAction.NO_ACTION) {
                    return false;
                }
                ++index1;
                ++index2;
                continue;
            }
            FieldPath family1 = this.table1IdToPathMap.get(i1.getFamilyId());
            int res = family1.compareTo(family2 = this.table2IdToPathMap.get(i2.getFamilyId()));
            if (res == 0) {
                DBDocumentImpl familyDoc1 = null;
                DBDocumentImpl familyDoc2 = null;
                if (i1.getAction() != SerializationAction.NO_ACTION) {
                    familyDoc1 = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)i1.getByteBuffer(), null, (boolean)true, (boolean)true, (boolean)true);
                }
                if (i2.getAction() != SerializationAction.NO_ACTION) {
                    familyDoc2 = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)i2.getByteBuffer(), null, (boolean)true, (boolean)true, (boolean)true);
                }
                ++index1;
                ++index2;
                if (familyDoc1 == null && familyDoc2 == null) continue;
                if (familyDoc1 == null && familyDoc2 != null) {
                    if (!TimeDescriptor.isCreateTimeValid((KeyValue)familyDoc2)) continue;
                    return false;
                }
                if (familyDoc1 != null && familyDoc2 == null) {
                    if (!TimeDescriptor.isCreateTimeValid((KeyValue)familyDoc1)) continue;
                    return false;
                }
                boolean matched = false;
                if (this.table1projectionMap == null || this.table1projectionMap.get(i1.getFamilyId()).isEmpty()) {
                    matched = KeyValueWithTS.equals((KeyValue)familyDoc1, (KeyValue)familyDoc2, (boolean)true, (boolean)false, null, null);
                } else {
                    List<String> projectedQuals1 = this.table1projectionMap.get(i1.getFamilyId());
                    List<String> projectedQuals2 = this.table2projectionMap.get(i2.getFamilyId());
                    if (projectedQuals1.size() != projectedQuals2.size()) {
                        String err = "Mismatch in number of projected fieldpaths for tables " + this.table1Path + " and " + this.table2Path;
                        throw new IOException(err);
                    }
                    for (String fp : projectedQuals1) {
                        if (!projectedQuals2.contains(fp)) {
                            String err = "Projection fieldpath mismatch for " + fp + " in Column Family with ID" + i2.getFamilyId() + " in table " + this.table2Path;
                            throw new IOException(err);
                        }
                        matched = KeyValueWithTS.equals((KeyValue)familyDoc1.getKeyValue(fp), (KeyValue)familyDoc2.getKeyValue(fp), (boolean)true, (boolean)false, null, null);
                        if (matched) continue;
                        return false;
                    }
                }
                if (matched) continue;
                return false;
            }
            if (res < 0) {
                if (i1.getAction() != SerializationAction.NO_ACTION) {
                    return false;
                }
                ++index1;
                continue;
            }
            if (i2.getAction() != SerializationAction.NO_ACTION) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    class DBDocComparator
    implements Comparator<SerializedFamilyInfo> {
        private Map<Integer, FieldPath> pathMap;

        DBDocComparator(Map<Integer, FieldPath> pathMap) {
            this.pathMap = pathMap;
        }

        @Override
        public int compare(SerializedFamilyInfo arg0, SerializedFamilyInfo arg1) {
            return this.pathMap.get(arg0.getFamilyId()).compareTo(this.pathMap.get(arg1.getFamilyId()));
        }
    }
}

