/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.index.test;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.index.tools.VerifyIndex;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.IntegrationTest;
import java.util.Iterator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTest.class})
public class TestVerifyIndex
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestVerifyIndex.class);

    public static boolean verifyIndex(String tableName, String indexName) throws Exception {
        assert (tableName != null);
        assert (indexName != null);
        String[] args = new String[]{"-path", tableName, "-index", indexName};
        int ret = 0;
        try {
            ret = ToolRunner.run((Tool)new VerifyIndex(), (String[])args);
            if (ret != 0) {
                return false;
            }
        }
        catch (Exception e) {
            _logger.error("VerifyIndex for table " + tableName + ", index" + indexName + " failed: " + e.getMessage());
            throw e;
        }
        return true;
    }

    @Test
    public void testArrayIndexNullValueAndVerifyIndex_MAPRDB_1321() throws Exception {
        String tName = "testArrayIndexNullValueAndVerifyIndex-table";
        String i1Name = "testArrayIndexNullValueAndVerifyIndex-index";
        Table t1 = DBTests.createOrGetTable((String)tName);
        String[] indexedFields = new String[]{"a"};
        DBTests.createIndex((String)tName, (String)i1Name, (String[])indexedFields);
        Document d1 = MapRDBImpl.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().setNull("b")});
        Document d2 = MapRDBImpl.newDocument().setArray("a", new Object[]{null, MapRDBImpl.newDocument().setNull("b"), MapRDBImpl.newDocument().set("c", "ac")});
        t1.insertOrReplace("key1", d1);
        t1.insertOrReplace("key2", d2);
        t1.flush();
        DBTests.waitForIndexFlush((String)tName);
        IndexDesc i1Desc = DBTests.getIndex((Table)t1, (String)i1Name);
        Table i1 = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = i1.find();
        Iterator itr = ds.iterator();
        int count = 0;
        assert (itr.hasNext());
        block8: while (itr.hasNext()) {
            Document readDoc = (Document)itr.next();
            switch (readDoc.getIdString()) {
                case "key1": {
                    ++count;
                    continue block8;
                }
                case "key2": {
                    ++count;
                    continue block8;
                }
            }
            Assert.fail((String)"Invalid key");
        }
        Assert.assertEquals((long)2L, (long)count);
        ds.close();
        assert (TestVerifyIndex.verifyIndex(t1.getPath().toString(), i1Name));
    }

    @Test
    public void testNonArrayIndexMapAndArrayIndexKeyValue_MAPRDB_1345() throws Exception {
        String tName = "testNonArrayIndexMapAndArrayIndexKeyValue-table";
        String i1Name = "testNonArrayIndexMapAndArrayIndexKeyValue-index";
        Table t1 = DBTests.createOrGetTable((String)tName);
        String[] indexedFields = new String[]{"a"};
        DBTests.createIndex((String)tName, (String)i1Name, (String[])indexedFields);
        Document d1 = MapRDBImpl.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", "ab1"), MapRDBImpl.newDocument().set("c", "ac1")});
        Document d2 = MapRDBImpl.newDocument().set("a.b.c", "abc1");
        Document d3 = MapRDBImpl.newDocument().set("a", 10);
        t1.insertOrReplace("key1", d1);
        t1.insertOrReplace("key2", d2);
        t1.insertOrReplace("key3", d3);
        t1.flush();
        DBTests.waitForIndexFlush((String)tName);
        IndexDesc i1Desc = DBTests.getIndex((Table)t1, (String)i1Name);
        Table i1 = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = i1.find();
        Iterator itr = ds.iterator();
        int count = 0;
        assert (itr.hasNext());
        block10: while (itr.hasNext()) {
            Document readDoc = (Document)itr.next();
            switch (readDoc.getIdString()) {
                case "key1": {
                    ++count;
                    continue block10;
                }
                case "key2": {
                    count += 2;
                    continue block10;
                }
                case "key3": {
                    count += 4;
                    continue block10;
                }
            }
            Assert.fail((String)"Invalid key");
        }
        Assert.assertEquals((long)7L, (long)count);
        ds.close();
        assert (TestVerifyIndex.verifyIndex(t1.getPath().toString(), i1Name));
    }

    @Test
    public void testHashPartitionedArrayIndex() throws Exception {
        String tName = "testHashPartitionedArrayIndex-table";
        String iName = "testHashPartitionedArrayIndex-index";
        Table t = DBTests.createOrGetTable((String)tName);
        Document d1 = MapRDBImpl.newDocument().set("a.b", "ab1").set("a.c", "ac1");
        Document d2 = MapRDBImpl.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", "ab1").set("c", "ac2"), MapRDBImpl.newDocument().set("b", "ab2").set("c", "ac1"), MapRDBImpl.newDocument().set("b", "ab1").set("c", "ac1")});
        Document d3 = MapRDBImpl.newDocument().set("a.b", "ab2").set("a.c", "ac1");
        t.insertOrReplace("key1", d1);
        t.insertOrReplace("key2", d2);
        t.insertOrReplace("key3", d1);
        t.insertOrReplace("key4", d2);
        t.insertOrReplace("key5", d3);
        String[] indexedFields = new String[]{"a[].b"};
        String[] includedFields = new String[]{"a[].c"};
        DBTests.createIndex((String)tName, (String)iName, (String[])indexedFields, (String[])includedFields, (boolean)true, (int)10);
        DBTests.waitForIndexFlush((Path)t.getPath());
        assert (TestVerifyIndex.verifyIndex(t.getPath().toString(), iName));
    }
}

