/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.mapreduce.tools.DiffTables;
import com.mapr.db.mapreduce.tools.Export;
import com.mapr.db.mapreduce.tools.Import;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.annotations.IntegrationTest;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.types.ODate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTest.class})
public class TestCFMapping {
    private static final Logger _logger = LoggerFactory.getLogger(TestCFMapping.class);
    private static final String SRC_TABLE_NAME = "/srctable";
    private static final String DST_TABLE_NAME = "/dsttable";
    private static final String exportPath = "/expPath1";
    private static final String DIFF_TABLE_OUT_DIR = "/df1";

    private Document getRecord() {
        Document d = MapRDBImpl.newDocument();
        d.set("a.b", 234);
        d.set("a.c.x1", "str1").set("a.c.x2", new Double(22.22).doubleValue()).set("p", ODate.parse((String)"2015-08-15")).set("e.f1", false).setArray("e.f2", new int[]{22, 33, 44});
        return d;
    }

    public void runExport(String srcTable) throws Exception {
        int ret = ToolRunner.run(null, (Tool)new Export(), (String[])new String[]{"-src", srcTable, "-dst", exportPath, "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private void runImport(String destTable) throws Exception {
        int ret = ToolRunner.run(null, (Tool)new Import(), (String[])new String[]{"-src", exportPath, "-dst", destTable, "-bulkload", "-false", "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    void rmDir(String path) throws IOException, InterruptedException {
        ProcessBuilder proc = new ProcessBuilder("hadoop", "fs", "-rmr", path);
        Process p = proc.start();
        p.waitFor();
    }

    void compareTables(String srcTable, String dstTable, boolean expectedPass) throws Exception {
        String outdir = DIFF_TABLE_OUT_DIR;
        this.rmDir(outdir);
        int ret = ToolRunner.run(null, (Tool)new DiffTables(), (String[])new String[]{"-src", srcTable, "-dst", dstTable, "-outdir", outdir, "-mapreduce", "false"});
        if (expectedPass) {
            Assert.assertEquals((long)0L, (long)ret);
        }
    }

    @Test
    public void testMCFMapping() throws Exception {
        ImmutableMap sm = ImmutableMap.of((Object)"p", (Object)"p", (Object)"a.c", (Object)"a.c", (Object)"e", (Object)"e");
        ImmutableMap dm = ImmutableMap.of((Object)"a.c", (Object)"a.c", (Object)"e", (Object)"e", (Object)"p", (Object)"p");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)sm);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)dm);
        Document d = this.getRecord();
        for (int i = 0; i < 3; ++i) {
            srcTable.insertOrReplace("key" + i, d);
        }
        srcTable.flush();
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(new Path(exportPath))) {
            fs.delete(new Path(exportPath), true);
        }
        this.runExport(srcTable.getPath().toString());
        this.runImport(dstTable.getPath().toString());
        _logger.info("Comparing tables");
        this.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), true);
    }
}

