/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools.impl;

import com.mapr.db.Admin;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.mapreduce.impl.ClusterTablePath;
import com.mapr.db.mapreduce.impl.DiffTableUtils;
import com.mapr.db.mapreduce.impl.DocEmptySerialization;
import com.mapr.db.mapreduce.impl.MapReduceUtilMethods;
import com.mapr.db.mapreduce.impl.RangeChecksumInputFormat;
import com.mapr.db.mapreduce.impl.TableSplit;
import com.mapr.db.mapreduce.tools.impl.DBDocComparator;
import com.mapr.db.mapreduce.tools.impl.DiffTableComparator;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueWithTS;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Checksum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;

public class RangeChecksum
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(RangeChecksum.class);
    public static final String NAME = "ComputeChecksum";
    public static final int ISROOT = 1;
    public static final int ISNOTROOT = 0;
    public static final int ISARRAYELEMENT = 1;
    public static final int ISNOTARRAYELEMENT = 0;
    static String jobDisplayName = null;
    static String tableName = null;
    static String inputSplitKeyRangeFileName = null;
    static boolean needSplit = false;
    static String subKeyRangeFileName = null;
    static String includeKeyRangeFileName = null;
    static String columnSpec = null;
    static boolean excludedEmbeddedFamily;
    static String outputDir;
    static boolean exit;
    static boolean diffChecksum;

    public static String getOutputPathName(String dir, String table) {
        return new String(dir + "/" + table.replace("/", "").replace(":", "") + ".checksum");
    }

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException, URISyntaxException {
        if (!RangeChecksum.doCommandLine(args)) {
            return null;
        }
        conf.set("maprdb.mapreduce.inputtable", tableName);
        ClusterTablePath ctPath = ClusterTablePath.parse((String)tableName);
        if (ctPath.clusterName != null) {
            conf.set("fs.defaultFS", ctPath.getClusterUri().toString());
            String hsAddress = DiffTableUtils.getServiceAddress((Configuration)conf, (String)ctPath.getClusterUri().toString(), (String)"historyserver");
            String rmAddress = DiffTableUtils.getServiceAddress((Configuration)conf, (String)ctPath.getClusterUri().toString(), (String)"resourcemanager");
            if (rmAddress != null) {
                conf.set("yarn.resourcemanager.address", rmAddress);
            }
            if (hsAddress != null) {
                conf.set("mapreduce.jobhistory.address", hsAddress);
            }
            LOG.info((Object)("Job for table(" + tableName + ") will be submitted to cluster(" + ctPath.clusterName + ")"));
        } else {
            LOG.info((Object)("Job for table(" + tableName + ") will be submitted to local cluster."));
        }
        if (inputSplitKeyRangeFileName == null) {
            inputSplitKeyRangeFileName = outputDir + "/" + DiffTableUtils.getTabletKeyFileName((String)tableName);
            DiffTableUtils.writeTabletKeyRange((String)inputSplitKeyRangeFileName, (String)tableName);
        }
        String segKeyDirName = outputDir + "/" + DiffTableUtils.getSegKeyDirName((String)tableName);
        if (subKeyRangeFileName == null) {
            subKeyRangeFileName = outputDir + "/" + DiffTableUtils.getSegKeyFileName((String)tableName);
            DiffTableUtils.writeSegKeyRange((String)subKeyRangeFileName, (String)tableName);
        }
        String outputSplitKeyRangeFileName = null;
        if (needSplit) {
            outputSplitKeyRangeFileName = outputDir + "/" + DiffTableUtils.getReSplitedTabletKeyFileName((String)tableName);
            DiffTableUtils.splitSubRegionKeysbyRegionKeys((String)inputSplitKeyRangeFileName, (String)subKeyRangeFileName, (String)outputSplitKeyRangeFileName, (String)segKeyDirName);
        } else {
            outputSplitKeyRangeFileName = inputSplitKeyRangeFileName;
        }
        conf.set("KeyRangeDirName", segKeyDirName);
        conf.set("splitfilename", outputSplitKeyRangeFileName);
        if (includeKeyRangeFileName != null) {
            conf.set("includedregionfilename", includeKeyRangeFileName);
        }
        conf.setBoolean("maprdb.exclude.embedded", excludedEmbeddedFamily);
        if (columnSpec != null) {
            conf.set("columnspeccconf", columnSpec);
            conf.set("maprdb.mapreduce.fieldpath", columnSpec);
        }
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), DocEmptySerialization.class.getName()});
        Job job = Job.getInstance((Configuration)conf, (String)NAME);
        if (jobDisplayName != null) {
            job.setJobName(jobDisplayName);
        } else {
            job.setJobName(NAME);
        }
        job.setJarByClass(RangeChecksum.class);
        job.setInputFormatClass(RangeChecksumInputFormat.class);
        job.setMapperClass(RangeChecksumMapper.class);
        job.setOutputKeyClass(ByteBufWritableComparable.class);
        job.setOutputValueClass(LongWritable.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(RangeChecksum.getOutputPathName(outputDir, tableName)));
        LazyOutputFormat.setOutputFormatClass((Job)job, SequenceFileOutputFormat.class);
        job.setSpeculativeExecution(false);
        job.setReducerClass(RangeCheckSumReducer.class);
        job.setNumReduceTasks(1);
        return job;
    }

    public static String[] convertFromDiffTablesArg(boolean useSrcTable, String splitKRFile, String subKRFile, String includeKRFile, String outChecksumDir, String inputJobDisplayName, String[] diffArgs) {
        if (diffArgs.length == 0 && splitKRFile == null && subKRFile == null && includeKRFile == null) {
            return new String[0];
        }
        if (subKRFile != null && splitKRFile == null) {
            throw new IllegalArgumentException("Input sub key range file of checksum calculation is missing.");
        }
        if (includeKRFile != null && splitKRFile == null) {
            throw new IllegalArgumentException("Input key range file of must-be-included regions is missing.");
        }
        boolean hasOutdir = false;
        ArrayList<String> rangeArgs = new ArrayList<String>();
        for (int i = 0; i < diffArgs.length; ++i) {
            String cmd = diffArgs[i];
            if (cmd.equalsIgnoreCase("-columns") || cmd.equalsIgnoreCase("-exclude_embedded_families")) {
                if (!RangeChecksum.checkNextArg(diffArgs, i)) break;
                rangeArgs.add(cmd);
                rangeArgs.add(diffArgs[i + 1]);
                continue;
            }
            if (cmd.equalsIgnoreCase("-src") && useSrcTable) {
                if (!RangeChecksum.checkNextArg(diffArgs, i)) break;
                rangeArgs.add("-table");
                rangeArgs.add(diffArgs[i + 1]);
                continue;
            }
            if (cmd.equalsIgnoreCase("-dst") && !useSrcTable) {
                if (!RangeChecksum.checkNextArg(diffArgs, i)) break;
                rangeArgs.add("-table");
                rangeArgs.add(diffArgs[i + 1]);
                continue;
            }
            if (!cmd.equalsIgnoreCase("-outdir")) continue;
            if (!RangeChecksum.checkNextArg(diffArgs, i)) break;
            if (outChecksumDir != null) {
                rangeArgs.add(cmd);
                rangeArgs.add(outChecksumDir);
                hasOutdir = true;
                continue;
            }
            throw new IllegalArgumentException("Output directory " + diffArgs[i + 1] + " but not set in DiffTableWithCrc but not set in RangeChecksum");
        }
        if (splitKRFile != null) {
            rangeArgs.add("-split_keyrange");
            rangeArgs.add(splitKRFile);
        }
        if (includeKRFile != null) {
            rangeArgs.add("-keyrange_included");
            rangeArgs.add(includeKRFile);
        }
        if (subKRFile != null) {
            rangeArgs.add("-sub_keyrange");
            rangeArgs.add(subKRFile);
        }
        if (inputJobDisplayName != null) {
            rangeArgs.add("-job_name");
            rangeArgs.add(inputJobDisplayName);
        }
        if (outChecksumDir != null && !hasOutdir) {
            rangeArgs.add("-outdir");
            rangeArgs.add(outChecksumDir);
        }
        String[] retArr = new String[rangeArgs.size()];
        retArr = rangeArgs.toArray(retArr);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)rangeArgs.toString());
        }
        return retArr;
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length == 0) {
            return true;
        }
        if (args.length < 2) {
            RangeChecksum.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equalsIgnoreCase("-h") || cmd.startsWith("--h")) {
                    RangeChecksum.printUsage(null);
                    return false;
                }
                if (cmd.equalsIgnoreCase("-table")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    tableName = args[i + 1];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-split_keyrange")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    inputSplitKeyRangeFileName = args[i + 1];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-keyrange_included")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    includeKeyRangeFileName = args[i + 1];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-sub_keyrange")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    needSplit = true;
                    subKeyRangeFileName = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-columns")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    columnSpec = args[i + 1];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-exclude_embedded_families")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    excludedEmbeddedFamily = Boolean.valueOf(args[i + 1]);
                    continue;
                }
                if (cmd.equalsIgnoreCase("-outdir")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    outputDir = args[i + 1];
                    continue;
                }
                if (!cmd.equalsIgnoreCase("-job_name")) continue;
                if (!RangeChecksum.checkNextArg(args, i)) {
                    return false;
                }
                jobDisplayName = args[i + 1];
            }
            if (tableName == null) {
                RangeChecksum.printUsage(null);
                return false;
            }
            if (includeKeyRangeFileName != null && inputSplitKeyRangeFileName == null) {
                RangeChecksum.printUsage("inputSplitKeyRangeFileName is provided, but includeKeyRangeFileName is missing.");
                return false;
            }
            columnSpec = MapReduceUtilMethods.processColumnSpec((String)columnSpec, (String)tableName);
            LOG.info((Object)("Compute checksum for " + (columnSpec != null ? columnSpec : "all") + "column families from " + tableName));
            Admin admin = MapRDBImpl.newAdmin();
            TableDescriptorImpl desc = (TableDescriptorImpl)admin.getTableDescriptor(tableName);
            if (desc.isStream()) {
                excludedEmbeddedFamily = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            RangeChecksum.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean checkNextArg(String[] args, int i) {
        if (i + 1 >= args.length) {
            RangeChecksum.printUsage("Missing arguements after " + args[i]);
            return false;
        }
        return true;
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: hadoop com.mapr.db.mapreduce.tools.impl.RangeChecksum -table tableName [options].\nNotes: the output directory will contain the calculated checksum file.\nOptions:\n  [-outdir <output_checksum_file_directory>]  directory for checksum output file.\n  [-split_keyrange <split_keyrange_file>] The key ranges that mapper task should be divided.\n     If this is not provided, the program will use mapr tablets as the key ranges.\n  [-keyrange_included <keyrange_included_file>] The key ranges that mapper task must run.\n     The key ranges must be a subset of the key ranges in split_keyrange file.\n  [-columns <comma separated list of field paths> ]\n  [-exclude_embedded_families <true|false>] (default: false)\n  Don't include the  other column families with path embedded in specified columns.");
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        Job job = RangeChecksum.createSubmittableJob(conf, args);
        int ret = 0;
        if (job != null) {
            ret = job.waitForCompletion(true) ? 0 : 1;
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)conf, (Tool)new RangeChecksum(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    static {
        outputDir = null;
        exit = false;
        diffChecksum = false;
    }

    public static class RangeCheckSumReducer
    extends Reducer<ByteBufWritableComparable, LongWritable, ByteBufWritableComparable, LongWritable> {
        public void reduce(ByteBufWritableComparable key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int i = 0;
            for (LongWritable val : values) {
                if (i == 0) {
                    context.write((Object)key, (Object)val);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("checksum for start key(" + key + "):(" + Long.toString(val.get()) + ")"));
                    }
                } else {
                    LOG.error((Object)("extra " + Integer.toString(i) + " checksum for start key(" + key + "):(" + Long.toString(val.get()) + ")"));
                }
                ++i;
            }
        }
    }

    public static class RangeChecksumMapper
    extends Mapper<Value, DBDocumentImpl, ByteBufWritableComparable, LongWritable> {
        private boolean hasRows_ = false;
        private Checksum checksum_ = new PureJavaCrc32();
        private String keyRangeFileName_ = null;
        private String keyRangeDirName_ = null;
        private List<ByteBufWritableComparable> keysInThisMapper_ = null;
        private int cIdx_ = -1;
        private int nIdx_ = -1;
        private Map<Integer, FieldPath> tableIdToPathMap_ = new HashMap<Integer, FieldPath>();
        private Map<FieldPath, Integer> tablePathToIdMap_ = new HashMap<FieldPath, Integer>();
        private Map<Integer, List<String>> projectionMap_ = null;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            String tName;
            super.setup(context);
            TableSplit tableSplit = (TableSplit)context.getInputSplit();
            byte[] startRow = tableSplit.getStartRow();
            byte[] endRow = tableSplit.getStopRow();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Mapper Setup: startRow(" + Bytes.toStringBinary((byte[])startRow) + ") endRow(" + Bytes.toStringBinary((byte[])endRow) + ")"));
            }
            Configuration conf = context.getConfiguration();
            this.keyRangeDirName_ = conf.get("KeyRangeDirName", null);
            this.keyRangeFileName_ = startRow.length == 0 ? "neginf" : "k_" + Bytes.toStringBinary((byte[])startRow);
            LOG.info((Object)("keyRangeDirName(" + this.keyRangeDirName_ + ")\n DiffTableUtils.KEYPREFIX(" + "k_" + ")\n startRow(" + Bytes.toStringBinary((byte[])startRow) + ")\n keyRangeFileName_(" + this.keyRangeFileName_ + ")"));
            this.keysInThisMapper_ = DiffTableUtils.readKeyRange((Configuration)conf, (String)(this.keyRangeDirName_ + "/" + this.keyRangeFileName_));
            if (this.keysInThisMapper_.size() == 0) {
                throw new IOException("No segment keys found for tablet with start at row (" + Bytes.toStringBinary((byte[])startRow) + ")");
            }
            if (!Bytes.equals((byte[])this.keysInThisMapper_.get(0).getBytes(), (byte[])startRow)) {
                throw new IOException("First segment key(" + this.keysInThisMapper_.get(0) + ") is NOT the tablet start key(" + Bytes.toStringBinary((byte[])startRow) + ")");
            }
            this.cIdx_ = 0;
            if (this.keysInThisMapper_.size() > 1) {
                this.nIdx_ = 1;
            }
            if ((tName = conf.get("maprdb.mapreduce.inputtable", null)) == null) {
                throw new IOException("Input table cannot be null!");
            }
            this.tableIdToPathMap_.clear();
            this.tablePathToIdMap_.clear();
            DiffTableComparator.getIdToFieldPathMap(tName, this.tableIdToPathMap_, this.tablePathToIdMap_);
            String cols = conf.get("columnspeccconf");
            if (cols != null) {
                this.projectionMap_ = MapRDBTableImplHelper.getMultipleCFQualifiers(this.tablePathToIdMap_, (boolean)excludedEmbeddedFamily, (String[])cols.split(","));
            }
            LOG.info((Object)("Checksum table " + tName + "has id-to-path map " + this.tableIdToPathMap_));
            this.checksum_.reset();
        }

        public void updateChecksum(ByteBufWritableComparable row, DBDocumentImpl docValue) {
            ByteBuffer rowKey = IdCodec.encode((Value)docValue.getId());
            LOG.info((Object)("row from mapper(" + Bytes.toStringBinary((byte[])row.getBytes()) + "), rowkey(id) from doc(" + Bytes.toStringBinary((byte[])rowKey.array()) + ")"));
            this.checksum_.update(rowKey.array(), 0, rowKey.limit());
            SerializedFamilyInfo[] docData = RowcolCodec.encode((Document)docValue, this.tablePathToIdMap_, (boolean)false, (boolean)true);
            Arrays.sort(docData, new DBDocComparator(this.tableIdToPathMap_));
            int index = 0;
            while (index < docData.length) {
                SerializedFamilyInfo i = null;
                if (index < docData.length) {
                    i = docData[index];
                    if (this.projectionMap_ != null && !this.projectionMap_.containsKey(i.getFamilyId())) {
                        ++index;
                        continue;
                    }
                }
                if (i == null || i.getAction() == SerializationAction.NO_ACTION) {
                    ++index;
                    continue;
                }
                DBDocumentImpl familyDoc = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)i.getByteBuffer(), null, (boolean)true, (boolean)true, (boolean)true);
                if (familyDoc == null) {
                    ++index;
                    continue;
                }
                FieldPath family = this.tableIdToPathMap_.get(i.getFamilyId());
                String familyStr = family.asPathString();
                this.checksum_.update(familyStr.getBytes(), 0, familyStr.length());
                if (this.projectionMap_ == null || this.projectionMap_.get(i.getFamilyId()).isEmpty()) {
                    KeyValueWithTS.updateChecksumKeyValue((Checksum)this.checksum_, (KeyValue)familyDoc, (boolean)true, null);
                } else {
                    List<String> projFPList = this.projectionMap_.get(i.getFamilyId());
                    for (String fp : projFPList) {
                        KeyValueWithTS.updateChecksumKeyValue((Checksum)this.checksum_, (KeyValue)familyDoc.getKeyValue(fp), (boolean)true, null);
                    }
                }
                ++index;
            }
            LOG.debug((Object)("row: " + row + ", update checksum to: " + this.checksum_.getValue()));
        }

        public void map(Value rowValue, DBDocumentImpl docValue, Mapper.Context context) throws IOException, InterruptedException {
            if (!this.hasRows_) {
                this.hasRows_ = true;
            }
            ByteBufWritableComparable rowkey = new ByteBufWritableComparable(IdCodec.encode((Value)rowValue));
            if (this.keysInThisMapper_.get(this.cIdx_).compareTo(rowkey) > 0) {
                throw new IOException("rowkey(" + rowkey + ") is larger that its segment start key(" + this.keysInThisMapper_.get(this.cIdx_) + ")");
            }
            if (this.nIdx_ != -1 && this.keysInThisMapper_.get(this.nIdx_).compareTo(rowkey) <= 0) {
                context.write((Object)this.keysInThisMapper_.get(this.cIdx_), (Object)new LongWritable(this.checksum_.getValue()));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Segment with start key: " + this.keysInThisMapper_.get(this.cIdx_) + ", checksum: " + this.checksum_.getValue()));
                }
                this.checksum_.reset();
                ++this.cIdx_;
                if (this.cIdx_ >= this.keysInThisMapper_.size()) {
                    throw new IOException("No more segments to cover rowkey(" + rowkey + ")");
                }
                this.nIdx_ = this.cIdx_ + 1;
                if (this.nIdx_ == this.keysInThisMapper_.size()) {
                    this.nIdx_ = -1;
                }
                this.updateChecksum(rowkey, docValue);
            } else {
                this.updateChecksum(rowkey, docValue);
            }
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (!this.hasRows_) {
                LOG.info((Object)"This Split does not contain any row, will log default checksum for empty segment");
            }
            context.write((Object)this.keysInThisMapper_.get(this.cIdx_), (Object)new LongWritable(this.checksum_.getValue()));
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Segment with start key: " + this.keysInThisMapper_.get(this.cIdx_) + ", checksum: " + this.checksum_.getValue()));
            }
            this.cIdx_ = -1;
            this.nIdx_ = -1;
            this.checksum_.reset();
            this.tableIdToPathMap_.clear();
            this.tablePathToIdMap_.clear();
        }
    }
}

